/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net.workers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import org.tip.puck.PuckException;
import org.tip.puck.net.Individual;
import org.tip.puck.net.KinType;
import org.tip.puck.net.Net;
import org.tip.puck.net.workers.BicomponentEdge;
import org.tip.puck.net.workers.NetUtils;

public class BicomponentWorker {
    private int step;
    private Stack<BicomponentEdge> bicomax;
    private Map<Integer, Integer> bicomponents;
    private int volume;
    private int number;
    private Map<Individual, Status> status;
    private Stack<BicomponentEdge> bicomponentStack;
    private Stack<BicomponentEdge> workingStack;
    private Map<Individual, Integer> discovery;
    private boolean all;
    private boolean matrimonial;

    public BicomponentWorker(Net net, boolean matrimonial, boolean all) {
        this.matrimonial = matrimonial;
        this.all = all;
        this.step = 0;
        this.bicomax = new Stack();
        this.bicomponents = new TreeMap<Integer, Integer>();
        this.status = new HashMap<Individual, Status>();
        for (Individual individual : net.individuals()) {
            this.status.put(individual, Status.WAITING);
        }
    }

    static void add(Map<Integer, Integer> bicomponents, int i, int threshold) {
        if (bicomponents.get(i) == null || bicomponents.get(i) > threshold) {
            bicomponents.put(i, threshold);
        }
    }

    static void addAll(Map<Integer, Integer> bicomponents, Map<Integer, Integer> map) {
        for (int i : map.keySet()) {
            BicomponentWorker.add(bicomponents, i, map.get(i));
        }
    }

    public static Net getCore(Net net) {
        Net result = new BicomponentWorker(net, true, true).getMaximalBicomponent();
        return result;
    }

    private Net getMaximalBicomponent() {
        this.workingStack = new Stack();
        this.bicomponentStack = new Stack();
        this.discovery = new HashMap<Individual, Integer>();
        ArrayList<Individual> list = new ArrayList<Individual>(this.status.keySet());
        Collections.sort(list);
        for (Individual individual : list) {
            if (this.status.get(individual) != Status.WAITING || !this.isPossibleStartingPoint(individual)) continue;
            this.bicomp(new BicomponentEdge(null, individual, null, 0));
        }
        this.getBicomponent(this.bicomponentStack, null, this.all);
        BicomponentWorker.report(this.bicomponents, this.volume);
        Net result = this.fromEdges(this.bicomax);
        return result;
    }

    public int bicomp(BicomponentEdge edge) {
        ++this.step;
        System.out.println(String.valueOf(this.step) + "\t" + edge);
        this.status.put(edge.getTarget(), Status.ONGOING);
        this.discovery.put(edge.getTarget(), this.step);
        int back = this.discovery.get(edge.getTarget());
        for (KinType alterKinType : KinType.basicTypes()) {
            if (this.matrimonial && alterKinType == KinType.PARENT && edge.getKinType() == KinType.CHILD) continue;
            for (Individual successor : edge.getTarget().getKin(alterKinType)) {
                if (successor.equals(edge.getSource()) || this.status.get(successor) == Status.DONE) continue;
                System.out.println("\tNormal\t" + successor);
                back = this.bicomp1(new BicomponentEdge(edge.getTarget(), successor, alterKinType, back));
            }
        }
        if (this.matrimonial && back < this.discovery.get(edge.getTarget()) && edge.getKinType() == KinType.CHILD) {
            for (Individual successor : edge.getTarget().getParents()) {
                if (successor.equals(edge.getSource()) || this.status.get(successor) == Status.DONE) continue;
                System.out.println("\tSupplementary\t" + successor);
                back = this.bicomp1(new BicomponentEdge(edge.getTarget(), successor, KinType.PARENT, back));
            }
        }
        this.status.put(edge.getTarget(), Status.DONE);
        System.out.println(String.valueOf(this.step) + "\t" + edge + " " + back);
        return back;
    }

    public int bicomp1(BicomponentEdge edge) {
        int result;
        this.bicomponentStack.push(edge);
        if (this.status.get(edge.getTarget()) == Status.WAITING) {
            int cback = this.bicomp(edge);
            if (cback > this.discovery.get(edge.getSource())) {
                System.out.println("\tcut tail until " + edge + " " + BicomponentWorker.clear(this.bicomponentStack, edge));
            } else if (cback == this.discovery.get(edge.getSource())) {
                if (this.matrimonial && edge.adjusted(edge.getSource()) != null && edge.adjusted(edge.getSource()).getKinType() == KinType.PARENT && this.bicomponentStack.peek().adjusted(edge.getSource()) != null && this.bicomponentStack.peek().adjusted(edge.getSource()).getKinType() == KinType.PARENT) {
                    System.out.println("\txcut tail until " + edge + " " + BicomponentWorker.clear(this.bicomponentStack, edge));
                } else {
                    System.out.println("\tget Bicomponent until " + edge + ": " + this.bicomponentStack);
                    this.getBicomponent(this.bicomponentStack, edge, this.all);
                }
            }
            result = Math.min(edge.getBack(), cback);
        } else {
            System.out.println("\tOld " + edge);
            result = Math.min(edge.getBack(), this.discovery.get(edge.getTarget()));
        }
        return result;
    }

    private boolean isPossibleStartingPoint(Individual individual) {
        boolean result = !this.matrimonial || individual.numberOfParents() + individual.spouses().size() + individual.children().size() > 1 && (individual.isFertile() || individual.isNotSingle());
        return result;
    }

    void count(Map<Integer, Integer> bicomponents, int i) {
        try {
            bicomponents.put(i, bicomponents.get(i) + 1);
        }
        catch (NullPointerException npe) {
            bicomponents.put(i, 1);
        }
        ++this.number;
        this.volume += i;
    }

    static void report(Map<Integer, Integer> bicomponents, int volume) {
        for (int i : bicomponents.keySet()) {
            System.out.println(String.valueOf(i) + "\t" + bicomponents.get(i));
        }
        System.out.println(String.valueOf(bicomponents.size()) + " " + volume);
    }

    public static Net getMaximalBicomponent(Net net) {
        Net result = new BicomponentWorker(net, false, false).getMaximalBicomponent();
        return result;
    }

    public static Net getKernel(Net net) {
        Net result = new BicomponentWorker(net, true, false).getMaximalBicomponent();
        return result;
    }

    public Net fromEdges(Stack<BicomponentEdge> edges) {
        Net result = new Net();
        while (!edges.isEmpty()) {
            BicomponentEdge edge = edges.pop();
            Individual ego = result.getCloneWithAttributes(edge.getSource());
            Individual alter = result.getCloneWithAttributes(edge.getTarget());
            try {
                NetUtils.setKin(result, ego, alter, edge.getKinType().inverse());
            }
            catch (PuckException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public void getBicomponent(Stack<BicomponentEdge> stack, BicomponentEdge e, boolean all) {
        Stack<Object> bico = new Stack<BicomponentEdge>();
        if (e == null) {
            bico = stack;
        } else {
            bico.push(stack.pop());
            while (bico.peek() != e) {
                bico.push(stack.pop());
            }
        }
        if (!bico.isEmpty()) {
            this.count(this.bicomponents, bico.size());
        }
        if (!all && bico.size() <= this.bicomax.size()) {
            return;
        }
        if (!all) {
            this.bicomax.clear();
        }
        while (!bico.isEmpty()) {
            this.bicomax.push((BicomponentEdge)bico.pop());
        }
    }

    private static <E> List<E> clear(Stack<E> stack, E e) {
        ArrayList<Object> result = new ArrayList<Object>();
        Object last = null;
        while (last != e) {
            last = stack.pop();
            result.add(last);
        }
        return result;
    }

    private static enum Status {
        WAITING,
        ONGOING,
        DONE;

    }
}

