/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net.relations.roles.io;

import fr.devinsy.util.StringList;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckException;
import org.tip.puck.PuckExceptions;
import org.tip.puck.io.ods.ODSBufferedReader;
import org.tip.puck.io.xls.XLSBufferedReader;
import org.tip.puck.net.Attributes;
import org.tip.puck.net.relations.RelationModel;
import org.tip.puck.net.relations.roles.RoleRelationMaker;
import org.tip.puck.net.relations.roles.RoleRelationRules;
import org.tip.puck.net.relations.roles.io.IOTermsTools;
import org.tip.puck.report.Report;

public class TermStandardFile {
    private static Logger logger = LoggerFactory.getLogger(TermStandardFile.class);
    public static String DEFAULT_CHARSET_NAME = "UTF-8";

    public static RelationModel load(File source, Report report, RoleRelationRules ruleConstraints) throws PuckException {
        RelationModel result;
        if (source == null) {
            throw PuckExceptions.INVALID_PARAMETER.create("File=[" + source + "].", new Object[0]);
        }
        if (!source.exists()) {
            throw PuckExceptions.FILE_NOT_FOUND.create("File=[" + source + "].", new Object[0]);
        }
        if (!source.isFile()) {
            throw PuckExceptions.NOT_A_FILE.create("File=[" + source + "].", new Object[0]);
        }
        String name = StringUtils.lowerCase((String)source.getName());
        if (name.endsWith(".term.ods")) {
            result = TermStandardFile.loadFromTermODSFile(source, report, ruleConstraints);
        } else if (name.endsWith(".term.txt")) {
            result = TermStandardFile.loadFromTermTXTFile(source, report, ruleConstraints);
        } else if (name.endsWith(".term.xls")) {
            result = TermStandardFile.loadFromTermXLSFile(source, report, ruleConstraints);
        } else {
            throw PuckExceptions.UNSUPPORTED_FILE_FORMAT.create("File=[" + source + "].", new Object[0]);
        }
        return result;
    }

    public static RelationModel loadFromTermODSFile(File file, Report report, RoleRelationRules ruleConstraints) throws PuckException {
        RelationModel result;
        ODSBufferedReader in = null;
        try {
            try {
                in = new ODSBufferedReader(file);
                result = TermStandardFile.readFromTermTXTFile(in, report, ruleConstraints);
                result.setName(IOTermsTools.getBaseName(file, ".term.ods"));
            }
            catch (UnsupportedEncodingException exception) {
                throw PuckExceptions.UNSUPPORTED_ENCODING.create("Opening file [" + file + "]", new Object[0]);
            }
            catch (FileNotFoundException exception) {
                throw PuckExceptions.FILE_NOT_FOUND.create("Opening file [" + file + "]", new Object[0]);
            }
            catch (Exception exception) {
                throw PuckExceptions.IO_ERROR.create(exception, "\nOpening file [" + file + "]\n[" + exception.getMessage() + "]", new Object[0]);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)in);
        return result;
    }

    public static RelationModel loadFromTermTXTFile(File file, Report report, RoleRelationRules ruleConstraints) throws PuckException {
        RelationModel result;
        BufferedReader in = null;
        try {
            try {
                in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), DEFAULT_CHARSET_NAME));
                result = TermStandardFile.readFromTermTXTFile(in, report, ruleConstraints);
                result.setName(IOTermsTools.getBaseName(file, ".term.txt"));
            }
            catch (UnsupportedEncodingException exception) {
                throw PuckExceptions.UNSUPPORTED_ENCODING.create("Opening file [" + file + "]", new Object[0]);
            }
            catch (FileNotFoundException exception) {
                throw PuckExceptions.IO_ERROR.create(exception, "\nOpening file [" + file + "]\n[" + exception.getMessage() + "]", new Object[0]);
            }
            catch (Exception exception) {
                throw PuckExceptions.IO_ERROR.create(exception, "\nOpening file [" + file + "]\n[" + exception.getMessage() + "]", new Object[0]);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)in);
        return result;
    }

    public static RelationModel loadFromTermXLSFile(File file, Report report, RoleRelationRules ruleConstraints) throws PuckException {
        RelationModel result;
        XLSBufferedReader in = null;
        try {
            try {
                in = new XLSBufferedReader(file);
                result = TermStandardFile.readFromTermTXTFile(in, report, ruleConstraints);
                result.setName(IOTermsTools.getBaseName(file, ".term.xls"));
            }
            catch (UnsupportedEncodingException exception) {
                throw PuckExceptions.UNSUPPORTED_ENCODING.create("Opening file [" + file + "]", new Object[0]);
            }
            catch (FileNotFoundException exception) {
                throw PuckExceptions.FILE_NOT_FOUND.create("Opening file [" + file + "]", new Object[0]);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw PuckExceptions.IO_ERROR.create(exception, "\nOpening file [" + file + "]\n[" + exception.getMessage() + "]", new Object[0]);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)in);
        return result;
    }

    public static RelationModel readFromTermTXTFile(BufferedReader in, Report report, RoleRelationRules ruleConstraints) throws PuckException {
        logger.debug("Read attributes.");
        Attributes attributes = new Attributes();
        IOTermsTools.readAttributesVertically(attributes, in);
        String selfName = IOTermsTools.extractSelfName(attributes);
        logger.debug("selfName=[{}]", (Object)selfName);
        RoleRelationRules rules = ruleConstraints == null ? IOTermsTools.extractRelationRoleRules(attributes) : ruleConstraints;
        logger.debug("rule=[{}]", (Object)rules);
        StringList lines = IOTermsTools.readTermRuleLines(in);
        logger.debug("lines count=[{}]", (Object)lines.size());
        report.outputs().appendln("Source reading");
        report.outputs().appendln();
        report.outputs().append("Self Name:\t\t").appendln(selfName);
        report.outputs().append("Role Relation Rules:\t").appendln(rules);
        report.outputs().appendln();
        RelationModel result = RoleRelationMaker.createStandard("default", selfName, lines, rules, report);
        return result;
    }
}

