/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net.relations.roles;

import fr.devinsy.util.StringList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.tip.puck.graphs.Graph;
import org.tip.puck.graphs.GraphMaker;
import org.tip.puck.graphs.Link;
import org.tip.puck.graphs.Node;
import org.tip.puck.graphs.Nodes;
import org.tip.puck.graphs.workers.GraphUtils;
import org.tip.puck.graphs.workers.GraphValuator;
import org.tip.puck.net.AlterAge;
import org.tip.puck.net.Gender;
import org.tip.puck.net.KinType;
import org.tip.puck.net.relations.RelationModel;
import org.tip.puck.net.relations.Role;
import org.tip.puck.net.relations.Roles;
import org.tip.puck.net.relations.roles.MetaRole;
import org.tip.puck.net.relations.roles.RoleActor;
import org.tip.puck.net.relations.roles.RoleActorPair;
import org.tip.puck.net.relations.roles.RoleActors;
import org.tip.puck.net.relations.roles.RoleActorsComparator;
import org.tip.puck.net.relations.roles.RoleDefinition;
import org.tip.puck.net.relations.roles.RoleDefinitions;
import org.tip.puck.net.relations.roles.RoleRelation;
import org.tip.puck.net.relations.roles.RoleRelationMaker;
import org.tip.puck.net.relations.roles.RoleRelations;
import org.tip.puck.partitions.Cluster;
import org.tip.puck.partitions.Partition;
import org.tip.puck.util.Value;

public class RoleRelationWorker {
    private RoleRelations relations;
    private Partition<RoleActors> chainsPartition;
    private int maxIterations;
    private Roles generators;
    private Roles terms;
    private Partition<Role> termsByEgoGender;
    private Partition<Role> termsByGender;
    private Map<Role, List<Integer>> generations;
    private Map<Integer, Integer[]> termCountsByGenderationAndGender;
    private String title;
    private Map<Role, Roles> reciprocalRoles;
    private Roles autoReciprocalRoles;
    private Map<KinType, Roles> recursiveRoles;
    private Map<Role, StringList> positions;
    private Map<Role, Map<Role, Roles>> compositions;
    private Map<Role, Partition<Role>> basicCompositions;
    private Map<Role, RoleDefinitions> roleDefininitionsByRole;
    private Map<MetaRole, List<List<Role>>>[] collateralTerms;
    private Map<MetaRole, CousinClassification>[] collateralClassifications;
    private CousinClassification[] collateralClassification;
    private List<RoleRelationMaker.RoleRelationRule> rules;
    private Graph<Role>[] roleRelationGraphs;
    private Map<Value, Graph<Role>>[] roleRelationSubGraphs;

    public RoleRelationWorker(RelationModel model, int maxIterations) {
        this.relations = model.getRoleRelations();
        this.terms = this.relations.getRoles();
        this.title = model.getName();
        this.maxIterations = maxIterations;
        this.chainsPartition = RoleRelationWorker.expand(this.relations, this.relations.getGenderConfigs(), maxIterations);
        this.generators = this.relations.getGenerators();
        this.rules = model.getRules();
    }

    private static Partition<RoleActors> expand(RoleRelations relations, Map<Role, Roles> genderConfigs, int maxIterations) {
        Partition<RoleActors> result = new Partition<RoleActors>();
        Gender[] genderArray = Gender.values();
        int n = genderArray.length;
        int n2 = 0;
        while (n2 < n) {
            Gender egoGender = genderArray[n2];
            RoleActor self = relations.getSelf(egoGender);
            RoleRelationWorker.expand(result, relations, genderConfigs, self, new RoleActors(), 0, maxIterations);
            ++n2;
        }
        return result;
    }

    private static void expand(Partition<RoleActors> positions, RoleRelations relations, Map<Role, Roles> genderConfigs, RoleActor self, RoleActors selfChain, int iterations, int maxIterations) {
        for (KinType kinType : KinType.basicTypesWithSiblings()) {
            for (RoleActor alter : relations.getAlters(self, kinType, null)) {
                if (!RoleRelationMaker.concatenable(self, alter)) continue;
                RoleActors alterChain = selfChain.clone();
                if (alter.getEgoGender() != self.getEgoGender()) {
                    RoleActor adjustedSelf = relations.getSelf(alter.getEgoGender());
                    for (RoleActor actor : alterChain) {
                        RoleActorPair pair = new RoleActorPair(relations, adjustedSelf, actor, RoleActorPair.Adjustable.NONE);
                        if (pair.isValid()) {
                            RoleActor adjustedActor = pair.getAlter();
                            actor.setRole(adjustedActor.getRole());
                            adjustedSelf = adjustedActor;
                            continue;
                        }
                        adjustedSelf = null;
                        break;
                    }
                    if (adjustedSelf == null) continue;
                }
                if (alter.hasSelfName()) continue;
                alterChain.add(alter);
                if (!positions.put(alterChain, new Value(alter.getIndividual())) || iterations >= maxIterations) continue;
                RoleRelationWorker.expand(positions, relations, genderConfigs, alter, alterChain, iterations + 1, maxIterations);
            }
        }
    }

    Map<Role, StringList> getPositions() {
        if (this.positions == null) {
            this.positions = new TreeMap<Role, StringList>();
            for (Cluster<RoleActors> chainsCluster : this.chainsPartition.getClusters().toListSortedByValue()) {
                StringList chainStrings = new StringList();
                this.positions.put(chainsCluster.getValue().roleValue(), chainStrings);
                List<RoleActors> chains = chainsCluster.getItems();
                Collections.sort(chains, new RoleActorsComparator());
                for (RoleActors chain : chains) {
                    String chainString = chain.toLetters();
                    if (chainStrings.contains((Object)chainString)) continue;
                    chainStrings.add((Object)chainString);
                }
            }
        }
        return this.positions;
    }

    Map<Role, Roles> getReciprocalRoles() {
        if (this.reciprocalRoles == null) {
            this.reciprocalRoles = new TreeMap<Role, Roles>();
            this.autoReciprocalRoles = new Roles();
            for (Cluster<RoleActors> cluster : this.chainsPartition.getClusters().toListSortedByValue()) {
                Role role = cluster.getValue().roleValue();
                Roles roles = new Roles();
                this.reciprocalRoles.put(role, roles);
                boolean cross = RoleActor.isUniqueCross(this.relations.getGenderConfigs().get(role));
                for (Value value : RoleRelationWorker.getReciprocals(this.relations, role, this.chainsPartition).getValues()) {
                    Role reciprocalRole = value.roleValue();
                    roles.add(reciprocalRole);
                    if (!reciprocalRole.equals(role) || cross) continue;
                    this.autoReciprocalRoles.add(role);
                }
            }
        }
        return this.reciprocalRoles;
    }

    Map<Role, Partition<Role>> getBasicCompositions() {
        if (this.basicCompositions == null) {
            this.basicCompositions = new TreeMap<Role, Partition<Role>>();
            for (RoleRelation relation : this.relations.toSortedList()) {
                RoleActor self = relation.getSelf();
                Role selfTerm = self.getIndividual();
                Partition<Role> partition = this.basicCompositions.get(selfTerm);
                if (partition == null) {
                    partition = new Partition();
                    this.basicCompositions.put(selfTerm, partition);
                }
                for (RoleActor actor : relation.getActors()) {
                    if (actor.isSelf()) continue;
                    for (Role metaRole : this.generators) {
                        if (!((MetaRole)metaRole).specifies(actor.getRole()) || actor.hasSelfName() && !((MetaRole)metaRole).getEgoGender().matchs(((MetaRole)metaRole).getAlterGender())) continue;
                        partition.put(actor.getIndividual(), new Value(metaRole));
                    }
                }
            }
        }
        return this.basicCompositions;
    }

    public Roles getAutoReciprocalRoles() {
        if (this.autoReciprocalRoles == null) {
            this.getReciprocalRoles();
        }
        return this.autoReciprocalRoles;
    }

    private static Partition<RoleActors> getReciprocals(RoleRelations relations, Role alpha, Partition<RoleActors> chainsMap) {
        Partition<RoleActors> result = new Partition<RoleActors>();
        for (RoleActors chain : chainsMap.getCluster(new Value(alpha)).getItems()) {
            RoleActors inverseChain = new RoleActors();
            int i = chain.size() - 1;
            while (i > -1) {
                RoleActor alter = (RoleActor)chain.get(i);
                RoleActor self = relations.getSelf(chain.getFirst().getEgoGender());
                if (i > 0) {
                    self = (RoleActor)chain.get(i - 1);
                }
                inverseChain.add(self.asReciprocalOf(alter, relations));
                --i;
            }
            ArrayList<RoleActors> startChains = new ArrayList<RoleActors>();
            RoleActors root = new RoleActors();
            RoleActor reciprocalSelf = relations.getSelf(chain.getLast().getAlterGender());
            root.add(reciprocalSelf);
            startChains.add(root);
            for (RoleActors endChain : relations.adjustChain(inverseChain, startChains)) {
                result.put(endChain, new Value(endChain.getLast().getIndividual()));
            }
        }
        return result;
    }

    private static Partition<RoleActors> getCompositions(RoleRelations relations, Role alpha, Role beta, Partition<RoleActors> chainsMap) {
        Partition<RoleActors> result = new Partition<RoleActors>();
        for (RoleActors alphaActors : chainsMap.getCluster(new Value(alpha)).getItems()) {
            for (RoleActors betaActors : chainsMap.getCluster(new Value(beta)).getItems()) {
                if (!alphaActors.getLast().getAlterGender().matchs(betaActors.getLast().getEgoGender()) || alphaActors.getLast().hasSelfName() || betaActors.getLast().hasSelfName()) continue;
                ArrayList<RoleActors> startChains = new ArrayList<RoleActors>();
                startChains.add(alphaActors.clone());
                for (RoleActors chain : relations.adjustChain(betaActors, startChains)) {
                    result.put(chain, new Value(chain.getLast().getIndividual()));
                }
            }
        }
        return result;
    }

    Map<Role, RoleDefinitions> getRoleDefininitionsByRole() {
        if (this.roleDefininitionsByRole == null) {
            this.roleDefininitionsByRole = new TreeMap<Role, RoleDefinitions>();
            for (RoleDefinition definition : this.relations.getDefinitions()) {
                RoleDefinitions definitions = this.roleDefininitionsByRole.get(definition.getAlterTerm());
                if (definitions == null) {
                    definitions = new RoleDefinitions();
                    this.roleDefininitionsByRole.put(definition.getAlterTerm(), definitions);
                }
                definitions.add(definition);
            }
        }
        return this.roleDefininitionsByRole;
    }

    Map<Role, Map<Role, Roles>> getCompositions() {
        if (this.compositions == null) {
            this.compositions = new TreeMap<Role, Map<Role, Roles>>();
        }
        for (Cluster<RoleActors> alphaCluster : this.chainsPartition.getClusters().toListSortedByValue()) {
            Role alpha = alphaCluster.getValue().roleValue();
            TreeMap<Role, Roles> map = new TreeMap<Role, Roles>();
            this.compositions.put(alpha, map);
            for (Cluster<RoleActors> betaCluster : this.chainsPartition.getClusters().toListSortedByValue()) {
                Role beta = betaCluster.getValue().roleValue();
                Roles roles = new Roles();
                map.put(beta, roles);
                for (Value gammaValue : RoleRelationWorker.getCompositions(this.relations, alpha, beta, this.chainsPartition).getValues()) {
                    roles.add(gammaValue.roleValue());
                }
            }
        }
        return this.compositions;
    }

    public CousinClassification[] getCollateralClassification() {
        if (this.collateralClassification == null) {
            this.getCollateralTerms();
        }
        return this.collateralClassification;
    }

    Map<MetaRole, CousinClassification>[] getCollateralClassifications() {
        if (this.collateralClassifications == null) {
            this.getCollateralTerms();
        }
        return this.collateralClassifications;
    }

    Map<MetaRole, List<List<Role>>>[] getCollateralTerms() {
        if (this.collateralTerms == null) {
            this.collateralTerms = new TreeMap[2];
            this.collateralClassifications = new TreeMap[2];
            this.collateralClassification = new CousinClassification[2];
            int i = 0;
            while (i < 2) {
                this.collateralTerms[i] = new TreeMap<MetaRole, List<List<Role>>>();
                this.collateralClassifications[i] = new TreeMap<MetaRole, CousinClassification>();
                ++i;
            }
            RoleActors parents = new RoleActors();
            RoleActors parallelAscendants = new RoleActors();
            RoleActors crossAscendants = new RoleActors();
            RoleActors siblings = new RoleActors();
            RoleActors parallelCousins = new RoleActors();
            RoleActors crossCousins = new RoleActors();
            Gender[] genderArray = Gender.values();
            int n = genderArray.length;
            int n2 = 0;
            while (n2 < n) {
                Gender egoGender = genderArray[n2];
                RoleActor self = this.relations.getSelf(egoGender);
                siblings.addAll(this.relations.getAlters(self, KinType.SIBLING, null));
                for (RoleActor parent : this.relations.getAlters(self, KinType.PARENT, null)) {
                    parents.add(parent);
                    for (RoleActor parentSibling : this.relations.getAlters(parent, KinType.SIBLING, null)) {
                        RoleActors cousins = this.relations.getAlters(parentSibling, KinType.CHILD, null);
                        if (parent.getAlterGender() == parentSibling.getAlterGender()) {
                            parallelAscendants.add(parentSibling);
                            for (RoleActor parallelCousin : cousins) {
                                if (parallelCousin.hasSelfName()) continue;
                                parallelCousins.add(parallelCousin);
                            }
                            continue;
                        }
                        if (parent.getAlterGender() != parentSibling.getAlterGender().invert()) continue;
                        crossAscendants.add(parentSibling);
                        crossCousins.addAll(cousins);
                    }
                }
                ++n2;
            }
            boolean noEgoGenderDistinction = !this.relations.hasEgoGenderDistinction();
            boolean noAlterGenderDistinction = !this.relations.hasAlterGenderDistinction();
            boolean noAlterAgeDistinction = !this.relations.hasAlterAgeDistinction();
            for (Gender egoGender : Gender.values(noEgoGenderDistinction)) {
                for (Gender alterGender : Gender.values(noAlterGenderDistinction)) {
                    for (AlterAge alterAge : AlterAge.values(noAlterAgeDistinction)) {
                        MetaRole config = new MetaRole(null, egoGender, alterGender, alterAge);
                        List[] thisTerms = new List[2];
                        int i2 = 0;
                        while (i2 < 2) {
                            thisTerms[i2] = new ArrayList();
                            ++i2;
                        }
                        thisTerms[0].add(parents.getByImpliedAbsoluteRole(config).getIndividuals().toSortedList());
                        thisTerms[0].add(parallelAscendants.getByImpliedAbsoluteRole(config).getIndividuals().toSortedList());
                        thisTerms[0].add(crossAscendants.getByImpliedAbsoluteRole(config).getIndividuals().toSortedList());
                        thisTerms[1].add(siblings.getByImpliedAbsoluteRole(config).getIndividuals().toSortedList());
                        thisTerms[1].add(parallelCousins.getByImpliedAbsoluteRole(config).getIndividuals().toSortedList());
                        thisTerms[1].add(crossCousins.getByImpliedAbsoluteRole(config).getIndividuals().toSortedList());
                        CousinClassification[] thisCousinClassification = new CousinClassification[2];
                        int i3 = 0;
                        while (i3 < 2) {
                            thisCousinClassification[i3] = RoleRelationWorker.getTermClassification(thisTerms[i3]);
                            if (thisCousinClassification[i3] != null) {
                                this.collateralClassifications[i3].put(config, thisCousinClassification[i3]);
                                this.collateralTerms[i3].put(config, thisTerms[i3]);
                                this.collateralClassification[i3] = this.collateralClassification[i3] == null || this.collateralClassification[i3].equals((Object)thisCousinClassification[i3]) ? thisCousinClassification[i3] : CousinClassification.UNDEFINED;
                            }
                            ++i3;
                        }
                    }
                }
            }
        }
        return this.collateralTerms;
    }

    public String getRecursiveRolePattern() {
        String result = "";
        for (KinType kinType : this.getRecursiveRoles().keySet()) {
            if (kinType == KinType.UNKNOWN || this.getRecursiveRoles().get((Object)kinType).isEmpty()) continue;
            String sep = ";";
            if (result.equals("")) {
                sep = "";
            }
            result = String.valueOf(result) + sep + this.getRecursiveRoles().get((Object)kinType).size() + " " + (Object)((Object)kinType);
        }
        result = String.valueOf(this.getRecursiveRoles().get((Object)KinType.UNKNOWN).size()) + " (" + result + ")";
        return result;
    }

    Map<KinType, Roles> getRecursiveRoles() {
        if (this.recursiveRoles == null) {
            this.recursiveRoles = new TreeMap<KinType, Roles>();
            for (KinType kinType : KinType.basicTypesWithSiblings()) {
                this.recursiveRoles.put(kinType, new Roles());
            }
            this.recursiveRoles.put(KinType.UNKNOWN, new Roles());
            for (RoleRelation relation : this.relations) {
                Role self = relation.getSelfTerm();
                if (self.hasName(this.relations.getSelfName())) continue;
                for (RoleActor actor : relation.getActors()) {
                    if (actor.isSelf() || !self.equals(actor.getIndividual())) continue;
                    this.recursiveRoles.get((Object)actor.getRole().getKinType()).addNew(self);
                    this.recursiveRoles.get((Object)KinType.UNKNOWN).addNew(self);
                }
            }
        }
        return this.recursiveRoles;
    }

    private static CousinClassification getTermClassification(List<List<Role>> terms) {
        CousinClassification result = null;
        List<Role> linealTerms = terms.get(0);
        List<Role> parallelTerms = terms.get(1);
        List<Role> crossTerms = terms.get(2);
        if (!(linealTerms.isEmpty() && parallelTerms.isEmpty() && crossTerms.isEmpty())) {
            Boolean merging = null;
            Boolean lineal = null;
            if (!linealTerms.isEmpty() && linealTerms.equals(parallelTerms)) {
                merging = true;
            } else if (!linealTerms.isEmpty() || !parallelTerms.isEmpty()) {
                merging = false;
            }
            if (!crossTerms.isEmpty() && crossTerms.equals(parallelTerms)) {
                lineal = true;
            } else if (!crossTerms.isEmpty() || !parallelTerms.isEmpty()) {
                lineal = false;
            }
            result = lineal != null && lineal.booleanValue() ? (merging != null && merging.booleanValue() ? CousinClassification.GENERATIONAL : CousinClassification.LINEAL) : (merging != null && merging != false ? CousinClassification.BIFURCATE_MERGING : CousinClassification.BIFURCATE_COLLATERAL);
        }
        return result;
    }

    private static void countGenerations(Map<Role, List<Integer>> counts, RoleRelations relations, RoleActor self, int selfCount, int iterations, int maxIterations) {
        for (KinType kinType : KinType.basicTypesWithSiblings()) {
            int alterCount = selfCount + kinType.genDistance();
            for (RoleActor alter : relations.getAlters(self, kinType, null)) {
                Role role = alter.getIndividual();
                List<Integer> count = counts.get(role);
                if (count == null) {
                    count = new ArrayList<Integer>();
                    counts.put(role, count);
                }
                if (!count.contains(alterCount)) {
                    count.add(alterCount);
                }
                if (iterations >= maxIterations) continue;
                RoleRelationWorker.countGenerations(counts, relations, alter, alterCount, iterations + 1, maxIterations);
            }
        }
    }

    Map<Role, List<Integer>> getGenerations() {
        if (this.generations == null) {
            this.generations = new TreeMap<Role, List<Integer>>();
            Gender[] genderArray = Gender.values();
            int n = genderArray.length;
            int n2 = 0;
            while (n2 < n) {
                Gender egoGender = genderArray[n2];
                RoleRelationWorker.countGenerations(this.generations, this.relations, this.relations.getSelf(egoGender), 0, 0, this.maxIterations);
                ++n2;
            }
            for (List<Integer> list : this.generations.values()) {
                Collections.sort(list);
            }
        }
        return this.generations;
    }

    List<Integer> getGenerationLevels() {
        ArrayList<Integer> result = new ArrayList<Integer>(this.getTermCountsByGenerationAndGender().keySet());
        Collections.sort(result, Collections.reverseOrder());
        return result;
    }

    public String[] getGenerationPatterns() {
        String[] result = new String[]{"", "", "", ""};
        for (Integer genLevel : this.getGenerationLevels()) {
            int i = 0;
            while (i < 4) {
                if (genLevel == 0) {
                    int n = i;
                    result[n] = String.valueOf(result[n]) + "| ";
                }
                int n = i;
                result[n] = String.valueOf(result[n]) + this.getTermCountsByGenerationAndGender().get(genLevel)[i] + " ";
                if (genLevel == 0) {
                    int n2 = i;
                    result[n2] = String.valueOf(result[n2]) + "| ";
                }
                ++i;
            }
        }
        return result;
    }

    Map<Integer, Integer[]> getTermCountsByGenerationAndGender() {
        if (this.termCountsByGenderationAndGender == null) {
            this.termCountsByGenderationAndGender = new TreeMap<Integer, Integer[]>();
            for (Role role : this.getTerms()) {
                Integer gender = this.getGender(role).toInt();
                for (Integer generation : this.getGenerations(role)) {
                    Integer[] byGender = this.termCountsByGenderationAndGender.get(generation);
                    if (byGender == null) {
                        byGender = new Integer[]{0, 0, 0, 0};
                        this.termCountsByGenderationAndGender.put(generation, byGender);
                    }
                    int n = gender;
                    byGender[n] = byGender[n] + 1;
                    byGender[3] = byGender[3] + 1;
                }
            }
        }
        return this.termCountsByGenderationAndGender;
    }

    Gender getEgoGender(Role role) {
        Gender result = null;
        if (this.relations.getGenderConfigs().get(role) != null) {
            for (Role metaRole : this.relations.getGenderConfigs().get(role)) {
                Gender gender = ((MetaRole)metaRole).getEgoGender();
                if (result == null) {
                    result = gender;
                    break;
                }
                if (result == gender) continue;
                result = Gender.UNKNOWN;
            }
        }
        return result;
    }

    Gender getGender(Role role) {
        Gender result = null;
        if (this.relations.getGenderConfigs().get(role) != null) {
            for (Role metaRole : this.relations.getGenderConfigs().get(role)) {
                Gender gender = ((MetaRole)metaRole).getAlterGender();
                if (result == null) {
                    result = gender;
                    break;
                }
                if (result == gender) continue;
                result = Gender.UNKNOWN;
            }
        }
        return result;
    }

    public List<Integer> getGenerations(Role role) {
        List<Integer> result = this.getGenerations().get(role);
        if (result == null) {
            result = new ArrayList<Integer>();
        }
        return result;
    }

    void setGenderPartitions() {
        this.termsByEgoGender = new Partition();
        this.termsByGender = new Partition();
        for (Role role : this.getTerms()) {
            this.termsByEgoGender.put(role, new Value(this.getEgoGender(role)));
            this.termsByGender.put(role, new Value(this.getGender(role)));
        }
    }

    public Roles getTermsByGender(Gender gender) {
        Roles result = this.getTermsByExclusiveGender(gender);
        result.addAll(this.getTermsByExclusiveGender(Gender.UNKNOWN));
        return result;
    }

    public Roles getTermsByExclusiveGender(Gender gender) {
        Roles result = new Roles();
        if (this.termsByGender == null) {
            this.setGenderPartitions();
        }
        if (this.termsByGender.getCluster(new Value(gender)) != null) {
            result.addAll(this.termsByGender.getCluster(new Value(gender)).getItems());
        }
        return result;
    }

    public Roles getTermsByEgoGender(Gender gender) {
        Roles result = this.getTermsByExclusiveEgoGender(gender);
        result.addAll(this.getTermsByExclusiveEgoGender(Gender.UNKNOWN));
        return result;
    }

    public Roles getTermsByExclusiveEgoGender(Gender gender) {
        Roles result = new Roles();
        if (this.termsByEgoGender == null) {
            this.setGenderPartitions();
        }
        if (this.termsByEgoGender.getCluster(new Value(gender)) != null) {
            result.addAll(this.termsByEgoGender.getCluster(new Value(gender)).getItems());
        }
        return result;
    }

    public RoleRelations getRelations() {
        return this.relations;
    }

    Partition<RoleActors> getChainsPartition() {
        return this.chainsPartition;
    }

    public int getMaxIterations() {
        return this.maxIterations;
    }

    public Roles getTerms() {
        return this.terms;
    }

    Roles getGenerators() {
        return this.generators;
    }

    public String getTitle() {
        return this.title;
    }

    public Map<RoleActor, RoleActors> getRoleRelationMap(Gender egoGender) {
        TreeMap<RoleActor, RoleActors> result = new TreeMap<RoleActor, RoleActors>();
        if (egoGender == null) {
            for (Gender gender : Gender.valuesNotUnknown()) {
                Map<RoleActor, RoleActors> map = this.getRoleRelationMap(gender);
                for (RoleActor actor : map.keySet()) {
                    RoleActor newActor = actor.clone();
                    if (newActor.hasSelfName()) {
                        newActor.setIndividual(new Role(String.valueOf(actor.getName()) + " " + (Object)((Object)gender)));
                    }
                    RoleActors actors = map.get(actor);
                    RoleActors newActors = new RoleActors();
                    if (actors != null) {
                        for (RoleActor alterActor : actors.toList()) {
                            RoleActor newAlterActor = alterActor.clone();
                            if (newAlterActor.hasSelfName()) {
                                newAlterActor.setIndividual(new Role(String.valueOf(alterActor.getName()) + " " + (Object)((Object)gender)));
                            }
                            newActors.add(newAlterActor);
                        }
                    }
                    result.put(newActor, newActors);
                }
            }
        } else {
            for (RoleRelation relation : this.relations.toSortedList()) {
                RoleActors products;
                RoleActor self = relation.getSelf();
                if (!egoGender.specifies(self.getEgoGender())) continue;
                RoleActor genderedSelf = self.withEgoGender(egoGender);
                if (!self.hasSelfName()) {
                    genderedSelf.setAlterGender(RoleActor.getUniqueAlterGender(this.relations.getGenderConfigs().get(self.getIndividual()), null, egoGender));
                }
                if ((products = (RoleActors)result.get(genderedSelf)) == null) {
                    products = new RoleActors();
                    result.put(genderedSelf, products);
                }
                for (RoleActor actor : relation.getActors().toListSortedByRoles()) {
                    RoleActor genderedActor = actor.withEgoGender(egoGender);
                    if (genderedActor.hasSelfName() && egoGender.isUnknown() || genderedActor.isSelf() || !genderedActor.hasCorrectGender(genderedSelf, this.relations)) continue;
                    products.addNew(genderedActor);
                }
            }
        }
        return result;
    }

    private static boolean isRepresented(RoleActor actor, Collection<RoleActor> actors) {
        boolean result = false;
        for (RoleActor other : actors) {
            if (!other.hasName(actor.getName())) continue;
            result = true;
            break;
        }
        return result;
    }

    private void setRoleRelationGraphNodes(Graph<Role> graph, Map<RoleActor, RoleActors> roleRelationMap) {
        for (RoleActor roleActor : new ArrayList<RoleActor>(roleRelationMap.keySet())) {
            Node<Role> node = graph.addNode(roleActor.getIndividual());
            if (node.getAttributeValue("GENDER") != null) {
                String value = node.getAttributeValue("GENDER");
                if (value.equals(roleActor.getAlterGender().toString())) continue;
                if (value.contains("CROSS")) {
                    if (roleActor.getRole().isCross()) {
                        if (value.contains(roleActor.getAlterGender().toString())) continue;
                        node.setAttribute("GENDER", "CROSS-UNKNOWN");
                        continue;
                    }
                    if (value.contains(roleActor.getAlterGender().toString())) {
                        node.setAttribute("GENDER", roleActor.getAlterGender().toString());
                        continue;
                    }
                    node.setAttribute("GENDER", "UNKNOWN");
                    continue;
                }
                if (value.equals(roleActor.getAlterGender().toString())) continue;
                if (value.equals("UNKNOWN")) {
                    node.setAttribute("GENDER", roleActor.getAlterGender().toString());
                    continue;
                }
                node.setAttribute("GENDER", "X");
                continue;
            }
            if (roleActor.getRole().isCross()) {
                node.setAttribute("GENDER", "CROSS-" + roleActor.getAlterGender().toString());
                continue;
            }
            node.setAttribute("GENDER", roleActor.getAlterGender().toString());
        }
        for (Node node : graph.getNodes()) {
            if (node.getAttributeValue("GENDER") == null || !node.getAttributeValue("GENDER").equals("X")) continue;
            node.setAttribute("GENDER", "UNKNOWN");
        }
    }

    /*
     * WARNING - void declaration
     */
    public List<Graph<Role>> getRoleRelationGraphsGendered(Graph<Role> source) {
        ArrayList<Graph<Role>> result = new ArrayList<Graph<Role>>();
        Nodes<Role> maleNodes = new Nodes<Role>();
        Nodes<Role> femaleNodes = new Nodes<Role>();
        Nodes<Role> maleNodesCross = new Nodes<Role>();
        Nodes<Role> femaleNodesCross = new Nodes<Role>();
        ArrayList<Nodes<Role>> nodesList = new ArrayList<Nodes<Role>>();
        nodesList.add(maleNodes);
        nodesList.add(femaleNodes);
        nodesList.add(maleNodesCross);
        nodesList.add(femaleNodesCross);
        String[] labels = new String[]{"MALE", "FEMALE", "CROSS-MALE", "CROSS-FEMALE"};
        for (Node<Role> node : source.getNodes()) {
            String gender = node.getAttributeValue("GENDER");
            if (gender.equals("MALE") || gender.equals("UNKNOWN")) {
                maleNodes.add(node);
            }
            if (gender.equals("FEMALE") || gender.equals("UNKNOWN")) {
                femaleNodes.add(node);
            }
            if (gender.equals("CROSS-MALE") || gender.equals("CROSS-UNKNOWN")) {
                maleNodesCross.add(node);
            }
            if (!gender.equals("CROSS-FEMALE") && !gender.equals("CROSS-UNKNOWN")) continue;
            femaleNodesCross.add(node);
        }
        boolean bl = false;
        for (Nodes nodes : nodesList) {
            void var9_14;
            result.add(GraphMaker.extractSubgraph(source, nodes.toListSortedById(), labels[var9_14]));
            ++var9_14;
        }
        return result;
    }

    public Graph<Role> getRoleRelationGraphInternal(Link.LinkType type) {
        Graph<Role> result = new Graph<Role>();
        result.setLabel(String.valueOf(this.getTitle()) + " Same-Sex");
        Map<RoleActor, RoleActors> map = this.getRoleRelationMap(null);
        this.setRoleRelationGraphNodes(result, map);
        for (RoleActor self : new ArrayList<RoleActor>(map.keySet())) {
            RoleActors alters = map.get(self);
            if (alters == null) continue;
            for (RoleActor alter : alters.toListSortedByRoles()) {
                if (!self.getAlterGender().matchs(alter.getAlterGender()) || !self.getEgoGender().matchs(alter.getEgoGender()) || !self.getAlterGender().matchs(self.getEgoGender()) || !alter.getAlterGender().matchs(alter.getEgoGender()) || type != null && alter.getRole().getLinkType() != type) continue;
                if (!alter.isParent()) {
                    result.addLink(self.getIndividual(), alter.getIndividual(), alter.getRole().getLinkType(), 1.0, alter.getRole().getName());
                    continue;
                }
                result.addLink(alter.getIndividual(), self.getIndividual(), alter.getRole().getLinkType(), 1.0, alter.getRole().invertName());
            }
        }
        result.renumberNodesByLabel();
        return result;
    }

    public Graph<Role> getRoleRelationGraph(Gender egoGender) {
        Graph<Role> result = new Graph<Role>();
        if (egoGender != null) {
            result.setLabel(String.valueOf(this.getTitle()) + " " + egoGender.toSpeakerString());
        } else {
            result.setLabel(String.valueOf(this.getTitle()) + " Total");
        }
        Map<RoleActor, RoleActors> map = this.getRoleRelationMap(egoGender);
        this.setRoleRelationGraphNodes(result, map);
        for (RoleActor self : new ArrayList<RoleActor>(map.keySet())) {
            RoleActors alters = map.get(self);
            if (alters == null) continue;
            for (RoleActor alter : alters.toListSortedByRoles()) {
                if (!alter.isParent()) {
                    result.addLink(self.getIndividual(), alter.getIndividual(), alter.getRole().getLinkType(), 1.0, alter.getRole().getName());
                    continue;
                }
                result.addLink(alter.getIndividual(), self.getIndividual(), alter.getRole().getLinkType(), 1.0, alter.getRole().invertName());
            }
        }
        result.renumberNodesByLabel();
        return result;
    }

    public Graph<Role>[] getRoleRelationGraphs() {
        if (this.roleRelationGraphs == null) {
            this.roleRelationGraphs = new Graph[2];
            int i = 0;
            while (i < 2) {
                this.roleRelationGraphs[i] = this.getRoleRelationGraph(Gender.valueOf(i));
                ++i;
            }
        }
        return this.roleRelationGraphs;
    }

    public Map<Value, Graph<Role>>[] getRoleRelationSubGraphs() {
        if (this.roleRelationSubGraphs == null) {
            this.roleRelationSubGraphs = new TreeMap[2];
            int i = 0;
            while (i < 2) {
                this.roleRelationSubGraphs[i] = GraphMaker.createSubgraphsByLineTags(this.getRoleRelationGraph(Gender.valueOf(i)));
                this.roleRelationSubGraphs[i].put(new Value(KinType.UNKNOWN), this.getRoleRelationGraphs()[i]);
                ++i;
            }
        }
        return this.roleRelationSubGraphs;
    }

    private Graph<Role> getGraph(KinType kinType, Gender egoGender) {
        Graph<Role> result = kinType == KinType.UNKNOWN ? this.getRoleRelationGraphs()[egoGender.toInt()] : this.getRoleRelationSubGraphs()[egoGender.toInt()].get(new Value(kinType.toString()));
        return result;
    }

    private Value getGraphStatistics(KinType kinType, Gender egoGender, String indicator) {
        Value result = GraphValuator.get(this.getGraph(kinType, egoGender), indicator);
        return result;
    }

    public Value getGraphStatistics(Gender egoGender, String indicator) {
        Value result = GraphValuator.get(this.getRoleRelationGraphs()[egoGender.toInt()], indicator);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public StringList getNetworkAnalysis() {
        void var7_15;
        StringList result = new StringList();
        List<Graph<Role>> genderedGraphs = this.getRoleRelationGraphsGendered(this.getRoleRelationGraphInternal(Link.LinkType.ARC));
        List<String> indicators2 = Arrays.asList("SIZE", "NODES", "NRLINES", "NRCOMPONENTS", "CONCENTRATION", "DENSITY", "MEANDEGREE", "MAXDEPTH", "MAXDEPTH_NORM", "MEANDEPTH", "MEANDEPTH_NORM", "CYCLERANK", "NRCYCLIC", "NRCYCLIC_NORM", "CYCLIC", "NRLOOPS", "LOOPS", "NRTOPS", "TOPS", "NRBOTTOMS", "BOTTOMS", "NRISOLATES", "ISOLATES", "NRDOWNFORKS", "DOWNFORKS", "NRUPFORKS", "UPFORKS");
        HashMap qualiMaps = new HashMap();
        HashMap quantiMaps = new HashMap();
        String line = "";
        for (String string : indicators2) {
            line = String.valueOf(line) + "\t" + string;
        }
        result.appendln(line);
        result.appendln();
        for (Graph graph : genderedGraphs) {
            line = graph.getLabel();
            TreeMap<String, String> qualiMap = new TreeMap<String, String>();
            TreeMap<String, Value> quantiMap = new TreeMap<String, Value>();
            if (!graph.getLabel().contains("CROSS")) {
                qualiMaps.put(graph.getLabel(), qualiMap);
                quantiMaps.put(graph.getLabel(), quantiMap);
            }
            for (String indicator1 : indicators2) {
                Value value = GraphValuator.get(graph, indicator1);
                quantiMap.put(indicator1, value);
                line = String.valueOf(line) + "\t" + value;
                if (indicator1.equals("CONCENTRATION")) {
                    if (value.doubleValue() == 100.0) {
                        qualiMap.put(indicator1, "COHESIVE");
                        continue;
                    }
                    qualiMap.put(indicator1, "DISPERSED");
                    continue;
                }
                if (indicator1.equals("NRLOOPS")) {
                    if (value.intValue() > 0) {
                        qualiMap.put(indicator1, "LOOPS");
                        continue;
                    }
                    qualiMap.put(indicator1, "NOLOOPS");
                    continue;
                }
                if (indicator1.equals("NRDOWNFORKS")) {
                    if (value.intValue() > 1) {
                        qualiMap.put(indicator1, "MULTI-COLLATERAL");
                        continue;
                    }
                    if (value.intValue() == 1) {
                        qualiMap.put(indicator1, "UNI-COLLATERAL");
                        continue;
                    }
                    qualiMap.put(indicator1, "NON-COLLATERAL");
                    continue;
                }
                if (indicator1.equals("NRUPFORKS")) {
                    if (value.intValue() > 1) {
                        qualiMap.put(indicator1, "MULTI-AFFINAL");
                        continue;
                    }
                    if (value.intValue() == 1) {
                        qualiMap.put(indicator1, "UNI-AFFINAL");
                        continue;
                    }
                    qualiMap.put(indicator1, "NON-AFFINAL");
                    continue;
                }
                if (indicator1.equals("NRTOPS")) {
                    if (value.intValue() > 1) {
                        qualiMap.put(indicator1, "MULTI-APICAL");
                        continue;
                    }
                    if (value.intValue() == 1) {
                        qualiMap.put(indicator1, "UNI-APICAL");
                        continue;
                    }
                    qualiMap.put(indicator1, "CIRCULAR");
                    continue;
                }
                if (indicator1.equals("NRBOTTOMS")) {
                    if (value.intValue() > 1) {
                        qualiMap.put(indicator1, "MULTI-BASAL");
                        continue;
                    }
                    if (value.intValue() == 1) {
                        qualiMap.put(indicator1, "UNI-BASAL");
                        continue;
                    }
                    qualiMap.put(indicator1, "CIRCULAR");
                    continue;
                }
                if (indicator1.equals("NRCYCLIC_NORM")) {
                    if (value.doubleValue() == 100.0) {
                        qualiMap.put(indicator1, "CYCLIC");
                        continue;
                    }
                    if ((double)value.intValue() == 0.0) {
                        qualiMap.put(indicator1, "ACYCLIC");
                        continue;
                    }
                    qualiMap.put(indicator1, "NON-ACYCLIC");
                    continue;
                }
                if (!indicator1.equals("MEANDEGREE_NORM")) continue;
                if (value.doubleValue() == 100.0) {
                    qualiMap.put(indicator1, "VERTICAL");
                    continue;
                }
                if ((double)value.intValue() == 0.0) {
                    qualiMap.put(indicator1, "HORIZONTAL");
                    continue;
                }
                if ((double)value.intValue() > 50.0) {
                    qualiMap.put(indicator1, "VERTICAL BIAS");
                    continue;
                }
                qualiMap.put(indicator1, "HORIZONTAL BIAS");
            }
            result.appendln(line);
            if (graph.getLabel().contains("CROSS")) continue;
            int i = 1;
            for (Graph component : GraphUtils.componentGraphs(graph)) {
                line = String.valueOf(graph.getLabel()) + "_" + i;
                for (String indicator : indicators2) {
                    String oldValue;
                    if (indicator.equals("NRCOMPONENTS") || indicator.equals("CONCENTRATION")) {
                        line = String.valueOf(line) + "\t";
                        continue;
                    }
                    Value value = GraphValuator.get(component, indicator);
                    line = String.valueOf(line) + "\t" + value;
                    if (!indicator.equals("NRTOPS") && !indicator.equals("NRBOTTOMS") || value.intValue() != 0 || GraphValuator.get(component, "NRISOLATES").intValue() == GraphValuator.get(component, "SIZE").intValue() || (oldValue = (String)qualiMap.get(indicator)) == null || oldValue.contains("CIRCULAR")) continue;
                    qualiMap.put(indicator, String.valueOf(oldValue) + "-CIRCULAR");
                }
                result.appendln(line);
                ++i;
            }
            result.appendln("");
        }
        result.appendln();
        result.appendln("Summary");
        result.appendln();
        for (String string : ((Map)qualiMaps.get("MALE")).keySet()) {
            String femaleLine;
            String maleLine = String.valueOf(string) + "\t" + (String)((Map)qualiMaps.get("MALE")).get(string);
            if (!maleLine.equals(femaleLine = String.valueOf(string) + "\t" + (String)((Map)qualiMaps.get("FEMALE")).get(string))) {
                maleLine = String.valueOf(maleLine) + " / " + (String)((Map)qualiMaps.get("FEMALE")).get(string);
                result.appendln(maleLine);
                continue;
            }
            result.appendln(maleLine);
        }
        String string = "SYMMETRIC";
        for (String indicator : ((Map)quantiMaps.get("MALE")).keySet()) {
            if (((Value)((Map)quantiMaps.get("MALE")).get(indicator)).equals(((Map)quantiMaps.get("FEMALE")).get(indicator)) || ((Value)((Map)quantiMaps.get("MALE")).get(indicator)).isList()) continue;
            String string2 = "ASYMMETRIC";
            break;
        }
        result.append("SYMMETRY\t" + (String)var7_15);
        return result;
    }

    public List<RoleRelationMaker.RoleRelationRule> getRules() {
        return this.rules;
    }

    public Roles getEmicGenerator(RoleDefinition definition) {
        RoleActor actor = definition.getAlter();
        Roles result = this.relations.getEmicRoles(actor.getRole(), actor.getEgoGender(), actor.getAlterGender(), actor.getAlterAge());
        return result;
    }

    public static enum CousinClassification {
        BIFURCATE_MERGING,
        BIFURCATE_COLLATERAL,
        GENERATIONAL,
        LINEAL,
        UNDEFINED;

    }
}

