/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net.relations;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.tip.puck.PuckException;
import org.tip.puck.net.Attributable;
import org.tip.puck.net.Attribute;
import org.tip.puck.net.Attributes;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Individuals;
import org.tip.puck.net.Populatable;
import org.tip.puck.net.relations.Actor;
import org.tip.puck.net.relations.Actors;
import org.tip.puck.net.relations.RelationEnvironment;
import org.tip.puck.net.relations.RelationModel;
import org.tip.puck.net.relations.Role;
import org.tip.puck.net.relations.Roles;
import org.tip.puck.net.relations.workers.RelationValuator;
import org.tip.puck.net.workers.IndividualValuator;
import org.tip.puck.segmentation.Segmentation;
import org.tip.puck.sequences.Ordinal;
import org.tip.puck.util.Numberable;
import org.tip.puck.util.Value;

public class Relation
implements Numberable,
Attributable,
Populatable {
    private int id;
    private int typedId;
    private RelationModel model;
    private String name;
    private Actors actors;
    private Attributes attributes;

    public Relation(RelationModel model) {
        this.model = model;
        this.actors = new Actors();
        this.attributes = new Attributes();
    }

    public Relation(int id, int typedId, RelationModel model, String name, Actor ... actors) {
        this.id = id;
        this.typedId = typedId;
        this.model = model;
        this.name = name;
        this.actors = new Actors();
        Actor[] actorArray = actors;
        int n = actors.length;
        int n2 = 0;
        while (n2 < n) {
            Actor actor = actorArray[n2];
            this.actors.add(actor);
            ++n2;
        }
        this.attributes = new Attributes();
    }

    public Actors actors() {
        return this.actors;
    }

    public boolean addActor(Individual individual, Role role) {
        boolean result = this.actors().add(new Actor(individual, role));
        individual.relations().add(this);
        return result;
    }

    public boolean addNewActor(Individual individual, Role role) {
        Actor actor = new Actor(individual, role);
        boolean result = this.actors().addNew(actor);
        if (result) {
            individual.relations().add(this);
        }
        return result;
    }

    public Attributes attributes() {
        Attributes result = this.attributes;
        return result;
    }

    public boolean equals(Object obj) {
        boolean result = obj != null && this.getId() == ((Relation)obj).getId();
        return result;
    }

    public Actor getActor(Actor actor) {
        Actor result = null;
        for (Actor thisActor : this.actors) {
            if (!thisActor.equals(actor)) continue;
            result = thisActor;
            break;
        }
        return result;
    }

    public Actor getActor(Individual individual, String roleName) {
        Actor result = null;
        Actors actors = this.actors().getById(individual.getId()).getByRole(roleName);
        if (actors.size() > 0) {
            result = (Actor)actors.get(0);
        }
        return result;
    }

    @Override
    public String getAttributeValue(String label) {
        Attribute attribute = (Attribute)this.attributes().get(label);
        String result = attribute == null ? null : attribute.getValue();
        return result;
    }

    public Actors getDependants(Actor referent) {
        Actors result = new Actors();
        if (referent != null) {
            for (Actor actor : this.actors) {
                if (actor.getReferent() == null || !actor.getReferent().equals(referent.getIndividual())) continue;
                result.add(actor);
            }
        }
        return result;
    }

    public Individual getFirstIndividual() {
        Iterator iterator;
        Individual result = null;
        Individuals individuals = this.getIndividuals();
        if (individuals != null && (iterator = individuals.iterator()).hasNext()) {
            Individual individual;
            result = individual = (Individual)iterator.next();
        }
        return result;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public Individuals getIndividuals() {
        Individuals result = new Individuals();
        for (Actor actor : this.actors) {
            result.add(actor.getIndividual());
        }
        return result;
    }

    @Override
    public Individuals getIndividuals(Segmentation segmentation) {
        Individuals result = new Individuals();
        for (Individual individual : this.getIndividuals()) {
            if (!segmentation.getCurrentIndividuals().contains(individual)) continue;
            result.add(individual);
        }
        return result;
    }

    @Override
    public Individuals getAllIndividuals(List<Ordinal> times) {
        return this.getIndividuals();
    }

    public Individuals getIndividuals(List<String> roleNames) {
        Individuals result = new Individuals();
        for (Actor actor : this.actors) {
            if (!roleNames.contains(actor.getRole().getName())) continue;
            result.add(actor.getIndividual());
        }
        return result;
    }

    public Individuals getIndividuals(String roleName) {
        Individuals result = new Individuals();
        for (Actor actor : this.actors) {
            if (!actor.getRole().getName().equals(roleName)) continue;
            result.add(actor.getIndividual());
        }
        return result;
    }

    public RelationModel getModel() {
        return this.model;
    }

    public String getName() {
        return this.name;
    }

    public Individuals getReferents(Individual ego) {
        Individuals result = new Individuals();
        if (ego != null) {
            for (Actor actor : this.actors) {
                if (actor.getIndividual() != ego || actor.getReferent() == null || result.contains(actor.getReferent())) continue;
                result.add(actor.getReferent());
            }
        }
        return result;
    }

    public List<String> getRoleNames(Individual individual) {
        ArrayList<String> result = new ArrayList<String>();
        for (Actor actor : this.actors) {
            if (!actor.getIndividual().equals(individual)) continue;
            result.add(actor.getRole().getName());
        }
        return result;
    }

    public String getRoleNamesAsString(Individual individual) {
        String result = "";
        for (Actor actor : this.actors) {
            if (!actor.getIndividual().equals(individual)) continue;
            result = String.valueOf(result) + actor.getRole().getName() + " ";
        }
        return result;
    }

    public Roles getRoles(Individual individual) {
        Roles result = new Roles();
        for (Actor actor : this.actors) {
            if (!actor.getIndividual().equals(individual)) continue;
            result.add(actor.getRole());
        }
        return result;
    }

    public Integer getTime(String dateLabel) {
        Value timeValue = RelationValuator.get(this, dateLabel, null);
        Integer result = timeValue != null ? Integer.valueOf(timeValue.intValue()) : null;
        return result;
    }

    public int getTypedId() {
        return this.typedId;
    }

    public boolean hasActor(Actor actor) {
        boolean result = actor == null ? false : this.actors.hasActor(actor.getId(), actor.getRole().getName());
        return result;
    }

    public boolean hasActor(Individual individual) {
        boolean result = individual == null ? false : this.actors.hasActor(individual.getId());
        return result;
    }

    public boolean hasActor(Individual individual, String role) {
        boolean result = individual == null ? false : this.actors.hasActor(individual.getId(), role);
        return result;
    }

    public boolean hasActor(int id) {
        boolean result = this.actors.hasActor(id);
        return result;
    }

    public boolean hasActor(int id, String role) {
        boolean result = this.actors.hasActor(id, role);
        return result;
    }

    public boolean hasActors(String ... roleNames) {
        boolean result = false;
        String[] stringArray = roleNames;
        int n = roleNames.length;
        int n2 = 0;
        while (n2 < n) {
            String roleName = stringArray[n2];
            if (this.actors.getByRole(roleName).size() > 0) {
                result = true;
                break;
            }
            ++n2;
        }
        return result;
    }

    public Actors getDifferentwActors(Relation other) {
        Actors result = new Actors();
        if (other == null) {
            result.addAll(this.actors);
        } else {
            for (Actor actor : this.actors) {
                if (other.actors().contains(actor)) continue;
                result.add(actor);
            }
        }
        return result;
    }

    public boolean hasAttributeValue(String label) {
        boolean result = label == null ? true : this.getAttributeValue(label) != null;
        return result;
    }

    @Override
    public String hashKey() {
        String result = "" + this.id;
        return result;
    }

    public boolean hasRole(Individual individual, String roleName) {
        boolean result = false;
        for (Actor actor : this.actors) {
            if (actor.getIndividual() != individual || !actor.getRole().getName().equals(roleName)) continue;
            result = true;
            break;
        }
        return result;
    }

    public boolean hasTime(String dateLabel, Integer time) {
        boolean result = this.getTime(dateLabel) != null && this.getTime(dateLabel).equals(time);
        return result;
    }

    public boolean matches(String pattern) {
        boolean result;
        if (StringUtils.isBlank((CharSequence)pattern)) {
            result = false;
        } else {
            String targetPattern = pattern.toLowerCase();
            if (this.name.toLowerCase().contains(targetPattern)) {
                result = true;
            } else {
                boolean ended = false;
                result = false;
                Iterator iterator = this.actors.iterator();
                while (!ended) {
                    if (iterator.hasNext()) {
                        Actor actor = (Actor)iterator.next();
                        if (!actor.getIndividual().getName().toLowerCase().contains(targetPattern)) continue;
                        ended = true;
                        result = true;
                        continue;
                    }
                    ended = true;
                    result = false;
                }
            }
        }
        return result;
    }

    public void removeActor(Actor actor) {
        this.actors.remove(actor);
        actor.getIndividual().relations().remove(this);
    }

    public void removeActor(int id) {
        for (Actor actor : this.actors.toList()) {
            if (actor.getId() != id) continue;
            this.actors.remove(actor);
        }
    }

    public void setAttribute(String label, String value) {
        this.attributes().put(label, value);
    }

    @Override
    public void setId(int id) {
        this.id = id;
    }

    public void setModel(RelationModel model) {
        this.model = model;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTypedId(int typedId) {
        this.typedId = typedId;
    }

    public String toString() {
        String result = this.model + " " + this.id + " " + this.name;
        if (this.id != this.typedId) {
            result = String.valueOf(result) + " (" + this.typedId + ")";
        }
        return result;
    }

    public void updateReferents(String roleName) {
        Individual referent = null;
        for (Actor actor : this.actors) {
            if (!actor.getRole().getName().equals(roleName) || actor.getReferent() != null) continue;
            referent = actor.getIndividual();
            break;
        }
        if (referent != null) {
            for (Actor actor : this.actors) {
                if (actor.getReferent() != null || actor.getIndividual() == referent || actor.getRole().getName().equals(roleName)) continue;
                actor.setReferent(referent);
            }
        }
    }

    public String getActorsAsString(String roleName, RelationEnvironment egoEnvironment) throws PuckException {
        String result = "";
        ArrayList<String> actorNames = new ArrayList<String>();
        for (Actor actor : this.actors().getByRole(roleName).toSortedList()) {
            if (actor.getIndividual() == egoEnvironment.getEgo() && roleName.equals("MIG")) continue;
            List<String> relations = egoEnvironment.getRelationsByAlter().get(actor.getIndividual());
            relations.remove("KIN");
            actorNames.add(actor.getIndividual() + " " + relations);
        }
        if (!actorNames.isEmpty()) {
            result = ((Object)actorNames).toString();
        } else if (roleName.equals("HOST")) {
            if (RelationValuator.isBirth(this) && egoEnvironment.getEgo().getMother() != null) {
                result = String.valueOf(result) + egoEnvironment.getEgo().getMother() + " [MOTHER]";
            } else {
                for (String impersonalRelation : RelationValuator.getImpersonalRelationTypes(this, egoEnvironment.getEgo(), egoEnvironment.getEgoRoleName(), egoEnvironment.getImpersonalAlterLabel(), egoEnvironment.getRelationsByAlter())) {
                    result = String.valueOf(result) + impersonalRelation + " ";
                }
            }
        }
        return result;
    }

    public String getActorsAsString(RelationEnvironment egoEnvironment) throws PuckException {
        String result = "";
        for (String roleName : egoEnvironment.getRoleNames()) {
            result = String.valueOf(result) + roleName + ":" + this.getActorsAsString(roleName, egoEnvironment) + "\t";
        }
        return result;
    }

    public Relation clone() {
        Relation result = new Relation(this.id, this.typedId, this.model, this.name, new Actor[0]);
        for (Actor actor : this.actors) {
            result.addActor(actor.getIndividual(), actor.getRole());
        }
        for (Attribute attribute : this.attributes) {
            result.attributes.add(attribute);
        }
        return result;
    }

    @Override
    public Relation clone(int id) {
        Relation result = this.clone();
        result.setId(id);
        return result;
    }

    public Relation ageFiltered(int threshold, int time) {
        Relation result = new Relation(this.id, this.typedId, this.model, this.name, new Actor[0]);
        for (Actor actor : this.actors) {
            if (IndividualValuator.ageAtYear(actor.getIndividual(), time) >= threshold) {
                result.actors.add(actor);
                continue;
            }
            if (IndividualValuator.getBirthYear(actor.getIndividual()) != null) continue;
            result.actors.add(actor);
        }
        for (Attribute attribute : this.attributes) {
            result.attributes.add(attribute);
        }
        return result;
    }
}

