/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.geo.tools;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import java.util.ArrayList;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.referencing.CRS;
import org.geotools.referencing.GeodeticCalculator;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.geometry.coordinate.Position;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.geo.Coordinate2;
import org.tip.puck.geo.Place;
import org.tip.puck.geo.io.BuildingGeoLinks;
import org.tip.puck.graphs.Graph;
import org.tip.puck.graphs.Node;

public class GeotoolsUtils {
    private static final Logger logger = LoggerFactory.getLogger(GeotoolsUtils.class);
    private GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory(null);

    public ArrayList<DefaultFeatureCollection> getFeaturesForNodesPlaces(Graph<Place> geoNetwork, Graph<?> geoFlowNetwork) {
        ArrayList<DefaultFeatureCollection> collectionsPointsAndLines = new ArrayList<DefaultFeatureCollection>();
        SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
        b.setName("SCHEMA_POINT");
        b.setCRS((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        b.add("id_geonames", Integer.class);
        b.add("name", String.class);
        b.add("country", String.class);
        b.add("the_geom", Point.class);
        SimpleFeatureType pointFeatureType = b.buildFeatureType();
        DefaultFeatureCollection featurePointsCollection = new DefaultFeatureCollection("internal", pointFeatureType);
        for (Node<Place> node : geoNetwork.getNodes()) {
            Point point = this.geometryFactory.createPoint(GeotoolsUtils.convert(node.getReferent().getCoordinate2()));
            SimpleFeature f = SimpleFeatureBuilder.build((SimpleFeatureType)pointFeatureType, (Object[])new Object[]{node.getReferent().getIdGeonames(), node.getReferent().getToponym(), node.getReferent().getCountry_ISO2(), point}, null);
            if (f == null) continue;
            featurePointsCollection.add(f);
        }
        collectionsPointsAndLines.add(featurePointsCollection);
        geoNetwork.addLinksByIds(geoNetwork.getLinks());
        BuildingGeoLinks buildingGeoLinks = new BuildingGeoLinks();
        DefaultFeatureCollection featureLinesCollection = buildingGeoLinks.buildLinkGeometry(null, geoNetwork);
        collectionsPointsAndLines.add(featureLinesCollection);
        return collectionsPointsAndLines;
    }

    public static Coordinate convert(Coordinate2 source) {
        Coordinate result = source == null ? null : new Coordinate(source.getLongitude(), source.getLatitude(), source.getElevation());
        return result;
    }

    public static ArrayList<DefaultFeatureCollection> getFeaturesForNodesPlaces(Graph<Place> graph) {
        ArrayList<DefaultFeatureCollection> result = new ArrayList<DefaultFeatureCollection>();
        GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory(null);
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName("SCHEMA_POINT");
        builder.setCRS((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        builder.add("id_geonames", String.class);
        builder.add("name", String.class);
        builder.add("weight", Double.class);
        builder.add("the_geom", Point.class);
        SimpleFeatureType pointFeatureType = builder.buildFeatureType();
        DefaultFeatureCollection featurePointsCollection = new DefaultFeatureCollection("internal", pointFeatureType);
        for (Node<Place> node : graph.getNodes()) {
            logger.debug("node.getReferent={}", (Object)node.getReferent());
            Point point = geometryFactory.createPoint(GeotoolsUtils.convert(node.getReferent().getCoordinate2()));
            SimpleFeature feature = SimpleFeatureBuilder.build((SimpleFeatureType)pointFeatureType, (Object[])new Object[]{node.getReferent().getExtraData(), node.getReferent().getToponym(), node.getWeight(), point}, null);
            if (feature == null) continue;
            featurePointsCollection.add(feature);
        }
        result.add(featurePointsCollection);
        BuildingGeoLinks buildingGeoLinks = new BuildingGeoLinks();
        DefaultFeatureCollection featureLinesCollection = buildingGeoLinks.buildLinkGeometry2(null, graph);
        result.add(featureLinesCollection);
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Double distance(Place first, Place second, char unit) {
        Double result = null;
        if (first.getCoordinate2() != null && second.getCoordinate2() != null) {
            CoordinateReferenceSystem crs = null;
            try {
                crs = CRS.decode((String)"EPSG:4326");
            }
            catch (NoSuchAuthorityCodeException e1) {
                e1.printStackTrace();
            }
            catch (FactoryException e1) {
                e1.printStackTrace();
            }
            if (crs == null) return result;
            GeodeticCalculator gc = new GeodeticCalculator(crs);
            Coordinate temp_coord_start = new Coordinate(first.getCoordinate2().getLongitude(), first.getCoordinate2().getLatitude());
            Coordinate temp_coord_end = new Coordinate(second.getCoordinate2().getLongitude(), second.getCoordinate2().getLatitude());
            try {
                gc.setStartingPosition((Position)JTS.toDirectPosition((Coordinate)temp_coord_start, (CoordinateReferenceSystem)crs));
                gc.setDestinationPosition((Position)JTS.toDirectPosition((Coordinate)temp_coord_end, (CoordinateReferenceSystem)crs));
            }
            catch (TransformException e) {
                e.printStackTrace();
            }
            result = gc.getOrthodromicDistance();
            switch (unit) {
                default: {
                    return result / 1000.0;
                }
                case 'M': {
                    return result / 1000.0 * 0.621371;
                }
                case 'N': {
                    return result / 1000.0 * 0.539957;
                }
            }
        }
        if (first.getCoordinate2() == null) {
            System.err.println("Coordinates missing for " + first);
        }
        if (second.getCoordinate2() != null) return null;
        System.err.println("Coordinates missing for " + second);
        return null;
    }
}

