/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.geo.io;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateList;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import javax.swing.JProgressBar;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.tip.puck.geo.Coordinate2;
import org.tip.puck.geo.Place;
import org.tip.puck.geo.tools.GeotoolsUtils;
import org.tip.puck.graphs.Graph;
import org.tip.puck.graphs.Link;

public class BuildingGeoLinks {
    DefaultFeatureCollection featureLinesCollection;
    SimpleFeatureBuilder featureBuilder;
    GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory(null);
    SimpleFeatureType lineFeatureType;
    Object[] attributesSchema = new Object[3];

    public BuildingGeoLinks() {
        SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
        b.setName("SCHEMA_LINES");
        b.add("name", String.class);
        b.add("value", Double.class);
        b.setCRS((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        b.add("the_geom", LineString.class);
        this.lineFeatureType = b.buildFeatureType();
        this.featureLinesCollection = new DefaultFeatureCollection("internal", this.lineFeatureType);
        this.featureBuilder = new SimpleFeatureBuilder(this.lineFeatureType);
    }

    public DefaultFeatureCollection buildLinkGeometry(JProgressBar progressBar, Graph<Place> graphPlaces) {
        for (Link link : graphPlaces.getArcs()) {
            if (((Place)link.getSourceNode().getReferent()).getCoordinate2() != null & ((Place)link.getTargetNode().getReferent()).getCoordinate2() != null) {
                if (link.getSourceId() != link.getTargetId()) {
                    Coordinate[] tabCoord = new Coordinate[]{GeotoolsUtils.convert(((Place)link.getSourceNode().getReferent()).getCoordinate2()), GeotoolsUtils.convert(((Place)link.getTargetNode().getReferent()).getCoordinate2())};
                    LineString line = this.geometryFactory.createLineString(tabCoord);
                    this.attributesSchema[2] = line;
                } else {
                    int nbPoints = 10;
                    double radius = 0.1;
                    double x_start = GeotoolsUtils.convert((Coordinate2)((Place)link.getSourceNode().getReferent()).getCoordinate2()).x;
                    double y_start = GeotoolsUtils.convert((Coordinate2)((Place)link.getSourceNode().getReferent()).getCoordinate2()).y + radius;
                    Coordinate[] coordTabCircle = new Coordinate[2 * nbPoints + 1];
                    int i = 0;
                    double ang_rd = -1.5707963267948966;
                    while (ang_rd <= 4.71238898038469) {
                        double x = radius * Math.cos(ang_rd) + x_start;
                        double y = radius * Math.sin(ang_rd) + y_start;
                        coordTabCircle[i++] = new Coordinate(x, y);
                        ang_rd += Math.PI / (double)nbPoints;
                    }
                    CoordinateList coordList2 = new CoordinateList(coordTabCircle);
                    LinearRing ring = this.geometryFactory.createLinearRing(coordList2.toCoordinateArray());
                    this.attributesSchema[2] = ring;
                }
                this.attributesSchema[0] = String.valueOf(((Place)link.getSourceNode().getReferent()).getToponym()) + " -- " + ((Place)link.getTargetNode().getReferent()).getToponym();
                this.attributesSchema[1] = link.getWeight();
                SimpleFeature f = SimpleFeatureBuilder.build((SimpleFeatureType)this.lineFeatureType, (Object[])this.attributesSchema, null);
                this.featureLinesCollection.add(f);
            }
            if (progressBar == null) continue;
            int i = progressBar.getValue();
            progressBar.setValue(i++);
        }
        return this.featureLinesCollection;
    }

    public DefaultFeatureCollection buildLinkGeometry2(JProgressBar progressBar, Graph<Place> graphPlaces) {
        for (Link link : graphPlaces.getArcs()) {
            if (((Place)link.getSourceNode().getReferent()).getCoordinate2() != null & ((Place)link.getTargetNode().getReferent()).getCoordinate2() != null) {
                if (link.getSourceId() != link.getTargetId()) {
                    Coordinate[] tabCoord = new Coordinate[]{GeotoolsUtils.convert(((Place)link.getSourceNode().getReferent()).getCoordinate2()), GeotoolsUtils.convert(((Place)link.getTargetNode().getReferent()).getCoordinate2())};
                    LineString line = this.geometryFactory.createLineString(tabCoord);
                    this.attributesSchema[2] = line;
                } else {
                    Coordinate sourceCoordinate = GeotoolsUtils.convert(((Place)link.getSourceNode().getReferent()).getCoordinate2());
                    int nbPoints = 10;
                    double radius = 0.1;
                    double x_start = sourceCoordinate.x;
                    double y_start = sourceCoordinate.y + radius;
                    Coordinate[] coordTabCircle = new Coordinate[2 * nbPoints + 1];
                    int i = 0;
                    double ang_rd = -1.5707963267948966;
                    while (ang_rd <= 4.71238898038469) {
                        double x = radius * Math.cos(ang_rd) + x_start;
                        double y = radius * Math.sin(ang_rd) + y_start;
                        coordTabCircle[i++] = new Coordinate(x, y);
                        ang_rd += Math.PI / (double)nbPoints;
                    }
                    if (i > 0) {
                        coordTabCircle[i - 1].x = coordTabCircle[0].x;
                        coordTabCircle[i - 1].y = coordTabCircle[0].y;
                    }
                    CoordinateList coordList2 = new CoordinateList(coordTabCircle);
                    LinearRing ring = this.geometryFactory.createLinearRing(coordList2.toCoordinateArray());
                    this.attributesSchema[2] = ring;
                }
                this.attributesSchema[0] = String.valueOf(((Place)link.getSourceNode().getReferent()).getToponym()) + " -- " + ((Place)link.getTargetNode().getReferent()).getToponym();
                this.attributesSchema[1] = link.getWeight();
                SimpleFeature f = SimpleFeatureBuilder.build((SimpleFeatureType)this.lineFeatureType, (Object[])this.attributesSchema, null);
                this.featureLinesCollection.add(f);
            }
            if (progressBar == null) continue;
            int i = progressBar.getValue();
            progressBar.setValue(i++);
        }
        return this.featureLinesCollection;
    }

    public SimpleFeatureBuilder getFeatureBuilder() {
        return this.featureBuilder;
    }

    public DefaultFeatureCollection getFeatureLinesCollection() {
        return this.featureLinesCollection;
    }

    public GeometryFactory getGeometryFactory() {
        return this.geometryFactory;
    }

    public SimpleFeatureType getLineFeatureType() {
        return this.lineFeatureType;
    }

    public void setFeatureBuilder(SimpleFeatureBuilder featureBuilder) {
        this.featureBuilder = featureBuilder;
    }

    public void setFeatureLinesCollection(DefaultFeatureCollection featureLinesCollection) {
        this.featureLinesCollection = featureLinesCollection;
    }

    public void setGeometryFactory(GeometryFactory geometryFactory) {
        this.geometryFactory = geometryFactory;
    }

    public void setLineFeatureType(SimpleFeatureType lineFeatureType) {
        this.lineFeatureType = lineFeatureType;
    }
}

