/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.geo.graphs;

import org.tip.puck.geo.GeoLevel;
import org.tip.puck.geo.Geography;
import org.tip.puck.geo.Place;
import org.tip.puck.graphs.Graph;
import org.tip.puck.graphs.Link;
import org.tip.puck.graphs.Node;
import org.tip.puck.partitions.Cluster;

public class GeoNetworkUtils {
    public static <E> Graph<Place> createGeoNetwork(Graph<Cluster<E>> clusterNetwork, Geography geography, GeoLevel level) {
        Graph<Place> result = new Graph<Place>();
        for (Node<Cluster<E>> node : clusterNetwork.getNodes()) {
            result.addNode(node.getId(), geography.get(node.getReferent().getLabel()));
        }
        for (Link link : clusterNetwork.getLinks()) {
            if (link.isArc()) {
                result.addArc(link.getSourceId(), link.getTargetId(), link.getWeight());
            }
            if (!link.isEdge()) continue;
            result.addEdge(link.getSourceId(), link.getTargetId(), link.getWeight());
        }
        return result;
    }

    public static <E> Graph<String> createGeoNetwork2(Graph<Cluster<E>> clusterNetwork, GeoLevel level) {
        Graph<String> result = new Graph<String>();
        result.setLabel(String.valueOf(clusterNetwork.getLabel()) + "_" + (Object)((Object)level));
        for (Node<Cluster<E>> node : clusterNetwork.getNodes()) {
            result.addNode(node.getId(), node.getReferent().getLabel());
        }
        for (Link link : clusterNetwork.getLinks()) {
            if (link.isArc()) {
                result.addArc(link.getSourceId(), link.getTargetId(), link.getWeight());
            }
            if (!link.isEdge()) continue;
            result.addEdge(link.getSourceId(), link.getTargetId(), link.getWeight());
        }
        return result;
    }

    public static void writeGeoNetwork(Graph<Place> geoNetwork) {
    }
}

