/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.geo;

import com.vividsolutions.jts.geom.Coordinate;
import fr.devinsy.util.StringList;
import fr.devinsy.util.StringSet;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.tip.puck.geo.AlternateToponyms;
import org.tip.puck.geo.Coordinate2;
import org.tip.puck.geo.GeoLevel;

public class Place {
    private String toponym;
    private AlternateToponyms alternateToponyms;
    private GeoLevel geoLevel;
    private Coordinate coordinate;
    private Coordinate2 coordinate2;
    private String extraData;
    private String comment;
    private String superiorToponym;
    private Place superiorPlace;
    private String shortName;
    String geonames1;
    String geonames2;
    String geonames3;
    String countryISO2;
    Integer idGeonames;

    public Place(String toponym) {
        this.toponym = toponym;
        this.extraData = null;
        this.alternateToponyms = new AlternateToponyms();
        this.geoLevel = GeoLevel.LOCAL;
    }

    public Place(GeoLevel level, String shortName, Place superiorPlace) {
        this.shortName = shortName;
        this.superiorPlace = superiorPlace;
        this.toponym = Place.getToponym(shortName, level, superiorPlace);
        this.extraData = null;
        this.alternateToponyms = new AlternateToponyms();
        this.geoLevel = level;
    }

    public String getSuperiorToponym() {
        return this.superiorToponym;
    }

    public String getComment() {
        return this.comment;
    }

    public Coordinate getCoordinate() {
        return this.coordinate;
    }

    public Coordinate2 getCoordinate2() {
        return this.coordinate2;
    }

    public String getCountry_ISO2() {
        return this.countryISO2;
    }

    public Double getElevation() {
        Double result = this.coordinate2 == null ? null : Double.valueOf(this.coordinate2.getElevation());
        return result;
    }

    public String getExtraData() {
        return this.extraData;
    }

    public GeoLevel getGeoLevel() {
        return this.geoLevel;
    }

    public AlternateToponyms getHomonyms() {
        return this.alternateToponyms;
    }

    public String getGeonames1() {
        return this.geonames1;
    }

    public void setGeonames1(String geonames1) {
        this.geonames1 = geonames1;
    }

    public String getGeonames2() {
        return this.geonames2;
    }

    public Integer getIdGeonames() {
        return this.idGeonames;
    }

    public Double getLatitude() {
        Double result = this.coordinate2 == null ? null : Double.valueOf(this.coordinate2.getLatitude());
        return result;
    }

    public Double getLongitude() {
        Double result = this.coordinate2 == null ? null : Double.valueOf(this.coordinate2.getLongitude());
        return result;
    }

    public String getToponym() {
        return this.toponym;
    }

    public StringList getToponyms() {
        StringList result = new StringList();
        result.add((Object)this.toponym);
        result.addAll((Collection)((Object)this.getHomonyms()));
        return result;
    }

    public boolean isGeocoded() {
        boolean result = this.coordinate2 != null;
        return result;
    }

    public void setSuperiorToponym(String abovePlace) {
        this.superiorToponym = abovePlace;
    }

    public void setAlternateToponyms(String homonyms) {
        if (StringUtils.isBlank((CharSequence)homonyms)) {
            this.alternateToponyms.clear();
        } else {
            this.alternateToponyms.clear();
            String[] stringArray = homonyms.split("[;]");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String homonym = stringArray[n2];
                this.alternateToponyms.add(homonym);
                ++n2;
            }
        }
    }

    public void setAlternateToponyms(StringSet source) {
        if (source == null) {
            this.alternateToponyms.clear();
        } else {
            this.alternateToponyms.clear();
            for (String homonym : source.toStringList().sort()) {
                if (StringUtils.equals((CharSequence)this.toponym, (CharSequence)homonym)) continue;
                this.alternateToponyms.add(homonym);
            }
        }
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setCoordinate2(Coordinate2 coordinate) {
        this.coordinate2 = coordinate;
    }

    public Place setElevation(Double value) {
        if (value == null) {
            this.coordinate2 = null;
        } else {
            if (this.coordinate2 == null) {
                this.coordinate2 = new Coordinate2();
            }
            this.coordinate2.setElevation(value);
        }
        return this;
    }

    public Place setElevation(Integer value) {
        Place result = value == null ? this.setElevation((Double)null) : this.setElevation((double)value);
        return result;
    }

    public void setExtraData(String extraData) {
        this.extraData = extraData;
    }

    public void setGeoLevel(GeoLevel geoLevel) {
        this.geoLevel = geoLevel;
    }

    public Place setLatitude(Double value) {
        if (value == null) {
            this.coordinate2 = null;
        } else {
            if (this.coordinate2 == null) {
                this.coordinate2 = new Coordinate2();
            }
            this.coordinate2.setLatitude(value);
        }
        return this;
    }

    public Place setLongitude(Double value) {
        if (value == null) {
            this.coordinate2 = null;
        } else {
            if (this.coordinate2 == null) {
                this.coordinate2 = new Coordinate2();
            }
            this.coordinate2.setLongitude(value);
        }
        return this;
    }

    public void setToponym(String toponym) {
        this.toponym = toponym;
    }

    public String toString() {
        String result = this.toponym;
        return result;
    }

    public Place getSuperiorPlace() {
        return this.superiorPlace;
    }

    public void setSuperiorPlace(Place superiorPlace) {
        this.superiorPlace = superiorPlace;
    }

    public String getBitoponym() {
        String result = this.superiorPlace == null ? this.toponym : String.valueOf(this.toponym) + " / " + this.superiorPlace.toponym;
        return result;
    }

    public String getShortName() {
        return this.shortName;
    }

    public static String getToponym(String shortName, GeoLevel level, Place supPlace) {
        String result;
        switch (level) {
            case INTERCONTINENTAL: {
                result = shortName;
                break;
            }
            case CONTINENT: {
                result = shortName;
                break;
            }
            case COUNTRY: {
                result = shortName;
                break;
            }
            case DEPARTMENT: {
                result = String.valueOf(shortName) + " (Dept.)";
                break;
            }
            case TOWNSHIP: {
                if (supPlace != null && supPlace.getGeoLevel() == GeoLevel.DEPARTMENT) {
                    result = String.valueOf(shortName) + ", " + supPlace.getShortName();
                    break;
                }
                result = shortName;
                break;
            }
            case TOWN: {
                if (supPlace != null && supPlace.getGeoLevel() == GeoLevel.TOWNSHIP) {
                    Place dept = supPlace.getSuperiorPlace();
                    if (dept != null && dept.getGeoLevel() == GeoLevel.DEPARTMENT) {
                        result = String.valueOf(shortName) + " (" + supPlace.getShortName() + ", " + dept.getShortName() + ")";
                        break;
                    }
                    result = String.valueOf(shortName) + " (" + supPlace.getShortName() + ")";
                    break;
                }
                result = shortName;
                break;
            }
            case QUARTER: {
                if (supPlace != null && supPlace.getGeoLevel() == GeoLevel.TOWN) {
                    result = String.valueOf(supPlace.getShortName()) + "-" + shortName;
                    break;
                }
                result = shortName;
                break;
            }
            case SUBQUARTER: {
                if (supPlace != null && supPlace.getGeoLevel() == GeoLevel.QUARTER) {
                    Place town = supPlace.getSuperiorPlace();
                    if (town != null && town.getGeoLevel() == GeoLevel.TOWN) {
                        result = String.valueOf(town.getShortName()) + "-" + supPlace.getShortName() + "-" + shortName;
                        break;
                    }
                    result = String.valueOf(supPlace.getShortName()) + "-" + shortName;
                    break;
                }
                result = shortName;
                break;
            }
            default: {
                result = shortName;
            }
        }
        return result;
    }

    public int compareByLevel(Place place) {
        int result = this.geoLevel.compareTo(place.geoLevel);
        return result;
    }

    public Place getSuperiorPlace(List<String> placenames) {
        Place result = this;
        while (placenames != null && !placenames.isEmpty() && !placenames.contains(result.getShortName())) {
            result = result.getSuperiorPlace();
        }
        return result;
    }

    public Place atLevel(GeoLevel level) {
        Place result = this;
        if (level != GeoLevel.LOCAL) {
            while (result != null && result.getGeoLevel() != level) {
                result = result.getSuperiorPlace();
            }
        }
        return result;
    }

    public Place(String name, Coordinate coord) {
        this(name);
        this.coordinate = coord;
    }

    public Place(Integer idGeonames, String name, String geonames1, String geonames2, String geonames3, String countryCode, Coordinate coord) {
        this(name, coord);
        this.geonames1 = geonames1;
        this.geonames2 = geonames2;
        this.geonames3 = geonames3;
        this.countryISO2 = countryCode;
        this.idGeonames = idGeonames;
    }
}

