package org.tip.puck.spacetime.workers;

import org.tip.puck.net.relations.Relation;
import org.tip.puck.segmentation.Segmentation;
import org.tip.puck.spacetime.House;
import org.tip.puck.spacetime.Houses;
import org.tip.puck.spacetime.Ordinal;

public class HouseMaker {

	public static Houses createHouses(Segmentation segmentation, SpaceTimeCriteria criteria){
		Houses result;
		
		result = new Houses(criteria);
		
		for (Relation relation : segmentation.getCurrentRelations().getByModelName(criteria.getRelationModelName())){
			
			String stringId = relation.getAttributeValue(criteria.getLocalUnitLabel());
			if (stringId != null){
				
				int id = Integer.parseInt(stringId);
				House house = result.getById(id);
				if (house == null){
					house = new House(criteria.getLocalUnitLabel(), id);
					result.put(house);
				}
				
				String stringTime = relation.getAttributeValue(criteria.getDateLabel());
				if (stringTime != null){
					
					int time = Integer.parseInt(stringTime);
					house.put(relation, new Ordinal(time));

				}
			}
		}
		//
		return result;
	}		


}
