package org.tip.puck.spacetime;

import java.util.Map;
import java.util.TreeMap;

import org.tip.puck.net.Individual;
import org.tip.puck.net.Individuals;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.net.relations.Relations;
import org.tip.puck.net.workers.IndividualValuator;
import org.tip.puck.net.workers.RelationValuator;
import org.tip.puck.util.Numberable;

/**
 * 
 * @author Klaus Hamberger
 *
 */
public class Slice implements Comparable<Slice>, Numberable {
	
	int id;
	Ordinal time;
	Relations relations;
	Relations allRelations;
	String idLabel;
	String idValue;
	Map<Individual,Relation> relationsByIndividuals;
	
	
	public Slice(){
	}
	
	public Slice(Ordinal time, String constantAttributeLabel){
		
		this.time = time;
		this.relations = new Relations();
		this.allRelations = new Relations();
		this.idLabel = constantAttributeLabel;
		this.id = time.getYear();  // Temporary solution
		
		relationsByIndividuals = new TreeMap<Individual,Relation>();
		
	}
	
	public int getId() {
		return id;
	}
	
	public void setId(int id) {
		this.id = id;
	}
	
	public Ordinal time() {
		return time;
	}
	
	public void setTime(Ordinal time) {
		this.time = time;
	}
	
	@Override
	public String hashKey() {
		return id + "";
	}
	
	@Override
	public int compareTo(Slice slice) {
		return this.time.compareTo(slice.time());
	}

	public String idValue() {
		return idValue;
	}

	public void put(Relation relation){
		relations.put(relation);
	}

	public Relations relations() {
		return relations;
	}

	public Relations allRelations() {
		return allRelations;
	}

	public Map<Individual, Relation> relationsByIndividuals() {
		return relationsByIndividuals;
	}
	
	public void put (Individual individual, Relation relation){
		put(relation);
		relationsByIndividuals.put(individual, relation);
	}
	
	public Individuals members(){
		Individuals result;

		result = new Individuals();
		for (Individual individual : relationsByIndividuals.keySet()){
			result.put(individual);
		}
		//
		return result;
	}
	
	public Relation getRelation(Individual individual){
		return relationsByIndividuals.get(individual);
	}
	
	
	public boolean isIndividualLabel(String label){
		
		return IndividualValuator.getAttributeLabels(members()).contains(label);

	}
	
	public boolean isStateLabel(String label){
		
		return RelationValuator.getAttributeLabels(relations).contains(label);

	}
	
	
	
	

	
	
	

}
