package org.tip.puck.net.relations.workers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.TreeMap;

import org.apache.commons.lang3.StringUtils;
import org.tip.puck.graphs.Graph;
import org.tip.puck.graphs.Link.LinkType;
import org.tip.puck.net.Gender;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Net;
import org.tip.puck.net.relations.RelationModel;
import org.tip.puck.net.relations.Role;
import org.tip.puck.net.relations.RoleDefinition;
import org.tip.puck.net.relations.RoleDefinition.AlterAge;
import org.tip.puck.net.relations.RoleDefinition.Primary;
import org.tip.puck.net.relations.RoleDefinitions;
import org.tip.puck.net.relations.Roles;

import fr.devinsy.util.StringList;

public class RelationModelMaker {

	private static void compose(final RelationModel model, final Individual indi, final Gender egoGender, final Queue<Individual> queue,
			final List<Individual> visited, final List<String> egoNeutral) {

		RoleDefinitions roleDefinitions = model.roleDefinitions();

		if (!indi.getName().equalsIgnoreCase("ego") && roleDefinitions.getRoleByName(indi.getName()) == null) {
			System.out.println("role definition missing: " + indi+" for "+egoGender+" ego");
		}

		if (indi.getFather() != null && indi.getFather().getName() != null && !visited.contains(indi.getFather())) {
			indi.getFather().setAttribute("EGOGENDER", egoGender.toString());
			indi.getFather().setAttribute("GENERATION", (Integer.parseInt(indi.getAttributeValue("GENERATION")) + 1) + "");
			Gender childGender = indi.getGender();
			if (indi.getName().equalsIgnoreCase("Ego")) {
				if (egoNeutral.contains("PARENT")) {
					childGender = Gender.UNKNOWN;
				}
				roleDefinitions.addNew(new RoleDefinition(roleDefinitions.size(), model.role(indi.getFather()), Primary.PARENT, null, null, Gender.MALE, null,
						childGender));
			} else {
				for (Role fatherRole : roleDefinitions.getRoles(Primary.PARENT, Gender.MALE, null, childGender)) {
					Roles composition = new Roles();
					composition.add(roleDefinitions.getRoleByName(indi.getName()));
					composition.add(fatherRole);
					roleDefinitions.addNew(new RoleDefinition(roleDefinitions.size(), model.role(indi.getFather()), null, null, composition, Gender.MALE, null,
							egoGender));
				}
			}
			queue.add(indi.getFather());
			visited.add(indi.getFather());
		}

		if (indi.getMother() != null && indi.getMother().getName() != null && !visited.contains(indi.getMother())) {
			indi.getMother().setAttribute("EGOGENDER", egoGender.toString());
			indi.getMother().setAttribute("GENERATION", (Integer.parseInt(indi.getAttributeValue("GENERATION")) + 1) + "");
			Gender childGender = indi.getGender();
			if (indi.getName().equalsIgnoreCase("Ego")) {
				if (egoNeutral.contains("PARENT")) {
					childGender = Gender.UNKNOWN;
				}
				roleDefinitions.addNew(new RoleDefinition(roleDefinitions.size(), model.role(indi.getMother()), Primary.PARENT, null, null, Gender.FEMALE,
						null, childGender));
			} else {
				for (Role motherRole : roleDefinitions.getRoles(Primary.PARENT, Gender.FEMALE, null, childGender)) {
					Roles composition = new Roles();
					composition.add(roleDefinitions.getRoleByName(indi.getName()));
					composition.add(motherRole);
					roleDefinitions.addNew(new RoleDefinition(roleDefinitions.size(), model.role(indi.getMother()), null, null, composition, Gender.FEMALE,
							null, egoGender));
				}
			}
			queue.add(indi.getMother());
			visited.add(indi.getMother());
		}

		for (Individual sibling : indi.siblings()) {
			
			Gender siblingGender = indi.getGender();
			if (egoNeutral.contains("SIBLING")) {
				siblingGender = Gender.UNKNOWN;
			}

			if (sibling.getName() != null && !visited.contains(sibling)) {
				sibling.setAttribute("EGOGENDER", egoGender.toString());
				sibling.setAttribute("GENERATION", indi.getAttributeValue("GENERATION"));
				if (indi.getName().equalsIgnoreCase("Ego")) {
					roleDefinitions.addNew(new RoleDefinition(roleDefinitions.size(), model.role(sibling), Primary.SIBLING, null, null, sibling.getGender(),
							getAlterAge(sibling, indi), siblingGender));
				} else {
					for (Role siblingRole : roleDefinitions.getRoles(Primary.SIBLING, sibling.getGender(), getAlterAge(sibling, indi), siblingGender)) {
						Roles composition = new Roles();
						composition.add(roleDefinitions.getRoleByName(indi.getName()));
						composition.add(siblingRole);
						roleDefinitions.addNew(new RoleDefinition(roleDefinitions.size(), model.role(sibling), null, null, composition, sibling.getGender(),
								null, egoGender));
					}
				}
				queue.add(sibling);
				visited.add(sibling);
			}
		}

		for (Individual spouse : indi.getPartners()) {

			Gender spouseGender = indi.getGender();

			if (spouse.getName() != null && !visited.contains(spouse)) {
				spouse.setAttribute("EGOGENDER", egoGender.toString());
				spouse.setAttribute("GENERATION", indi.getAttributeValue("GENERATION"));
				if (indi.getName().equalsIgnoreCase("Ego")) {
					if (egoNeutral.contains("SPOUSE")) {
						spouseGender = Gender.UNKNOWN;
					}
					roleDefinitions.addNew(new RoleDefinition(roleDefinitions.size(), model.role(spouse), Primary.SPOUSE, null, null, spouse.getGender(), null,
							spouseGender));
				} else {
					for (Role spouseRole : roleDefinitions.getRoles(Primary.SPOUSE, spouse.getGender(), null, spouseGender)) {
						Roles composition = new Roles();
						composition.add(roleDefinitions.getRoleByName(indi.getName()));
						composition.add(spouseRole);
						roleDefinitions.addNew(new RoleDefinition(roleDefinitions.size(), model.role(spouse), null, null, composition, spouse.getGender(),
								null, egoGender));
					}
				}
				queue.add(spouse);
				visited.add(spouse);
			}
		}

		for (Individual child : indi.children()) {

			Gender parentGender = indi.getGender();

			if (child.getName() != null && !visited.contains(child)) {
				child.setAttribute("EGOGENDER", egoGender.toString());
				child.setAttribute("GENERATION", (Integer.parseInt(indi.getAttributeValue("GENERATION")) - 1) + "");

				if (indi.getName().equalsIgnoreCase("Ego")) {
					if (egoNeutral.contains("CHILD")) {
						parentGender = Gender.UNKNOWN;
					}
					Roles parentRoles = roleDefinitions.getRoles(Primary.PARENT, parentGender, null, child.getGender());
					for (Role role : parentRoles) {
						roleDefinitions.addNew(new RoleDefinition(roleDefinitions.size(), model.role(child), null, role, null, child.getGender(), null,
								parentGender));
					}
				} else {
					Roles parentRoles = roleDefinitions.getRoles(Primary.PARENT, parentGender, null, child.getGender());

					for (Role parentRole : parentRoles) {
						Role childRole = roleDefinitions.getInverseRole(parentRole, child.getGender(), parentGender);
						if (childRole != null) {
							Roles composition = new Roles();
							composition.add(roleDefinitions.getRoleByName(indi.getName()));
							composition.add(childRole);
							roleDefinitions.addNew(new RoleDefinition(roleDefinitions.size(), model.role(child), null, null, composition, child.getGender(),
									getAlterAge(child), egoGender));
						} else {
							System.out.println("Missing " + indi.getGender() + " (" + parentGender + ") " + " parentRole for " + child.getGender() + " child :"
									+ indi + " for " + child);
						}
					}
				}
				queue.add(child);
				visited.add(child);
			}
		}
		
	}

	private static void composeParents(final RelationModel model, final Individual indi, final Gender egoGender, final Queue<Individual> queue,
			final List<Individual> visited, final List<String> egoNeutral) {

		RoleDefinitions roleDefinitions = model.roleDefinitions();

		if (indi.getFather() != null && indi.getFather().getName() != null && !visited.contains(indi.getFather())) {
			indi.getFather().setAttribute("EGOGENDER", egoGender.toString());
			indi.getFather().setAttribute("GENERATION", (Integer.parseInt(indi.getAttributeValue("GENERATION")) + 1) + "");
			Gender childGender = indi.getGender();
			if (egoNeutral.contains("PARENT")) {
				childGender = Gender.UNKNOWN;
			}
			if (indi.getName().equalsIgnoreCase("Ego")) {
				roleDefinitions.addNew(new RoleDefinition(roleDefinitions.size(), model.role(indi.getFather()), Primary.PARENT, null, null, Gender.MALE, null,
						childGender));
			} else {
				for (Role fatherRole : roleDefinitions.getRoles(Primary.PARENT, Gender.MALE, null, childGender)) {
					Roles composition = new Roles();
					composition.add(roleDefinitions.getRoleByName(indi.getName()));
					composition.add(fatherRole);
					roleDefinitions.addNew(new RoleDefinition(roleDefinitions.size(), model.role(indi.getFather()), null, null, composition, null, null,
							egoGender));
				}
			}
			queue.add(indi.getFather());
			visited.add(indi.getFather());
		}

		if (indi.getMother() != null && indi.getMother().getName() != null && !visited.contains(indi.getMother())) {
			indi.getMother().setAttribute("EGOGENDER", egoGender.toString());
			indi.getMother().setAttribute("GENERATION", (Integer.parseInt(indi.getAttributeValue("GENERATION")) + 1) + "");
			Gender childGender = indi.getGender();
			if (egoNeutral.contains("PARENT")) {
				childGender = Gender.UNKNOWN;
			}
			if (indi.getName().equalsIgnoreCase("Ego")) {
				roleDefinitions.addNew(new RoleDefinition(roleDefinitions.size(), model.role(indi.getMother()), Primary.PARENT, null, null, Gender.FEMALE,
						null, childGender));
			} else {
				for (Role motherRole : roleDefinitions.getRoles(Primary.PARENT, Gender.FEMALE, null, childGender)) {
					Roles composition = new Roles();
					composition.add(roleDefinitions.getRoleByName(indi.getName()));
					composition.add(motherRole);
					roleDefinitions.addNew(new RoleDefinition(roleDefinitions.size(), model.role(indi.getMother()), null, null, composition, null, null,
							egoGender));
				}
			}
			queue.add(indi.getMother());
			visited.add(indi.getMother());
		}

	}

	public static RelationModel create(final Net net) {
		RelationModel result;

		result = new RelationModel(net.getLabel());
		createRoleDefinitions(result, net);

		//
		return result;
	}
	
	public static RelationModel createFromPositionList(final String name, final StringList roleDefinitionsList) {
		RelationModel result;

		result = new RelationModel(name);
		createRoleDefinitionsFromPositionList(result, roleDefinitionsList);

		//
		return result;
	}

	public static RelationModel create(final String name, final StringList roleDefinitionsList) {
		RelationModel result;

		result = new RelationModel(name);
		createRoleDefinitions(result, roleDefinitionsList);

		//
		return result;
	}

	public static RoleDefinitions createRoleDefinitions(final RelationModel model, final Net net) {
		RoleDefinitions result;
		
		result = new RoleDefinitions();

		Individual maleEgo = null;
		Individual femaleEgo = null;

		// Determine egos
		for (Individual indi : net.individuals()) {
			if (indi.getName().equalsIgnoreCase("Ego")) {
				indi.setAttribute("EGOGENDER", indi.getGender().toString());
				indi.setAttribute("GENERATION", "0");
				if (indi.isMale()) {
					maleEgo = indi;
				} else if (indi.isFemale()) {
					femaleEgo = indi;
				}
				if (maleEgo != null && femaleEgo != null) {
					result.setEgoGenderDistinction(true);
					break;
				}
			}
		}

		List<String> egoNeutral = new ArrayList<String>();

		if ((maleEgo != null && maleEgo.isSterile()) || (femaleEgo != null && femaleEgo.isSterile()) || !result.isEgoGenderDistinction()) {
			egoNeutral.add("CHILD");
		}
		if ((maleEgo != null && maleEgo.isOrphan()) || (femaleEgo != null && femaleEgo.isOrphan()) || !result.isEgoGenderDistinction()) {
			egoNeutral.add("PARENT");
		}
		if ((maleEgo != null && maleEgo.isSingle()) || (femaleEgo != null && femaleEgo.isSingle()) || !result.isEgoGenderDistinction()) {
			egoNeutral.add("SPOUSE");
		}
		if ((maleEgo != null && maleEgo.isUnique()) || (femaleEgo != null && femaleEgo.isUnique()) || !result.isEgoGenderDistinction()) {
			egoNeutral.add("SIBLING");
		}

		Queue<Individual> maleQueue = new LinkedList<Individual>();
		Queue<Individual> femaleQueue = new LinkedList<Individual>();
		List<Individual> visited = new ArrayList<Individual>();

		// Temporary: preliminary separate parent composition for male and
		// female ego to assure disponibility of child roles for all genders

		if (maleEgo != null) {
			maleQueue.add(maleEgo);
			visited.add(maleEgo);
			composeParents(model, maleEgo, Gender.MALE, maleQueue, visited, egoNeutral);
		}
		if (femaleEgo != null) {
			femaleQueue.add(femaleEgo);
			visited.add(femaleEgo);
			composeParents(model, femaleEgo, Gender.FEMALE, femaleQueue, visited, egoNeutral);
		}

		if (maleEgo != null) {
			compose(model, maleEgo, Gender.MALE, maleQueue, visited, egoNeutral);
			System.out.println("Male Ego environments complete: " + maleQueue);
		}

		if (femaleEgo != null) {
			compose(model, femaleEgo, Gender.FEMALE, femaleQueue, visited, egoNeutral);
			System.out.println("Female Ego environments complete: " + femaleQueue);
		}

		while (!maleQueue.isEmpty()) {
			Individual indi = maleQueue.remove();
			Gender egoGender = Gender.valueOf(indi.getAttributeValue("EGOGENDER"));
			compose(model, indi, egoGender, maleQueue, visited, egoNeutral);
		}
		
		while (!femaleQueue.isEmpty()) {
			Individual indi = femaleQueue.remove();
			Gender egoGender = Gender.valueOf(indi.getAttributeValue("EGOGENDER"));
			compose(model, indi, egoGender, femaleQueue, visited, egoNeutral);
		}
		
		result = result.clean();
		model.setRoleDefinitions(result);
		
		//
		return result;
	}
	
	public static RoleDefinitions createRoleDefinitionsFromPositionList(final RelationModel model, final StringList rolePositionList) {
		RoleDefinitions result;

		result = new RoleDefinitions();
		
		Map<String,Roles> pseudoRoles = new TreeMap<String,Roles>();
		
		int id = 0;
		
		// Set primary terms
		
		for (String rolePositionLine : rolePositionList) {
			
			String[] items = rolePositionLine.split("\t");
			id++;
			
			RoleDefinition definition = new RoleDefinition(id);
			
			for (int idx = 0; idx < items.length; idx++) {
				
				String item = items[idx];
				if (StringUtils.isEmpty(item)) {
					continue;
				}
				
				switch (idx) {
				case 0:
					definition.setRole(model.role(item));
				break;
				case 1:
					if (Character.isLowerCase(item.charAt(item.length()-1))){
						definition.setOther(item);
						item = null;
					} else if (item.charAt(0)=='e'){
						definition.setAlterAge(AlterAge.ELDER);
						item = item.substring(1);
					} else if (item.charAt(0)=='y'){
						definition.setAlterAge(AlterAge.YOUNGER);
						item = item.substring(1);
					}
					if (item!=null && !RoleDefinitions.setPrimaryFromString(definition,item)){
						definition.setComposition();
						definition.composition().add(new Role(item));
						if (pseudoRoles.get(item)==null){
							pseudoRoles.put(item,new Roles());
						}
						pseudoRoles.get(item).add(definition.role());
						
						char firstLetter = item.charAt(0);
						if (definition.egoGender().isUnknown() && (firstLetter=='H' || firstLetter=='W')){
							definition.setEgoGender(Gender.valueOf(firstLetter).invert());
						}

					}
				break;
				case 2:
					definition.setEgoGender(Gender.valueOf(item.charAt(0)));
				break;
				}
			}
			
			result.addNew(definition);
		}
		
		// Set inversions of primary terms
		
		result.setInversePrimaryTerms();
		
		// Set other terms
		
		result = result.clean();
		for (RoleDefinition definition : result.toSortedList()){

			if (definition.composition()!=null && definition.composition().size()==1 && pseudoRoles.containsKey(definition.composition().get(0).getName())){
				
				String name = definition.composition().get(0).getName();
				String firstItem = name.substring(0, name.length()-1);
				String lastItem = name.substring(name.length()-1);
				
				Roles firstRoles = null;
				
				if (firstItem.length()==1){
					firstRoles = result.getPrimaryTerms(firstItem, definition.egoGender(), null, Gender.UNKNOWN);
				}
				
				if (firstRoles==null){
					firstRoles = pseudoRoles.get(firstItem);
				}
				
				if (firstRoles==null){
					firstRoles = new Roles();
					firstRoles.add(new Role("["+firstItem+"]"));
				}
				
				Gender egoGender = Gender.UNKNOWN;
				char genderLetter = firstItem.charAt(firstItem.length()-1);
				if (genderLetter=='S' || genderLetter=='F' || genderLetter=='H'  || genderLetter=='B' ){
					egoGender = Gender.MALE;
				} else if (genderLetter=='D' || genderLetter=='M' || genderLetter=='W'  || genderLetter=='Z' ){
					egoGender = Gender.FEMALE;
				}
				
				for (Role firstRole : firstRoles){

					definition.composition().set(0, firstRole);
					Roles lastRoles = result.getPrimaryTerms(lastItem,egoGender,definition.alterAge(), definition.alterGender());

					if (lastRoles.size()>0){
						result.removeById(definition.getId());
						for (Role lastRole : lastRoles) {
							RoleDefinition def1 = definition.clone();
							def1.setId(result.getLastId()+1);
							def1.composition().add(lastRole);
							result.addNew(def1);
						}
					}
				}
			}
		}
		
		result = result.clean();
		
		//
		model.setRoleDefinitions(result);
		return result;
	}
	
	public static RoleDefinitions createRoleDefinitions(final RelationModel model, final StringList roleDefinitionsList) {
		RoleDefinitions result;

		result = new RoleDefinitions();

		int id = 0;

		for (String roleDefinitionLine : roleDefinitionsList) {
			
			String[] items = roleDefinitionLine.split("\t");

			id++;
			Role role = null;
			Primary primary = null;
			Role inversion = null;
			Roles composition = new Roles();
			AlterAge alterAge = null;
			Gender alterGender = Gender.UNKNOWN;
			Gender egoGender = Gender.UNKNOWN;

			for (int idx = 0; idx < items.length; idx++) {

				String item = items[idx];
				if (StringUtils.isEmpty(item)) {
					continue;
				}

				switch (idx) {
					case 0:
						role = model.role(item);
					break;
					case 1:
						primary = Primary.valueOf(item);
					break;
					case 2:
						inversion = model.role(item);
					break;
					case 3:
						composition.add(model.role(item));
					break;
					case 4:
						composition.add(model.role(item));
					break;
					case 5:
						alterGender = Gender.valueOf(item);
					break;
					case 6:
						alterAge = AlterAge.valueOf(item);
					break;
					case 7:
						egoGender = Gender.valueOf(item);
					break;
				}
			}
			result.add(new RoleDefinition(id, role, primary, inversion, composition, alterGender, alterAge, egoGender));
		}

		result = result.clean();

		//
		model.setRoleDefinitions(result);
		return result;
	}

	private static AlterAge getAlterAge(final Individual indi) {
		AlterAge result;

		result = null;

		if (indi.getAttributeValue("GENERATION").equals("0") && indi.getBirthOrder() != null) {
			if (indi.getBirthOrder() == 3) {
				result = AlterAge.YOUNGER;
			} else if (indi.getBirthOrder() == 1) {
				result = AlterAge.ELDER;
			}
		}
		//
		return result;
	}

	private static AlterAge getAlterAge(final Individual alter, final Individual ego) {
		AlterAge result;

		result = null;

		if (alter == null || ego == null) {
			result = null;
		} else if (alter.isYoungerThan(ego)) {
			result = AlterAge.YOUNGER;
		} else if (alter.isElderThan(ego)) {
			result = AlterAge.ELDER;
		}
		//
		return result;
	}
	
	private static boolean crossSex (Role ego, Role alter, Map<Role,List<Gender>> genders){
		boolean result;
		
		result = false;
				
		for (Gender egoGender : genders.get(ego)){
			for (Gender alterGender : genders.get(alter)){
				if (egoGender!=alterGender){
					result = true;
					break;
				}
			}
			if (result){
				break;
			}
		}
		//
		return result;
	}

	private static boolean sameSex (Role ego, Role alter, Map<Role,List<Gender>> genders){
		boolean result;
		
		result = false;
		
		for (Gender egoGender : genders.get(ego)){
			for (Gender alterGender : genders.get(alter)){
				if (egoGender==alterGender){
					result = true;
					break;
				}
			}
			if (result){
				break;
			}
		}
		//
		return result;
	}


	public static Graph<Role> relationModelGraph(final RelationModel model) {
		Graph<Role> result;

		result = new Graph<Role>();
		result.setLabel(model.getName());

		Map<Role, LinkType> linkTypes = new HashMap<Role, LinkType>();
		Map<Role, Integer> weights = new HashMap<Role, Integer>();
		Map<Role, Roles> inversions = new HashMap<Role, Roles>();
		Map<Role, String> tags = new HashMap<Role, String>();
		
		RelationModelStatistics statistics = new RelationModelStatistics(model);
		Map<Role,List<Gender>> genderMap = statistics.genderMap();

		Role maleEgo = new Role("Male Ego");
		Role femaleEgo = new Role("Female Ego");
		
		Gender[] maleGenders = new Gender[]{Gender.MALE};
		Gender[] femaleGenders = new Gender[]{Gender.FEMALE};
		
		genderMap.put(maleEgo, Arrays.asList(maleGenders));
		genderMap.put(femaleEgo, Arrays.asList(femaleGenders));

		result.addNode(maleEgo);
		result.addNode(femaleEgo);

		for (Role role : model.roles()) {
			result.addNode(role);
		}

		// Set primary links
		
		for (RoleDefinition definition : model.roleDefinitions().toSortedList()) {
			if (definition.primary() != null) {
				
				Role alter = definition.role();
				Roles egos = new Roles();
				if (!definition.egoGender().isFemale()){
					egos.add(maleEgo);
				} 
				if (!definition.egoGender().isMale()){
					egos.add(femaleEgo);
				}
								
				switch (definition.primary()) {
					case PARENT:
						linkTypes.put(alter, LinkType.ARC);
						if (definition.alterGender().isMale()) {
							weights.put(alter, 1);
							tags.put(alter, "F");
						} else if (definition.alterGender().isFemale()) {
							weights.put(alter, -1);
							tags.put(alter, "M");
						} else {
							tags.put(alter, "Pa");
						}
					break;
					case SIBLING:
						linkTypes.put(alter, LinkType.EDGE);
						weights.put(alter, -1);
						if (definition.alterGender().isMale()) {
							tags.put(alter, "B");
						} else if (definition.alterGender().isFemale()) {
							tags.put(alter, "Z");
						} else {
							tags.put(alter, "Sb");
						}
					break;
					case SPOUSE:
						linkTypes.put(alter, LinkType.EDGE);
						weights.put(alter, 1);
						if (definition.alterGender().isMale()) {
							tags.put(alter, "H");
						} else if (definition.alterGender().isFemale()) {
							tags.put(alter, "W");
						} else {
							tags.put(alter, "Sp");
						}
					break;
				}
				
				for (Role ego : egos){
					if (definition.primary()==Primary.SPOUSE && !crossSex(ego,alter,genderMap)){
						continue;
					}
					result.addLink(ego, alter, linkTypes.get(alter), weights.get(alter));
				}
			}
		}
		
		// Set inverse primary links;
		
		for (RoleDefinition definition : model.roleDefinitions().toSortedList()) {
			if (definition.inversion() != null) {
				
				Role alter = definition.role();
				Roles egos = new Roles();
				if (!definition.egoGender().isFemale()){
					egos.add(maleEgo);
				} 
				if (!definition.egoGender().isMale()){
					egos.add(femaleEgo);
				}
				Role linkRole = definition.inversion();
				
				Roles inverseRoles = inversions.get(alter);
				if (inverseRoles == null){
					inverseRoles = new Roles();
					inversions.put(alter, inverseRoles);
				}
				inverseRoles.add(linkRole);

				for (Role ego : egos){
					if (genderMap.get(ego).size()==0 || sameSex(ego,linkRole,genderMap)){
						result.addLink(alter, ego, linkTypes.get(linkRole), weights.get(linkRole));
					}
				}
			}
		}

		// Set composite terms

		for (RoleDefinition definition : model.roleDefinitions().toSortedList()) {
			if (definition.composition() != null) {
				
				Role alter = definition.role();
				Role ego = definition.composition().get(0);
				Role linkRole = definition.composition().get(1);
				
				if (linkTypes.containsKey(linkRole)){
					if (linkTypes.get(linkRole)==LinkType.EDGE && weights.get(linkRole)==1 && !crossSex(ego,alter,genderMap)){
						continue;
					}
					result.addLink(ego, alter, linkTypes.get(linkRole), weights.get(linkRole));
				} else if (inversions.containsKey(linkRole)){
					Roles inverseLinkRoles = inversions.get(linkRole);
					for (Role inverseLinkRole : inverseLinkRoles){
						if (genderMap.get(ego).size()==0 || sameSex(ego,inverseLinkRole,genderMap)){
							if (alter.getName().equals("viya'")) System.out.println("inverse "+ego+" "+inverseLinkRole+" "+linkTypes.get(inverseLinkRole));
							result.addLink(alter, ego, linkTypes.get(inverseLinkRole), weights.get(inverseLinkRole));
						}
					}
				} else {
					System.err.println("Undefined link role "+ linkRole);
				}

			} else if (definition.primary()==null && definition.inversion()==null){
				
				System.err.println("No composition : "+definition);
			}

/*					for (Gender egoGender : model.roleDefinitions().getAlterGenders(definition.composition().get(0))) {
						for (Gender alterGender : model.roleDefinitions().getAlterGenders(definition.composition().get(1))) {
							if (definition.alterGender() != null && definition.alterGender().equals(alterGender)) {
								Role inverseRole = model.roleDefinitions().getInverseRole(definition.composition().get(1), egoGender, alterGender);
								System.out.println(role+" "+inverseRole);
								
								arcType = arcTypes.get(inverseRole);
								if (arcType.equals("FATHER")) {
									result.addArc(alterNode, egoNode, 1);
								} else if (arcType.equals("MOTHER")) {
									result.addArc(alterNode, egoNode, -1);
								}
							}
						}
					}
				}*/

				// System.out.println(definition+" "+alterNode+" "+egoNode+" "+arcType);

		
		}

		//
		return result;
	}

}
