package org.tip.puck.net.relations;


/**
 * 
 * @author TIP
 */
public class Role implements Comparable<Role> {

	private String name;
	private int defaultCardinality;

	/**
	 * 
	 * @param role
	 */
	public Role(final Role role) {

		if (role == null) {
			//
			this.name = "";
			this.defaultCardinality = 0;

		} else {
			//
			this.name = role.getName();
			this.defaultCardinality = role.getDefaultCardinality();
		}
	}

	/**
	 * 
	 * @param name
	 * @param defaultCardinality
	 */
	public Role(final String name) {

		this.name = name;
		this.defaultCardinality = 0;
	}

	/**
	 * 
	 * @param name
	 * @param defaultCardinality
	 */
	public Role(final String name, final int defaultCardinality) {
		this.name = name;
		this.defaultCardinality = defaultCardinality;
	}

	/**
	 * 
	 */
	@Override
	public boolean equals(final Object role) {
		boolean result;
		
		result = role!=null && this.name.equals(((Role) role).name);
		
		//
		return result;
	}
	
	public static boolean equalOrBothNull(Role alpha, Role beta){
		return (alpha==null && beta==null) || (alpha!=null && alpha.equals(beta));
	}


	public int getDefaultCardinality() {
		return this.defaultCardinality;
	}

	public String getName() {
		return this.name;
	}

	public void setDefaultCardinality(final int defaultCardinality) {
		this.defaultCardinality = defaultCardinality;
	}

	public void setName(final String name) {
		this.name = name;
	}
	
	@Override
	public String toString(){
		return this.name;
	}
	
	public int compareTo (Role other){
		int result;
		
		if (other==null || name == null || other.name == null){
			result = 0;
		} else {
			result = name.compareTo(other.name);
		}
		
		//
		return result;
	}
	
	@Override
	public int hashCode(){
		return toString().hashCode();
	}
}
