/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.views.geographyEditor;

import javax.swing.table.AbstractTableModel;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.geo2.GeoLevel2;
import org.tip.puck.geo2.Place2;
import org.tip.puck.geo2.Places2;
import org.tip.puck.net.workers.AttributeValueDescriptors;

public class PlaceLineModel
extends AbstractTableModel {
    private static final Logger logger = LoggerFactory.getLogger(PlaceLineModel.class);
    private static final long serialVersionUID = -58643312061422885L;
    public static final int COLUMN_LABEL = 0;
    public static final int COLUMN_USES = 1;
    public static final int COLUMN_LATITUDE = 2;
    public static final int COLUMN_LONGITUDE = 3;
    public static final int COLUMN_ELEVATION = 4;
    public static final int COLUMN_LEVEL = 5;
    public static final int COLUMN_ABOVE = 6;
    public static final int COLUMN_EXTERNALID = 7;
    public static final int COLUMN_HOMONYMS = 8;
    public static final int COLUMN_COMMENT = 9;
    public static final int COLUMN_COUNT = 10;
    private Places2 source;
    private AttributeValueDescriptors valueDescriptors;
    private int lastSearchIndex;
    private String lastSearchPattern;

    public PlaceLineModel(Places2 source, AttributeValueDescriptors valueDescriptors) {
        this.valueDescriptors = valueDescriptors;
        this.setSource(source);
    }

    public Class getColumnClass(int columnIndex) {
        Class result;
        switch (columnIndex) {
            case 0: {
                result = String.class;
                break;
            }
            case 1: {
                result = Long.class;
                break;
            }
            case 2: {
                result = Double.class;
                break;
            }
            case 3: {
                result = Double.class;
                break;
            }
            case 4: {
                result = Double.class;
                break;
            }
            case 5: {
                result = GeoLevel2.class;
                break;
            }
            case 6: {
                result = String.class;
                break;
            }
            case 7: {
                result = String.class;
                break;
            }
            case 8: {
                result = String.class;
                break;
            }
            case 9: {
                result = String.class;
                break;
            }
            default: {
                result = String.class;
            }
        }
        return result;
    }

    @Override
    public int getColumnCount() {
        int result = 10;
        return result;
    }

    @Override
    public String getColumnName(int columnIndex) {
        String result;
        switch (columnIndex) {
            case 0: {
                result = "Toponym";
                break;
            }
            case 1: {
                result = "Uses";
                break;
            }
            case 2: {
                result = "Latitude";
                break;
            }
            case 3: {
                result = "Longitude";
                break;
            }
            case 4: {
                result = "Elevation";
                break;
            }
            case 5: {
                result = "Level";
                break;
            }
            case 6: {
                result = "Above";
                break;
            }
            case 7: {
                result = "External ID";
                break;
            }
            case 8: {
                result = "Homonyms";
                break;
            }
            case 9: {
                result = "Comment";
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }

    @Override
    public int getRowCount() {
        int result = this.source == null ? 0 : this.source.size();
        return result;
    }

    public Places2 getSource() {
        Places2 result = this.source;
        return result;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object result;
        Place2 line = (Place2)this.source.get(rowIndex);
        if (line == null) {
            result = null;
        } else {
            switch (columnIndex) {
                case 0: {
                    result = line.getToponym();
                    break;
                }
                case 1: {
                    result = this.valueDescriptors.getCountOf(line.getToponyms());
                    break;
                }
                case 2: {
                    result = line.getLatitude();
                    break;
                }
                case 3: {
                    result = line.getLongitude();
                    break;
                }
                case 4: {
                    result = line.getElevation();
                    break;
                }
                case 5: {
                    result = line.getGeoLevel();
                    break;
                }
                case 6: {
                    result = line.getAbovePlace();
                    break;
                }
                case 7: {
                    result = line.getExternalId();
                    break;
                }
                case 8: {
                    result = line.getHomonyms().toStringWithCommas();
                    break;
                }
                case 9: {
                    result = line.getComment();
                    break;
                }
                default: {
                    result = null;
                }
            }
        }
        return result;
    }

    public int indexOf(Place2 target) {
        int result = this.source == null ? -1 : this.source.indexOf(target);
        return result;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        boolean result;
        switch (col) {
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                result = true;
                break;
            }
            default: {
                result = false;
            }
        }
        return result;
    }

    public boolean isSet() {
        boolean result = this.source != null;
        return result;
    }

    public Place2 nextSearched(String pattern) {
        Place2 result = null;
        return result;
    }

    public int nextSearchedIndex(String pattern) {
        int result = this.indexOf(this.nextSearched(pattern));
        return result;
    }

    public Place2 removeItem(int rowIndex) {
        Place2 result;
        if (rowIndex >= 0 && rowIndex < this.source.size()) {
            result = (Place2)this.source.get(rowIndex);
            this.source.remove(result);
            this.fireTableRowsDeleted(rowIndex, rowIndex);
        } else {
            result = null;
        }
        return result;
    }

    public void resetSearch() {
        this.lastSearchIndex = -1;
        this.lastSearchPattern = null;
    }

    public void setNewItem(Place2 newPlace) {
        this.source.add(newPlace);
        this.fireTableRowsInserted(this.source.size(), this.source.size());
    }

    public void setSource(Places2 source) {
        this.resetSearch();
        if (this.source != null) {
            this.fireTableRowsDeleted(0, this.source.size());
        }
        if (source == null) {
            this.source = new Places2();
        } else {
            this.source = source;
            this.source.sortByToponym();
        }
        this.fireTableDataChanged();
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        logger.debug("setValueAt " + rowIndex + " " + columnIndex);
        Place2 current = (Place2)this.source.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                if (!StringUtils.isNotBlank((CharSequence)((String)value))) break;
                current.setToponym(StringUtils.trim((String)((String)value)));
                this.source.sortByToponym();
                break;
            }
            case 2: {
                current.setLatitude((Double)value);
                break;
            }
            case 3: {
                current.setLongitude((Double)value);
                break;
            }
            case 4: {
                current.setElevation((Double)value);
                break;
            }
            case 5: {
                current.setGeoLevel((GeoLevel2)((Object)value));
                break;
            }
            case 6: {
                current.setAbovePlace((String)value);
                break;
            }
            case 7: {
                current.setExternalId((String)value);
                break;
            }
            case 8: {
                current.setHomonyms((String)value);
                break;
            }
            case 9: {
                current.setComment((String)value);
            }
        }
        this.fireTableDataChanged();
    }
}

