/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.views;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckException;
import org.tip.puck.PuckExceptions;
import org.tip.puck.graphs.random.RandomGraphReporter;
import org.tip.puck.partitions.graphs.VirtualFieldworkVariationsCriteria;
import org.tip.puck.report.Report;
import org.tip.puckgui.GroupNetGUI;
import org.tip.puckgui.PuckGUI;
import org.tip.puckgui.views.FooReporterInputWindow;

public class VirtualFieldworkVariationsInputWindow
extends JFrame {
    private static final Logger logger = LoggerFactory.getLogger(VirtualFieldworkVariationsInputWindow.class);
    private static final long serialVersionUID = -6113524443785800524L;
    private JFrame thisJFrame;
    private JPanel contentPane;
    private JButton btnRestoreDefaults;
    private JCheckBox chckbxNumberOfLoops;
    private JCheckBox chckbxNumberOfCircuits;
    private JCheckBox chckbxNumberOfTriangles;
    private JCheckBox chckbxConcentration;
    private JCheckBox chckbxStrengthConcentration;
    private JCheckBox chckbxWeightDistribution;
    private JCheckBox chckbxStrengthDistribution;
    private JSpinner spnrFractionOfNodes;
    private JSpinner spnrFractionOfArcs;
    private JSpinner spnrNumberOfRuns;
    private final ButtonGroup buttonGroupVariable1 = new ButtonGroup();
    private final ButtonGroup buttonGroupVariable2 = new ButtonGroup();
    private JRadioButton rdbtnVariable1Index1;
    private JRadioButton rdbtnVariable1Index2;
    private JRadioButton rdbtnVariable2Index1;
    private JRadioButton rdbtnVariable2Index2;
    private JCheckBox chckbxExtractRepresentative;
    private JSpinner spnrVariable1IntervalFactor;
    private JSpinner spnrVariable2IntervalFactor;
    private JSpinner spnrOutPreference;
    private JSpinner spnrVariable1NumberOfIntervals;
    private JSpinner spnrVariable2NumberOfIntervals;
    private JCheckBox chckbxSymmetry;

    public VirtualFieldworkVariationsInputWindow(final GroupNetGUI groupNetGUI) {
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(FooReporterInputWindow.class.getResource("/org/tip/puckgui/favicon-16x16.jpg")));
        this.thisJFrame = this;
        this.setTitle("Virtual Fieldwork Variations");
        this.setDefaultCloseOperation(3);
        this.setBounds(100, 100, 518, 500);
        this.setLocationRelativeTo(null);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(this.contentPane);
        this.contentPane.setLayout(new BorderLayout(0, 0));
        JPanel buttonPanel = new JPanel();
        this.contentPane.add((Component)buttonPanel, "South");
        JButton btnCancel = new JButton("Cancel");
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VirtualFieldworkVariationsInputWindow.this.dispose();
            }
        });
        this.btnRestoreDefaults = new JButton("Restore Defaults");
        this.btnRestoreDefaults.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VirtualFieldworkVariationsInputWindow.this.setCriteria(new VirtualFieldworkVariationsCriteria());
            }
        });
        buttonPanel.add(this.btnRestoreDefaults);
        buttonPanel.add(btnCancel);
        JButton btnLaunch = new JButton("Launch");
        this.getRootPane().setDefaultButton(btnLaunch);
        btnLaunch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    VirtualFieldworkVariationsCriteria criteria = VirtualFieldworkVariationsInputWindow.this.getCriteria();
                    PuckGUI.instance().getPreferences().setVirtualFieldworkVariationsCriteria(criteria);
                    Report report = RandomGraphReporter.reportVirtualFieldworkVariations(groupNetGUI.getGroupNet(), criteria);
                    groupNetGUI.addReportTab(report);
                    VirtualFieldworkVariationsInputWindow.this.dispose();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(VirtualFieldworkVariationsInputWindow.this.thisJFrame, message, title, 0);
                }
            }
        });
        buttonPanel.add(btnLaunch);
        JPanel panel_targets = new JPanel();
        panel_targets.setBorder(new TitledBorder(null, "Targets", 4, 2, null, null));
        this.contentPane.add((Component)panel_targets, "North");
        panel_targets.setLayout(new BoxLayout(panel_targets, 0));
        JPanel panel_1 = new JPanel();
        panel_targets.add(panel_1);
        panel_1.setLayout(new BoxLayout(panel_1, 1));
        this.chckbxNumberOfLoops = new JCheckBox("Number of loops");
        panel_1.add(this.chckbxNumberOfLoops);
        this.chckbxNumberOfCircuits = new JCheckBox("Number of circuits");
        panel_1.add(this.chckbxNumberOfCircuits);
        this.chckbxNumberOfTriangles = new JCheckBox("Number of triangles");
        panel_1.add(this.chckbxNumberOfTriangles);
        Component horizontalStrut = Box.createHorizontalStrut(20);
        panel_targets.add(horizontalStrut);
        JPanel panel = new JPanel();
        panel_targets.add(panel);
        panel.setLayout(new BoxLayout(panel, 1));
        this.chckbxConcentration = new JCheckBox("Concentration");
        panel.add(this.chckbxConcentration);
        this.chckbxWeightDistribution = new JCheckBox("Weight distribution");
        panel.add(this.chckbxWeightDistribution);
        this.chckbxStrengthDistribution = new JCheckBox("Strength distribution");
        panel.add(this.chckbxStrengthDistribution);
        Component horizontalStrut_2 = Box.createHorizontalStrut(20);
        panel_targets.add(horizontalStrut_2);
        JPanel panel_7 = new JPanel();
        panel_targets.add(panel_7);
        panel_7.setLayout(new BoxLayout(panel_7, 1));
        this.chckbxSymmetry = new JCheckBox("Symmetry");
        panel_7.add(this.chckbxSymmetry);
        this.chckbxStrengthConcentration = new JCheckBox("Strength Concentration");
        panel_7.add(this.chckbxStrengthConcentration);
        Component verticalGlue = Box.createVerticalGlue();
        panel_7.add(verticalGlue);
        JPanel panel_parameters = new JPanel();
        panel_parameters.setBorder(new TitledBorder(null, "Parameters", 4, 2, null, null));
        this.contentPane.add((Component)panel_parameters, "Center");
        panel_parameters.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"100dlu"), FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow")}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        JLabel lblNumberOfNodes = new JLabel("Fraction of nodes:");
        panel_parameters.add((Component)lblNumberOfNodes, "2, 2");
        this.spnrFractionOfNodes = new JSpinner();
        this.spnrFractionOfNodes.setModel(new SpinnerNumberModel(new Double(1.0), new Double(0.0), new Double(1.0), new Double(0.05)));
        ((JSpinner.NumberEditor)this.spnrFractionOfNodes.getEditor()).getFormat().setMinimumFractionDigits(5);
        panel_parameters.add((Component)this.spnrFractionOfNodes, "4, 2");
        JLabel lblNumberOfArcs = new JLabel("Fraction of arcs:");
        panel_parameters.add((Component)lblNumberOfArcs, "2, 4");
        this.spnrFractionOfArcs = new JSpinner();
        this.spnrFractionOfArcs.setModel(new SpinnerNumberModel(new Double(0.1), new Double(0.0), new Double(1.0), new Double(0.05)));
        ((JSpinner.NumberEditor)this.spnrFractionOfArcs.getEditor()).getFormat().setMinimumFractionDigits(5);
        panel_parameters.add((Component)this.spnrFractionOfArcs, "4, 4");
        JLabel lblOutPreference = new JLabel("Out preference:");
        panel_parameters.add((Component)lblOutPreference, "2, 6, right, default");
        this.spnrOutPreference = new JSpinner();
        this.spnrOutPreference.setModel(new SpinnerNumberModel(new Double(0.5), new Double(0.1), null, new Double(0.1)));
        ((JSpinner.NumberEditor)this.spnrOutPreference.getEditor()).getFormat().setMinimumFractionDigits(1);
        panel_parameters.add((Component)this.spnrOutPreference, "4, 6");
        JLabel lblNumberOfRuns = new JLabel("Number of runs:");
        panel_parameters.add((Component)lblNumberOfRuns, "2, 8");
        this.spnrNumberOfRuns = new JSpinner();
        this.spnrNumberOfRuns.setModel(new SpinnerNumberModel(new Integer(100), new Integer(1), null, new Integer(1)));
        panel_parameters.add((Component)this.spnrNumberOfRuns, "4, 8");
        JPanel panel_2 = new JPanel();
        panel_parameters.add((Component)panel_2, "2, 10, 5, 1, fill, fill");
        panel_2.setLayout(new BoxLayout(panel_2, 0));
        JPanel panel_firstVariable = new JPanel();
        panel_firstVariable.setBorder(new TitledBorder(null, "First variable", 4, 2, null, null));
        panel_2.add(panel_firstVariable);
        panel_firstVariable.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        JLabel lblIndex = new JLabel("Index:");
        panel_firstVariable.add((Component)lblIndex, "2, 2, right, default");
        JPanel panel_3 = new JPanel();
        panel_firstVariable.add((Component)panel_3, "4, 2, fill, fill");
        panel_3.setLayout(new BoxLayout(panel_3, 1));
        this.rdbtnVariable1Index1 = new JRadioButton("variable 1");
        this.buttonGroupVariable1.add(this.rdbtnVariable1Index1);
        this.rdbtnVariable1Index1.setSelected(true);
        panel_3.add(this.rdbtnVariable1Index1);
        this.rdbtnVariable1Index2 = new JRadioButton("variable 2");
        this.buttonGroupVariable1.add(this.rdbtnVariable1Index2);
        panel_3.add(this.rdbtnVariable1Index2);
        JPanel panel_5 = new JPanel();
        panel_firstVariable.add((Component)panel_5, "2, 4, right, fill");
        panel_5.setLayout(new BoxLayout(panel_5, 1));
        JLabel lblNumberOf = new JLabel("Number of");
        panel_5.add(lblNumberOf);
        JLabel lblIntervals = new JLabel("intervals:");
        panel_5.add(lblIntervals);
        this.spnrVariable1NumberOfIntervals = new JSpinner();
        this.spnrVariable1NumberOfIntervals.setModel(new SpinnerNumberModel(new Integer(5), new Integer(0), null, new Integer(1)));
        panel_firstVariable.add((Component)this.spnrVariable1NumberOfIntervals, "4, 4");
        JLabel lblIntervalFactor = new JLabel("Interval factor:");
        panel_firstVariable.add((Component)lblIntervalFactor, "2, 6, right, default");
        this.spnrVariable1IntervalFactor = new JSpinner();
        this.spnrVariable1IntervalFactor.setModel(new SpinnerNumberModel(new Integer(10), new Integer(1), null, new Integer(1)));
        panel_firstVariable.add((Component)this.spnrVariable1IntervalFactor, "4, 6");
        Component horizontalStrut_1 = Box.createHorizontalStrut(20);
        panel_2.add(horizontalStrut_1);
        JPanel panel_secondVariable = new JPanel();
        panel_secondVariable.setBorder(new TitledBorder(null, "Second variable", 4, 2, null, null));
        panel_2.add(panel_secondVariable);
        panel_secondVariable.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        JLabel lblIndex_1 = new JLabel("Index:");
        panel_secondVariable.add((Component)lblIndex_1, "2, 2, right, default");
        JPanel panel_4 = new JPanel();
        panel_secondVariable.add((Component)panel_4, "4, 2, fill, fill");
        panel_4.setLayout(new BoxLayout(panel_4, 1));
        this.rdbtnVariable2Index1 = new JRadioButton("variable 1");
        this.buttonGroupVariable2.add(this.rdbtnVariable2Index1);
        panel_4.add(this.rdbtnVariable2Index1);
        this.rdbtnVariable2Index2 = new JRadioButton("variable 2");
        this.buttonGroupVariable2.add(this.rdbtnVariable2Index2);
        this.rdbtnVariable2Index2.setSelected(true);
        panel_4.add(this.rdbtnVariable2Index2);
        JPanel panel_6 = new JPanel();
        panel_secondVariable.add((Component)panel_6, "2, 4, right, fill");
        panel_6.setLayout(new BoxLayout(panel_6, 1));
        JLabel lblNumberOf_1 = new JLabel("Number of");
        panel_6.add(lblNumberOf_1);
        JLabel lblIntervals_1 = new JLabel("intervals:");
        panel_6.add(lblIntervals_1);
        this.spnrVariable2NumberOfIntervals = new JSpinner();
        this.spnrVariable2NumberOfIntervals.setModel(new SpinnerNumberModel(new Integer(5), new Integer(0), null, new Integer(1)));
        panel_secondVariable.add((Component)this.spnrVariable2NumberOfIntervals, "4, 4");
        JLabel lblIntervalFactor_1 = new JLabel("Interval factor:");
        panel_secondVariable.add((Component)lblIntervalFactor_1, "2, 6, right, default");
        this.spnrVariable2IntervalFactor = new JSpinner();
        this.spnrVariable2IntervalFactor.setModel(new SpinnerNumberModel(new Integer(10), new Integer(1), null, new Integer(1)));
        panel_secondVariable.add((Component)this.spnrVariable2IntervalFactor, "4, 6");
        this.chckbxExtractRepresentative = new JCheckBox("Extract a representative network");
        panel_parameters.add((Component)this.chckbxExtractRepresentative, "2, 10, 5, 1");
        this.setCriteria(PuckGUI.instance().getPreferences().getVirtualFieldworkVariationsCriteria());
    }

    public VirtualFieldworkVariationsCriteria getCriteria() throws PuckException {
        int index2;
        int index1;
        VirtualFieldworkVariationsCriteria result = new VirtualFieldworkVariationsCriteria();
        result.setNumberOfLoopsChecked(this.chckbxNumberOfLoops.isSelected());
        result.setNumberOfCircuitsChecked(this.chckbxNumberOfCircuits.isSelected());
        result.setNumberOfTrianglesChecked(this.chckbxNumberOfTriangles.isSelected());
        result.setConcentrationChecked(this.chckbxConcentration.isSelected());
        result.setStrengthConcentrationChecked(this.chckbxStrengthConcentration.isSelected());
        result.setWeightDistributionChecked(this.chckbxWeightDistribution.isSelected());
        result.setStrengthDistributionChecked(this.chckbxStrengthDistribution.isSelected());
        result.setSymmetryChecked(this.chckbxSymmetry.isSelected());
        result.setFractionOfNodes((Double)this.spnrFractionOfNodes.getValue());
        result.setFractionOfArcs((Double)this.spnrFractionOfArcs.getValue());
        result.setOutPreference((Double)this.spnrOutPreference.getValue());
        result.setNumberOfRuns((Integer)this.spnrNumberOfRuns.getValue());
        if (this.rdbtnVariable1Index1.isSelected()) {
            index1 = 0;
        } else if (this.rdbtnVariable1Index2.isSelected()) {
            index1 = 1;
        } else {
            throw PuckExceptions.INVALID_PARAMETER.create("Bad value", new Object[0]);
        }
        result.setFirstVariableIndex(index1);
        result.setFirstVariableIntervalFactor((Integer)this.spnrVariable1IntervalFactor.getValue());
        if (this.rdbtnVariable2Index1.isSelected()) {
            index2 = 0;
        } else if (this.rdbtnVariable2Index2.isSelected()) {
            index2 = 1;
        } else {
            throw PuckExceptions.INVALID_PARAMETER.create("Bad value", new Object[0]);
        }
        result.setSecondVariableIndex(index2);
        result.setSecondVariableIntervalFactor((Integer)this.spnrVariable2IntervalFactor.getValue());
        return result;
    }

    public void setCriteria(VirtualFieldworkVariationsCriteria source) {
        if (source != null) {
            this.chckbxNumberOfLoops.setSelected(source.isNumberOfLoopsChecked());
            this.chckbxNumberOfCircuits.setSelected(source.isNumberOfCircuitsChecked());
            this.chckbxNumberOfTriangles.setSelected(source.isNumberOfTrianglesChecked());
            this.chckbxConcentration.setSelected(source.isConcentrationChecked());
            this.chckbxWeightDistribution.setSelected(source.isWeightDistributionChecked());
            this.chckbxStrengthDistribution.setSelected(source.isStrengthDistributionChecked());
            this.chckbxSymmetry.setSelected(source.isSymmetryChecked());
            this.spnrFractionOfNodes.setValue(source.getFractionOfNodes());
            this.spnrFractionOfArcs.setValue(source.getArcWeightFraction());
            this.spnrOutPreference.setValue(source.getOutPreference());
            this.spnrNumberOfRuns.setValue(source.getNumberOfRuns());
            this.rdbtnVariable1Index1.setSelected(false);
            this.rdbtnVariable1Index2.setSelected(false);
            switch (source.getFirstVariableIndex()) {
                case 0: {
                    this.rdbtnVariable1Index1.setSelected(true);
                    break;
                }
                case 1: {
                    this.rdbtnVariable1Index2.setSelected(true);
                }
            }
            this.spnrVariable1NumberOfIntervals.setValue(source.getFirstVariableNumberOfIntervals());
            this.spnrVariable1IntervalFactor.setValue(source.getFirstVariableIntervalFactor());
            this.rdbtnVariable2Index1.setSelected(false);
            this.rdbtnVariable2Index2.setSelected(false);
            switch (source.getSecondVariableIndex()) {
                case 0: {
                    this.rdbtnVariable2Index1.setSelected(true);
                    break;
                }
                case 1: {
                    this.rdbtnVariable2Index2.setSelected(true);
                }
            }
            this.spnrVariable2NumberOfIntervals.setValue(source.getSecondVariableNumberOfIntervals());
            this.spnrVariable2IntervalFactor.setValue(source.getSecondVariableIntervalFactor());
        }
    }
}

