/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.views;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import fr.devinsy.util.StringList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.spacetime.workers.UnknownPlacesCriteria;

public class UnknownPlacesInputDialog
extends JDialog {
    private static final long serialVersionUID = 7208254679850378876L;
    private static final Logger logger = LoggerFactory.getLogger(UnknownPlacesInputDialog.class);
    private final JPanel contentPanel = new JPanel();
    private UnknownPlacesCriteria dialogCriteria;
    private static UnknownPlacesCriteria lastCriteria = new UnknownPlacesCriteria();
    private JComboBox cmbbxTarget;

    public UnknownPlacesInputDialog(StringList relationModelNames) {
        ArrayList<String> targetLabels = new ArrayList<String>();
        targetLabels.add("ALL");
        targetLabels.add("INDIVIDUALS");
        targetLabels.add("RELATIONS");
        if (relationModelNames != null) {
            for (String name : relationModelNames) {
                targetLabels.add(name);
            }
        }
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setModal(true);
        this.setAlwaysOnTop(true);
        this.setTitle("Unknown Places Input");
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(UnknownPlacesInputDialog.class.getResource("/org/tip/puckgui/favicon-16x16.jpg")));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                UnknownPlacesInputDialog.this.dialogCriteria = null;
                UnknownPlacesInputDialog.this.setVisible(false);
            }
        });
        this.setBounds(100, 100, 420, 120);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC}));
        JLabel lblTarget = new JLabel("Target:");
        this.contentPanel.add((Component)lblTarget, "2, 2, right, default");
        this.cmbbxTarget = new JComboBox<Object>(targetLabels.toArray());
        this.contentPanel.add((Component)this.cmbbxTarget, "4, 2, fill, default");
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(1));
        this.getContentPane().add((Component)buttonPane, "South");
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UnknownPlacesInputDialog.this.dialogCriteria = null;
                UnknownPlacesInputDialog.this.setVisible(false);
            }
        });
        cancelButton.setActionCommand("Cancel");
        buttonPane.add(cancelButton);
        JButton okButton = new JButton("Launch");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UnknownPlacesCriteria criteria = UnknownPlacesInputDialog.this.getCriteria();
                if (criteria == null) {
                    String title = "Invalid input";
                    String message = "Invalid input.";
                    JOptionPane.showMessageDialog(null, message, title, 0);
                } else {
                    lastCriteria = criteria;
                    UnknownPlacesInputDialog.this.dialogCriteria = criteria;
                    UnknownPlacesInputDialog.this.setVisible(false);
                }
            }
        });
        okButton.setActionCommand("OK");
        buttonPane.add(okButton);
        this.getRootPane().setDefaultButton(okButton);
        this.setCriteria(lastCriteria);
    }

    public UnknownPlacesCriteria getCriteria() {
        UnknownPlacesCriteria result = new UnknownPlacesCriteria();
        switch (this.cmbbxTarget.getSelectedIndex()) {
            case 0: {
                result.setIncludedIndividual(true);
                result.setIncludedAllRelations(true);
                break;
            }
            case 1: {
                result.setIncludedIndividual(true);
                result.setIncludedAllRelations(false);
                break;
            }
            case 2: {
                result.setIncludedIndividual(false);
                result.setIncludedAllRelations(true);
                break;
            }
            default: {
                result.setIncludedIndividual(false);
                result.setIncludedAllRelations(false);
                result.getRelationNames().add((Object)((String)this.cmbbxTarget.getSelectedItem()));
            }
        }
        logger.debug("result={}", (Object)result.toString());
        return result;
    }

    public UnknownPlacesCriteria getDialogCriteria() {
        UnknownPlacesCriteria result = this.dialogCriteria;
        return result;
    }

    private void setCriteria(UnknownPlacesCriteria source) {
        if (source != null) {
            if (source.isIncludedIndividual()) {
                if (source.isIncludedAllRelations()) {
                    this.cmbbxTarget.setSelectedIndex(0);
                } else {
                    this.cmbbxTarget.setSelectedIndex(1);
                }
            } else if (source.getRelationNames().size() == 1) {
                this.cmbbxTarget.setSelectedItem(source.getRelationNames().get(0));
            } else {
                this.cmbbxTarget.setSelectedIndex(2);
            }
        }
    }

    public static void main(String[] args) {
        UnknownPlacesInputDialog.showDialog(null);
    }

    public static UnknownPlacesCriteria showDialog(StringList relationModelNames) {
        UnknownPlacesInputDialog dialog = new UnknownPlacesInputDialog(relationModelNames);
        dialog.setLocationRelativeTo(null);
        dialog.pack();
        dialog.setVisible(true);
        UnknownPlacesCriteria result = dialog.getDialogCriteria();
        return result;
    }
}

