/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.views;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckException;
import org.tip.puck.PuckExceptions;
import org.tip.puck.PuckManager;
import org.tip.puck.report.Report;
import org.tip.puckgui.WindowGUI;
import org.tip.puckgui.util.GenericFileFilter;
import org.tip.puckgui.views.ReportPanel;

public class ReportsPanel
extends JPanel {
    private static final Logger logger = LoggerFactory.getLogger(ReportsPanel.class);
    private static final long serialVersionUID = -1537588159515830202L;
    private File file;
    private Report report;

    public ReportsPanel(final WindowGUI parent, final Report report) {
        this.report = report;
        this.file = new File("report-" + new SimpleDateFormat("yyyyMMddHHmmss").format(Calendar.getInstance().getTime()) + ".txt");
        this.setLayout(new BoxLayout(this, 1));
        JTabbedPane tabbedPaneReports = new JTabbedPane(1);
        tabbedPaneReports.setTabLayoutPolicy(1);
        this.add(tabbedPaneReports);
        ReportPanel reportPanel = new ReportPanel(parent, report);
        tabbedPaneReports.addTab(report.title(), null, reportPanel, null);
        for (Report subReport : report.subReports()) {
            reportPanel = new ReportPanel(parent, subReport);
            tabbedPaneReports.addTab(subReport.title(), null, reportPanel, null);
        }
        tabbedPaneReports.setSelectedIndex(0);
        JPanel panelButtons = new JPanel();
        this.add(panelButtons);
        panelButtons.setLayout(new BoxLayout(panelButtons, 0));
        JButton btnClose = new JButton("Close");
        btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                parent.closeCurrentTab();
            }
        });
        panelButtons.add(btnClose);
        Component horizontalGlue = Box.createHorizontalGlue();
        panelButtons.add(horizontalGlue);
        JButton btnSaveButton = new JButton("Save");
        btnSaveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    File targetFile = new File("report-" + report.target() + "-" + new SimpleDateFormat("yyyyMMddhhmmss").format(Calendar.getInstance().getTime()) + ".txt");
                    boolean ended = false;
                    while (!ended) {
                        boolean doSave;
                        JFileChooser chooser = new JFileChooser();
                        chooser.setSelectedFile(targetFile);
                        chooser.setDialogTitle(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.saveAsFileChooser.text"));
                        chooser.setFileSelectionMode(0);
                        chooser.setAcceptAllFileFilterUsed(false);
                        GenericFileFilter defaultFileFilter = new GenericFileFilter("Report Formats (*.txt, *.xls)", "txt", "xls");
                        chooser.addChoosableFileFilter(defaultFileFilter);
                        chooser.addChoosableFileFilter(new GenericFileFilter("Text (*.txt)", "txt"));
                        chooser.addChoosableFileFilter(new GenericFileFilter("Microsoft Excel (*.xls)", "xls"));
                        chooser.setFileFilter(defaultFileFilter);
                        if (chooser.showSaveDialog(parent.getJFrame()) == 0) {
                            System.out.println("getCurrentDirectory(): " + chooser.getCurrentDirectory());
                            System.out.println("getSelectedFile() : " + chooser.getSelectedFile());
                            targetFile = chooser.getSelectedFile();
                        } else {
                            System.out.println("No Selection ");
                            ended = true;
                        }
                        if (ended) continue;
                        if (targetFile.exists()) {
                            String title = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileConfirm.existingFile.title");
                            String message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileConfirm.existingFile.text");
                            int response = JOptionPane.showConfirmDialog(parent.getJFrame(), message, title, 1);
                            if (response == 0) {
                                doSave = true;
                                ended = true;
                            } else if (response == 1) {
                                doSave = false;
                                ended = false;
                            } else {
                                doSave = false;
                                ended = true;
                            }
                        } else {
                            doSave = true;
                            ended = true;
                        }
                        if (!doSave) continue;
                        PuckManager.saveReport(targetFile, report);
                    }
                }
                catch (PuckException exception) {
                    String message;
                    String title = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.title");
                    switch (PuckExceptions.valueOf(exception.getCode())) {
                        case UNSUPPORTED_FILE_FORMAT: {
                            message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.unsupportedFileFormat");
                            break;
                        }
                        case NOT_A_FILE: {
                            message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.notAFile");
                            break;
                        }
                        case UNSUPPORTED_ENCODING: {
                            message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.unsupportedEncoding");
                            break;
                        }
                        default: {
                            message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.default");
                        }
                    }
                    JOptionPane.showMessageDialog(parent.getJFrame(), message, title, 0);
                }
            }
        });
        panelButtons.add(btnSaveButton);
    }
}

