/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.views;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import fr.devinsy.util.StringList;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.InputStream;
import java.util.ResourceBundle;
import java.util.jar.Manifest;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.util.BuildInformation;

public class AboutPopup
extends JDialog {
    private static final long serialVersionUID = 5496087410697509828L;
    private static final Logger logger = LoggerFactory.getLogger(AboutPopup.class);

    public AboutPopup() {
        this.setResizable(false);
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(AboutPopup.class.getResource("/org/tip/puckgui/favicon-16x16.jpg")));
        this.setTitle(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("AboutPopup.this.title"));
        this.setModal(true);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setBounds(100, 100, 653, 335);
        this.setLocationRelativeTo(null);
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        JPanel panelContent = new JPanel();
        panelContent.setBackground(Color.WHITE);
        this.getContentPane().add((Component)panelContent, "Center");
        panelContent.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC}));
        JLabel lblNewLabel = new JLabel();
        panelContent.add((Component)lblNewLabel, "2, 2");
        lblNewLabel.setIcon(new ImageIcon(AboutPopup.class.getResource("/org/tip/puckgui/images/logo-puck-250x.jpg")));
        JTextPane textPane = new JTextPane();
        panelContent.add((Component)textPane, "4, 2");
        textPane.setEditable(false);
        textPane.setText(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("AboutPopup.textPane.text"));
        textPane.setText(String.valueOf(textPane.getText().replace("$PUCK_VERSION", AboutPopup.puckFullVersion())) + "\n" + AboutPopup.infos());
        JPanel panel_1 = new JPanel();
        panel_1.setBackground(Color.WHITE);
        this.getContentPane().add((Component)panel_1, "South");
        JButton button = new JButton("OK");
        panel_1.add(button);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("OK pressed.");
                AboutPopup.this.dispose();
            }
        });
        button.setActionCommand("OK");
    }

    public static String infos() {
        StringList text = new StringList();
        text.append("JVM = ").append(System.getProperty("java.version")).append(" ").appendln(System.getProperty("java.vm.version"));
        text.append("XMX = ");
        text.append(Runtime.getRuntime().freeMemory() / 1024L / 1024L);
        text.append("M/");
        text.append(Runtime.getRuntime().totalMemory() / 1024L / 1024L);
        text.append("M/");
        text.append(Runtime.getRuntime().maxMemory() / 1024L / 1024L);
        text.appendln("M");
        text.append("OS = ").append(System.getProperty("os.name")).append(" ").append(System.getProperty("os.version")).append(" ").append(System.getProperty("sun.arch.data.model")).appendln("bits");
        String result = text.toString();
        return result;
    }

    public static void main(String[] args) {
        try {
            AboutPopup dialog = new AboutPopup();
            dialog.setDefaultCloseOperation(2);
            dialog.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String puckFullVersion() {
        String result = BuildInformation.isDefined() ? "Puck " + new BuildInformation().version() : "Puck dev";
        return result;
    }

    public static String puckImplementationVersion() {
        String result;
        try {
            InputStream in = AboutPopup.class.getResourceAsStream("/META-INF/MANIFEST.MF");
            if (in == null) {
                result = null;
            } else {
                Manifest manifest = new Manifest(in);
                result = manifest.getMainAttributes().getValue("Implementation-Version");
            }
        }
        catch (Exception exception) {
            result = null;
        }
        return result;
    }

    public static String puckTime() {
        String[] tokens;
        String implementationVersion = AboutPopup.puckImplementationVersion();
        String result = implementationVersion == null ? "NOW" : ((tokens = implementationVersion.split(" ")).length == 4 ? String.valueOf(tokens[2]) + " " + tokens[3] : implementationVersion);
        return result;
    }

    public static String puckVersion() {
        String[] tokens;
        String implementationVersion = AboutPopup.puckImplementationVersion();
        String result = implementationVersion == null ? "2.0.dev" : ((tokens = implementationVersion.split(" ")).length == 4 ? tokens[1] : implementationVersion);
        return result;
    }
}

