/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.models;

import fr.devinsy.util.StringList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.table.AbstractTableModel;
import org.tip.puck.net.Individual;
import org.tip.puck.net.relations.Actor;
import org.tip.puck.net.relations.Actors;
import org.tip.puck.net.relations.Relation;

public class IndividualRelationsModel
extends AbstractTableModel {
    private static final long serialVersionUID = -8018474967949155510L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("org.tip.puckgui.messages");
    protected Individual source;
    protected List<Relation> delegate;

    public IndividualRelationsModel(Individual source) {
        this.setSource(source);
    }

    public Class getColumnClass(int columnIndex) {
        Class result;
        switch (columnIndex) {
            case 0: {
                result = Number.class;
                break;
            }
            case 1: {
                result = String.class;
                break;
            }
            case 2: {
                result = String.class;
                break;
            }
            case 3: {
                result = String.class;
                break;
            }
            case 4: {
                result = String.class;
                break;
            }
            default: {
                result = String.class;
            }
        }
        return result;
    }

    @Override
    public int getColumnCount() {
        int result = 5;
        return result;
    }

    @Override
    public String getColumnName(int columnIndex) {
        String result;
        switch (columnIndex) {
            case 0: {
                result = BUNDLE.getString("MainWindow.individual.relation.id");
                break;
            }
            case 1: {
                result = BUNDLE.getString("MainWindow.individual.relation.model");
                break;
            }
            case 2: {
                result = BUNDLE.getString("MainWindow.individual.relation.name");
                break;
            }
            case 3: {
                result = BUNDLE.getString("MainWindow.individual.relation.role");
                break;
            }
            case 4: {
                result = BUNDLE.getString("MainWindow.individual.relation.others");
                break;
            }
            default: {
                result = "";
            }
        }
        return result;
    }

    public List<Relation> getDelegate() {
        List<Relation> result = this.delegate;
        return result;
    }

    @Override
    public int getRowCount() {
        int result = this.source == null ? 0 : this.delegate.size();
        return result;
    }

    public Individual getSource() {
        Individual result = this.source;
        return result;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object result;
        if (this.source == null) {
            result = null;
        } else if (rowIndex >= this.delegate.size()) {
            result = null;
        } else {
            block0 : switch (columnIndex) {
                case 0: {
                    result = this.delegate.get(rowIndex).getTypedId();
                    break;
                }
                case 1: {
                    result = this.delegate.get(rowIndex).getModel().getName();
                    break;
                }
                case 2: {
                    result = this.delegate.get(rowIndex).getName();
                    break;
                }
                case 3: {
                    Actors actors = this.delegate.get(rowIndex).actors().getById(this.source.getId());
                    StringList roleNames = new StringList();
                    for (Actor actor : actors) {
                        String formattedRole = actor.getRelationOrder() == null ? actor.getRole().getName() : String.format("%s(%d)", actor.getRole().getName(), actor.getRelationOrder());
                        roleNames.append(formattedRole);
                    }
                    result = roleNames.toStringWithCommas();
                    break;
                }
                case 4: {
                    Actors others = this.delegate.get(rowIndex).actors().getOthers(this.source.getId());
                    switch (others.size()) {
                        case 0: {
                            result = "";
                            break block0;
                        }
                        case 1: {
                            result = String.format("(%d) %s", ((Actor)others.get(0)).getId(), ((Actor)others.get(0)).getName());
                            break block0;
                        }
                    }
                    result = String.format("%d actors", others.size());
                    break;
                }
                default: {
                    result = null;
                }
            }
        }
        return result;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        boolean result = false;
        return result;
    }

    public void setSource(Individual source) {
        this.source = source;
        if (source != null) {
            this.delegate = source.relations().toList();
        }
        this.fireTableDataChanged();
    }
}

