/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui;

import fr.devinsy.flatdb4geonames.model.FlatDB4GeoNames;
import java.awt.EventQueue;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.PropertyConfigurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckException;
import org.tip.puck.PuckManager;
import org.tip.puck.graphs.Graph;
import org.tip.puck.io.kinsources.KinsourcesFile;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Net;
import org.tip.puck.partitions.Cluster;
import org.tip.puck.segmentation.Segmentation;
import org.tip.puckgui.GroupNetGUI;
import org.tip.puckgui.NetGUI;
import org.tip.puckgui.Preferences;
import org.tip.puckgui.PreferencesFile;
import org.tip.puckgui.RecentFiles;
import org.tip.puckgui.RecentFilesFile;
import org.tip.puckgui.WindowGUI;
import org.tip.puckgui.util.GUIToolBox;

public class PuckGUI {
    private static final Logger logger = LoggerFactory.getLogger(PuckGUI.class);
    private List<WindowGUI> windowGUIs;
    private int windowGUICounter;
    private File recentFilesFile;
    private RecentFiles recentFiles;
    private File recentFoldersFile;
    private RecentFiles recentFolders;
    private File puckHome = new File(String.valueOf(System.getProperty("user.home")) + File.separator + ".puck");
    private File preferencesFile;
    private Preferences preferences;

    private PuckGUI() {
        if (!this.puckHome.exists()) {
            this.puckHome.mkdir();
            logger.info("Puck home directory created: " + this.puckHome.getAbsolutePath());
        }
        this.windowGUICounter = 0;
        this.windowGUIs = new ArrayList<WindowGUI>();
        this.preferencesFile = new File(String.valueOf(this.puckHome.getAbsolutePath()) + File.separator + "preferencesrc");
        if (this.preferencesFile.exists()) {
            try {
                this.preferences = PreferencesFile.load(this.preferencesFile);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                logger.error("Error loading preferences file: " + exception.getMessage());
                logger.warn("Ignoring preferences file.");
                this.preferences = new Preferences();
            }
        } else {
            logger.info("No preferences file found.");
            this.preferences = new Preferences();
        }
        this.updateLanguage();
        this.recentFilesFile = new File(String.valueOf(this.puckHome.getAbsolutePath()) + File.separator + "recentfilesrc");
        if (this.recentFilesFile.exists()) {
            try {
                this.recentFiles = RecentFilesFile.load(this.recentFilesFile);
            }
            catch (PuckException exception) {
                logger.error("Error loading recent files file: " + exception.getMessage());
                logger.warn("Ignoring recent files file.");
                this.recentFiles = new RecentFiles();
            }
        } else {
            this.recentFiles = new RecentFiles();
        }
        this.recentFoldersFile = new File(String.valueOf(this.puckHome.getAbsolutePath()) + File.separator + "recentfoldersrc");
        if (this.recentFoldersFile.exists()) {
            try {
                this.recentFolders = RecentFilesFile.load(this.recentFoldersFile);
            }
            catch (PuckException exception) {
                logger.error("Error loading recent folders file: " + exception.getMessage());
                logger.warn("Ignoring recent folders file.");
                this.recentFolders = new RecentFiles();
            }
        } else {
            this.recentFolders = new RecentFiles();
        }
        UIManager.put("swing.boldMetal", Boolean.FALSE);
        System.out.println("System lookAndFeel property:" + System.getProperty("swing.defaultlaf"));
        System.out.println("Available lookAndFeel: " + GUIToolBox.availableLookAndFeels().toString());
        System.out.println("System lookAndFeel: " + UIManager.getSystemLookAndFeelClassName());
        System.out.println("Current lookAndFeel: " + UIManager.getLookAndFeel().getName());
        if (!StringUtils.equals((CharSequence)UIManager.getSystemLookAndFeelClassName(), (CharSequence)"javax.swing.plaf.metal.MetalLookAndFeel")) {
            try {
                System.out.println("Metal LAF setted and system LAF detected, try to set system LAF.");
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception exception) {
                System.out.println("Failed to set the system LookAndFeel.");
            }
        } else if (GUIToolBox.availableLookAndFeels().toString().contains("GTK+")) {
            try {
                System.out.println("Metal LAF setted and GTK+ LAF detected, try to set GTK+ LAF.");
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.gtk.GTKLookAndFeel");
            }
            catch (Exception exception) {
                System.out.println("Failed to set the system LookAndFeel.");
            }
        }
        System.out.println("Activated lookAndFeel: " + UIManager.getLookAndFeel().getName());
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread thread, Throwable exception) {
                exception.printStackTrace();
                String title = "Error computerum est";
                String message = exception instanceof OutOfMemoryError ? "Java ran out of memory!" : "An unexpected error occured:\n\n" + exception.getMessage();
                JOptionPane.showMessageDialog(null, message, title, 0);
            }
        });
    }

    public void close(GroupNetGUI gui) {
        this.windowGUIs.remove(gui);
        if (this.windowGUIs.size() == 0) {
            this.exit();
        }
    }

    public void close(WindowGUI gui) {
        this.windowGUIs.remove(gui);
        if (this.windowGUIs.size() == 0) {
            this.exit();
        }
    }

    public GroupNetGUI createGroupNetGUI(Graph<Cluster<Individual>> graph) throws PuckException {
        ++this.windowGUICounter;
        GroupNetGUI result = new GroupNetGUI(this.windowGUICounter, graph);
        this.windowGUIs.add(result);
        return result;
    }

    public NetGUI createNetGUI() {
        ++this.windowGUICounter;
        NetGUI result = new NetGUI(this.windowGUICounter);
        this.windowGUIs.add(result);
        return result;
    }

    public NetGUI createNetGUI(File file) throws PuckException {
        NetGUI result = this.createNetGUI(file, PuckManager.DEFAULT_CHARSET_NAME);
        return result;
    }

    public NetGUI createNetGUI(File file, Net net) {
        ++this.windowGUICounter;
        NetGUI result = new NetGUI(this.windowGUICounter, file, net);
        this.windowGUIs.add(result);
        return result;
    }

    public NetGUI createNetGUI(File file, Net net, Segmentation segmentation) throws PuckException {
        ++this.windowGUICounter;
        NetGUI result = new NetGUI(this.windowGUICounter, file, net, segmentation);
        this.windowGUIs.add(result);
        return result;
    }

    public NetGUI createNetGUI(File file, String charsetName) throws PuckException {
        Net net = PuckManager.loadNet(file, charsetName);
        ++this.windowGUICounter;
        NetGUI result = new NetGUI(this.windowGUICounter, file, net);
        this.windowGUIs.add(result);
        return result;
    }

    public NetGUI createNetGUIWithNewFile(File file, Net net) {
        File targetFile;
        ++this.windowGUICounter;
        if (file.getName().contains(".")) {
            String filePathName = file.getAbsolutePath();
            int separatorIndex = filePathName.lastIndexOf(46);
            String leftPart = filePathName.substring(0, separatorIndex);
            String rightPart = filePathName.substring(separatorIndex);
            targetFile = new File(String.valueOf(leftPart) + "-" + this.windowGUICounter + rightPart);
        } else {
            targetFile = new File(String.valueOf(file.getName()) + "-" + this.windowGUICounter);
        }
        NetGUI result = new NetGUI(this.windowGUICounter, targetFile, net);
        this.windowGUIs.add(result);
        return result;
    }

    public NetGUI duplicate(NetGUI source) throws PuckException {
        Net targetNet = new Net(source.getNet());
        Segmentation targetSegmentation = new Segmentation(targetNet, source.getSegmentation());
        NetGUI result = this.createNetGUI(source.getFile(), targetNet, targetSegmentation);
        result.setChanged(source.isChanged());
        return result;
    }

    public boolean existsUnsavedChanges() {
        boolean ended = false;
        int count = 0;
        boolean result = false;
        while (!ended) {
            if (count < this.windowGUIs.size()) {
                if (this.windowGUIs.get(count).isChanged()) {
                    ended = true;
                    result = true;
                    continue;
                }
                ++count;
                continue;
            }
            ended = true;
            result = false;
        }
        return result;
    }

    public void exit() {
        try {
            RecentFilesFile.save(this.recentFilesFile, this.recentFiles);
            RecentFilesFile.save(this.recentFoldersFile, this.recentFolders);
            this.savePreferences();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            logger.error("Error saving recent files data: " + exception.getMessage());
            logger.warn("Ignoring properties file save.");
        }
        System.exit(0);
    }

    public Preferences getPreferences() {
        return this.preferences;
    }

    public List<NetGUI> netGUIs() {
        ArrayList<NetGUI> result = new ArrayList<NetGUI>();
        for (WindowGUI gui : this.windowGUIs) {
            if (!(gui instanceof NetGUI)) continue;
            result.add((NetGUI)gui);
        }
        return result;
    }

    public RecentFiles recentFiles() {
        return this.recentFiles;
    }

    public RecentFiles recentFolders() {
        return this.recentFolders;
    }

    public void run(String[] fileNames) {
        String databaseDirectory;
        if (fileNames != null && fileNames.length > 0) {
            String[] stringArray = fileNames;
            int n = fileNames.length;
            int n2 = 0;
            while (n2 < n) {
                String fileName = stringArray[n2];
                try {
                    this.createNetGUI(new File(fileName));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    System.err.println("Error loading file named [" + fileName + "]");
                }
                ++n2;
            }
        } else if (this.preferences.isAutoLoadLastFile() && !this.recentFiles.isEmpty()) {
            try {
                this.createNetGUI(this.recentFiles.getMoreRecent());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (this.windowGUIs.isEmpty()) {
            this.createNetGUI();
        }
        if (StringUtils.isNotBlank((CharSequence)(databaseDirectory = this.preferences.getFlatDB4GeonamesDirectory()))) {
            try {
                FlatDB4GeoNames.open((String)databaseDirectory);
                logger.debug("FlatDB4GeoNames opened: " + databaseDirectory);
            }
            catch (Exception exception) {
                logger.error("Cannot open FlatDB4GeoNames database: " + databaseDirectory);
                this.preferences.setFlatDB4GeoNamesDirectory(null);
            }
        }
    }

    public void savePreferences() throws PuckException {
        PreferencesFile.save(this.preferencesFile, this.preferences);
    }

    public void updateLanguage() {
        Locale currentLocale = this.preferences.getLanguage().locale();
        Locale.setDefault(currentLocale);
        UIManager.getDefaults().setDefaultLocale(currentLocale);
        JComponent.setDefaultLocale(currentLocale);
        ResourceBundle.clearCache();
        for (WindowGUI windowGUI : this.windowGUIs) {
            windowGUI.updateLocale(currentLocale);
        }
    }

    public List<WindowGUI> windowGUIs() {
        List<WindowGUI> result = this.windowGUIs;
        return result;
    }

    public static PuckGUI instance() {
        PuckGUI result = SingletonLoader.instance;
        return result;
    }

    public static void main(final String[] args) {
        KinsourcesFile.fixPrimeSizeLimitInJava6();
        File loggerConfig = new File("log4j.properties");
        if (loggerConfig.exists()) {
            PropertyConfigurator.configure((String)loggerConfig.getAbsolutePath());
            logger.info("Dedicated log configuration done.");
            logger.info("Configuration file was found in [{}].", (Object)loggerConfig.getAbsoluteFile());
        } else {
            BasicConfigurator.configure();
            logger.info("Basic log configuration done.");
            logger.info("Configuration file was not found in [{}].", (Object)loggerConfig.getAbsoluteFile());
        }
        if (args.length > 0 && StringUtils.startsWithAny((CharSequence)args[0], (CharSequence[])new CharSequence[]{"-h", "-help", "--help"})) {
            System.out.println("puck [-h|-help|--help|fileNames|fileName1 ... fileNameN]");
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        PuckGUI.instance().run(args);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
        }
    }

    /* synthetic */ PuckGUI(PuckGUI puckGUI) {
        this();
    }

    private static class SingletonLoader {
        private static final PuckGUI instance = new PuckGUI(null);

        private SingletonLoader() {
        }
    }
}

