/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.util;

import java.util.ArrayList;
import org.tip.puck.util.Count;

public class Counts
extends ArrayList<Count> {
    private static final long serialVersionUID = -3120428104749848806L;

    public Counts() {
    }

    public Counts(int capacity) {
        super(capacity);
        while (capacity >= this.size()) {
            this.add(new Count());
        }
    }

    public double average() {
        double sum = 0.0;
        int count = 0;
        for (Count value : this) {
            sum += value.get();
            ++count;
        }
        double result = count == 0 ? 0.0 : sum * 1.0 / (double)count;
        return result;
    }

    public Count averageCount() {
        Count result = new Count();
        int count = 0;
        for (Count value : this) {
            result.add(value.get());
            result.addMin(value.getMin());
            result.addMax(value.getMax());
            ++count;
        }
        if (count != 0) {
            result.set(result.get() * 1.0 / (double)count);
            result.setMin(result.getMin() * 1.0 / (double)count);
            result.setMax(result.getMax() * 1.0 / (double)count);
        }
        return result;
    }

    @Override
    public Count get(int index) {
        while (index >= this.size()) {
            this.add(new Count());
        }
        Count result = (Count)super.get(index);
        return result;
    }

    public double max() {
        double result;
        if (this.size() == 0) {
            result = 0.0;
        } else {
            result = Double.MIN_VALUE;
            for (Count value : this) {
                if (!(value.get() > result)) continue;
                result = value.get();
            }
        }
        return result;
    }

    public double maxAverage() {
        double sum = 0.0;
        int count = 0;
        for (Count value : this) {
            sum += value.getMax();
            ++count;
        }
        double result = count == 0 ? 0.0 : sum * 1.0 / (double)count;
        return result;
    }

    public Count maxCount() {
        Count result = new Count(Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE);
        for (Count value : this) {
            if (value.get() > result.get()) {
                result.set(value.get());
            }
            if (value.getMin() > result.getMin()) {
                result.setMin(value.get());
            }
            if (!(value.getMax() > result.getMax())) continue;
            result.setMax(value.getMax());
        }
        return result;
    }

    public double maxMax() {
        double result;
        if (this.size() == 0) {
            result = 0.0;
        } else {
            result = Double.MIN_VALUE;
            for (Count value : this) {
                if (!(value.getMax() > result)) continue;
                result = value.getMax();
            }
        }
        return result;
    }

    public double min() {
        double result;
        if (this.size() == 0) {
            result = 0.0;
        } else {
            result = Double.MAX_VALUE;
            for (Count value : this) {
                if (!(value.get() < result)) continue;
                result = value.get();
            }
        }
        return result;
    }

    public double minAverage() {
        double sum = 0.0;
        int count = 0;
        for (Count value : this) {
            sum += value.getMin();
            ++count;
        }
        double result = count == 0 ? 0.0 : sum * 1.0 / (double)count;
        return result;
    }

    public Count minCount() {
        Count result = new Count(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
        for (Count value : this) {
            if (value.get() < result.get()) {
                result.set(value.get());
            }
            if (value.getMin() < result.getMin()) {
                result.setMin(value.getMin());
            }
            if (!(value.getMax() < result.getMax())) continue;
            result.setMax(value.getMax());
        }
        return result;
    }

    public double minMin() {
        double result;
        if (this.size() == 0) {
            result = 0.0;
        } else {
            result = Double.MAX_VALUE;
            for (Count value : this) {
                if (!(value.getMin() < result)) continue;
                result = value.getMin();
            }
        }
        return result;
    }

    public double sum() {
        double result = 0.0;
        for (Count value : this) {
            result += value.get();
        }
        return result;
    }
}

