/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.spacetime.workers;

import fr.devinsy.util.StringList;
import java.util.ResourceBundle;
import org.tip.puck.PuckException;
import org.tip.puck.net.Net;
import org.tip.puck.net.workers.AttributeDescriptors;
import org.tip.puck.net.workers.AttributeWorker;
import org.tip.puck.partitions.PartitionCriteria;
import org.tip.puck.report.Report;
import org.tip.puck.report.ReportList;
import org.tip.puck.segmentation.Segmentation;
import org.tip.puck.spacetime.Slices;
import org.tip.puck.spacetime.workers.SequenceReporter;
import org.tip.puck.spacetime.workers.SliceMaker;
import org.tip.puck.spacetime.workers.SliceReporter;
import org.tip.puck.spacetime.workers.SpaceTimeCriteria;
import org.tip.puck.statistics.StatisticsCriteria;

public class SpaceTimeReporter {
    public static ReportList reportHugeAnalysis(Net net, Segmentation segmentation, SpaceTimeCriteria criteria, ResourceBundle bundle) throws PuckException {
        ReportList result = new ReportList();
        if (criteria != null) {
            StringList relationModelNames = net.relationModels().sortedNameList();
            AttributeDescriptors attributeDescriptors = AttributeWorker.getExogenousAttributeDescriptors(segmentation, null);
            if (criteria.isSequenceAnalysis()) {
                if (!criteria.getSequenceReportTypes().isEmpty()) {
                    Report sequenceReport = SequenceReporter.reportSequences(net, segmentation, criteria);
                    result.add(sequenceReport);
                }
                if (!criteria.getSequenceGeneralStatistics().isEmpty()) {
                    Report sequenceCensusReport = SequenceReporter.reportGeneralSequenceCensus(segmentation, criteria);
                    result.add(sequenceCensusReport);
                }
                if (!criteria.getEgoNetworksOperations().isEmpty()) {
                    Report egoNetworkReport = SequenceReporter.reportEgoNetworksCensus(segmentation, criteria);
                    result.add(egoNetworkReport);
                }
                if (!criteria.getParcoursNetworksOperations().isEmpty()) {
                    Report parcoursNetworkReport = SequenceReporter.reportParcoursNetworksCensus(segmentation, criteria);
                    result.add(parcoursNetworkReport);
                }
                if (!criteria.getTrajectoriesOperations().isEmpty()) {
                    Report trajectoriesReport = SequenceReporter.reportTrajectoriesCensus(segmentation, criteria);
                    result.add(trajectoriesReport);
                }
            } else {
                StatisticsCriteria statisticsCriteria = new StatisticsCriteria();
                PartitionCriteria placeCriteria = PartitionCriteria.createRaw("BIRT_PLACE");
                placeCriteria.setLabelParameter("Bas-Mono");
                statisticsCriteria.getPartitionCriterias().add(placeCriteria);
                statisticsCriteria.getPartitionCriterias().add(PartitionCriteria.createSizedGrouping("AGE", null, 0.0, 20.0, null));
                statisticsCriteria.getPartitionCriterias().add(PartitionCriteria.createRaw("QUARTER"));
                statisticsCriteria.getPartitionCriterias().add(PartitionCriteria.createRaw("PATRIL"));
                statisticsCriteria.getPartitionCriterias().add(PartitionCriteria.createRaw("OCCUPATION"));
                statisticsCriteria.getPartitionCriterias().add(PartitionCriteria.createRaw("MATRISTATUS"));
                statisticsCriteria.getPartitionCriterias().add(PartitionCriteria.createRaw("REFERENT"));
                statisticsCriteria.setPlaceParameter("Bas-Mono");
                Slices slices = SliceMaker.createSlices(segmentation, criteria);
                if (!criteria.getSliceReportTypes().isEmpty()) {
                    Report sliceReport = SliceReporter.reportSlices(slices, criteria);
                    result.add(sliceReport);
                }
                if (criteria.getSliceGeneralStatistics().contains((Object)SpaceTimeCriteria.SliceGeneralStatistics.STATICS)) {
                    Report sliceStaticsReport = SliceReporter.reportIndividualStatics(slices, statisticsCriteria);
                    result.add(sliceStaticsReport);
                }
                if (criteria.getSliceGeneralStatistics().contains((Object)SpaceTimeCriteria.SliceGeneralStatistics.DYNAMICS)) {
                    Report sliceDynamicsReport = SliceReporter.reportIndividualDynamics(slices, statisticsCriteria);
                    result.add(sliceDynamicsReport);
                }
                if (!criteria.getEgoNetworksOperations().isEmpty()) {
                    Report egoNetworkReport = SliceReporter.reportEgoNetworks(slices, statisticsCriteria, criteria);
                    result.add(egoNetworkReport);
                }
                if (!criteria.getTrajectoriesOperations().isEmpty()) {
                    Report trajectoriesReport = SliceReporter.reportDevelopmentCycles(slices, statisticsCriteria);
                    result.add(trajectoriesReport);
                }
            }
        }
        return result;
    }
}

