/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.spacetime.workers;

import fr.devinsy.util.StringList;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.tip.puck.PuckException;
import org.tip.puck.PuckExceptions;
import org.tip.puck.graphs.GraphProfile;
import org.tip.puck.graphs.Node;
import org.tip.puck.io.paj.PAJFile;
import org.tip.puck.matrix.MatrixStatistics;
import org.tip.puck.net.Gender;
import org.tip.puck.net.Individual;
import org.tip.puck.net.IndividualComparator;
import org.tip.puck.net.Individuals;
import org.tip.puck.net.relations.Actor;
import org.tip.puck.net.relations.Actors;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.net.relations.Relations;
import org.tip.puck.net.workers.IndividualValuator;
import org.tip.puck.net.workers.NetUtils;
import org.tip.puck.net.workers.RelationValuator;
import org.tip.puck.partitions.Cluster;
import org.tip.puck.partitions.Partition;
import org.tip.puck.partitions.PartitionCriteria;
import org.tip.puck.partitions.PartitionMaker;
import org.tip.puck.report.Report;
import org.tip.puck.report.ReportChart;
import org.tip.puck.report.ReportRawData;
import org.tip.puck.report.ReportTable;
import org.tip.puck.spacetime.CorrelationMatrix;
import org.tip.puck.spacetime.Sequence;
import org.tip.puck.spacetime.Slice;
import org.tip.puck.spacetime.Slices;
import org.tip.puck.spacetime.workers.SequencesCensus;
import org.tip.puck.spacetime.workers.SpaceTimeCriteria;
import org.tip.puck.statistics.StatisticsCriteria;
import org.tip.puck.statistics.StatisticsReporter;
import org.tip.puck.util.Chronometer;
import org.tip.puck.util.MathUtils;
import org.tip.puck.util.Numberable;
import org.tip.puck.util.NumberedValues;
import org.tip.puck.util.PuckUtils;
import org.tip.puck.util.ToolBox;
import org.tip.puck.util.Value;

public class SliceReporter {
    private static String getStatus(Slices slices, Individual individual, int time) {
        Relation relation;
        String result = "";
        Slice slice = (Slice)slices.getById(time);
        if (slice != null && (relation = slice.relationsByIndividuals().get(individual)) != null) {
            if (relation.getAttributeValue(slices.idLabel()) != null) {
                result = String.valueOf(result) + relation.getAttributeValue(slices.idLabel());
            } else if (relation.getAttributeValue(slices.placeLabel()) != null) {
                result = String.valueOf(result) + relation.getAttributeValue(slices.placeLabel());
            }
            Actors actors = relation.actors().getById(individual.getId());
            if (actors.size() > 0) {
                Actor actor = (Actor)actors.get(0);
                if (actor.getAttributeValue("MODE") != null) {
                    result = String.valueOf(result) + " " + actor.getAttributeValue("MODE");
                }
                result = String.valueOf(result) + "\t";
                if (actor.getAttributeValue(slices.startDateLabel()) != null) {
                    result = String.valueOf(result) + actor.getAttributeValue(slices.startDateLabel());
                }
                if (actor.getAttributeValue(slices.endDateLabel()) != null) {
                    result = String.valueOf(result) + "-" + actor.getAttributeValue(slices.endDateLabel());
                }
                if (actor.getAttributeValue("NOTE") != null) {
                    result = String.valueOf(result) + " [" + actor.getAttributeValue("NOTE") + "]";
                }
            }
        }
        return result;
    }

    public static Report reportSlices(Slices slices, SpaceTimeCriteria criteria) {
        Report result = new Report(String.valueOf(criteria.getRelationModelName()) + " Slices");
        StringList list = new StringList();
        for (String houseId : slices.idValues()) {
            list.appendln(houseId);
            list.appendln();
            List<Individual> members = slices.membersByRelationId().get(houseId).toSortedList(IndividualComparator.Sorting.BIRT_YEAR);
            for (Individual member : members) {
                list.append(String.valueOf(member.signature()) + " (" + IndividualValuator.lifeStatusAtYear(member, 2015) + ")\t");
                for (Integer id : slices.ids()) {
                    String status = SliceReporter.getStatus(slices, member, id);
                    if (status != null) {
                        list.append(String.valueOf(status) + "\t");
                        continue;
                    }
                    Integer deathYear = IndividualValuator.getDeathYear(member);
                    Integer birthYear = IndividualValuator.getBirthYear(member);
                    if (deathYear != null && deathYear <= id) {
                        list.append("+" + deathYear + "\t\t");
                        continue;
                    }
                    if (birthYear != null && birthYear >= id) {
                        list.append("*" + birthYear + "\t\t");
                        continue;
                    }
                    list.append("?\t\t");
                }
                list.appendln();
            }
            list.appendln();
        }
        result.outputs().append(list);
        return result;
    }

    public static Report reportDevelopmentCycles(Slices slices, StatisticsCriteria criteria) throws PuckException {
        if (slices == null || criteria == null) {
            throw PuckExceptions.INVALID_PARAMETER.create("Null parameter detected.", new Object[0]);
        }
        Report result = new Report("Development Cycles " + slices.relationModelName());
        Chronometer chrono = new Chronometer();
        result.setOrigin("Space reporter");
        SpaceTimeCriteria censusCriteria = new SpaceTimeCriteria();
        censusCriteria.setCensusType(SpaceTimeCriteria.CensusType.PARCOURS);
        censusCriteria.addNetworkTitle("Event Type Network");
        censusCriteria.getMainRelationClassificationTypes().add(SpaceTimeCriteria.RelationClassificationType.TREES);
        censusCriteria.getEventTypes().add(SpaceTimeCriteria.RelationClassificationType.TREES);
        for (SpaceTimeCriteria.RelationClassificationType relationClassificationType : censusCriteria.getMainRelationClassificationTypes()) {
            censusCriteria.getCensusOperationLabels().add("PROFILE_" + (Object)((Object)relationClassificationType));
            censusCriteria.getCensusOperationLabels().add("SUPPORT_" + (Object)((Object)relationClassificationType));
        }
        SequencesCensus census = new SequencesCensus(slices.groupSequences(), censusCriteria);
        SpaceTimeCriteria.CensusType censusType = censusCriteria.getCensusType();
        Report overallReport = new Report("Survey");
        Report diagramReport = new Report("Diagrams");
        Report detailReport = new Report("Details");
        Report componentReport = new Report("Components");
        Report treeReport = new Report("Trees");
        ArrayList<ReportChart> charts = new ArrayList<ReportChart>();
        ArrayList<ReportTable> tables = new ArrayList<ReportTable>();
        overallReport.outputs().appendln("Measure\tAverage (Male)\tAverage Pos. (Male)\tMedian (Male)\tMaximum (Male)\tSum (Male)\tAverage (Female)\tAverage Pos. (Female)\tMedian (Female)\tMaximum (Female)\tSum (Female)\tAverage (All)\tAverage Pos. (All)\tMedian (All)\tMaximum (All)\tSum (All)");
        for (String label : censusCriteria.getCensusOperationLabels()) {
            PartitionCriteria partitionCriteria = new PartitionCriteria(label);
            ReportChart chart = null;
            if (!label.contains("ALTERS") && !label.contains("PROFILE")) {
                NumberedValues values = census.getValues(label);
                Partition<Relation> partition = PartitionMaker.create(label, slices.relations(slices.ids().get(0)), values, partitionCriteria);
                PartitionCriteria splitCriteria = new PartitionCriteria(censusCriteria.getPartitionLabel());
                chart = StatisticsReporter.createPartitionChart(partition, partitionCriteria, null);
                overallReport.outputs().append(String.valueOf(label) + "\t");
                String sum = "";
                if (label.startsWith("NR")) {
                    sum = String.valueOf(new Double(values.sum()).intValue());
                }
                overallReport.outputs().append(String.valueOf(MathUtils.round(values.average(), 2)) + "\t" + MathUtils.round(values.averagePositives(), 2) + "\t" + values.median() + "\t" + values.max() + "\t" + sum + "\t");
                overallReport.outputs().appendln();
            }
            if (chart == null) continue;
            charts.add(chart);
            ReportTable table = ReportTable.transpose(chart.createReportTableWithSum());
            tables.add(table);
            if (label.contains("EVENTS_") || label.contains("RELATIONS")) continue;
            tables.add(ReportTable.normalize(table));
        }
        overallReport.outputs().appendln();
        detailReport.outputs().append("Nr\tEgo\tGender");
        for (String partitionLabel : censusCriteria.getCensusOperationLabels()) {
            detailReport.outputs().append("\t" + partitionLabel);
        }
        detailReport.outputs().appendln();
        for (Sequence sequence : slices.groupSequences()) {
            Individual ego = sequence.getEgo();
            if (censusType != SpaceTimeCriteria.CensusType.GENERAL && censusType != SpaceTimeCriteria.CensusType.PARCOURS) continue;
            detailReport.outputs().append(String.valueOf(ego.getId()) + "\t" + ego);
            for (String label : censusCriteria.getCensusOperationLabels()) {
                if (label.contains("SIMILARITY")) {
                    String[] keys;
                    Value value = (Value)census.getValues(label).get(ego.getId());
                    Map indiSimilaritiesMap = value.mapValue();
                    String[] stringArray = keys = new String[]{"PARENT", "CHILD", "SIBLING", "SPOUSE"};
                    int n = keys.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String key = stringArray[n2];
                        Double[] sim = (Double[])indiSimilaritiesMap.get(new Value(key));
                        if (sim != null) {
                            detailReport.outputs().append("\t" + MathUtils.round(sim[4], 2));
                        }
                        ++n2;
                    }
                    continue;
                }
                detailReport.outputs().append("\t" + census.getValues(label).get(ego.getId()));
            }
            detailReport.outputs().appendln();
        }
        if (censusType == SpaceTimeCriteria.CensusType.PARCOURS) {
            for (SpaceTimeCriteria.RelationClassificationType relationClassificationType : censusCriteria.getMainRelationClassificationTypes()) {
                CorrelationMatrix subSequenceMatrix;
                if (censusCriteria.getNetworkTitles().contains("Event Type Network")) {
                    CorrelationMatrix eventSequenceMatrix = census.getEventSequenceMatrix(relationClassificationType.toString());
                    if (eventSequenceMatrix != null) {
                        eventSequenceMatrix.setUngendered(true);
                        for (ReportChart chart : eventSequenceMatrix.getCharts()) {
                            charts.add(chart);
                        }
                        tables.add(eventSequenceMatrix.getTable("Event Type Sequences"));
                    }
                    overallReport.outputs().appendln();
                    overallReport.outputs().appendln("Sequence Network Statistics " + (Object)((Object)relationClassificationType));
                    overallReport.outputs().appendln("\tDensity\tInertia\t(Divergence)\tConcentration\t(Divergence)\tSymmetry\t(Divergence)\tCentral nodes");
                    Gender[] genderArray = Gender.values();
                    int value = genderArray.length;
                    int table = 0;
                    while (table < value) {
                        Gender gender = genderArray[table];
                        GraphProfile<Cluster<String>> profile = eventSequenceMatrix.getProfile(gender);
                        String centralReferents = "";
                        for (Cluster<String> centralReferent : profile.getCentralReferents()) {
                            centralReferents = String.valueOf(centralReferents) + centralReferent.getValue() + " ";
                        }
                        double maxBetweenness = profile.getMaxBetweenness();
                        double density = profile.density();
                        double endo = MathUtils.round(profile.getStatistics(MatrixStatistics.Indicator.LOOPS, MatrixStatistics.Mode.NORMALIZED), 2);
                        double endoExp = MathUtils.round(profile.getStatistics(MatrixStatistics.Indicator.LOOPS, MatrixStatistics.Mode.DIVERGENCE_NORMALIZED), 2);
                        double conc = MathUtils.round(profile.getStatistics(MatrixStatistics.Indicator.CONCENTRATION, MatrixStatistics.Mode.SIMPLE), 2);
                        double concExp = MathUtils.round(profile.getStatistics(MatrixStatistics.Indicator.CONCENTRATION, MatrixStatistics.Mode.DIVERGENCE), 2);
                        double sym = MathUtils.round(profile.getStatistics(MatrixStatistics.Indicator.SYMMETRY, MatrixStatistics.Mode.SIMPLE), 2);
                        double symExp = MathUtils.round(profile.getStatistics(MatrixStatistics.Indicator.SYMMETRY, MatrixStatistics.Mode.DIVERGENCE), 2);
                        overallReport.outputs().appendln((Object)((Object)gender) + "\t" + density + "\t" + endo + "\t" + endoExp + "\t" + conc + "\t" + concExp + "\t" + sym + "\t" + symExp + "\t" + centralReferents + "(" + maxBetweenness + ") betweenness centrality");
                        ++table;
                    }
                    overallReport.outputs().appendln();
                }
                if (!censusCriteria.getNetworkTitles().contains("Sequence Type Network") || (subSequenceMatrix = census.getSubSequenceMatrix(relationClassificationType.toString())) == null) continue;
                charts.add(subSequenceMatrix.getRamificationChart());
            }
        }
        int chartIndex = 0;
        while (chartIndex < charts.size()) {
            diagramReport.outputs().append((ReportChart)charts.get(chartIndex));
            if (chartIndex % 4 == 3) {
                diagramReport.outputs().appendln();
            }
            ++chartIndex;
        }
        for (ReportTable table : tables) {
            diagramReport.outputs().appendln(table.getTitle());
            diagramReport.outputs().appendln(table);
        }
        result.outputs().append(overallReport);
        result.outputs().append(diagramReport);
        result.outputs().append(detailReport);
        if (censusType == SpaceTimeCriteria.CensusType.EGONETWORKS || censusType == SpaceTimeCriteria.CensusType.PARCOURSNETWORKS) {
            result.outputs().append(componentReport);
        }
        if (censusType == SpaceTimeCriteria.CensusType.PARCOURS) {
            result.outputs().append(treeReport);
        }
        Map<String, StringList> pajekBuffers = census.getPajekBuffers();
        for (String title : pajekBuffers.keySet()) {
            StringList pajekBuffer = pajekBuffers.get(title);
            if (pajekBuffer.length() == 0) continue;
            File targetFile = ToolBox.setExtension(ToolBox.addToName(new File(slices.relationModelName()), "-" + title), ".paj");
            ReportRawData rawData = new ReportRawData("Export " + title + "s to Pajek", "Pajek", "paj", targetFile);
            rawData.setData(PAJFile.convertToMicrosoftEndOfLine(pajekBuffer.toString()));
            result.outputs().appendln();
            result.outputs().append(rawData);
        }
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static Report reportIndividualStatics(Slices slices, StatisticsCriteria criteria) throws PuckException {
        if (criteria == null) {
            throw PuckExceptions.INVALID_PARAMETER.create("Null parameter detected.", new Object[0]);
        }
        Report result = new Report("Population Statics " + slices.relationModelName());
        Chronometer chrono = new Chronometer();
        result.setOrigin("Relation reporter");
        for (PartitionCriteria partitionCriteria : criteria.getPartitionCriterias()) {
            if (StringUtils.isEmpty((CharSequence)partitionCriteria.getLabel())) continue;
            ArrayList<ReportChart> charts = new ArrayList<ReportChart>(20);
            ArrayList<ReportTable> tables = new ArrayList<ReportTable>(20);
            for (Integer time : slices.ids()) {
                Relations relations = slices.relations(time);
                String label = String.valueOf(slices.relationModelName()) + " " + time;
                Partition<Object> partition = new Partition();
                if (partitionCriteria.getLabel().equals("REFERENT")) {
                    partitionCriteria.setLabelParameter(String.valueOf(slices.relationModelName()) + " " + slices.getEgoRoleName() + " " + time);
                    Partition<Individual> prePartition = PartitionMaker.create(label, relations.getIndividuals(), relations, partitionCriteria);
                    for (Individual ego : prePartition.getItemsAsList()) {
                        Value alterId = prePartition.getValue(ego);
                        if (alterId == null) continue;
                        List<String> alterRoles = NetUtils.getAlterRoles(ego, (Individual)slices.individuals().getById(alterId.intValue()), slices.maxDepths(), slices.getRelationModelNames(), slices.getChainClassification(), null, null);
                        Collections.sort(alterRoles);
                        partition.put(ego, new Value(alterRoles.toString()));
                    }
                } else {
                    if (partitionCriteria.getLabel().equals("AGE") || partitionCriteria.getLabel().equals("MATRISTATUS") || partitionCriteria.getLabel().equals("OCCUPATION")) {
                        partitionCriteria.setLabelParameter("" + time);
                    }
                    partition = PartitionMaker.create(label, relations.getIndividuals(), relations, partitionCriteria);
                }
                ReportChart chart = StatisticsReporter.createPartitionChart(partition, partitionCriteria, criteria.getSplitCriteria());
                charts.add(chart);
                ReportTable table = ReportTable.transpose(chart.createReportTableWithSum());
                tables.add(table);
            }
            int nr = Math.min(4, slices.size());
            int chartIndex = 0;
            while (chartIndex < charts.size()) {
                result.outputs().append((ReportChart)charts.get(chartIndex));
                if (chartIndex % nr == nr - 1) {
                    result.outputs().appendln();
                }
                ++chartIndex;
            }
            for (ReportTable table : tables) {
                result.outputs().appendln(table);
            }
        }
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public static Report reportEgoNetworks(Slices slices, StatisticsCriteria criteria, SpaceTimeCriteria censusCriteria) throws PuckException {
        ReportTable table;
        PartitionCriteria splitCriteria;
        Partition<Numberable> partition;
        NumberedValues values;
        Object partitionCriteria;
        if (slices == null || criteria == null) {
            throw PuckExceptions.INVALID_PARAMETER.create("Null parameter detected.", new Object[0]);
        }
        Report result = new Report("Ego Networks " + slices.relationModelName());
        Chronometer chrono = new Chronometer();
        result.setOrigin("Space reporter");
        SequencesCensus census = new SequencesCensus(slices.indiSequences(), censusCriteria);
        Individuals members = slices.members();
        Report overallReport = new Report("Survey");
        Report diagramReport = new Report("Diagrams");
        Report detailReport = new Report("Details");
        Report componentReport = new Report("Components");
        ArrayList<Object> charts = new ArrayList<Object>();
        ArrayList<ReportTable> tables = new ArrayList<ReportTable>();
        overallReport.outputs().appendln("Measure\tAverage (Male)\tAverage Pos. (Male)\tMedian (Male)\tMaximum (Male)\tSum (Male)\tAverage (Female)\tAverage Pos. (Female)\tMedian (Female)\tMaximum (Female)\tSum (Female)\tAverage (All)\tAverage Pos. (All)\tMedian (All)\tMaximum (All)\tSum (All)");
        for (String label : censusCriteria.getCensusOperationLabels()) {
            void var16_19;
            partitionCriteria = new PartitionCriteria(label);
            Object var16_20 = null;
            if (!label.contains("ALTERS") && !label.contains("PROFILE")) {
                values = census.getValues(label);
                partition = PartitionMaker.create(label, slices.relations(slices.ids().get(0)), values, (PartitionCriteria)partitionCriteria);
                splitCriteria = new PartitionCriteria(censusCriteria.getPartitionLabel());
                ReportChart reportChart = StatisticsReporter.createPartitionChart(partition, (PartitionCriteria)partitionCriteria, null);
                overallReport.outputs().append(String.valueOf(label) + "\t");
                String sum = "";
                if (label.startsWith("NR")) {
                    sum = String.valueOf(new Double(values.sum()).intValue());
                }
                overallReport.outputs().append(String.valueOf(MathUtils.round(values.average(), 2)) + "\t" + MathUtils.round(values.averagePositives(), 2) + "\t" + values.median() + "\t" + values.max() + "\t" + sum + "\t");
                overallReport.outputs().appendln();
            }
            if (var16_19 == null) continue;
            charts.add(var16_19);
            table = ReportTable.transpose(var16_19.createReportTableWithSum());
            tables.add(table);
            if (label.contains("EVENTS_") || label.contains("RELATIONS")) continue;
            tables.add(ReportTable.normalize(table));
        }
        overallReport.outputs().appendln();
        overallReport.outputs().appendln("Measure\tAverage (Male)\tAverage Pos. (Male)\tMedian (Male)\tMaximum (Male)\tSum (Male)\tAverage (Female)\tAverage Pos. (Female)\tMedian (Female)\tMaximum (Female)\tSum (Female)\tAverage (All)\tAverage Pos. (All)\tMedian (All)\tMaximum (All)\tSum (All)");
        for (String label : censusCriteria.getCensusOperationLabels()) {
            void var16_25;
            partitionCriteria = new PartitionCriteria(label);
            if (label.equals("NREVENTS")) {
                ((PartitionCriteria)partitionCriteria).setType(PartitionCriteria.PartitionType.RAW);
            } else if (label.contains("AGEFIRST")) {
                ((PartitionCriteria)partitionCriteria).setType(PartitionCriteria.PartitionType.SIZED_GROUPING);
                ((PartitionCriteria)partitionCriteria).setStart(0.0);
                ((PartitionCriteria)partitionCriteria).setSize(5.0);
            } else if (label.equals("ECCENTRICITY")) {
                ((PartitionCriteria)partitionCriteria).setType(PartitionCriteria.PartitionType.SIZED_GROUPING);
                ((PartitionCriteria)partitionCriteria).setStart(-100.0);
                ((PartitionCriteria)partitionCriteria).setSize(20.0);
            } else if (label.contains("COVERAGE") || label.contains("SAME") || label.contains("NORM") || label.contains("DENSITY") || label.contains("BETWEENNESS") || label.contains("EFFICIENCY") || label.contains("CONCENTRATION")) {
                ((PartitionCriteria)partitionCriteria).setType(PartitionCriteria.PartitionType.SIZED_GROUPING);
                ((PartitionCriteria)partitionCriteria).setStart(0.0);
                ((PartitionCriteria)partitionCriteria).setSize(20.0);
            } else if (label.contains("MEAN") || label.contains("COVERAGE") || label.contains("PEREVENT") || label.contains("BETWEENNESS") || label.contains("BROKERAGE") || label.contains("EFFICIENT_SIZE")) {
                ((PartitionCriteria)partitionCriteria).setType(PartitionCriteria.PartitionType.SIZED_GROUPING);
                ((PartitionCriteria)partitionCriteria).setStart(0.0);
                ((PartitionCriteria)partitionCriteria).setSize(1.0);
            } else {
                ((PartitionCriteria)partitionCriteria).setType(PartitionCriteria.PartitionType.RAW);
            }
            Object var16_23 = null;
            if (!label.contains("ALTERS") && !label.contains("PROFILE")) {
                values = census.getValues(label);
                partition = PartitionMaker.create(label, members, values, (PartitionCriteria)partitionCriteria);
                splitCriteria = new PartitionCriteria(censusCriteria.getPartitionLabel());
                ReportChart reportChart = StatisticsReporter.createPartitionChart(partition, (PartitionCriteria)partitionCriteria, splitCriteria);
                if (label.substring(0, 3).equals("AGE")) {
                    ((PartitionCriteria)partitionCriteria).setType(PartitionCriteria.PartitionType.RAW);
                    ((PartitionCriteria)partitionCriteria).setSizeFilter(PartitionCriteria.SizeFilter.HOLES);
                    ((PartitionCriteria)partitionCriteria).setValueFilter(PartitionCriteria.ValueFilter.NULL);
                    partition = PartitionMaker.create(label, members, values, (PartitionCriteria)partitionCriteria);
                    if (partition.maxValue() != null) {
                        ReportChart survivalChart = StatisticsReporter.createSurvivalChart(partition, splitCriteria);
                        charts.add(survivalChart);
                    } else {
                        System.err.println(String.valueOf(label) + " no max value");
                    }
                }
                NumberedValues[] genderedValues = PuckUtils.getGenderedNumberedValues(values, members);
                overallReport.outputs().append(String.valueOf(label) + "\t");
                int gender = 0;
                while (gender < 3) {
                    String sum = "";
                    if (label.startsWith("NR")) {
                        sum = String.valueOf(new Double(genderedValues[gender].sum()).intValue());
                    }
                    overallReport.outputs().append(String.valueOf(MathUtils.round(genderedValues[gender].average(), 2)) + "\t" + MathUtils.round(genderedValues[gender].averagePositives(), 2) + "\t" + values.median() + "\t" + genderedValues[gender].max() + "\t" + sum + "\t");
                    ++gender;
                }
                overallReport.outputs().appendln();
            }
            if (var16_25 == null) continue;
            charts.add(var16_25);
            table = ReportTable.transpose(var16_25.createReportTableWithSum());
            tables.add(table);
            if (label.contains("EVENTS_") || label.contains("RELATIONS")) continue;
            tables.add(ReportTable.normalize(table));
        }
        overallReport.outputs().appendln();
        detailReport.outputs().append("Nr\tEgo\tGender");
        for (String partitionLabel : censusCriteria.getCensusOperationLabels()) {
            detailReport.outputs().append("\t" + partitionLabel);
        }
        TreeMap<String, Map<String, Double>> componentChartMap = new TreeMap<String, Map<String, Double>>();
        detailReport.outputs().appendln();
        for (Individual ego : members.toSortedList()) {
            if (census.getValues("SIZE").get(ego.getId()) != null) {
                detailReport.outputs().append(String.valueOf(ego.getId()) + "\t" + ego + "\t" + (Object)((Object)ego.getGender()));
                for (String string : censusCriteria.getCensusOperationLabels()) {
                    detailReport.outputs().append("\t" + census.getValues(string).get(ego.getId()));
                }
                detailReport.outputs().appendln();
            }
            for (String string : censusCriteria.getNetworkTitles()) {
                Map<Integer, Partition<Node<Individual>>> componentsMap = census.getComponents(string);
                if (componentsMap == null) continue;
                Partition<Node<Individual>> components = componentsMap.get(ego.getId());
                componentReport.outputs().appendln("Components " + string);
                componentReport.outputs().appendln(ego + "\t" + components.size());
                int i = 1;
                for (Cluster<Node<Individual>> cluster : components.getClusters().toListSortedByValue()) {
                    componentReport.outputs().appendln("\t" + i + "\t" + cluster.getValue() + "\t(" + cluster.size() + ")\t" + cluster.getItemsAsString());
                    ++i;
                }
                componentReport.outputs().appendln();
                for (Value value : components.getValues()) {
                    String label = value.toString();
                    TreeMap<String, Double> map = (TreeMap<String, Double>)componentChartMap.get(label);
                    if (map == null) {
                        map = new TreeMap<String, Double>();
                        Gender[] genderArray = Gender.values();
                        int n = genderArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Gender gender = genderArray[n2];
                            map.put(gender.toString(), 0.0);
                            ++n2;
                        }
                        componentChartMap.put(label, map);
                    }
                    map.put(ego.getGender().toString(), (Double)map.get(ego.getGender().toString()) + 1.0);
                }
            }
        }
        ReportChart componentChart = StatisticsReporter.createChart("COMPONENTS", componentChartMap);
        charts.add(componentChart);
        tables.add(ReportTable.transpose(componentChart.createReportTableWithSum()));
        if (census.getRelationConnectionMatrix() != null) {
            for (ReportChart chart2 : census.getRelationConnectionMatrix().getCharts()) {
                charts.add(chart2);
            }
            tables.add(census.getRelationConnectionMatrix().getTable("Component Connections"));
        }
        int chartIndex = 0;
        while (chartIndex < charts.size()) {
            diagramReport.outputs().append((ReportChart)charts.get(chartIndex));
            if (chartIndex % 4 == 3) {
                diagramReport.outputs().appendln();
            }
            ++chartIndex;
        }
        for (ReportTable table2 : tables) {
            diagramReport.outputs().appendln(table2.getTitle());
            diagramReport.outputs().appendln(table2);
        }
        result.outputs().append(overallReport);
        result.outputs().append(diagramReport);
        result.outputs().append(detailReport);
        result.outputs().append(componentReport);
        Map<String, StringList> pajekBuffers = census.getPajekBuffers();
        for (String string : pajekBuffers.keySet()) {
            StringList pajekBuffer = pajekBuffers.get(string);
            if (pajekBuffer.length() == 0) continue;
            File targetFile = ToolBox.setExtension(ToolBox.addToName(new File(slices.relationModelName()), "-" + string), ".paj");
            ReportRawData rawData = new ReportRawData("Export " + string + "s to Pajek", "Pajek", "paj", targetFile);
            rawData.setData(PAJFile.convertToMicrosoftEndOfLine(pajekBuffer.toString()));
            result.outputs().appendln();
            result.outputs().append(rawData);
        }
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public static Report reportEgoNetworks(Slices slices, StatisticsCriteria criteria) throws PuckException {
        Iterator<String> table;
        PartitionCriteria splitCriteria;
        Partition<Numberable> partition;
        NumberedValues values;
        if (slices == null || criteria == null) {
            throw PuckExceptions.INVALID_PARAMETER.create("Null parameter detected.", new Object[0]);
        }
        Report result = new Report("Ego Networks " + slices.relationModelName());
        Chronometer chrono = new Chronometer();
        result.setOrigin("Space reporter");
        SpaceTimeCriteria censusCriteria = new SpaceTimeCriteria(SpaceTimeCriteria.CensusType.EGONETWORKS);
        censusCriteria.setRelationModelName("RESIDENCE");
        censusCriteria.setEgoRoleName("RESIDENT");
        censusCriteria.setAlterFilterRoleName("ALL");
        SequencesCensus census = new SequencesCensus(slices.indiSequences(), censusCriteria);
        SpaceTimeCriteria.CensusType censusType = censusCriteria.getCensusType();
        Individuals members = slices.members();
        Report overallReport = new Report("Survey");
        Report diagramReport = new Report("Diagrams");
        Report detailReport = new Report("Details");
        Report componentReport = new Report("Components");
        Report treeReport = new Report("Trees");
        ArrayList<Object> charts = new ArrayList<Object>();
        ArrayList<ReportTable> tables = new ArrayList<ReportTable>();
        overallReport.outputs().appendln("Measure\tAverage (Male)\tAverage Pos. (Male)\tMedian (Male)\tMaximum (Male)\tSum (Male)\tAverage (Female)\tAverage Pos. (Female)\tMedian (Female)\tMaximum (Female)\tSum (Female)\tAverage (All)\tAverage Pos. (All)\tMedian (All)\tMaximum (All)\tSum (All)");
        for (String label : censusCriteria.getCensusOperationLabels()) {
            void var18_33;
            PartitionCriteria partitionCriteria = new PartitionCriteria(label);
            Object var18_34 = null;
            if (!label.contains("ALTERS") && !label.contains("PROFILE")) {
                values = census.getValues(label);
                partition = PartitionMaker.create(label, slices.relations(slices.ids().get(0)), values, partitionCriteria);
                splitCriteria = new PartitionCriteria(censusCriteria.getPartitionLabel());
                ReportChart reportChart = StatisticsReporter.createPartitionChart(partition, partitionCriteria, null);
                overallReport.outputs().append(String.valueOf(label) + "\t");
                Object sum = "";
                if (label.startsWith("NR")) {
                    sum = String.valueOf(new Double(values.sum()).intValue());
                }
                overallReport.outputs().append(String.valueOf(MathUtils.round(values.average(), 2)) + "\t" + MathUtils.round(values.averagePositives(), 2) + "\t" + values.median() + "\t" + values.max() + "\t" + (String)sum + "\t");
                overallReport.outputs().appendln();
            }
            if (var18_33 == null) continue;
            charts.add(var18_33);
            table = ReportTable.transpose(var18_33.createReportTableWithSum());
            tables.add((ReportTable)((Object)table));
            if (label.contains("EVENTS_") || label.contains("RELATIONS")) continue;
            tables.add(ReportTable.normalize((ReportTable)((Object)table)));
        }
        overallReport.outputs().appendln();
        overallReport.outputs().appendln("Measure\tAverage (Male)\tAverage Pos. (Male)\tMedian (Male)\tMaximum (Male)\tSum (Male)\tAverage (Female)\tAverage Pos. (Female)\tMedian (Female)\tMaximum (Female)\tSum (Female)\tAverage (All)\tAverage Pos. (All)\tMedian (All)\tMaximum (All)\tSum (All)");
        for (String label : censusCriteria.getCensusOperationLabels()) {
            void var18_40;
            PartitionCriteria partitionCriteria = new PartitionCriteria(label);
            if (label.equals("NREVENTS")) {
                partitionCriteria.setType(PartitionCriteria.PartitionType.RAW);
            } else if (label.contains("AGEFIRST")) {
                partitionCriteria.setType(PartitionCriteria.PartitionType.SIZED_GROUPING);
                partitionCriteria.setStart(0.0);
                partitionCriteria.setSize(5.0);
            } else if (label.equals("ECCENTRICITY")) {
                partitionCriteria.setType(PartitionCriteria.PartitionType.SIZED_GROUPING);
                partitionCriteria.setStart(-100.0);
                partitionCriteria.setSize(20.0);
            } else if (label.contains("COVERAGE") || label.contains("SAME") || label.contains("NORM") || label.contains("DENSITY") || label.contains("BETWEENNESS") || label.contains("EFFICIENCY") || label.contains("CONCENTRATION")) {
                partitionCriteria.setType(PartitionCriteria.PartitionType.SIZED_GROUPING);
                partitionCriteria.setStart(0.0);
                partitionCriteria.setSize(20.0);
            } else if (label.contains("MEAN") || label.contains("COVERAGE") || label.contains("PEREVENT") || label.contains("BETWEENNESS") || label.contains("BROKERAGE") || label.contains("EFFICIENT_SIZE")) {
                partitionCriteria.setType(PartitionCriteria.PartitionType.SIZED_GROUPING);
                partitionCriteria.setStart(0.0);
                partitionCriteria.setSize(1.0);
            } else {
                partitionCriteria.setType(PartitionCriteria.PartitionType.RAW);
            }
            Object var18_37 = null;
            if (label.contains("SIMILARITY")) {
                SpaceTimeCriteria.RelationClassificationType relationClassificationType = SpaceTimeCriteria.RelationClassificationType.valueOf(label.substring(label.lastIndexOf("_") + 1));
                Map<Value, Double[]> similaritiesMap = census.getSimilaritiesMap(relationClassificationType);
                ReportChart reportChart = StatisticsReporter.createMapChart(similaritiesMap, label, new String[]{"HH", "FH", "HF", "FF", "All"}, ReportChart.GraphType.LINES);
                for (Value key : similaritiesMap.keySet()) {
                    overallReport.outputs().appendln(String.valueOf(label) + "_" + key + "\t" + MathUtils.percent(similaritiesMap.get(key)[4], 100.0));
                }
            } else if (!label.contains("ALTERS") && !label.contains("PROFILE")) {
                values = census.getValues(label);
                partition = PartitionMaker.create(label, members, values, partitionCriteria);
                splitCriteria = new PartitionCriteria(censusCriteria.getPartitionLabel());
                ReportChart reportChart = StatisticsReporter.createPartitionChart(partition, partitionCriteria, splitCriteria);
                if (label.substring(0, 3).equals("AGE")) {
                    partitionCriteria.setType(PartitionCriteria.PartitionType.RAW);
                    partitionCriteria.setSizeFilter(PartitionCriteria.SizeFilter.HOLES);
                    partitionCriteria.setValueFilter(PartitionCriteria.ValueFilter.NULL);
                    partition = PartitionMaker.create(label, members, values, partitionCriteria);
                    if (partition.maxValue() != null) {
                        ReportChart survivalChart = StatisticsReporter.createSurvivalChart(partition, splitCriteria);
                        charts.add(survivalChart);
                    } else {
                        System.err.println(String.valueOf(label) + " no max value");
                    }
                }
                NumberedValues[] genderedValues = PuckUtils.getGenderedNumberedValues(values, members);
                overallReport.outputs().append(String.valueOf(label) + "\t");
                int gender = 0;
                while (gender < 3) {
                    String sum = "";
                    if (label.startsWith("NR")) {
                        sum = String.valueOf(new Double(genderedValues[gender].sum()).intValue());
                    }
                    overallReport.outputs().append(String.valueOf(MathUtils.round(genderedValues[gender].average(), 2)) + "\t" + MathUtils.round(genderedValues[gender].averagePositives(), 2) + "\t" + values.median() + "\t" + genderedValues[gender].max() + "\t" + sum + "\t");
                    ++gender;
                }
                overallReport.outputs().appendln();
            }
            if (var18_40 == null) continue;
            charts.add(var18_40);
            if (label.equals("SIMILARITY")) {
                tables.add(ReportTable.transpose(var18_40.createReportTable()));
                continue;
            }
            table = ReportTable.transpose(var18_40.createReportTableWithSum());
            tables.add((ReportTable)((Object)table));
            if (label.contains("EVENTS_") || label.contains("RELATIONS")) continue;
            tables.add(ReportTable.normalize((ReportTable)((Object)table)));
        }
        overallReport.outputs().appendln();
        detailReport.outputs().append("Nr\tEgo\tGender");
        for (String partitionLabel : censusCriteria.getCensusOperationLabels()) {
            if (partitionLabel.contains("SIMILARITY")) {
                SpaceTimeCriteria.RelationClassificationType relationClassificationType = SpaceTimeCriteria.RelationClassificationType.valueOf(partitionLabel.substring(partitionLabel.lastIndexOf("_") + 1));
                detailReport.outputs().append("\tSIMILARITY_PARENT_" + (Object)((Object)relationClassificationType) + "\tSIMILARITY_CHILD_" + (Object)((Object)relationClassificationType) + "\tSIMILARITY_SIBLING_" + (Object)((Object)relationClassificationType) + "\tSIMILARITY_SPOUSE_" + (Object)((Object)relationClassificationType));
                continue;
            }
            detailReport.outputs().append("\t" + partitionLabel);
        }
        TreeMap<String, Map<String, Double>> componentChartMap = new TreeMap<String, Map<String, Double>>();
        detailReport.outputs().appendln();
        for (Individual ego : members.toSortedList()) {
            if ((censusType == SpaceTimeCriteria.CensusType.GENERAL || censusType == SpaceTimeCriteria.CensusType.PARCOURS || censusType == SpaceTimeCriteria.CensusType.PARCOURSNETWORKS) && census.getValues("NREVENTS").get(ego.getId()) != null || censusType == SpaceTimeCriteria.CensusType.EGONETWORKS && census.getValues("SIZE").get(ego.getId()) != null) {
                detailReport.outputs().append(String.valueOf(ego.getId()) + "\t" + ego + "\t" + (Object)((Object)ego.getGender()));
                for (String string : censusCriteria.getCensusOperationLabels()) {
                    if (string.contains("SIMILARITY")) {
                        String[] keys;
                        Value value = (Value)census.getValues(string).get(ego.getId());
                        Map indiSimilaritiesMap = value.mapValue();
                        String[] stringArray = keys = new String[]{"PARENT", "CHILD", "SIBLING", "SPOUSE"};
                        int n = keys.length;
                        int sum = 0;
                        while (sum < n) {
                            String key = stringArray[sum];
                            Double[] sim = (Double[])indiSimilaritiesMap.get(new Value(key));
                            if (sim != null) {
                                detailReport.outputs().append("\t" + MathUtils.round(sim[4], 2));
                            }
                            ++sum;
                        }
                        continue;
                    }
                    detailReport.outputs().append("\t" + census.getValues(string).get(ego.getId()));
                }
                detailReport.outputs().appendln();
            }
            if (censusType != SpaceTimeCriteria.CensusType.EGONETWORKS && censusType != SpaceTimeCriteria.CensusType.PARCOURSNETWORKS) continue;
            for (String string : censusCriteria.getNetworkTitles()) {
                Map<Integer, Partition<Node<Individual>>> componentsMap = census.getComponents(string);
                if (componentsMap == null) continue;
                Partition<Node<Individual>> components = componentsMap.get(ego.getId());
                componentReport.outputs().appendln("Components " + string);
                componentReport.outputs().appendln(ego + "\t" + components.size());
                int i = 1;
                for (Cluster<Node<Individual>> cluster : components.getClusters().toListSortedByValue()) {
                    componentReport.outputs().appendln("\t" + i + "\t" + cluster.getValue() + "\t(" + cluster.size() + ")\t" + cluster.getItemsAsString());
                    ++i;
                }
                componentReport.outputs().appendln();
                for (Value value : components.getValues()) {
                    String label = value.toString();
                    TreeMap<String, Double> map = (TreeMap<String, Double>)componentChartMap.get(label);
                    if (map == null) {
                        map = new TreeMap<String, Double>();
                        Gender[] genderArray = Gender.values();
                        int n = genderArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Gender gender = genderArray[n2];
                            map.put(gender.toString(), 0.0);
                            ++n2;
                        }
                        componentChartMap.put(label, map);
                    }
                    map.put(ego.getGender().toString(), (Double)map.get(ego.getGender().toString()) + 1.0);
                }
            }
        }
        if (censusType == SpaceTimeCriteria.CensusType.EGONETWORKS || censusType == SpaceTimeCriteria.CensusType.PARCOURSNETWORKS) {
            ReportChart componentChart = StatisticsReporter.createChart("COMPONENTS", componentChartMap);
            charts.add(componentChart);
            tables.add(ReportTable.transpose(componentChart.createReportTableWithSum()));
            if (census.getRelationConnectionMatrix() != null) {
                for (ReportChart reportChart : census.getRelationConnectionMatrix().getCharts()) {
                    charts.add(reportChart);
                }
                tables.add(census.getRelationConnectionMatrix().getTable("Component Connections"));
            }
        }
        if (censusType == SpaceTimeCriteria.CensusType.PARCOURS) {
            for (SpaceTimeCriteria.RelationClassificationType relationClassificationType : censusCriteria.getMainRelationClassificationTypes()) {
                CorrelationMatrix correlationMatrix;
                if (censusCriteria.getNetworkTitles().contains("Event Type Network")) {
                    CorrelationMatrix correlationMatrix2 = census.getEventSequenceMatrix(relationClassificationType.toString());
                    if (correlationMatrix2 != null) {
                        for (ReportChart chart3 : correlationMatrix2.getCharts()) {
                            charts.add(chart3);
                        }
                        tables.add(correlationMatrix2.getTable("Event Type Sequences"));
                    }
                    overallReport.outputs().appendln();
                    overallReport.outputs().appendln("Sequence Network Statistics " + (Object)((Object)relationClassificationType));
                    overallReport.outputs().appendln("\tDensity\tInertia\t(Divergence)\tConcentration\t(Divergence)\tSymmetry\t(Divergence)\tCentral nodes");
                    Gender[] genderArray = Gender.values();
                    int components = genderArray.length;
                    int componentsMap = 0;
                    while (componentsMap < components) {
                        Gender gender = genderArray[componentsMap];
                        GraphProfile<Cluster<String>> profile = correlationMatrix2.getProfile(gender);
                        String centralReferents = "";
                        for (Cluster<String> centralReferent : profile.getCentralReferents()) {
                            centralReferents = String.valueOf(centralReferents) + centralReferent.getValue() + " ";
                        }
                        double maxBetweenness = profile.getMaxBetweenness();
                        double density = profile.density();
                        double endo = MathUtils.round(profile.getStatistics(MatrixStatistics.Indicator.LOOPS, MatrixStatistics.Mode.NORMALIZED), 2);
                        double endoExp = MathUtils.round(profile.getStatistics(MatrixStatistics.Indicator.LOOPS, MatrixStatistics.Mode.DIVERGENCE_NORMALIZED), 2);
                        double conc = MathUtils.round(profile.getStatistics(MatrixStatistics.Indicator.CONCENTRATION, MatrixStatistics.Mode.SIMPLE), 2);
                        double concExp = MathUtils.round(profile.getStatistics(MatrixStatistics.Indicator.CONCENTRATION, MatrixStatistics.Mode.DIVERGENCE), 2);
                        double sym = MathUtils.round(profile.getStatistics(MatrixStatistics.Indicator.SYMMETRY, MatrixStatistics.Mode.SIMPLE), 2);
                        double symExp = MathUtils.round(profile.getStatistics(MatrixStatistics.Indicator.SYMMETRY, MatrixStatistics.Mode.DIVERGENCE), 2);
                        overallReport.outputs().appendln((Object)((Object)gender) + "\t" + density + "\t" + endo + "\t" + endoExp + "\t" + conc + "\t" + concExp + "\t" + sym + "\t" + symExp + "\t" + centralReferents + "(" + maxBetweenness + ") betweenness centrality");
                        ++componentsMap;
                    }
                    overallReport.outputs().appendln();
                }
                if (!censusCriteria.getNetworkTitles().contains("Sequence Type Network") || (correlationMatrix = census.getSubSequenceMatrix(relationClassificationType.toString())) == null) continue;
                charts.add(correlationMatrix.getRamificationChart());
            }
        }
        int chartIndex = 0;
        while (chartIndex < charts.size()) {
            diagramReport.outputs().append((ReportChart)charts.get(chartIndex));
            if (chartIndex % 4 == 3) {
                diagramReport.outputs().appendln();
            }
            ++chartIndex;
        }
        for (ReportTable table2 : tables) {
            diagramReport.outputs().appendln(table2.getTitle());
            diagramReport.outputs().appendln(table2);
        }
        result.outputs().append(overallReport);
        result.outputs().append(diagramReport);
        result.outputs().append(detailReport);
        if (censusType == SpaceTimeCriteria.CensusType.EGONETWORKS || censusType == SpaceTimeCriteria.CensusType.PARCOURSNETWORKS) {
            result.outputs().append(componentReport);
        }
        if (censusType == SpaceTimeCriteria.CensusType.PARCOURS) {
            result.outputs().append(treeReport);
        }
        Map<String, StringList> pajekBuffers = census.getPajekBuffers();
        for (String string : pajekBuffers.keySet()) {
            StringList pajekBuffer = pajekBuffers.get(string);
            if (pajekBuffer.length() == 0) continue;
            File targetFile = ToolBox.setExtension(ToolBox.addToName(new File(slices.relationModelName()), "-" + string), ".paj");
            ReportRawData rawData = new ReportRawData("Export " + string + "s to Pajek", "Pajek", "paj", targetFile);
            rawData.setData(PAJFile.convertToMicrosoftEndOfLine(pajekBuffer.toString()));
            result.outputs().appendln();
            result.outputs().append(rawData);
        }
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static Report reportIndividualDynamics(Slices slices, StatisticsCriteria criteria) throws PuckException {
        if (slices == null || criteria == null) {
            throw PuckExceptions.INVALID_PARAMETER.create("Null parameter detected.", new Object[0]);
        }
        Report result = new Report("Population Dynamics " + slices.relationModelName());
        Chronometer chrono = new Chronometer();
        result.setOrigin("Space reporter");
        List<Integer> times = slices.ids();
        ArrayList<ReportChart> charts = new ArrayList<ReportChart>(20);
        ArrayList<ReportTable> tables = new ArrayList<ReportTable>(20);
        int i = 0;
        while (i < times.size() - 1) {
            int startTime = times.get(i);
            int endTime = times.get(i + 1);
            Relations totalStartSpace = slices.allRelations(startTime);
            Relations totalEndSpace = slices.allRelations(endTime);
            Relations filteredStartSpace = slices.relations(startTime);
            Relations filteredEndSpace = slices.relations(endTime);
            Partition<Individual> partition = new Partition<Individual>();
            partition.setLabel(String.valueOf(slices.relationModelName()) + " " + startTime + "-" + endTime);
            PartitionCriteria partitionCriteria = new PartitionCriteria();
            partitionCriteria.setLabel(partition.getLabel());
            Individuals totalStartPopulation = totalStartSpace.getIndividuals();
            Individuals totalEndPopulation = totalEndSpace.getIndividuals();
            Individuals filteredStartPopulation = filteredStartSpace.getIndividuals();
            Individuals filteredEndPopulation = filteredEndSpace.getIndividuals();
            Partition<Individual> destinations = new Partition<Individual>();
            destinations.setLabel("Destinations " + startTime + "/" + endTime);
            for (Individual individual : filteredStartSpace.getIndividuals().toSortedList()) {
                String endUnit;
                if (IndividualValuator.lifeStatusAtYear(individual, endTime).equals("DEAD")) {
                    partition.put(individual, new Value("DIED"));
                    continue;
                }
                if (!totalEndPopulation.contains(individual)) {
                    partition.put(individual, new Value("UNKNOWN DESTINATION"));
                    continue;
                }
                if (!filteredEndPopulation.contains(individual)) {
                    partition.put(individual, new Value("LEFT"));
                    for (Relation destination : totalEndSpace.getByIndividual(individual)) {
                        destinations.put(individual, RelationValuator.get(destination, "PLACE", (Object)criteria.getPlaceParameter()));
                    }
                    continue;
                }
                Iterator start = (Relation)filteredStartSpace.getByIndividual(individual).getFirst();
                Relation end = (Relation)filteredEndSpace.getByIndividual(individual).getFirst();
                Object startUnit = ((Relation)((Object)start)).getAttributeValue(slices.idLabel());
                if (startUnit == null) {
                    startUnit = ((Relation)((Object)start)).getAttributeValue(slices.placeLabel());
                }
                if ((endUnit = end.getAttributeValue(slices.idLabel())) == null) {
                    endUnit = ((Relation)((Object)start)).getAttributeValue(slices.placeLabel());
                }
                if (!((String)startUnit).equals(endUnit)) {
                    partition.put(individual, new Value("INTERNAL CHANGE"));
                    continue;
                }
                partition.put(individual, new Value("UNCHANGED"));
            }
            Partition<Individual> origins = new Partition<Individual>();
            origins.setLabel("Origins " + startTime + "/" + endTime);
            for (Individual individual : filteredEndSpace.getIndividuals().toSortedList()) {
                if (IndividualValuator.lifeStatusAtYear(individual, startTime).equals("UNBORN")) {
                    partition.put(individual, new Value("NEWBORN"));
                    continue;
                }
                if (!totalStartPopulation.contains(individual)) {
                    partition.put(individual, new Value("UNKNOWN ORIGIN"));
                    continue;
                }
                if (!filteredStartPopulation.contains(individual)) {
                    partition.put(individual, new Value("ENTERED"));
                    for (Relation origin : totalStartSpace.getByIndividual(individual)) {
                        origins.put(individual, RelationValuator.get(origin, "PLACE", (Object)criteria.getPlaceParameter()));
                    }
                    continue;
                }
                filteredStartSpace.getByIndividual(individual).equals(filteredEndSpace.getByIndividual(individual));
            }
            for (Cluster cluster : destinations.getClusters()) {
                System.out.println(cluster + "\t" + cluster.size() + "\t" + cluster.getItemsAsString());
            }
            ReportChart chart = StatisticsReporter.createPartitionChart(partition, partitionCriteria, criteria.getSplitCriteria());
            charts.add(chart);
            ReportTable table = ReportTable.transpose(chart.createReportTableWithSum());
            tables.add(table);
            ReportChart chartDestinations = StatisticsReporter.createPartitionChart(destinations, partitionCriteria, criteria.getSplitCriteria());
            charts.add(chartDestinations);
            ReportTable tableDestinations = ReportTable.transpose(chartDestinations.createReportTableWithSum());
            tables.add(tableDestinations);
            ReportChart chartOrigins = StatisticsReporter.createPartitionChart(origins, partitionCriteria, criteria.getSplitCriteria());
            charts.add(chartOrigins);
            ReportTable tableOrigins = ReportTable.transpose(chartOrigins.createReportTableWithSum());
            tables.add(tableOrigins);
            ++i;
        }
        int nr = Math.min(4, 2 * times.size());
        int chartIndex = 0;
        while (chartIndex < charts.size()) {
            result.outputs().append((ReportChart)charts.get(chartIndex));
            if (chartIndex % nr == nr - 1) {
                result.outputs().appendln();
            }
            ++chartIndex;
        }
        for (ReportTable table : tables) {
            result.outputs().appendln(table);
        }
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }
}

