/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.spacetime;

import java.util.Map;
import java.util.TreeMap;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Individuals;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.net.relations.Relations;
import org.tip.puck.net.workers.IndividualValuator;
import org.tip.puck.net.workers.RelationValuator;
import org.tip.puck.spacetime.Ordinal;
import org.tip.puck.util.Numberable;

public class Slice
implements Comparable<Slice>,
Numberable {
    int id;
    Ordinal time;
    Relations relations;
    Relations allRelations;
    String idLabel;
    String idValue;
    Map<Individual, Relation> relationsByIndividuals;

    public Slice() {
    }

    public Slice(Ordinal time, String constantAttributeLabel) {
        this.time = time;
        this.relations = new Relations();
        this.allRelations = new Relations();
        this.idLabel = constantAttributeLabel;
        this.id = time.getYear();
        this.relationsByIndividuals = new TreeMap<Individual, Relation>();
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void setId(int id) {
        this.id = id;
    }

    public Ordinal time() {
        return this.time;
    }

    public void setTime(Ordinal time) {
        this.time = time;
    }

    @Override
    public String hashKey() {
        return String.valueOf(this.id);
    }

    @Override
    public int compareTo(Slice slice) {
        return this.time.compareTo(slice.time());
    }

    public String idValue() {
        return this.idValue;
    }

    public void put(Relation relation) {
        this.relations.put(relation);
    }

    public Relations relations() {
        return this.relations;
    }

    public Relations allRelations() {
        return this.allRelations;
    }

    public Map<Individual, Relation> relationsByIndividuals() {
        return this.relationsByIndividuals;
    }

    public void put(Individual individual, Relation relation) {
        this.put(relation);
        this.relationsByIndividuals.put(individual, relation);
    }

    public Individuals members() {
        Individuals result = new Individuals();
        for (Individual individual : this.relationsByIndividuals.keySet()) {
            result.put(individual);
        }
        return result;
    }

    public Relation getRelation(Individual individual) {
        return this.relationsByIndividuals.get(individual);
    }

    public boolean isIndividualLabel(String label) {
        return IndividualValuator.getAttributeLabels(this.members()).contains((Object)label);
    }

    public boolean isStateLabel(String label) {
        return RelationValuator.getAttributeLabels(this.relations).contains(label);
    }
}

