/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net.relations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.tip.puck.net.Gender;
import org.tip.puck.net.relations.Role;
import org.tip.puck.net.relations.RoleDefinition;
import org.tip.puck.net.relations.RoleDefinitionComparator;
import org.tip.puck.net.relations.Roles;
import org.tip.puck.util.NumberablesHashMap;

public class RoleDefinitions
extends NumberablesHashMap<RoleDefinition> {
    boolean egoGenderDistinction;
    RoleDefinitions recursiveDefinitions;
    Map<Role, Roles> factors;
    Roles uncomposableRoles;

    public RoleDefinitions() {
    }

    public RoleDefinitions(RoleDefinitions roleDefinitions) {
        this.uncomposableRoles = roleDefinitions.uncomposableRoles;
        for (RoleDefinition roleDefinition : roleDefinitions) {
            this.add(roleDefinition.clone());
        }
    }

    private Role getFatherRole() {
        Role result = null;
        for (RoleDefinition roleDefinition : this) {
            if (roleDefinition.primary() == null || !roleDefinition.primary().equals((Object)RoleDefinition.Primary.PARENT) || !roleDefinition.alterGender().isMale()) continue;
            result = roleDefinition.role();
            break;
        }
        return result;
    }

    private Role getMotherRole() {
        Role result = null;
        for (RoleDefinition roleDefinition : this) {
            if (roleDefinition.primary() == null || !roleDefinition.primary().equals((Object)RoleDefinition.Primary.PARENT) || !roleDefinition.alterGender().isFemale()) continue;
            result = roleDefinition.role();
            break;
        }
        return result;
    }

    private Role getNeutralParentRole() {
        Role result = null;
        for (RoleDefinition roleDefinition : this) {
            if (roleDefinition.primary() == null || !roleDefinition.primary().equals((Object)RoleDefinition.Primary.PARENT) || !roleDefinition.alterGender().isUnknown()) continue;
            result = roleDefinition.role();
            break;
        }
        return result;
    }

    public void setInversePrimaryTerms() {
        Role fatherRole = this.getFatherRole();
        Role motherRole = this.getMotherRole();
        Role parentRole = this.getNeutralParentRole();
        if (fatherRole != null || motherRole != null || parentRole != null) {
            for (RoleDefinition def : this.toList()) {
                RoleDefinition parentDefinition;
                if (def.inversion() == null || !def.inversion().toString().equals("[Parent]")) continue;
                if (fatherRole != null) {
                    parentDefinition = def.clone();
                    parentDefinition.setId(this.getLastId() + 1);
                    parentDefinition.setInversion(fatherRole);
                    this.addNew(parentDefinition);
                }
                if (motherRole != null) {
                    parentDefinition = def.clone();
                    parentDefinition.setId(this.getLastId() + 1);
                    parentDefinition.setInversion(motherRole);
                    this.addNew(parentDefinition);
                }
                if (parentRole != null) {
                    parentDefinition = def.clone();
                    parentDefinition.setId(this.getLastId() + 1);
                    parentDefinition.setInversion(parentRole);
                    this.addNew(parentDefinition);
                }
                this.removeById(def.getId());
            }
        }
    }

    public static boolean setPrimaryFromString(RoleDefinition roleDefinition, String item) {
        boolean result = false;
        if (item.length() == 1) {
            result = true;
            if (item.equals("M")) {
                roleDefinition.setPrimary(RoleDefinition.Primary.PARENT);
                roleDefinition.setAlterGender(Gender.FEMALE);
            } else if (item.equals("F")) {
                roleDefinition.setPrimary(RoleDefinition.Primary.PARENT);
                roleDefinition.setAlterGender(Gender.MALE);
            } else if (item.equals("W")) {
                roleDefinition.setPrimary(RoleDefinition.Primary.SPOUSE);
                roleDefinition.setAlterGender(Gender.FEMALE);
                if (roleDefinition.egoGender().isUnknown()) {
                    roleDefinition.setEgoGender(Gender.MALE);
                }
            } else if (item.equals("H")) {
                roleDefinition.setPrimary(RoleDefinition.Primary.SPOUSE);
                roleDefinition.setAlterGender(Gender.MALE);
                if (roleDefinition.egoGender().isUnknown()) {
                    roleDefinition.setEgoGender(Gender.FEMALE);
                }
            } else if (item.equals("Z")) {
                roleDefinition.setPrimary(RoleDefinition.Primary.SIBLING);
                roleDefinition.setAlterGender(Gender.FEMALE);
            } else if (item.equals("B")) {
                roleDefinition.setPrimary(RoleDefinition.Primary.SIBLING);
                roleDefinition.setAlterGender(Gender.MALE);
            } else if (item.equals("D")) {
                roleDefinition.setInversion(new Role("[Parent]"));
                roleDefinition.setAlterGender(Gender.FEMALE);
            } else if (item.equals("S")) {
                roleDefinition.setInversion(new Role("[Parent]"));
                roleDefinition.setAlterGender(Gender.MALE);
            } else {
                result = false;
            }
        }
        return result;
    }

    public Roles getPrimaryTerms(String item, Gender egoGender, RoleDefinition.AlterAge alterAge, Gender alterGender) {
        Roles result = new Roles();
        RoleDefinition roleDefinition = new RoleDefinition(0);
        RoleDefinitions.setPrimaryFromString(roleDefinition, item);
        if (roleDefinition.egoGender().isUnknown()) {
            roleDefinition.setEgoGender(egoGender);
        }
        if (roleDefinition.alterGender().isUnknown()) {
            roleDefinition.setAlterGender(alterGender);
        }
        if (roleDefinition.alterAge() == null) {
            roleDefinition.setAlterAge(alterAge);
        }
        if (roleDefinition.inversion() != null && roleDefinition.inversion().getName().equals("[Parent]")) {
            Roles inverseRoles = new Roles();
            for (RoleDefinition definition : this.get(RoleDefinition.Primary.PARENT, null, null, egoGender, null, roleDefinition.alterGender())) {
                if (inverseRoles.contains(definition.role())) continue;
                inverseRoles.add(definition.role());
            }
            for (Role inverseRole : inverseRoles) {
                for (RoleDefinition definition : this.get(roleDefinition.primary(), inverseRole, roleDefinition.composition(), roleDefinition.alterGender(), roleDefinition.alterAge(), roleDefinition.egoGender())) {
                    if (result.contains(definition.role())) continue;
                    result.add(definition.role());
                }
            }
        }
        for (RoleDefinition definition : this.getMostPrecise(roleDefinition.primary(), roleDefinition.inversion(), roleDefinition.composition(), roleDefinition.alterGender(), roleDefinition.alterAge(), roleDefinition.egoGender())) {
            if (result.contains(definition.role())) continue;
            result.add(definition.role());
        }
        return result;
    }

    public RoleDefinitions get(RoleDefinition.Primary primary, Role inversion, Roles composition, Gender alterGender, RoleDefinition.AlterAge alterAge, Gender egoGender) {
        RoleDefinitions result = new RoleDefinitions();
        for (RoleDefinition def : this) {
            if (def.primary() != primary || def.inversion() != inversion || (def.composition() != null || composition != null) && (def.composition() == null || !def.composition().equals(composition)) || def.alterGender() != alterGender && !def.alterGender().isUnknown() && !alterGender.isUnknown() || def.alterAge() != alterAge && def.alterAge() != null && alterAge != null || def.egoGender() != egoGender && !def.egoGender().isUnknown() && !egoGender.isUnknown()) continue;
            result.addNew(def);
        }
        return result;
    }

    public RoleDefinitions getMostPrecise(RoleDefinition.Primary primary, Role inversion, Roles composition, Gender alterGender, RoleDefinition.AlterAge alterAge, Gender egoGender) {
        RoleDefinitions result = new RoleDefinitions();
        RoleDefinitions preResult = this.get(primary, inversion, composition, alterGender, alterAge, egoGender);
        for (RoleDefinition definition : preResult) {
            boolean isMostPrecise = true;
            for (RoleDefinition otherDefinition : preResult) {
                int compareGenderPrecision = 0;
                int compareAgePrecision = 0;
                if (!alterGender.isUnknown() && definition.alterGender().isUnknown() && !otherDefinition.alterGender().isUnknown()) {
                    compareGenderPrecision = -1;
                }
                if (!alterGender.isUnknown() && !definition.alterGender().isUnknown() && otherDefinition.alterGender().isUnknown()) {
                    compareGenderPrecision = 1;
                }
                if (alterAge != null && definition.alterAge() == null && otherDefinition.alterAge() != null) {
                    compareAgePrecision = -1;
                }
                if (alterAge != null && definition.alterAge() != null && otherDefinition.alterAge() == null) {
                    compareAgePrecision = 1;
                }
                if (compareGenderPrecision + compareAgePrecision >= 0) continue;
                isMostPrecise = false;
                break;
            }
            if (!isMostPrecise) continue;
            result.addNew(definition);
        }
        return result;
    }

    public boolean isPrimaryParent(RoleDefinition roleDefinition) {
        return roleDefinition.primary() == RoleDefinition.Primary.PARENT;
    }

    public boolean isPrimarySibling(RoleDefinition roleDefinition) {
        return roleDefinition.primary() == RoleDefinition.Primary.SIBLING;
    }

    public boolean isPrimarySpouse(RoleDefinition roleDefinition) {
        return roleDefinition.primary() == RoleDefinition.Primary.SPOUSE;
    }

    public boolean isPrimaryChild(RoleDefinition roleDefinition) {
        boolean result = false;
        for (RoleDefinition inverseDefinition : this.getDefinitions(roleDefinition.inversion())) {
            if (!this.isPrimaryParent(inverseDefinition)) continue;
            result = true;
        }
        return result;
    }

    public Roles getCompositeRoles(Role alpha, Role beta, int iterations, int maxIterations) {
        Roles result = new Roles();
        if (iterations <= maxIterations) {
            for (RoleDefinition alphaDef : this.getDefinitions(alpha)) {
                for (RoleDefinition betaDef : this.getDefinitions(beta)) {
                    Role deltaBeta;
                    Object delta;
                    Role gamma;
                    if (this.isPrimaryChild(betaDef)) {
                        if (this.isPrimaryParent(alphaDef)) {
                            for (RoleDefinition siblingDef : this.get(RoleDefinition.Primary.SIBLING, null, null, betaDef.alterGender(), betaDef.alterAge(), alphaDef.egoGender())) {
                                if (result.contains(siblingDef.role())) continue;
                                result.add(siblingDef.role());
                            }
                            continue;
                        }
                        if (alphaDef.composition() == null) continue;
                        gamma = (Role)alphaDef.composition().get(0);
                        delta = (Role)alphaDef.composition().get(1);
                        for (RoleDefinition deltaDef : this.getDefinitions((Role)delta)) {
                            if (!this.isPrimaryParent(deltaDef)) continue;
                            for (RoleDefinition siblingDef : this.get(RoleDefinition.Primary.SIBLING, null, null, betaDef.alterGender(), betaDef.alterAge(), deltaDef.egoGender())) {
                                deltaBeta = siblingDef.role();
                                for (Role gammaDeltaBeta : this.getCompositeRoles(gamma, deltaBeta, iterations + 1, maxIterations)) {
                                    if (result.contains(gammaDeltaBeta)) continue;
                                    result.add(gammaDeltaBeta);
                                }
                            }
                        }
                        continue;
                    }
                    if (!this.isPrimaryParent(betaDef)) continue;
                    if (this.isPrimaryChild(alphaDef)) {
                        for (RoleDefinition spouseDef : this.get(RoleDefinition.Primary.SPOUSE, null, null, betaDef.alterGender(), betaDef.alterAge(), alphaDef.egoGender())) {
                            if (result.contains(spouseDef.role())) continue;
                            result.add(spouseDef.role());
                        }
                        continue;
                    }
                    if (alphaDef.composition() == null) continue;
                    gamma = (Role)alphaDef.composition().get(0);
                    delta = (Role)alphaDef.composition().get(1);
                    for (RoleDefinition deltaDef : this.getDefinitions((Role)delta)) {
                        if (!this.isPrimaryChild(deltaDef)) continue;
                        for (RoleDefinition spouseDef : this.get(RoleDefinition.Primary.SPOUSE, null, null, betaDef.alterGender(), betaDef.alterAge(), deltaDef.egoGender())) {
                            deltaBeta = spouseDef.role();
                            for (Role gammaDeltaBeta : this.getCompositeRoles(gamma, deltaBeta, iterations + 1, maxIterations)) {
                                if (result.contains(gammaDeltaBeta)) continue;
                                result.add(gammaDeltaBeta);
                            }
                        }
                    }
                }
            }
            if (this.hasNonCompositeDefinition(beta)) {
                for (RoleDefinition def : this) {
                    if (RoleDefinitions.isNullOrHasNullFactor(def.composition()) || !((Role)def.composition().get(0)).equals(alpha) || !((Role)def.composition().get(1)).equals(beta) || result.contains(def.role())) continue;
                    result.add(def.role());
                }
            } else {
                for (RoleDefinition compositeDefinition : this.getCompositeDefinitions(beta)) {
                    if (this.isRecursive(compositeDefinition)) continue;
                    Role gamma = (Role)compositeDefinition.composition().get(0);
                    Role delta = (Role)compositeDefinition.composition().get(1);
                    for (Role alphaGamma : this.getCompositeRoles(alpha, gamma, iterations + 1, maxIterations)) {
                        for (Role alphaGammaDelta : this.getCompositeRoles(alphaGamma, delta, iterations + 1, maxIterations)) {
                            if (result.contains(alphaGammaDelta)) continue;
                            result.add(alphaGammaDelta);
                        }
                    }
                }
            }
            Collections.sort(result);
        }
        return result;
    }

    private static RoleDefinition.AlterAge inverse(RoleDefinition.AlterAge age) {
        RoleDefinition.AlterAge result = null;
        if (age != null) {
            result = age.invert();
        }
        return result;
    }

    public boolean isRecursive(RoleDefinition roleDefinition) {
        boolean result = this.recursiveDefinitions().contains(roleDefinition);
        return result;
    }

    public Roles getReciprocalRoles(Role role, int iterations, int maxIterations) {
        Roles result = new Roles();
        for (Role inverseRole : this.getInverseRoles(role)) {
            if (result.contains(inverseRole)) continue;
            result.add(inverseRole);
        }
        if (iterations <= maxIterations) {
            for (RoleDefinition compositeDefinition : this.getCompositeDefinitions(role)) {
                for (Role alpha : this.getReciprocalRoles((Role)compositeDefinition.composition().get(0), iterations + 1, maxIterations)) {
                    for (Role beta : this.getReciprocalRoles((Role)compositeDefinition.composition().get(1), iterations + 1, maxIterations)) {
                        for (Role betaAlpha : this.getCompositeRoles(beta, alpha, 0, maxIterations)) {
                            if (result.contains(betaAlpha)) continue;
                            result.add(betaAlpha);
                        }
                    }
                }
            }
        }
        return result;
    }

    public boolean isPrimary(Role role) {
        boolean result = this.getPrimaryDefinitions(role).size() > 0;
        return result;
    }

    public RoleDefinitions getPrimaryDefinitions(Role role) {
        RoleDefinitions result = new RoleDefinitions();
        for (RoleDefinition definition : this.getDefinitions(role)) {
            if (definition.primary() == null) continue;
            result.add(definition);
        }
        return result;
    }

    public Roles getInverseRoles(Role role) {
        Roles result = new Roles();
        for (RoleDefinition def : this.getDefinitions(role)) {
            if (this.isPrimarySibling(def)) {
                for (RoleDefinition siblingDef : this.get(RoleDefinition.Primary.SIBLING, null, null, def.egoGender(), RoleDefinitions.inverse(def.alterAge()), def.alterGender())) {
                    if (siblingDef == null || result.contains(siblingDef.role())) continue;
                    result.add(siblingDef.role());
                }
                continue;
            }
            if (this.isPrimarySpouse(def)) {
                for (RoleDefinition spouseDef : this.get(RoleDefinition.Primary.SPOUSE, null, null, def.egoGender(), RoleDefinitions.inverse(def.alterAge()), def.alterGender())) {
                    if (spouseDef == null || result.contains(spouseDef.role())) continue;
                    result.add(spouseDef.role());
                }
                continue;
            }
            if (def.inversion() != null) {
                result.add(def.inversion());
                continue;
            }
            for (RoleDefinition otherDefinition : this) {
                if (otherDefinition.inversion() == null || !otherDefinition.inversion().equals(role) || result.contains(otherDefinition.role())) continue;
                result.add(otherDefinition.role());
            }
        }
        return result;
    }

    public RoleDefinitions getCompositeDefinitions(Role role) {
        RoleDefinitions result = new RoleDefinitions();
        for (RoleDefinition definition : this.getDefinitions(role)) {
            if (definition.composition() == null) continue;
            result.add(definition);
        }
        return result;
    }

    public boolean hasNonCompositeDefinition(Role role) {
        boolean result = false;
        for (RoleDefinition definition : this.getDefinitions(role)) {
            if (definition.composition() != null) continue;
            result = true;
            break;
        }
        return result;
    }

    public RoleDefinitions getNonRecursiveDefinitions(Role role) {
        RoleDefinitions result = new RoleDefinitions();
        for (RoleDefinition roleDefinition : this) {
            if (!roleDefinition.role().equals(role) || this.recursiveDefinitions().contains(roleDefinition)) continue;
            result.add(roleDefinition);
        }
        return result;
    }

    public RoleDefinitions getDefinitions(Role role) {
        RoleDefinitions result = new RoleDefinitions();
        for (RoleDefinition roleDefinition : this) {
            if (!roleDefinition.role().equals(role)) continue;
            result.add(roleDefinition);
        }
        return result;
    }

    public RoleDefinition getEgoGenderComplement(RoleDefinition source) {
        RoleDefinition result = null;
        for (RoleDefinition def : this) {
            if (def.primary() != source.primary() || !Role.equalOrBothNull(def.inversion(), source.inversion()) || !Roles.equalOrBothNull(def.composition(), source.composition()) || def.alterGender() != source.alterGender() || def.alterAge() != source.alterAge() || def.egoGender() != source.egoGender().invert()) continue;
            result = def;
            break;
        }
        return result;
    }

    public RoleDefinition getEgoGenderComplementAgeNeutral(RoleDefinition source) {
        RoleDefinition result = null;
        for (RoleDefinition def : this) {
            if (def.primary() != source.primary() || !Role.equalOrBothNull(def.inversion(), source.inversion()) || !Roles.equalOrBothNull(def.composition(), source.composition()) || def.alterGender() != source.alterGender() || source.alterAge() != null && def.alterAge() != null && def.alterAge() != source.alterAge() || def.egoGender() != source.egoGender().invert()) continue;
            result = def;
            break;
        }
        return result;
    }

    public RoleDefinition getAlterGenderComplement(RoleDefinition source) {
        RoleDefinition result = null;
        for (RoleDefinition def : this) {
            if (def.primary() != source.primary() || !Role.equalOrBothNull(def.inversion(), source.inversion()) || !Roles.equalOrBothNull(def.composition(), source.composition()) || def.alterGender() != source.alterGender().invert() || def.alterAge() != source.alterAge() || def.egoGender() != source.egoGender()) continue;
            result = def;
            break;
        }
        return result;
    }

    public RoleDefinition getAlterGenderComplementAgeNeutral(RoleDefinition source) {
        RoleDefinition result = null;
        for (RoleDefinition def : this) {
            if (def.primary() != source.primary() || !Role.equalOrBothNull(def.inversion(), source.inversion()) || !Roles.equalOrBothNull(def.composition(), source.composition()) || def.alterGender() != source.alterGender().invert() || source.alterAge() != null && def.alterAge() != null && def.alterAge() != source.alterAge() || def.egoGender() != source.egoGender()) continue;
            result = def;
            break;
        }
        return result;
    }

    public RoleDefinition getAlterAgeComplement(RoleDefinition source) {
        RoleDefinition result = null;
        for (RoleDefinition def : this) {
            if (def.primary() != source.primary() || !Role.equalOrBothNull(def.inversion(), source.inversion()) || !Roles.equalOrBothNull(def.composition(), source.composition()) || def.alterGender() != source.alterGender() || source.alterAge() == null || def.alterAge() != source.alterAge().invert() || def.egoGender() != source.egoGender()) continue;
            result = def;
            break;
        }
        return result;
    }

    public Roles getRoles(RoleDefinition.Primary primary, Gender alterGender, RoleDefinition.AlterAge alterAge, Gender egoGender) {
        Roles result = new Roles();
        for (RoleDefinition def : this) {
            if (def.primary() != primary || def.alterGender() != Gender.UNKNOWN && alterGender != Gender.UNKNOWN && alterGender != def.alterGender() || def.egoGender() != Gender.UNKNOWN && egoGender != Gender.UNKNOWN && egoGender != def.egoGender() || def.alterAge() != alterAge && def.alterAge() != null && alterAge != null || result.contains(def.role())) continue;
            result.add(def.role());
        }
        return result;
    }

    public Role getRoleByName(String name) {
        Role result = null;
        for (RoleDefinition def : this) {
            if (def.role() == null || !def.role().getName().equals(name)) continue;
            result = def.role();
            break;
        }
        return result;
    }

    public Role getInverseRole(Role role, Gender egoGender, Gender alterGender) {
        if (egoGender == null) {
            System.err.println("Null ego gender: " + role);
        }
        if (alterGender == null) {
            System.err.println("Null alter gender: " + role);
        }
        Role result = null;
        for (RoleDefinition def : this) {
            if (def.inversion() != null && def.inversion().equals(role) && RoleDefinitions.genderMatch(egoGender, def.alterGender()) && RoleDefinitions.genderMatch(def.egoGender(), alterGender)) {
                result = def.role();
                break;
            }
            if (def.inversion() == null || !def.role().equals(role) || !RoleDefinitions.genderMatch(def.egoGender(), egoGender) || !RoleDefinitions.genderMatch(def.alterGender(), alterGender)) continue;
            result = def.inversion();
            break;
        }
        return result;
    }

    @Override
    public List<RoleDefinition> toSortedList() {
        List<RoleDefinition> result = this.toList();
        Collections.sort(result, new RoleDefinitionComparator());
        return result;
    }

    private static boolean genderMatch(Gender alphaGender, Gender betaGender) {
        return alphaGender == Gender.UNKNOWN || alphaGender == betaGender;
    }

    public boolean isEgoGenderDistinction() {
        return this.egoGenderDistinction;
    }

    public void setEgoGenderDistinction(boolean egoGenderDistinction) {
        this.egoGenderDistinction = egoGenderDistinction;
    }

    public List<Gender> getAlterGenders(Role role) {
        ArrayList<Gender> result = new ArrayList<Gender>();
        for (RoleDefinition def : this.getDefinitions(role)) {
            if (result.contains((Object)def.alterGender())) continue;
            result.add(def.alterGender());
        }
        return result;
    }

    public List<Gender> getMediusGenders(Role role) {
        ArrayList<Gender> result = new ArrayList<Gender>();
        for (RoleDefinition def : this.getDefinitions(role)) {
            if (def.composition() == null) continue;
            for (RoleDefinition mediusDef : this.getDefinitions((Role)def.composition().get(0))) {
                if (result.contains((Object)mediusDef.alterGender())) continue;
                result.add(mediusDef.alterGender());
            }
        }
        return result;
    }

    private Roles roles() {
        Roles result = new Roles();
        for (RoleDefinition definition : this) {
            if (definition.role() == null || result.contains(definition.role())) continue;
            result.add(definition.role());
        }
        return result;
    }

    public Map<Role, Roles> factors() {
        if (this.factors == null) {
            this.factors = new TreeMap<Role, Roles>();
            this.recursiveDefinitions = new RoleDefinitions();
            this.uncomposableRoles = new Roles();
            for (Role role : this.roles()) {
                this.factors.put(role, this.factors(role));
            }
        }
        return this.factors;
    }

    public RoleDefinitions recursiveDefinitions() {
        if (this.recursiveDefinitions == null) {
            this.factors();
        }
        return this.recursiveDefinitions;
    }

    private Roles factors(Role role) {
        Roles result = new Roles();
        LinkedList<Role> queue = new LinkedList<Role>();
        Roles visited = new Roles();
        queue.add(role);
        visited.add(role);
        while (!queue.isEmpty()) {
            Role factor = (Role)queue.remove();
            for (RoleDefinition definition : this.getDefinitions(factor)) {
                if (definition.primary() != null) {
                    if (result.contains(factor)) continue;
                    result.add(factor);
                    continue;
                }
                if (definition.inversion() != null) {
                    Role inv = definition.inversion();
                    if (inv.equals(role)) {
                        this.recursiveDefinitions.add(definition);
                        continue;
                    }
                    if (visited.contains(inv)) continue;
                    queue.add(inv);
                    visited.add(inv);
                    continue;
                }
                if (!RoleDefinitions.isNullOrHasNullFactor(definition.composition())) {
                    for (Role comp : definition.composition()) {
                        if (comp.equals(role)) {
                            this.recursiveDefinitions.add(definition);
                            continue;
                        }
                        if (visited.contains(comp)) continue;
                        queue.add(comp);
                        visited.add(comp);
                    }
                    continue;
                }
                if (definition.composition() == null) {
                    System.err.println("Null compositions: " + definition + " " + (Object)((Object)definition.primary()));
                    if (this.uncomposableRoles.contains(role)) continue;
                    this.uncomposableRoles.add(role);
                    continue;
                }
                System.err.println("Null factors: " + definition);
                if (this.uncomposableRoles.contains(role)) continue;
                this.uncomposableRoles.add(role);
            }
        }
        return result;
    }

    public static boolean isNullOrHasNullFactor(Roles composition) {
        boolean result = false;
        if (composition == null) {
            result = true;
        } else if (composition.size() < 2 || composition.get(0) == null || composition.get(1) == null) {
            result = true;
        }
        return result;
    }

    public Roles getUncomposableRoles() {
        return this.uncomposableRoles;
    }

    public String toString() {
        String result = this.toList().toString();
        return result;
    }

    public RoleDefinitions clean() {
        RoleDefinitions result = new RoleDefinitions();
        for (RoleDefinition def : this.toSortedList()) {
            boolean add = true;
            RoleDefinitions egoGenderInverts = result.get(def.primary(), def.inversion(), def.composition(), def.alterGender(), def.alterAge(), def.egoGender().invert());
            for (RoleDefinition egoGenderInvert : egoGenderInverts) {
                if (!def.role().equals(egoGenderInvert.role())) continue;
                egoGenderInvert.setEgoGender(Gender.UNKNOWN);
                add = false;
            }
            RoleDefinitions alterGenderInverts = result.get(def.primary(), def.inversion(), def.composition(), def.alterGender().invert(), def.alterAge(), def.egoGender());
            for (RoleDefinition alterGenderInvert : alterGenderInverts) {
                if (!def.role().equals(alterGenderInvert.role())) continue;
                alterGenderInvert.setAlterGender(Gender.UNKNOWN);
                add = false;
            }
            RoleDefinition.AlterAge invAlterAge = null;
            if (def.alterAge() != null) {
                invAlterAge = def.alterAge().invert();
            }
            RoleDefinitions alterAgeInverts = result.get(def.primary(), def.inversion(), def.composition(), def.alterGender(), invAlterAge, def.egoGender());
            for (RoleDefinition alterAgeInvert : alterAgeInverts) {
                if (!def.role().equals(alterAgeInvert.role())) continue;
                alterAgeInvert.setAlterAge(null);
                add = false;
            }
            if (!add) continue;
            result.addNew(def);
        }
        return result;
    }

    public boolean isSpouseRole(Role role) {
        boolean result = false;
        for (RoleDefinition definition : this.getDefinitions(role)) {
            if (definition.primary() != RoleDefinition.Primary.SPOUSE) continue;
            result = true;
            break;
        }
        return result;
    }
}

