/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net;

import fr.devinsy.util.StringList;
import org.tip.puck.net.Attribute;
import org.tip.puck.net.Attributes;
import org.tip.puck.net.Gender;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Individuals;
import org.tip.puck.net.UnionStatus;
import org.tip.puck.net.workers.IndividualValuator;
import org.tip.puck.util.Numberable;

public class Family
implements Numberable {
    private int id;
    private Individual husband;
    private Individual wife;
    private UnionStatus unionStatus;
    private Individuals children;
    private Attributes attributes;
    private Integer husbandOrder;
    private Integer wifeOrder;

    public Family(Individual husband, Individual wife) {
        this.unionStatus = UnionStatus.UNMARRIED;
        this.husband = husband;
        this.wife = wife;
        this.children = new Individuals();
        this.attributes = new Attributes();
    }

    public Family(int id) {
        this.id = id;
        this.unionStatus = UnionStatus.UNMARRIED;
        this.children = new Individuals();
        this.attributes = new Attributes();
    }

    public Family(int id, Individual husband, Individual wife) {
        this.id = id;
        this.unionStatus = UnionStatus.UNMARRIED;
        this.husband = husband;
        this.wife = wife;
        this.children = new Individuals();
        this.attributes = new Attributes();
    }

    public Family(int id, Individual husband, Individual wife, UnionStatus status) {
        this.id = id;
        this.unionStatus = status == null ? UnionStatus.UNMARRIED : status;
        this.husband = husband;
        this.wife = wife;
        this.children = new Individuals();
        this.attributes = new Attributes();
    }

    public Attributes attributes() {
        return this.attributes;
    }

    public Family clone() {
        Individual husbandClone = null;
        if (this.husband != null) {
            husbandClone = this.husband.clone();
        }
        Individual wifeClone = null;
        if (this.wife != null) {
            wifeClone = this.wife.clone();
        }
        Family result = new Family(this.id, husbandClone, wifeClone);
        return result;
    }

    public String getAttributeValue(String label) {
        Attribute attribute = (Attribute)this.attributes().get(label);
        String result = attribute == null ? null : attribute.getValue();
        return result;
    }

    public Individuals getChildren() {
        Individuals result = this.children;
        return result;
    }

    public Individuals getChildren(Gender gender) {
        Individuals result = new Individuals();
        for (Individual child : this.children) {
            if (child.getGender() != gender) continue;
            result.add(child);
        }
        return result;
    }

    public Individual getFather() {
        Individual result = this.husband;
        return result;
    }

    public Individual getHusband() {
        Individual result = this.husband;
        return result;
    }

    public Integer getHusbandOrder() {
        return this.husbandOrder;
    }

    public Family getHusbandsOriginFamily() {
        Family result = this.husband == null ? null : this.husband.getOriginFamily();
        return result;
    }

    @Override
    public int getId() {
        int result = this.id;
        return result;
    }

    public Integer getMaxEnd() {
        Integer result = IndividualValuator.extractYearAsInt(this.getAttributeValue("DIV_DATE"));
        if (result == null) {
            Integer husbandDeatYear = null;
            if (this.husband != null) {
                husbandDeatYear = IndividualValuator.extractYearAsInt(this.husband.getAttributeValue("DEAT_DATE"));
            }
            Integer wifeDeatYear = null;
            if (this.wife != null) {
                wifeDeatYear = IndividualValuator.extractYearAsInt(this.wife.getAttributeValue("DEAT_DATE"));
            }
            result = husbandDeatYear == null ? wifeDeatYear : (wifeDeatYear == null ? husbandDeatYear : Integer.valueOf(Math.min(husbandDeatYear, wifeDeatYear)));
        }
        return result;
    }

    public Individuals getMembers() {
        Individuals result = new Individuals();
        result.add(this.husband);
        result.add(this.wife);
        result.add(this.children);
        return result;
    }

    public Integer getMinStart() {
        Integer result = IndividualValuator.extractYearAsInt(this.getAttributeValue("MARR_DATE"));
        if (result == null) {
            for (Individual child : this.getChildren()) {
                Integer birtYear = IndividualValuator.extractYearAsInt(child.getAttributeValue("BIRT_DATE"));
                if (birtYear == null || result != null && birtYear >= result) continue;
                result = birtYear;
            }
        }
        return result;
    }

    public Individual getMissingHusband(int lastIndId) {
        Individual result = new Individual(lastIndId + 2 * this.id - 1, "Father of family " + this.id, Gender.MALE);
        return result;
    }

    public Individual getMissingWife(int lastIndId) {
        Individual result = new Individual(lastIndId + 2 * this.id, "Mother of family " + this.id, Gender.FEMALE);
        return result;
    }

    public Individual getMother() {
        Individual result = this.wife;
        return result;
    }

    public Individual getOtherParent(Individual parent) {
        Individual result = parent == this.husband ? this.wife : (parent == this.wife ? this.husband : null);
        return result;
    }

    public Individual getParent(Gender gender) {
        Individual result;
        switch (gender) {
            case MALE: {
                result = this.husband;
                break;
            }
            case FEMALE: {
                result = this.wife;
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }

    public Individuals getParents() {
        Individuals result = new Individuals();
        if (this.husband != null) {
            result.add(this.husband);
        }
        if (this.wife != null) {
            result.add(this.wife);
        }
        return result;
    }

    public String getRoleName(Individual ego, Individual alter) {
        String result = null;
        if (ego == alter) {
            result = "EGO";
        } else if (ego == this.husband) {
            if (alter == this.wife) {
                result = "SPOUSE";
            } else if (this.children.contains(alter)) {
                result = "PARENT";
            }
        } else if (ego == this.wife) {
            if (alter == this.husband) {
                result = "SPOUSE";
            } else if (this.children.contains(alter)) {
                result = "PARENT";
            }
        } else if (this.children.contains(ego)) {
            if (alter == this.husband || alter == this.wife) {
                result = "CHILD";
            } else if (this.children.contains(alter)) {
                result = "SIBLING";
            }
        }
        return result;
    }

    public Integer getUnionOrder(Individual parent) {
        Integer result = parent == this.husband ? this.husbandOrder : (parent == this.wife ? this.wifeOrder : null);
        return result;
    }

    public UnionStatus getUnionStatus() {
        return this.unionStatus;
    }

    public Individual getWife() {
        Individual result = this.wife;
        return result;
    }

    public Integer getWifeOrder() {
        return this.wifeOrder;
    }

    public Family getWifesOriginFamily() {
        Family result = this.wife == null ? null : this.wife.getOriginFamily();
        return result;
    }

    @Override
    public String hashKey() {
        String wifeStr = "?";
        String husbandStr = "?";
        if (this.wife != null) {
            wifeStr = "" + this.wife.getId();
        }
        if (this.husband != null) {
            husbandStr = "" + this.husband.getId();
        }
        return String.valueOf(wifeStr) + " [+] " + husbandStr;
    }

    public boolean hasMarried() {
        boolean result = this.unionStatus.hasMarried();
        return result;
    }

    public boolean isActiveAt(int year) {
        Integer minStart = this.getMinStart();
        Integer maxEnd = this.getMaxEnd();
        boolean result = minStart != null && minStart <= year && (maxEnd == null || year <= maxEnd);
        return result;
    }

    public boolean isDivorced() {
        boolean result = this.unionStatus.isDivorced();
        return result;
    }

    public boolean isEmpty() {
        boolean result = this.isOrphan() && this.isSterile() && this.attributes.isEmpty();
        return result;
    }

    public boolean isEmptyAndSingleParent() {
        boolean result = this.isSingleParent() && this.isSterile() && this.attributes.isEmpty();
        return result;
    }

    public boolean isFather(Individual parent) {
        boolean result = parent == null ? false : this.husband == parent;
        return result;
    }

    public boolean isFertile() {
        boolean result = this.children.size() != 0;
        return result;
    }

    public boolean isMother(Individual parent) {
        boolean result = parent == null ? false : this.wife == parent;
        return result;
    }

    public boolean isNotSingleParent() {
        boolean result = !this.isSingleParent();
        return result;
    }

    public boolean isOrphan() {
        boolean result = this.husband == null && this.wife == null;
        return result;
    }

    public boolean isParent(Individual parent) {
        boolean result = parent == null ? false : parent == this.husband || parent == this.wife;
        return result;
    }

    public boolean isSingleParent() {
        boolean result = this.husband == null && this.wife != null || this.husband != null && this.wife == null;
        return result;
    }

    public boolean isSterile() {
        boolean result = this.children.size() == 0;
        return result;
    }

    public int numberOfParents() {
        int result = this.husband != null && this.wife != null ? 2 : (this.husband == null && this.wife == null ? 0 : 1);
        return result;
    }

    public void setAttribute(String label, String value) {
        this.attributes().put(label, value);
    }

    public void setDivorced() {
        this.unionStatus = UnionStatus.DIVORCED;
    }

    public void setFather(Individual father) {
        this.husband = father;
    }

    public void setHusband(Individual husband) {
        this.husband = husband;
    }

    public void setHusbandOrder(Integer order) {
        this.husbandOrder = order == null || order < 1 ? null : order;
    }

    @Override
    public void setId(int id) {
        this.id = id;
    }

    public void setMarried() {
        this.unionStatus = UnionStatus.MARRIED;
    }

    public void setMarried(boolean married) {
        this.unionStatus = married ? UnionStatus.MARRIED : UnionStatus.UNMARRIED;
    }

    public void setMother(Individual mother) {
        this.wife = mother;
    }

    public void setSpouses(Individual husband, Individual wife) {
        this.husband = husband;
        this.wife = wife;
    }

    public void setUnionOrder(Individual parent, Integer order) {
        if (parent == this.husband) {
            this.setHusbandOrder(order);
        } else if (parent == this.wife) {
            this.setWifeOrder(order);
        }
    }

    public void setUnionStatus(UnionStatus value) {
        this.unionStatus = value == null ? UnionStatus.UNMARRIED : value;
    }

    public void setUnmarried() {
        this.unionStatus = UnionStatus.UNMARRIED;
    }

    public void setWife(Individual wife) {
        this.wife = wife;
    }

    public void setWifeOrder(Integer order) {
        this.wifeOrder = order == null || order < 1 ? null : order;
    }

    public String toNameString() {
        String husbandString = this.husband == null ? "" : this.husband.getName();
        String wifeString = this.wife == null ? "" : this.wife.getName();
        String separator = this.husband == null || this.wife == null ? "" : " & ";
        String result = String.valueOf(husbandString) + separator + wifeString;
        return result;
    }

    public String toString() {
        String husbandString = this.husband == null ? "" : this.husband.toString();
        String wifeString = this.wife == null ? "" : this.wife.toString();
        String separator = this.husband == null || this.wife == null ? "" : " & ";
        StringList buffer = new StringList(5);
        buffer.append(this.id);
        buffer.append(" ");
        buffer.append(husbandString);
        buffer.append(separator);
        buffer.append(wifeString);
        String result = buffer.toString();
        return result;
    }
}

