/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.io.ged;

import fr.devinsy.util.FileTools;
import fr.devinsy.util.StringList;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckException;

public class IdShrinker {
    private static final Logger logger = LoggerFactory.getLogger(IdShrinker.class);
    public static final String DEFAULT_CHARSET_NAME = "UTF-8";
    public static final Pattern ID_PATTERN = Pattern.compile("^(.*@)((\\D*)(\\d+)(\\D*))(@.*)$");

    public static boolean containsLongId(File source) throws IOException {
        boolean result;
        if (source == null || !source.getCanonicalPath().toLowerCase().endsWith(".ged")) {
            result = false;
        } else {
            StringList lines = FileTools.loadToStringList((File)source);
            boolean ended = false;
            Iterator iterator = lines.iterator();
            result = false;
            while (!ended) {
                if (iterator.hasNext()) {
                    String line = (String)iterator.next();
                    if (!line.matches("^.*@[IFif][a-zA-Z]*\\d{9,}@.*$")) continue;
                    ended = true;
                    result = true;
                    continue;
                }
                ended = true;
                result = false;
            }
        }
        return result;
    }

    public static File shrink(File file) throws PuckException, IOException {
        StringList sourceLines = FileTools.loadToStringList((File)file);
        StringList targetLines = new StringList(sourceLines.size());
        HashMap<String, String> map = new HashMap<String, String>();
        int lastId = 0;
        int lastIndividualId = 0;
        int lastFamilyId = 0;
        for (String sourceLine : sourceLines) {
            Matcher matcher = ID_PATTERN.matcher(sourceLine);
            if (matcher.find()) {
                String sourceId = matcher.group(2);
                String prefix = matcher.group(3);
                String value = matcher.group(4);
                String suffix = matcher.group(5);
                String targetId = (String)map.get(sourceId);
                if (targetId == null) {
                    targetId = prefix.length() == 0 || prefix.toUpperCase().startsWith("F") || prefix.toUpperCase().startsWith("I") ? (prefix.toUpperCase().startsWith("F") ? String.valueOf(prefix) + ++lastFamilyId + suffix : (prefix.toUpperCase().startsWith("I") ? String.valueOf(prefix) + ++lastIndividualId + suffix : String.valueOf(prefix) + ++lastId + suffix)) : sourceId;
                    map.put(sourceId, targetId);
                }
                String targetLine = String.valueOf(matcher.group(1)) + targetId + matcher.group(6);
                targetLines.append(targetLine);
                continue;
            }
            targetLines.append(sourceLine);
        }
        File result = FileTools.addToName((File)file, (String)("-shrinked_ids-" + new Date().getTime()));
        FileTools.save((File)result, (StringList)targetLines);
        return result;
    }
}

