/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.geo2.io;

import com.vividsolutions.jts.geom.Coordinate;
import fr.devinsy.util.StringList;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckException;
import org.tip.puck.PuckExceptions;
import org.tip.puck.geo.Geography;
import org.tip.puck.geo.Place;
import org.tip.puck.geo2.Coordinate2;
import org.tip.puck.geo2.GeoLevel2;
import org.tip.puck.geo2.Geography2;
import org.tip.puck.geo2.Place2;
import org.tip.puck.geo2.Places2;
import org.tip.puck.geo2.io.GEOTXTLabelsLine;
import org.tip.puck.io.iur.IURTXTFamilyLine;
import org.tip.puck.io.iur.IURTXTIndividualLine;
import org.tip.puck.net.Attribute;
import org.tip.puck.net.Attributes;
import org.tip.puck.util.LogHelper;

public class GEOTXTFile {
    private static final Logger logger = LoggerFactory.getLogger(GEOTXTFile.class);
    public static final String DEFAULT_CHARSET_NAME = "UTF-8";
    public static final int MAX_LINE_SIZE = 2048;

    public static Geography2 load(File file) throws PuckException {
        Geography2 result = GEOTXTFile.load(file, DEFAULT_CHARSET_NAME);
        return result;
    }

    public static Geography2 load(File file, String charsetName) throws PuckException {
        Geography2 result;
        BufferedReader in = null;
        try {
            try {
                in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charsetName));
                result = GEOTXTFile.readGeography(in);
                result.setLabel(file.getName());
            }
            catch (UnsupportedEncodingException exception) {
                throw PuckExceptions.UNSUPPORTED_ENCODING.create("Opening file [" + file + "]", new Object[0]);
            }
            catch (FileNotFoundException exception) {
                throw PuckExceptions.FILE_NOT_FOUND.create("Opening file [" + file + "]", new Object[0]);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)in);
        return result;
    }

    public static Geography2 readGeography(BufferedReader in) throws PuckException {
        Geography2 result;
        try {
            in.mark(2048);
            GEOTXTLabelsLine labelsLine = GEOTXTFile.readLabelsLine(in);
            if (labelsLine == null || labelsLine.size() != 1 || !((String)labelsLine.get(0)).equalsIgnoreCase("GEOGRAPHY")) {
                in.reset();
                result = null;
            } else {
                logger.debug("Geography loading...");
                result = new Geography2();
                GEOTXTFile.readHeaderAttributes(result.attributes(), in);
                GEOTXTFile.readPlaces(result, in);
            }
        }
        catch (IOException exception) {
            throw PuckExceptions.IO_ERROR.create(exception, "Reading labels line.", new Object[0]);
        }
        return result;
    }

    public static void readHeaderAttributes(Attributes target, BufferedReader in) throws PuckException {
        logger.debug("Read header attributes.");
        try {
            boolean ended = false;
            while (!ended) {
                in.mark(2048);
                String line = GEOTXTFile.readNotEmptyLine(in);
                if (line == null) {
                    ended = true;
                    continue;
                }
                String[] tokens = line.split("\\t");
                if (tokens.length > 2) {
                    ended = true;
                    in.reset();
                    continue;
                }
                if (!StringUtils.isNotBlank((CharSequence)tokens[0])) continue;
                target.put(tokens[0], tokens[1]);
            }
        }
        catch (IOException exception) {
            throw PuckExceptions.IO_ERROR.create(exception, "Reading labels line.", new Object[0]);
        }
    }

    public static GEOTXTLabelsLine readLabelsLine(BufferedReader in) throws PuckException {
        GEOTXTLabelsLine result;
        String line = GEOTXTFile.readNotEmptyLine(in);
        if (line == null) {
            result = null;
        } else {
            String[] tokens = line.split("\\t");
            result = new GEOTXTLabelsLine();
            String[] stringArray = tokens;
            int n = tokens.length;
            int n2 = 0;
            while (n2 < n) {
                String token = stringArray[n2];
                result.add(token);
                ++n2;
            }
        }
        return result;
    }

    public static String readNotEmptyLine(BufferedReader in) throws PuckException {
        String result;
        try {
            boolean ended = false;
            result = null;
            while (!ended) {
                String line = in.readLine();
                if (line == null) {
                    ended = true;
                    result = null;
                    continue;
                }
                if (!StringUtils.isNotBlank((CharSequence)line)) continue;
                ended = true;
                result = line;
            }
        }
        catch (IOException exception) {
            throw PuckExceptions.IO_ERROR.create(exception, "Reading line.", new Object[0]);
        }
        return result;
    }

    public static void readPlaces(Geography2 target, BufferedReader in) throws PuckException {
        GEOTXTLabelsLine labelsLine = GEOTXTFile.readLabelsLine(in);
        if (labelsLine != null) {
            boolean ended = false;
            while (!ended) {
                GEOTXTLabelsLine valuesLine = GEOTXTFile.readLabelsLine(in);
                if (valuesLine == null) {
                    ended = true;
                    continue;
                }
                Place2 place = new Place2(null);
                int valueCount = 0;
                while (valueCount < valuesLine.size()) {
                    String label = (String)labelsLine.get(valueCount);
                    String value = (String)valuesLine.get(valueCount);
                    if (StringUtils.equalsIgnoreCase((CharSequence)label, (CharSequence)"TOPONYM") || StringUtils.equalsIgnoreCase((CharSequence)label, (CharSequence)"NAME")) {
                        place.setToponym(value);
                    } else if (StringUtils.equalsIgnoreCase((CharSequence)label, (CharSequence)"HOMONYMS")) {
                        String[] stringArray = value.split("[,;]");
                        int n = stringArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String homonym = stringArray[n2];
                            if (StringUtils.isNotBlank((CharSequence)homonym)) {
                                place.getHomonyms().add(homonym);
                            }
                            ++n2;
                        }
                    } else if (StringUtils.equalsIgnoreCase((CharSequence)label, (CharSequence)"LATITUDE")) {
                        if (Coordinate2.isCoordinateValue(value)) {
                            try {
                                place.setLatitude(Double.parseDouble(value));
                            }
                            catch (Exception exception) {
                                System.out.println(exception.getMessage());
                                throw PuckExceptions.IO_ERROR.create(exception, "Latitude format error [" + value + "]", new Object[0]);
                            }
                        }
                    } else if (StringUtils.equalsIgnoreCase((CharSequence)label, (CharSequence)"LONGITUDE")) {
                        if (Coordinate2.isCoordinateValue(value)) {
                            try {
                                place.setLongitude(Double.parseDouble(value));
                            }
                            catch (Exception exception) {
                                throw PuckExceptions.IO_ERROR.create(exception, "Latitude format error [" + value + "]", new Object[0]);
                            }
                        }
                    } else if (StringUtils.equalsIgnoreCase((CharSequence)label, (CharSequence)"ELEVATION")) {
                        if (Coordinate2.isCoordinateValue(value)) {
                            try {
                                place.setElevation(Double.parseDouble(value));
                            }
                            catch (Exception exception) {
                                throw PuckExceptions.IO_ERROR.create(exception, "elevation format error [" + value + "]", new Object[0]);
                            }
                        }
                    } else if (StringUtils.equalsIgnoreCase((CharSequence)label, (CharSequence)"LEVEL")) {
                        if (StringUtils.isNotBlank((CharSequence)value)) {
                            try {
                                place.setGeoLevel(GeoLevel2.valueOf(value.toUpperCase()));
                            }
                            catch (NumberFormatException exception) {
                                throw PuckExceptions.IO_ERROR.create(exception, "Level format error [{}].", value);
                            }
                        }
                    } else if (StringUtils.equalsIgnoreCase((CharSequence)label, (CharSequence)"ABOVE")) {
                        if (StringUtils.isNotBlank((CharSequence)value)) {
                            place.setAbovePlace(value);
                        }
                    } else if (StringUtils.equalsIgnoreCase((CharSequence)label, (CharSequence)"EXTERNALID")) {
                        if (StringUtils.isNotBlank((CharSequence)value)) {
                            place.setExternalId(value);
                        }
                    } else if (StringUtils.equalsIgnoreCase((CharSequence)label, (CharSequence)"COMMENT")) {
                        if (StringUtils.isNotBlank((CharSequence)value)) {
                            place.setComment(value);
                        }
                    } else {
                        logger.debug("UNKNOWN LABEL [{}]", (Object)label);
                    }
                    ++valueCount;
                }
                if (!StringUtils.isNotBlank((CharSequence)place.getToponym())) continue;
                target.addPlace(place);
            }
        }
    }

    public static void save(File file, Geography2 source) throws PuckException {
        PrintWriter out = null;
        try {
            try {
                out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), DEFAULT_CHARSET_NAME));
                GEOTXTFile.writeGeography(out, source);
            }
            catch (UnsupportedEncodingException exception) {
                throw PuckExceptions.UNSUPPORTED_ENCODING.create("Opening file [" + file + "]", new Object[0]);
            }
            catch (FileNotFoundException exception) {
                throw PuckExceptions.FILE_NOT_FOUND.create("Opening file [" + file + "]", new Object[0]);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(out);
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)out);
    }

    public static void save(File file, Geography source) throws PuckException {
        PrintWriter out = null;
        try {
            try {
                out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), DEFAULT_CHARSET_NAME));
                GEOTXTFile.writeGeography(out, source);
            }
            catch (UnsupportedEncodingException exception) {
                throw PuckExceptions.UNSUPPORTED_ENCODING.create("Opening file [" + file + "]", new Object[0]);
            }
            catch (FileNotFoundException exception) {
                throw PuckExceptions.FILE_NOT_FOUND.create("Opening file [" + file + "]", new Object[0]);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(out);
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)out);
    }

    public static String toString(GEOTXTLabelsLine source) {
        String result;
        if (source == null) {
            result = "[null]";
        } else {
            StringList buffer = new StringList();
            buffer.append("[");
            Iterator iterator = source.iterator();
            while (iterator.hasNext()) {
                String label = (String)iterator.next();
                buffer.append(label);
                buffer.append(",");
            }
            buffer.removeLast();
            buffer.append("]");
            result = buffer.toString();
        }
        return result;
    }

    public static String toString(IURTXTFamilyLine source) {
        String result = source == null ? "[null]" : String.format("[id=%d][status=%c][fatherId=%d][motherId=%d][childIds=%s][attributeValues=%s]", source.getId(), Character.valueOf(source.getStatus()), source.getFatherId(), source.getMotherId(), source.getChildIds(), LogHelper.toString(source.attributeValues()));
        return result;
    }

    public static String toString(IURTXTIndividualLine source) {
        String result = source == null ? "[null]" : String.format("[id=%d][name=%s][gender=%c][attributeValues=%s]", source.getId(), source.getName(), Character.valueOf(source.getGender()), LogHelper.toString(source.attributeValues()));
        return result;
    }

    public static void writeGeography(PrintWriter out, Geography2 source) throws PuckException {
        out.println("GEOGRAPHY");
        out.println(" ");
        GEOTXTFile.writeHeaderAttributes(out, source.attributes());
        GEOTXTFile.writePlaces(out, source.getPlaces());
    }

    public static void writeGeography(PrintWriter out, Geography source) throws PuckException {
        out.println("GEOGRAPHY");
        out.println(" ");
        if (source != null) {
            StringList labelLine = new StringList();
            labelLine.add((Object)"TOPONYM");
            labelLine.add((Object)"HOMONYMS");
            labelLine.add((Object)"LATITUDE");
            labelLine.add((Object)"LONGITUDE");
            labelLine.add((Object)"ELEVATION");
            labelLine.add((Object)"LEVEL");
            labelLine.add((Object)"ABOVE");
            labelLine.add((Object)"EXTERNALID");
            labelLine.add((Object)"COMMENT");
            out.println(labelLine.toStringSeparatedBy("\t"));
            StringList valueLines = new StringList();
            Map<String, StringList> homonymLists = source.homonymLists();
            for (Place place : source.getPlaces()) {
                String sup = "";
                if (place.getSup() != null) {
                    sup = place.getSup().getToponym();
                }
                String homonyms = "";
                StringList homonymList = homonymLists.get(place.getId());
                if (homonymList != null) {
                    for (String homonym : homonymList) {
                        if (homonyms.length() != 0) {
                            homonyms = String.valueOf(homonyms) + ";";
                        }
                        homonyms = String.valueOf(homonyms) + homonym;
                    }
                }
                String latitude = "";
                String longitude = "";
                Coordinate coordinate = place.getCoordinate();
                if (coordinate != null) {
                    longitude = new Double(coordinate.x).toString();
                    latitude = new Double(coordinate.y).toString();
                }
                valueLines.append(String.valueOf(place.getToponym()) + "\t" + homonyms + "\t" + latitude + "\t" + longitude + "\t\t" + (Object)((Object)place.getLevel()) + "\t" + sup + "\t\t\t");
            }
            valueLines.sort();
            for (String valueLine : valueLines) {
                out.println(valueLine);
            }
        }
    }

    public static void writeHeaderAttributes(PrintWriter out, Attributes source) {
        if (source != null && !source.isEmpty()) {
            for (Attribute attribute : source) {
                out.print(attribute.getLabel());
                out.print("\t");
                out.println(attribute.getValue());
            }
            out.println(" ");
        }
    }

    public static void writePlaces(PrintWriter out, Places2 source) {
        if (source != null && !source.isEmpty()) {
            StringList labelLine = new StringList();
            labelLine.add((Object)"TOPONYM");
            labelLine.add((Object)"HOMONYMS");
            labelLine.add((Object)"LATITUDE");
            labelLine.add((Object)"LONGITUDE");
            labelLine.add((Object)"ELEVATION");
            labelLine.add((Object)"LEVEL");
            labelLine.add((Object)"ABOVE");
            labelLine.add((Object)"EXTERNALID");
            labelLine.add((Object)"COMMENT");
            out.println(labelLine.toStringSeparatedBy("\t"));
            for (Place2 place : source) {
                StringList valueLine = new StringList();
                valueLine.append(place.getToponym());
                valueLine.append(place.getHomonyms().toStringSeparatedBy(";"));
                if (place.getLatitude() == null) {
                    valueLine.append("");
                } else {
                    valueLine.append(Double.toString(place.getLatitude()));
                }
                if (place.getLongitude() == null) {
                    valueLine.append("");
                } else {
                    valueLine.append(Double.toString(place.getLongitude()));
                }
                if (place.getElevation() == null) {
                    valueLine.append("");
                } else {
                    valueLine.append(Double.toString(place.getElevation()));
                }
                if (place.getGeoLevel() == null) {
                    valueLine.append("");
                } else {
                    valueLine.append(place.getGeoLevel().toString());
                }
                valueLine.append(StringUtils.defaultString((String)place.getAbovePlace()));
                valueLine.append(StringUtils.defaultString((String)place.getExternalId()));
                valueLine.append(StringUtils.defaultString((String)place.getComment()));
                out.println(valueLine.toStringSeparatedBy("\t"));
            }
            out.println();
        }
    }
}

