/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.census.workers;

import fr.devinsy.util.StringList;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.tip.puck.PuckException;
import org.tip.puck.census.chains.Chain;
import org.tip.puck.census.chains.ChainFinder;
import org.tip.puck.census.chains.Notation;
import org.tip.puck.census.workers.CensusCriteria;
import org.tip.puck.census.workers.CensusDetail;
import org.tip.puck.census.workers.CensusUtils;
import org.tip.puck.census.workers.ChainValuator;
import org.tip.puck.census.workers.CircuitFinder;
import org.tip.puck.census.workers.RestrictionType;
import org.tip.puck.census.workers.SymmetryType;
import org.tip.puck.census.workers.TermCensus;
import org.tip.puck.graphs.Graph;
import org.tip.puck.graphs.onemode.ShuffleCriteria;
import org.tip.puck.graphs.onemode.Shuffler;
import org.tip.puck.io.paj.PAJFile;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Individuals;
import org.tip.puck.net.KinType;
import org.tip.puck.net.Net;
import org.tip.puck.net.workers.IndividualValuator;
import org.tip.puck.partitions.Cluster;
import org.tip.puck.partitions.MultiPartition;
import org.tip.puck.partitions.Partition;
import org.tip.puck.partitions.PartitionCriteria;
import org.tip.puck.partitions.PartitionMaker;
import org.tip.puck.partitions.graphs.ClusterNetworkReporter;
import org.tip.puck.partitions.graphs.ClusterNetworkUtils;
import org.tip.puck.report.Report;
import org.tip.puck.report.ReportChart;
import org.tip.puck.report.ReportRawData;
import org.tip.puck.report.ReportTable;
import org.tip.puck.segmentation.Segmentation;
import org.tip.puck.spacetime.workers.SpaceTimeCriteria;
import org.tip.puck.statistics.StatisticsReporter;
import org.tip.puck.util.Chronometer;
import org.tip.puck.util.MathUtils;
import org.tip.puck.util.PuckUtils;
import org.tip.puck.util.ToolBox;
import org.tip.puck.util.Value;

public class CensusReporter {
    public static ReportChart createFrequencyChart(MultiPartition<Chain> partitions) {
        ReportChart result = new ReportChart("Differential Census: Frequencies", ReportChart.GraphType.STACKED_BARS);
        result.setHeadersLegend("Individual clusters");
        result.setLinesLegend("Chains between membersByRelationId");
        int columnIndex = 0;
        for (Value columnValue : partitions.sortedColValues()) {
            result.setLineTitle(columnValue.toString(), columnIndex);
            int rowIndex = 0;
            for (Value rowValue : partitions.rowValuesSortedBySize()) {
                result.setHeader(rowValue.toString(), rowIndex);
                result.setValue(partitions.frequency(rowValue, columnValue), columnIndex, rowIndex);
                ++rowIndex;
            }
            ++columnIndex;
        }
        return result;
    }

    public static ReportChart createPercentageChart(MultiPartition<Chain> partitions) {
        ReportChart result = new ReportChart("Differential Census: Percentages", ReportChart.GraphType.LINES);
        result.setHeadersLegend("Individual clusters");
        result.setLinesLegend("% of chains between membersByRelationId");
        int columnIndex = 0;
        while (columnIndex < partitions.colCount()) {
            result.setLineTitle(partitions.getColValue(columnIndex).toString(), columnIndex);
            ++columnIndex;
        }
        int rowIndex = 0;
        while (rowIndex < partitions.colCount()) {
            for (Value columnValue : partitions.rowValuesSortedBySize()) {
                result.addValue(partitions.rowPercentage(columnValue, partitions.getColValue(rowIndex)), rowIndex);
            }
            ++rowIndex;
        }
        return result;
    }

    private static ReportTable getFrequencyTable(MultiPartition<Chain> partitions) {
        ReportTable result = new ReportTable(partitions.rowCount() + 3, partitions.colCount() + 2);
        result.set(0, 0, partitions.getLabel());
        int columnIndex = 1;
        for (Value value : partitions.sortedColValues()) {
            result.set(0, columnIndex, value.toString());
            ++columnIndex;
        }
        result.set(0, result.getColumnCount() - 1, "sum");
        int rowIndex = 1;
        for (Value rowValue : partitions.sortedRowValues()) {
            result.set(rowIndex, 0, rowValue.toString());
            columnIndex = 1;
            for (Value colValue : partitions.sortedColValues()) {
                result.set(rowIndex, columnIndex, partitions.frequency(rowValue, colValue));
                ++columnIndex;
            }
            result.set(rowIndex, result.getColumnCount() - 1, partitions.rowSum(rowValue));
            ++rowIndex;
        }
        result.set(result.getRowCount() - 2, 0, "sum");
        result.set(result.getRowCount() - 1, 0, "mean");
        columnIndex = 1;
        for (Value colValue : partitions.colValues()) {
            result.set(result.getRowCount() - 2, columnIndex, partitions.colSum(colValue));
            result.set(result.getRowCount() - 1, columnIndex, MathUtils.percent(partitions.colSum(colValue), 100 * partitions.rowCount()));
            ++columnIndex;
        }
        result.set(result.getRowCount() - 2, result.getColumnCount() - 1, partitions.sum());
        result.set(result.getRowCount() - 1, result.getColumnCount() - 1, MathUtils.percent(partitions.sum(), 100 * partitions.rowCount()));
        return result;
    }

    private static ReportTable getPercentageTable(MultiPartition<Chain> partitions) {
        ReportTable result = new ReportTable(partitions.rowValues().size() + 3, partitions.colValues().size() + 2);
        ArrayList<Double> percSums = new ArrayList<Double>();
        int nonZeroRowSum = 0;
        result.set(0, 0, partitions.getLabel());
        int columnIndex = 1;
        for (Value value : partitions.sortedColValues()) {
            result.set(0, columnIndex, value.toString());
            ++columnIndex;
            percSums.add(0.0);
        }
        result.set(0, result.getColumnCount() - 1, "relative size");
        int rowIndex = 1;
        for (Value rowValue : partitions.sortedRowValues()) {
            result.set(rowIndex, 0, rowValue.toString());
            columnIndex = 1;
            for (Value colValue : partitions.sortedColValues()) {
                result.set(rowIndex, columnIndex, partitions.rowPercentage(rowValue, colValue));
                percSums.set(columnIndex - 1, (Double)percSums.get(columnIndex - 1) + partitions.rowPercentage(rowValue, colValue));
                ++columnIndex;
            }
            result.set(rowIndex, result.getColumnCount() - 1, MathUtils.percent(partitions.rowSum(rowValue), partitions.sum()));
            if (partitions.rowSum(rowValue) > 0) {
                ++nonZeroRowSum;
            }
            ++rowIndex;
        }
        result.set(result.getRowCount() - 2, 0, "total share");
        result.set(result.getRowCount() - 1, 0, "mean share");
        columnIndex = 1;
        for (Value colValue : partitions.colValues()) {
            result.set(result.getRowCount() - 2, columnIndex, MathUtils.percent(partitions.colSum(colValue), partitions.sum()));
            result.set(result.getRowCount() - 1, columnIndex, MathUtils.round((Double)percSums.get(columnIndex - 1) / (double)nonZeroRowSum, 2));
            ++columnIndex;
        }
        return result;
    }

    public static Report reportDifferentialCensus(Segmentation segmentation, SpaceTimeCriteria spaceTimeCriteria, Integer date, CensusCriteria censusCriteria) throws PuckException {
        censusCriteria.setRestrictionType(RestrictionType.ALL);
        censusCriteria.setSymmetryType(SymmetryType.INVERTIBLE);
        censusCriteria.setClosingRelation("TOTAL");
        Chronometer chrono = new Chronometer();
        MultiPartition<Chain> partitions = null;
        partitions = spaceTimeCriteria == null ? CircuitFinder.createDifferentialCensus(segmentation, censusCriteria) : CircuitFinder.createDifferentialCensus(segmentation, spaceTimeCriteria.getRelationModelName(), spaceTimeCriteria.getLocalUnitLabel(), spaceTimeCriteria.getDateLabel(), date, censusCriteria);
        Report result = new Report();
        if (spaceTimeCriteria != null) {
            String reportName = spaceTimeCriteria.getRelationModelName();
            if (date != null) {
                reportName = String.valueOf(reportName) + " " + date;
            }
            result.setTitle(reportName);
        }
        result.setOrigin("Partition reporter");
        result.setTarget(String.valueOf(segmentation.getLabel()) + " " + censusCriteria.getIndividualPartitionLabel());
        partitions.count();
        ReportChart chart = CensusReporter.createFrequencyChart(partitions);
        result.outputs().append(chart);
        ReportChart chart2 = CensusReporter.createPercentageChart(partitions);
        result.outputs().appendln(chart2);
        ReportTable table = CensusReporter.getFrequencyTable(partitions);
        result.outputs().appendln(table);
        ReportTable table2 = CensusReporter.getPercentageTable(partitions);
        result.outputs().appendln(table2);
        Report report = new Report("Chain list by cluster");
        report.outputs().append(CircuitFinder.reportChainListByCluster(partitions));
        result.outputs().append(report);
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static boolean isBasicClassification(String chainClassification) {
        return StringUtils.equals((CharSequence)chainClassification, (CharSequence)"SIMPLE") || StringUtils.equals((CharSequence)chainClassification, (CharSequence)"CLASSIC") || StringUtils.equals((CharSequence)chainClassification, (CharSequence)"CLASSIC_GENDERED") || StringUtils.equals((CharSequence)chainClassification, (CharSequence)"POSITIONAL");
    }

    public static Report reportFindCircuit(CircuitFinder finder, Segmentation segmentation, CensusCriteria criteria, File sourceFile) throws PuckException {
        Graph<Comparable<Individual>> graph;
        Chronometer chrono = new Chronometer();
        finder.findCircuits();
        if (criteria.isOpenChainFrequencies()) {
            finder.getOpenChains();
        }
        Report result = new Report("Census");
        result.setOrigin("CircuitFinder3.findCircuits()");
        result.setTarget(segmentation.getLabel());
        result.inputs().add("Pattern", criteria.getPattern());
        result.inputs().add("Partition label", criteria.getClassificatoryLinking());
        result.inputs().add("Filter", criteria.getFilter());
        result.inputs().add("Closing Relation", criteria.getClosingRelation());
        result.inputs().add("Ego Role", criteria.getClosingRelationEgoRole());
        result.inputs().add("Alter Role", criteria.getClosingRelationAlterRole());
        result.inputs().add("Classification label", criteria.getChainClassification());
        result.inputs().add("Cross Sex", criteria.isCrossSexChainsOnly());
        result.inputs().add("Married Only", criteria.isCouplesOnly());
        result.inputs().add("Mark Individuals", criteria.isMarkIndividuals());
        result.inputs().add("Circuit Type", criteria.getCircuitType().toLabel());
        result.inputs().add("Filiation Type", criteria.getFiliationType().toString());
        result.inputs().add("Restriction Type", criteria.getRestrictionType().toString());
        result.inputs().add("Sibling Mode", criteria.getSiblingMode().toString());
        result.inputs().add("Symmetry Type", criteria.getSymmetryType().toString());
        result.inputs().add("Open Chain Frequencies", criteria.isOpenChainFrequencies());
        result.inputs().add("Circuit Induce Frame Network", criteria.isCircuitInducedFrameNetwork());
        result.inputs().add("Circuit Induce Network", criteria.isCircuitInducedNetwork());
        result.inputs().add("Circuit Interserction Network", criteria.isCircuitIntersectionNetwork());
        result.inputs().add("Circuit Networks", criteria.isCircuitNetworks());
        if (CensusReporter.isBasicClassification(criteria.getChainClassification())) {
            for (CensusDetail detail : criteria.getCensusDetails()) {
                if (!detail.isAvailable()) continue;
                String range = detail.isReport() && detail.isDiagram() ? " (report and diagram)" : (detail.isReport() ? " (report)" : " (diagram)");
                result.inputs().add("Census detail", String.valueOf(detail.getLabel()) + range);
            }
        }
        finder.count();
        result.outputs().append(finder.reportSurvey());
        Report report = new Report("Circuits");
        report.outputs().append(finder.reportCircuitTypeList());
        result.outputs().append(report);
        report = new Report("Couples");
        report.outputs().append(finder.reportCoupleList());
        result.outputs().append(report);
        report = new Report("Sortable list");
        report.outputs().append(finder.reportSortableList());
        result.outputs().append(report);
        StringList pajekBuffer = new StringList();
        StringList partitionLabels = criteria.getPartitionLabels();
        if (criteria.isCircuitInducedFrameNetwork()) {
            graph = CensusUtils.createCircuitInducedFrameNetwork(finder);
            pajekBuffer.addAll((Collection)PuckUtils.writePajekNetwork(graph, (List<String>)partitionLabels));
            pajekBuffer.appendln();
        }
        if (criteria.isCircuitInducedNetwork()) {
            graph = CensusUtils.createCircuitInducedNetwork(finder);
            pajekBuffer.addAll((Collection)PuckUtils.writePajekNetwork(graph, (List<String>)partitionLabels));
            pajekBuffer.appendln();
        }
        if (criteria.isCircuitIntersectionNetwork()) {
            finder.changeCircuitLabelsToClassic();
            graph = ClusterNetworkUtils.createCircuitIntersectionNetwork(finder);
            List<String> reportLabels = criteria.getCensusDetails().getReportLabels();
            reportLabels.add("DEGREE");
            reportLabels.add("SIZE");
            pajekBuffer.addAll((Collection)PuckUtils.writePajekNetwork(graph, reportLabels));
            pajekBuffer.appendln();
            report = ClusterNetworkReporter.reportCircuitIntersectionMatrix(graph);
            result.outputs().append(report);
            report = finder.decompose();
            result.outputs().append(report);
        }
        if (criteria.isCircuitNetworks()) {
            for (Chain circuit : finder.getCircuits().getItems()) {
                Graph<Individual> graph2 = CensusUtils.createCircuitNetwork(circuit);
                pajekBuffer.addAll((Collection)PuckUtils.writePajekNetwork(graph2));
                pajekBuffer.appendln();
            }
        }
        if (pajekBuffer.length() != 0) {
            File targetFile = ToolBox.setExtension(ToolBox.addToName(sourceFile, "-Circuit Networks"), ".paj");
            ReportRawData rawData = new ReportRawData("Export Circuit Networks to Pajek", "Pajek", "paj", targetFile);
            rawData.setData(PAJFile.convertToMicrosoftEndOfLine(pajekBuffer.toString()));
            result.outputs().appendln();
            result.outputs().append(rawData);
        }
        report = new Report("Diagrams");
        if (CensusReporter.isBasicClassification(criteria.getChainClassification())) {
            ArrayList<ReportChart> charts = new ArrayList<ReportChart>(20);
            ArrayList<ReportTable> tables = new ArrayList<ReportTable>(20);
            for (String label : criteria.getCensusDetails().getDiagramLabels()) {
                Partition<Chain> partition = PartitionMaker.create(label, finder.getCircuits(), PartitionCriteria.createRaw(label));
                ReportChart chart = finder.crossSex || finder.getSymmetry() != SymmetryType.INVARIABLE ? StatisticsReporter.createPartitionChart(partition) : StatisticsReporter.createPartitionChart(partition, new PartitionCriteria(partition.getLabel()), new PartitionCriteria("EGOGENDER"));
                if (chart == null) continue;
                charts.add(chart);
                tables.add(ReportTable.transpose(chart.createReportTableWithSum()));
            }
            int chartIndex = 0;
            while (chartIndex < charts.size()) {
                report.outputs().append((ReportChart)charts.get(chartIndex));
                if (chartIndex % 4 == 3) {
                    report.outputs().appendln();
                }
                ++chartIndex;
            }
            for (ReportTable table : tables) {
                report.outputs().appendln(table.getTitle());
                report.outputs().appendln(table);
            }
        }
        result.outputs().append(report);
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static Report reportFindCircuit(Segmentation segmentation, CensusCriteria criteria, File sourceFile) throws PuckException {
        CircuitFinder finder = new CircuitFinder(segmentation, criteria);
        Report result = CensusReporter.reportFindCircuit(finder, segmentation, criteria, sourceFile);
        return result;
    }

    public static Report reportFindCircuitsReshuffled(Net net, ShuffleCriteria shuffleCriteria, int runs, CensusCriteria criteria) throws PuckException {
        Chronometer chrono = new Chronometer();
        CircuitFinder finder = Shuffler.findCircuits(net, shuffleCriteria, runs, criteria);
        Report result = new Report("Census.");
        result.outputs().append(finder.reportSurvey());
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static List<Report> reportMultipleCensus(Segmentation segmentation, List<CensusCriteria> criteriaList) throws PuckException {
        ArrayList<Report> result = new ArrayList<Report>();
        for (CensusCriteria criteria : criteriaList) {
            Report report = CensusReporter.reportFindCircuit(segmentation, criteria, new File(""));
            report.setTitle(String.valueOf(report.title()) + " " + criteria.getClosingRelationEgoRole() + "-" + criteria.getClosingRelationAlterRole());
            result.add(report);
        }
        return result;
    }

    public static Report reportKinshipChains(String netLabel, Individual ego, Individual alter, int maxDepth, int maxOrder, String chainClassification) {
        Chronometer chrono = new Chronometer();
        Report result = new Report();
        result.setTitle("Chains linking " + ego.getName() + " and " + alter.getName());
        result.setOrigin("ChainFinder");
        result.setTarget(netLabel);
        result.inputs().add("Ego Id", ego.getId());
        result.inputs().add("Alter Id", alter.getId());
        result.inputs().add("Maximal Depth", maxDepth);
        result.inputs().add("Maximal Order", maxOrder);
        result.inputs().add("Chain Classification", chainClassification);
        Partition<Chain> chains = ChainFinder.findChains(ego, alter, maxDepth, maxOrder, chainClassification);
        for (Cluster<Chain> cluster : chains.getClusters().toListSortedByValue()) {
            result.outputs().append(cluster.getValue() + "\n");
            for (Chain chain : cluster.getItems()) {
                result.outputs().append(String.valueOf(chain.signature(Notation.CLASSIC_GENDERED)) + "\t" + chain.signature(Notation.POSITIONAL) + "\t" + chain.signature(Notation.NUMBERS) + "\n");
            }
        }
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static Report reportKinshipChainsForTerms(Segmentation segmentation) {
        Chronometer chrono = new Chronometer();
        Report result = new Report();
        result.setTitle("Kin term statistics");
        result.setOrigin("TermCensus");
        result.setTarget(segmentation.getLabel());
        Report report1 = new Report("Analysis");
        Report report2 = new Report("List of terms");
        TermCensus census = new TermCensus(segmentation);
        census.analyze();
        Partition<Chain> chains = census.getChains();
        Partition<String> consanguinealTerms = census.getConsanguinealTerms();
        Partition<String> affinalTerms = census.getAffinalTerms();
        report2.outputs().appendln("Classic\tPositional\tId\tAlterGender\tOrder\tGeneration\tDegree\tLine");
        for (Cluster<Chain> cluster : chains.getClusters().toListSortedByValue()) {
            String term = cluster.getValue().toString();
            report2.outputs().appendln(term);
            for (Chain chain : cluster.getItems()) {
                report2.outputs().appendln(String.valueOf(chain.signature(Notation.CLASSIC_GENDERED_AGED)) + "\t" + chain.signature(Notation.POSITIONAL) + "\t" + chain.getLast().getId() + "\t" + (Object)((Object)chain.getLast().getGender()) + "\t" + chain.dim() + "\t" + ChainValuator.get(chain, "SKEWSUM") + "\t" + ChainValuator.get(chain, "DEGREE_ROM") + "\t" + ChainValuator.get(chain, "LINE"));
            }
        }
        report2.outputs().appendln();
        report1.outputs().appendln(String.valueOf(consanguinealTerms.getItems().size()) + " Consanguineal terms");
        report1.outputs().appendln("Gen\tNrTerms\tTerms");
        for (Cluster<Object> cluster : consanguinealTerms.getClusters().toListSortedByDescendingValue()) {
            report1.outputs().appendln(cluster.getValue() + "\t" + cluster.size() + "\t" + cluster.getItemsAsString());
        }
        report1.outputs().appendln();
        report1.outputs().appendln(String.valueOf(affinalTerms.getItems().size()) + " Affinal terms");
        report1.outputs().appendln("Gen\tNrTerms\tTerms");
        for (Cluster<Object> cluster : affinalTerms.getClusters().toListSortedByDescendingValue()) {
            report1.outputs().appendln(cluster.getValue() + "\t" + cluster.size() + "\t" + cluster.getItemsAsString());
        }
        report1.outputs().appendln();
        report1.outputs().appendln("Cousin Terminology: " + census.getCousinTerminology());
        report1.outputs().appendln();
        report1.outputs().appendln("Term properties");
        report1.outputs().appendln("Term\tGendered\tGenerational\tBifucate\tMerging");
        for (String string : census.getTerms()) {
            report1.outputs().append(String.valueOf(string) + "\t\t");
            boolean[] blArray = census.getTermProperties().get(string);
            int n = blArray.length;
            int n2 = 0;
            while (n2 < n) {
                boolean property = blArray[n2];
                report1.outputs().append(String.valueOf(property) + "\t");
                ++n2;
            }
            report1.outputs().appendln();
        }
        report1.outputs().appendln();
        result.outputs().append(report1);
        result.outputs().append(report2);
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static Report reportMissingRelativesList(Segmentation segmentation, String partitionLabel) throws PuckException {
        Chronometer chrono = new Chronometer();
        Report result = new Report();
        result.setTitle("List of relatives.");
        result.setOrigin("Statistics reporter");
        result.setTarget(segmentation.getLabel());
        result.inputs().add("Partition", partitionLabel);
        Partition<Individual> partition = PartitionMaker.createRaw(partitionLabel, segmentation.getCurrentIndividuals());
        for (Cluster<Individual> cluster : partition.getClusters().toListSortedByValue()) {
            if (cluster == null || cluster.getValue() == null) continue;
            result.outputs().append(String.valueOf(cluster.getValue().toString()) + "\t(" + cluster.count() + ")");
            result.outputs().appendln();
            for (Individual individual : new Individuals(cluster.getItems()).toSortedList()) {
                StringList missingItems = new StringList();
                if (individual.getFather() == null) {
                    missingItems.appendln("\tFather missing");
                }
                if (individual.getFather() == null) {
                    missingItems.appendln("\tMother missing");
                }
                if (individual.getAttributeValue("SPCOMP") == null) {
                    missingItems.appendln("\tIncomplete Spouses: " + CensusReporter.reportRelativesAsString(individual, KinType.SPOUSE));
                }
                if (individual.getAttributeValue("CHCOMP") == null) {
                    missingItems.appendln("\tIncomplete Children: " + CensusReporter.reportRelativesAsString(individual, KinType.CHILD));
                }
                if (individual.getAttributeValue("INFO") != null) {
                    missingItems.appendln("\tOpen Questions");
                }
                if (missingItems.size() <= 0) continue;
                result.outputs().appendln(String.valueOf(individual.toString()) + "\tAge " + IndividualValuator.lifeStatusAtYear(individual, 2013));
                if (individual.getAttributeValue("NOTE") != null) {
                    result.outputs().appendln("\t" + individual.getAttributeValue("NOTE"));
                }
                result.outputs().appendln(missingItems);
            }
            result.outputs().appendln();
        }
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static Report reportPedigree(String netLabel, Individual ego, int maxDepth) {
        Chronometer chrono = new Chronometer();
        Report result = new Report();
        result.setTitle("Pedigree of " + ego.getName());
        result.setOrigin("ChainFinder");
        result.setTarget(netLabel);
        result.inputs().add("Maximal depth", maxDepth);
        String reportString = ChainFinder.getPedigree(ego, maxDepth);
        result.outputs().append(reportString);
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static Report reportProgeniture(String netLabel, Individual ego, int maxDepth) {
        Chronometer chrono = new Chronometer();
        Report result = new Report();
        result.setTitle("Progeniture of " + ego.getName());
        result.setOrigin("ChainFinder");
        result.setTarget(netLabel);
        result.inputs().add("Maximal depth", maxDepth);
        String reportString = ChainFinder.getProgeniture(ego, maxDepth);
        result.outputs().append(reportString);
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static Report reportReciprocalTerms(Segmentation segmentation) {
        Chronometer chrono = new Chronometer();
        Report result = new Report();
        result.setTitle("Reciprocal terms ");
        result.setOrigin("ChainFinder");
        result.setTarget(segmentation.getLabel());
        TermCensus census = new TermCensus(segmentation);
        Partition<String> reciprocalTerms = census.findReciprocalTerms();
        for (Cluster<String> cluster : reciprocalTerms.getClusters()) {
            result.outputs().appendln(cluster.getValue() + "\t" + cluster.getItemsAsString());
        }
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static Report reportTermProducts(Segmentation segmentation) {
        Chronometer chrono = new Chronometer();
        Report result = new Report();
        result.setTitle("Reciprocal terms ");
        result.setOrigin("ChainFinder");
        result.setTarget(segmentation.getLabel());
        TermCensus census = new TermCensus(segmentation);
        census.analyze();
        Partition<String> termProducts = census.findTermProducts();
        result.outputs().appendln("firstTerm\tSecondTerm\tProduct");
        for (String term1 : census.getTerms()) {
            for (String term2 : census.getTerms()) {
                Cluster<String> cluster = termProducts.getCluster(new Value(new String[]{term1, term2}));
                String items = "";
                if (cluster != null && cluster.size() > 0) {
                    items = cluster.getItemsAsString();
                }
                result.outputs().appendln(String.valueOf(term1) + "\t" + term2 + "\t" + items);
            }
        }
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static Report reportRelatives(String netLabel, Individual ego, String kinshipType) {
        Chronometer chrono = new Chronometer();
        Report result = new Report();
        result.setTitle("Relatives of " + ego.getName());
        result.setOrigin("ChainFinder");
        result.setTarget(netLabel);
        result.setInputComment("No comment.");
        result.inputs().add("Kinship type: ", kinshipType);
        Partition<Chain> relatives = ChainFinder.getKin(ego, kinshipType);
        for (Cluster<Chain> chains : relatives.getClusters().toListSortedByValue()) {
            Value value = chains.getValue();
            String entry = String.valueOf(value.individualValue().getId()) + "\t" + value.individualValue().getName() + "\t";
            for (Chain chain : chains.getItems()) {
                entry = String.valueOf(entry) + chain.signature(Notation.POSITIONAL) + " ";
            }
            entry = String.valueOf(entry) + "\n";
            result.outputs().append(entry);
        }
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    private static String reportRelativesAsString(Individual individual, KinType type) {
        String result = "";
        List<Object> relatives = type == KinType.PARENT ? individual.getKin(type).toList() : individual.getKin(type).toListSortedByBirthYearOrOrder();
        for (Individual individual2 : relatives) {
            result = String.valueOf(result) + individual2.toString() + "; ";
        }
        return result;
    }

    public static Report reportRelativesList(Segmentation segmentation, String partitionLabel) throws PuckException {
        int thisYear = Calendar.getInstance().get(1);
        Chronometer chrono = new Chronometer();
        Report result = new Report();
        result.setTitle("List of relatives.");
        result.setOrigin("Statistics reporter");
        result.setTarget(segmentation.getLabel());
        result.inputs().add("Partition", partitionLabel);
        if (partitionLabel.isEmpty()) {
            for (Individual individual : segmentation.getCurrentIndividuals().toSortedList()) {
                result.outputs().appendln(String.valueOf(individual.toString()) + "\tAge :" + IndividualValuator.lifeStatusAtYear(individual, thisYear));
                int i = 1;
                while (i >= -1) {
                    KinType kinType = KinType.valueOf(i);
                    String relativesAsString = CensusReporter.reportRelativesAsString(individual, kinType);
                    String complete = "";
                    if (kinType == KinType.SPOUSE && individual.getAttributeValue("SPCOMP") != null) {
                        complete = " (Compl.)";
                    }
                    if (kinType == KinType.CHILD && individual.getAttributeValue("CHCOMP") != null) {
                        complete = " (Compl.)";
                    }
                    if (relativesAsString.length() > 0) {
                        result.outputs().appendln("\t" + kinType.signature() + complete + ": " + relativesAsString);
                    }
                    --i;
                }
                result.outputs().appendln();
            }
            result.outputs().appendln();
        } else {
            Partition<Individual> partition = PartitionMaker.createRaw(partitionLabel, segmentation.getCurrentIndividuals());
            for (Cluster<Individual> cluster : partition.getClusters().toListSortedByValue()) {
                if (cluster == null || cluster.getValue() == null) continue;
                result.outputs().append(String.valueOf(cluster.getValue().toString()) + "\t(" + cluster.count() + ")");
                result.outputs().appendln();
                for (Individual individual : new Individuals(cluster.getItems()).toSortedList()) {
                    result.outputs().appendln(String.valueOf(individual.toString()) + "\tAge :" + IndividualValuator.lifeStatusAtYear(individual, thisYear));
                    int i = 1;
                    while (i >= -1) {
                        KinType kinType = KinType.valueOf(i);
                        String relativesAsString = CensusReporter.reportRelativesAsString(individual, kinType);
                        String complete = "";
                        if (kinType == KinType.SPOUSE && individual.getAttributeValue("SPCOMP") != null) {
                            complete = " (Compl.)";
                        }
                        if (kinType == KinType.CHILD && individual.getAttributeValue("CHCOMP") != null) {
                            complete = " (Compl.)";
                        }
                        if (relativesAsString.length() > 0) {
                            result.outputs().appendln("\t" + kinType.signature() + complete + ": " + relativesAsString);
                        }
                        --i;
                    }
                    result.outputs().appendln();
                }
                result.outputs().appendln();
            }
        }
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }
}

