/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.visualization.style.implementations;

import org.gephi.data.attributes.api.AttributeModel;
import org.gephi.data.attributes.api.AttributeOrigin;
import org.gephi.data.attributes.api.AttributeTable;
import org.gephi.data.attributes.api.AttributeType;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.Node;
import org.gephi.layout.api.LayoutController;
import org.gephi.preview.api.PreviewController;
import org.gephi.preview.api.PreviewModel;
import org.gephi.project.api.Workspace;
import org.openide.util.Lookup;
import org.tip.gephiplugins.genealogicalrenderers.shape.plugins.DefaultShapes;
import org.tip.puck.graphs.Link;
import org.tip.puck.visualization.layouts.sugiyama.SugiyamaLayout;
import org.tip.puck.visualization.style.Style;
import org.tip.puck.visualization.style.attributes.AttributeMap;
import org.tip.puck.visualization.style.attributes.GraphStyle;

public class OreGraph
implements Style {
    public static final String NODE_SHAPE_PROP = "shape";
    public static final String NODE_DEFAULT_SHAPE = DefaultShapes.diamond.name();
    private final AttributeMap map = new AttributeMap(){

        @Override
        public void setAttributes(Node gephiNode, org.tip.puck.graphs.Node<?> graphNode) {
            String shape = graphNode.getTag();
            if (shape.equalsIgnoreCase("ellipse")) {
                shape = "circle";
            }
            gephiNode.getNodeData().getAttributes().setValue(OreGraph.NODE_SHAPE_PROP.toLowerCase(), (Object)shape);
        }

        @Override
        public void setAttributes(Edge gephiEdge, Link<?> graphEdge) {
        }

        @Override
        public void registerAttributes(AttributeModel attributeModel) {
            AttributeTable table = attributeModel.getNodeTable();
            table.addColumn(OreGraph.NODE_SHAPE_PROP.toLowerCase(), OreGraph.NODE_SHAPE_PROP, AttributeType.STRING, AttributeOrigin.DATA, (Object)NODE_DEFAULT_SHAPE);
        }
    };

    @Override
    public GraphStyle graphStyle() {
        return GraphStyle.mixed;
    }

    @Override
    public AttributeMap styleMapping() {
        return this.map;
    }

    @Override
    public void applyStyle(Workspace workspace) {
        this.layout(workspace);
        GraphModel graphModel = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getModel(workspace);
        PreviewModel previewModel = ((PreviewController)Lookup.getDefault().lookup(PreviewController.class)).getModel(workspace);
        previewModel.getProperties().putValue("node.label.show", (Object)Boolean.FALSE);
        previewModel.getProperties().putValue("edge.curved", (Object)Boolean.FALSE);
        previewModel.getProperties().putValue("NodeShapeRenderer.property.enabled", (Object)Boolean.TRUE);
        previewModel.getProperties().putValue("NodeShapeRenderer.property.minsize", (Object)Float.valueOf(30.0f));
        PreviewController previewController = (PreviewController)Lookup.getDefault().lookup(PreviewController.class);
        previewController.refreshPreview(workspace);
    }

    private void layout(Workspace workspace) {
        GraphModel graphModel = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getModel(workspace);
        LayoutController lookup = (LayoutController)Lookup.getDefault().lookup(LayoutController.class);
        SugiyamaLayout buildLayout = new SugiyamaLayout(null);
        buildLayout.setGraphModel(graphModel);
        buildLayout.resetPropertiesValues();
        buildLayout.initAlgo();
        buildLayout.goAlgo();
        buildLayout.endAlgo();
    }
}

