/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net.relations.workers;

import fr.devinsy.util.StringList;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.tip.puck.PuckException;
import org.tip.puck.PuckExceptions;
import org.tip.puck.census.workers.CensusCriteria;
import org.tip.puck.census.workers.CensusReporter;
import org.tip.puck.census.workers.CircuitType;
import org.tip.puck.census.workers.RestrictionType;
import org.tip.puck.census.workers.SymmetryType;
import org.tip.puck.graphs.Graph;
import org.tip.puck.io.paj.PAJFile;
import org.tip.puck.net.Individual;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.partitions.Cluster;
import org.tip.puck.partitions.Partition;
import org.tip.puck.report.Report;
import org.tip.puck.report.ReportRawData;
import org.tip.puck.segmentation.Segmentation;
import org.tip.puck.spacetime.House;
import org.tip.puck.spacetime.HouseStatistics;
import org.tip.puck.spacetime.Houses;
import org.tip.puck.spacetime.Ordinal;
import org.tip.puck.spacetime.workers.HouseMaker;
import org.tip.puck.spacetime.workers.SpaceTimeCriteria;
import org.tip.puck.util.Chronometer;
import org.tip.puck.util.PuckUtils;
import org.tip.puck.util.ToolBox;

public class RelationReporter {
    public static Report reportItineraries(Segmentation segmentation, SpaceTimeCriteria criteria) throws PuckException {
        if (segmentation == null || criteria.getRelationModelName() == null) {
            throw PuckExceptions.INVALID_PARAMETER.create("Null parameter detected.", new Object[0]);
        }
        Report result = new Report("Itineraries " + criteria.getRelationModelName());
        Chronometer chrono = new Chronometer();
        result.setOrigin("Relation reporter");
        List<String> indicators = Arrays.asList("PLACE", "REFERENT_CHAIN", "REFERENT_KIN", "REFERENT");
        Houses houses = HouseMaker.createHouses(segmentation, criteria);
        HouseStatistics houseStatistics = new HouseStatistics(houses, criteria, indicators);
        houseStatistics.getMemberValues();
        Report report = new Report("Itineraries");
        String headLine1 = "MEMBER\t";
        String dateLine1 = "\t";
        for (String indicator : indicators) {
            headLine1 = String.valueOf(headLine1) + indicator;
            Integer[] integerArray = criteria.getDates();
            int n = integerArray.length;
            int n2 = 0;
            while (n2 < n) {
                Integer year = integerArray[n2];
                headLine1 = String.valueOf(headLine1) + "\t";
                dateLine1 = String.valueOf(dateLine1) + year + "\t";
                ++n2;
            }
        }
        report.outputs().appendln(headLine1);
        report.outputs().appendln(dateLine1);
        for (Individual member : houses.getMembers().toSortedList()) {
            String memberLine = member + "\t";
            for (String indicator : indicators) {
                Integer[] integerArray = criteria.getDates();
                int n = integerArray.length;
                int n3 = 0;
                while (n3 < n) {
                    Integer year = integerArray[n3];
                    Ordinal time = new Ordinal(year);
                    Object value = houseStatistics.getByMember(member, time, indicator);
                    memberLine = String.valueOf(memberLine) + value + "\t";
                    ++n3;
                }
            }
            report.outputs().appendln(memberLine);
        }
        result.outputs().append(report);
        return result;
    }

    public static Report reportTreeStructure(Segmentation segmentation, SpaceTimeCriteria criteria, boolean reducedTrees) throws PuckException {
        Integer year;
        Integer[] integerArray;
        if (segmentation == null || criteria.getRelationModelName() == null) {
            throw PuckExceptions.INVALID_PARAMETER.create("Null parameter detected.", new Object[0]);
        }
        Report result = new Report("Cluster Structure " + criteria.getRelationModelName());
        Chronometer chrono = new Chronometer();
        result.setOrigin("Relation reporter");
        List<String> indicators1 = Arrays.asList("GRAPH", "SIZE", "MAXDEPTH", "MEANDEPTH", "MEANINDEGREE", "DIAMETER", "NRCOMPONENTS", "MAXCOMPONENT", "CONCENTRATION");
        List<String> indicators2 = Arrays.asList("TREES_BY_ID", "TREES_BY_GENDER", "TREES_BY_KIN");
        List<String> indicators3 = Arrays.asList("OWNER", "OWNER_SPOUSE", "MOTHER", "FATHER", "CHILD", "SPOUSE", "SIBLING", "RELATIVE_AGNATIC", "RELATIVE_UTERINE", "RELATIVE_COGNATIC", "AFFINE", "UNKNOWN", "NONE");
        CensusCriteria censusCriteria = new CensusCriteria();
        censusCriteria.setPattern(criteria.getPattern());
        censusCriteria.setChainClassification(criteria.getChainClassification());
        censusCriteria.setRelationAttributeLabel(criteria.getLocalUnitLabel());
        censusCriteria.setRestrictionType(RestrictionType.ALL);
        censusCriteria.setSymmetryType(SymmetryType.INVERTIBLE);
        censusCriteria.setClosingRelation("TOTAL");
        Houses houses = HouseMaker.createHouses(segmentation, criteria);
        HouseStatistics houseStatistics1 = new HouseStatistics(houses, criteria, indicators1);
        HouseStatistics houseStatistics2 = new HouseStatistics(houses, criteria, indicators2);
        HouseStatistics houseStatistics3 = new HouseStatistics(houses, criteria, indicators3);
        HouseStatistics houseStatistics4 = new HouseStatistics(houses, criteria, new ArrayList<String>());
        HouseStatistics houseStatistics5 = new HouseStatistics(houses, criteria, new ArrayList<String>());
        HouseStatistics houseStatistics6 = new HouseStatistics(houses, criteria, null);
        houseStatistics1.getStatistics();
        houseStatistics2.getStatistics();
        houseStatistics3.getReferentKinCensus();
        houseStatistics4.getAllKinCensus(segmentation, censusCriteria);
        houseStatistics5.getReferentChainCensus();
        List<String> indicators4 = houseStatistics4.indicators();
        List<String> indicators5 = houseStatistics5.indicators();
        StringList pajekBuffer = new StringList();
        Partition<String> inFlows = houseStatistics6.getFlows("IN");
        Partition<String> outFlows = houseStatistics6.getFlows("OUT");
        Partition<String> allFlows = new Partition<String>();
        allFlows.add(inFlows);
        allFlows.add(outFlows);
        Report report1 = new Report("Metrics");
        Report report2 = new Report("Morphology");
        Report report3 = new Report("Referent kin census");
        Report report4 = new Report("All kin census");
        Report report5 = new Report("Referent chain census");
        Report report6 = new Report("Flow census");
        for (Cluster cluster : allFlows.getClusters().toListSortedByValue()) {
            report6.outputs().appendln(cluster.getValue());
            for (String item : cluster.getItems()) {
                report6.outputs().appendln("\t" + item);
            }
        }
        String headLine1 = "HOUSE\t";
        String dateLine1 = "\t";
        for (String indicator : indicators1) {
            if (indicator.equals("GRAPH")) continue;
            headLine1 = String.valueOf(headLine1) + indicator;
            Integer[] integerArray2 = criteria.getDates();
            int n = integerArray2.length;
            int n2 = 0;
            while (n2 < n) {
                Integer year2 = integerArray2[n2];
                headLine1 = String.valueOf(headLine1) + "\t";
                dateLine1 = String.valueOf(dateLine1) + year2 + "\t";
                ++n2;
            }
            headLine1 = String.valueOf(headLine1) + "\t";
            dateLine1 = String.valueOf(dateLine1) + "TREND\t";
        }
        report1.outputs().appendln(headLine1);
        report1.outputs().appendln(dateLine1);
        String headLine2 = "HOUSE\t";
        String dateLine2 = "\t";
        for (String indicator : indicators2) {
            headLine2 = String.valueOf(headLine2) + indicator;
            Integer[] integerArray3 = criteria.getDates();
            int n = integerArray3.length;
            int n3 = 0;
            while (n3 < n) {
                Integer year3 = integerArray3[n3];
                headLine2 = String.valueOf(headLine2) + "\t";
                dateLine2 = String.valueOf(dateLine2) + year3 + "\t";
                ++n3;
            }
        }
        report2.outputs().appendln(headLine2);
        report2.outputs().appendln(dateLine2);
        String headLine3 = "HOUSE\t";
        String dateLine3 = "\t";
        for (String indicator : indicators3) {
            headLine3 = String.valueOf(headLine3) + indicator;
            Integer[] integerArray4 = criteria.getDates();
            int n = integerArray4.length;
            int n4 = 0;
            while (n4 < n) {
                Integer year4 = integerArray4[n4];
                headLine3 = String.valueOf(headLine3) + "\t";
                dateLine3 = String.valueOf(dateLine3) + year4 + "\t";
                ++n4;
            }
            headLine3 = String.valueOf(headLine3) + "\t";
            dateLine3 = String.valueOf(dateLine3) + "TREND\t";
        }
        report3.outputs().appendln(headLine3);
        report3.outputs().appendln(dateLine3);
        String headLine4 = "HOUSE\t";
        String dateLine4 = "\t";
        for (String indicator : indicators4) {
            headLine4 = String.valueOf(headLine4) + indicator;
            Integer[] integerArray5 = criteria.getDates();
            int n = integerArray5.length;
            int n5 = 0;
            while (n5 < n) {
                Integer year5 = integerArray5[n5];
                headLine4 = String.valueOf(headLine4) + "\t";
                dateLine4 = String.valueOf(dateLine4) + year5 + "\t";
                ++n5;
            }
            headLine4 = String.valueOf(headLine4) + "\t";
            dateLine4 = String.valueOf(dateLine4) + "TREND\t";
        }
        report4.outputs().appendln(headLine4);
        report4.outputs().appendln(dateLine4);
        String headLine5 = "HOUSE\t";
        String dateLine5 = "\t";
        for (String indicator : indicators5) {
            headLine5 = String.valueOf(headLine5) + indicator;
            Integer[] integerArray6 = criteria.getDates();
            int n = integerArray6.length;
            int n6 = 0;
            while (n6 < n) {
                Integer year6 = integerArray6[n6];
                headLine5 = String.valueOf(headLine5) + "\t";
                dateLine5 = String.valueOf(dateLine5) + year6 + "\t";
                ++n6;
            }
            headLine5 = String.valueOf(headLine5) + "\t";
            dateLine5 = String.valueOf(dateLine5) + "TREND\t";
        }
        report5.outputs().appendln(headLine5);
        report5.outputs().appendln(dateLine5);
        for (House house : houses.toSortedList()) {
            Object value;
            Ordinal time;
            Integer year7;
            int n;
            int n7;
            Integer[] integerArray7;
            String houseLine1 = house + "\t";
            String houseLine2 = house + "\t";
            String houseLine3 = house + "\t";
            Object houseLine4 = house + "\t";
            String houseLine5 = house + "\t";
            for (String indicator : indicators1) {
                integerArray7 = criteria.getDates();
                n7 = integerArray7.length;
                n = 0;
                while (n < n7) {
                    year7 = integerArray7[n];
                    time = new Ordinal(year7);
                    value = houseStatistics1.get(house, time, indicator);
                    if (indicator.equals("GRAPH")) {
                        if (value != null) {
                            ArrayList<String> partitionLabels = new ArrayList<String>();
                            pajekBuffer.addAll((Collection)PuckUtils.writePajekNetwork((Graph)value, partitionLabels));
                            pajekBuffer.appendln();
                        }
                    } else {
                        houseLine1 = value != null ? String.valueOf(houseLine1) + value + "\t" : String.valueOf(houseLine1) + "\t";
                    }
                    ++n;
                }
                if (indicator.equals("GRAPH")) continue;
                houseLine1 = String.valueOf(houseLine1) + houseStatistics1.getTrend(house, indicator) + "\t";
            }
            for (String indicator : indicators2) {
                integerArray7 = criteria.getDates();
                n7 = integerArray7.length;
                n = 0;
                while (n < n7) {
                    year7 = integerArray7[n];
                    time = new Ordinal(year7);
                    value = houseStatistics2.get(house, time, indicator);
                    houseLine2 = value != null ? String.valueOf(houseLine2) + value + "\t" : String.valueOf(houseLine2) + "\t";
                    ++n;
                }
            }
            for (String indicator : indicators3) {
                integerArray7 = criteria.getDates();
                n7 = integerArray7.length;
                n = 0;
                while (n < n7) {
                    year7 = integerArray7[n];
                    time = new Ordinal(year7);
                    value = houseStatistics3.get(house, time, indicator);
                    houseLine3 = value != null ? String.valueOf(houseLine3) + value + "\t" : String.valueOf(houseLine3) + "\t";
                    ++n;
                }
                houseLine3 = String.valueOf(houseLine3) + houseStatistics3.getTrend(house, indicator) + "\t";
            }
            for (String indicator : indicators4) {
                integerArray7 = criteria.getDates();
                n7 = integerArray7.length;
                n = 0;
                while (n < n7) {
                    year7 = integerArray7[n];
                    time = new Ordinal(year7);
                    value = houseStatistics4.get(house, time, indicator);
                    if (value == null) {
                        value = 0;
                        houseStatistics4.put(house, time, indicator, value);
                    }
                    houseLine4 = String.valueOf(houseLine4) + value + "\t";
                    ++n;
                }
                houseLine4 = String.valueOf(houseLine4) + houseStatistics4.getTrend(house, indicator) + "\t";
            }
            for (String indicator : indicators5) {
                integerArray7 = criteria.getDates();
                n7 = integerArray7.length;
                n = 0;
                while (n < n7) {
                    year7 = integerArray7[n];
                    time = new Ordinal(year7);
                    value = houseStatistics5.get(house, time, indicator);
                    if (value == null) {
                        value = 0.0;
                        houseStatistics5.put(house, time, indicator, value);
                    }
                    houseLine5 = String.valueOf(houseLine5) + value + "\t";
                    ++n;
                }
                houseLine5 = String.valueOf(houseLine5) + houseStatistics5.getTrend(house, indicator) + "\t";
            }
            report1.outputs().appendln(houseLine1);
            report2.outputs().appendln(houseLine2);
            report3.outputs().appendln(houseLine3);
            report4.outputs().appendln(houseLine4);
            report5.outputs().appendln(houseLine5);
        }
        String endLine1 = "TOTAL\t";
        String endLine3 = "TOTAL\t";
        String endLine4 = "TOTAL\t";
        String endLine5 = "TOTAL\t";
        for (String indicator : indicators1) {
            if (indicator.equals("GRAPH")) continue;
            integerArray = criteria.getDates();
            int n = integerArray.length;
            int n8 = 0;
            while (n8 < n) {
                year = integerArray[n8];
                Ordinal time = new Ordinal(year);
                Double value = houseStatistics1.getMean(time, indicator);
                endLine1 = value == null ? String.valueOf(endLine1) + "\t" : String.valueOf(endLine1) + value + "\t";
                ++n8;
            }
            endLine1 = String.valueOf(endLine1) + houseStatistics1.getMeanTrend(indicator) + "\t";
        }
        report1.outputs().appendln(endLine1);
        for (String indicator : indicators3) {
            integerArray = criteria.getDates();
            int n = integerArray.length;
            int n9 = 0;
            while (n9 < n) {
                year = integerArray[n9];
                Ordinal time = new Ordinal(year);
                Double value = houseStatistics3.getMean(time, indicator);
                endLine3 = value == null ? String.valueOf(endLine3) + "\t" : String.valueOf(endLine3) + value + "\t";
                ++n9;
            }
            endLine3 = String.valueOf(endLine3) + houseStatistics3.getMeanTrend(indicator) + "\t";
        }
        report3.outputs().appendln(endLine3);
        for (String indicator : indicators4) {
            integerArray = criteria.getDates();
            int n = integerArray.length;
            int n10 = 0;
            while (n10 < n) {
                year = integerArray[n10];
                Ordinal time = new Ordinal(year);
                Double value = houseStatistics4.getMean(time, indicator);
                endLine4 = value == null ? String.valueOf(endLine4) + "\t" : String.valueOf(endLine4) + value + "\t";
                ++n10;
            }
            endLine4 = String.valueOf(endLine4) + houseStatistics4.getMeanTrend(indicator) + "\t";
        }
        report4.outputs().appendln(endLine4);
        for (String indicator : indicators5) {
            integerArray = criteria.getDates();
            int n = integerArray.length;
            int n11 = 0;
            while (n11 < n) {
                year = integerArray[n11];
                Ordinal time = new Ordinal(year);
                Double value = houseStatistics5.getMean(time, indicator);
                endLine5 = value == null ? String.valueOf(endLine5) + "\t" : String.valueOf(endLine5) + value + "\t";
                ++n11;
            }
            endLine5 = String.valueOf(endLine5) + houseStatistics5.getMeanTrend(indicator) + "\t";
        }
        report5.outputs().appendln(endLine5);
        if (pajekBuffer.length() != 0) {
            File targetFile = ToolBox.setExtension(ToolBox.addToName(new File("Sponsor network "), criteria.getLocalUnitLabel()), ".paj");
            ReportRawData rawData = new ReportRawData("Export Sponsor Networks to Pajek", "Pajek", "paj", targetFile);
            rawData.setData(PAJFile.convertToMicrosoftEndOfLine(pajekBuffer.toString()));
            result.outputs().appendln();
            result.outputs().append(rawData);
        }
        result.outputs().append(report1);
        result.outputs().append(report2);
        result.outputs().append(report3);
        result.outputs().append(report4);
        result.outputs().append(report5);
        result.outputs().append(report6);
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static List<Report> reportRelationCensus(Segmentation segmentation, SpaceTimeCriteria criteria) throws PuckException {
        if (segmentation == null || criteria.getRelationModelName() == null || criteria.getEgoRoleName() == null) {
            throw PuckExceptions.INVALID_PARAMETER.create("Null parameter detected. " + segmentation + " " + criteria.getRelationModelName() + " " + criteria.getEgoRoleName(), new Object[0]);
        }
        ArrayList<Report> result = new ArrayList<Report>();
        CensusCriteria censusCriteria = new CensusCriteria();
        censusCriteria.setCircuitType(CircuitType.RING);
        censusCriteria.setClosingRelation(criteria.getRelationModelName());
        censusCriteria.setClosingRelationEgoRole(criteria.getEgoRoleName());
        censusCriteria.setPattern(criteria.getPattern());
        censusCriteria.setRelationAttributeLabel(criteria.getLocalUnitLabel());
        censusCriteria.setDateLabel(criteria.getDateLabel());
        Integer[] times = criteria.getDates();
        for (Relation relation : segmentation.getAllRelations().getByModelName(criteria.getRelationModelName())) {
            relation.updateReferents(criteria.getDefaultReferentRoleName());
        }
        for (String alterRoleName : criteria.getRoleNames()) {
            censusCriteria.setClosingRelationAlterRole(alterRoleName);
            if (times == null) {
                Report report = CensusReporter.reportFindCircuit(segmentation, censusCriteria, null);
                report.setTitle("Relations " + criteria.getEgoRoleName() + " " + alterRoleName);
                result.add(report);
                continue;
            }
            int i = 0;
            while (i < times.length) {
                censusCriteria.setRelationTime(times[i]);
                Report report = CensusReporter.reportFindCircuit(segmentation, censusCriteria, null);
                report.setTitle("Relations " + criteria.getEgoRoleName() + " " + alterRoleName + " " + times[i]);
                result.add(report);
                ++i;
            }
        }
        return result;
    }
}

