/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net.relations.workers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.tip.puck.graphs.Graph;
import org.tip.puck.net.Gender;
import org.tip.puck.net.relations.RelationModel;
import org.tip.puck.net.relations.Role;
import org.tip.puck.net.relations.RoleDefinition;
import org.tip.puck.net.relations.RoleDefinitions;
import org.tip.puck.net.relations.Roles;
import org.tip.puck.net.relations.workers.RelationModelMaker;
import org.tip.puck.util.PuckUtils;

public class RelationModelStatistics {
    Roles roles;
    RoleDefinitions roleDefinitions;
    Graph<Role> graph;

    public RelationModelStatistics(RelationModel model) {
        this.graph = RelationModelMaker.relationModelGraph(model);
        this.roles = model.roles();
        this.roleDefinitions = model.roleDefinitions();
    }

    public List<Role> sortedRoles() {
        Roles result = this.roles;
        Collections.sort(result);
        return result;
    }

    public int termCount() {
        int result = this.roles.size();
        return result;
    }

    public List<Integer> generations(Role role) {
        return this.generations(role, 0, 3, new Roles());
    }

    public Map<Role, List<Gender>> genderMap() {
        HashMap<Role, List<Gender>> result = new HashMap<Role, List<Gender>>();
        for (Role role : this.roles) {
            result.put(role, this.genders(role));
        }
        return result;
    }

    public List<Gender> genders(Role role) {
        List<Gender> result = this.genders(role, 0, 3);
        return result;
    }

    public List<Gender> genders(Role role, int iterations, int maxIterations) {
        ArrayList<Gender> result = new ArrayList<Gender>();
        RoleDefinitions definitions = this.roleDefinitions.getDefinitions(role);
        for (RoleDefinition definition : definitions) {
            if (!definition.alterGender().isUnknown()) {
                if (result.contains((Object)definition.alterGender())) continue;
                result.add(definition.alterGender());
                continue;
            }
            if (definition.composition() == null || iterations >= maxIterations) continue;
            if (this.roleDefinitions.isSpouseRole((Role)definition.composition().get(1))) {
                for (Gender gender : this.genders((Role)definition.composition().get(0), iterations + 1, maxIterations)) {
                    if (result.contains((Object)gender.invert())) continue;
                    result.add(gender.invert());
                }
                continue;
            }
            for (Gender gender : this.genders((Role)definition.composition().get(1), iterations + 1, maxIterations)) {
                if (result.contains((Object)gender)) continue;
                result.add(gender);
            }
        }
        return result;
    }

    public List<Integer> generations(Role role, int iterations, int maxIterations, Roles visitedRoles) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        if (iterations <= maxIterations && !visitedRoles.contains(role)) {
            RoleDefinitions definitions = this.roleDefinitions.getNonRecursiveDefinitions(role);
            for (RoleDefinition definition : definitions) {
                if (definition.primary() == RoleDefinition.Primary.PARENT) {
                    if (!result.contains(1)) {
                        result.add(1);
                    }
                } else if (!(definition.primary() != RoleDefinition.Primary.SIBLING && definition.primary() != RoleDefinition.Primary.SPOUSE || result.contains(0))) {
                    result.add(0);
                }
                if (definition.inversion() != null) {
                    for (int inverseGeneration : this.generations(definition.inversion())) {
                        if (result.contains(-inverseGeneration)) continue;
                        result.add(-inverseGeneration);
                    }
                }
                if (definition.composition() == null) continue;
                for (int firstGeneration : this.generations((Role)definition.composition().get(0), iterations + 1, maxIterations, visitedRoles)) {
                    for (int secondGeneration : this.generations((Role)definition.composition().get(1), iterations + 1, maxIterations, visitedRoles)) {
                        if (result.contains(firstGeneration + secondGeneration)) continue;
                        if (role.getName().equals("kamuru")) {
                            System.out.println(definition.composition().get(0) + " " + definition.composition().get(1) + " " + firstGeneration + " " + secondGeneration);
                        }
                        result.add(firstGeneration + secondGeneration);
                    }
                }
            }
        }
        Collections.sort(result);
        return result;
    }

    public List<Integer> generations(Role role, Roles preDefined) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        RoleDefinitions definitions = this.roleDefinitions.getNonRecursiveDefinitions(role);
        for (RoleDefinition definition : definitions) {
            if (definition.primary() == RoleDefinition.Primary.PARENT) {
                if (!result.contains(1)) {
                    result.add(1);
                }
            } else if (!(definition.primary() != RoleDefinition.Primary.SIBLING && definition.primary() != RoleDefinition.Primary.SPOUSE || result.contains(0))) {
                result.add(0);
            }
            if (definition.inversion() != null) {
                for (int inverseGeneration : this.generations(definition.inversion())) {
                    if (result.contains(-inverseGeneration)) continue;
                    result.add(-inverseGeneration);
                }
            }
            if (definition.composition() == null || definition.composition().contains(role)) continue;
            boolean recursive = false;
            for (Role preRole : preDefined) {
                if (!definition.composition().contains(preRole)) continue;
                recursive = true;
                break;
            }
            if (recursive) continue;
            preDefined.add(role);
            Iterator<Object> iterator = this.generations((Role)definition.composition().get(0), preDefined).iterator();
            while (iterator.hasNext()) {
                int firstGeneration = (Integer)iterator.next();
                for (int secondGeneration : this.generations((Role)definition.composition().get(1), preDefined)) {
                    if (result.contains(firstGeneration + secondGeneration)) continue;
                    result.add(firstGeneration + secondGeneration);
                }
            }
            preDefined.remove(role);
        }
        Collections.sort(result);
        return result;
    }

    public List<String> links(Role role, int maxIterations) {
        return this.links(role, 0, maxIterations);
    }

    public List<String> links(Role role, int iterations, int maxIterations) {
        ArrayList<String> result = new ArrayList<String>();
        if (iterations > maxIterations) {
            return result;
        }
        RoleDefinitions definitions = this.roleDefinitions.getDefinitions(role);
        for (RoleDefinition definition : definitions) {
            String ps;
            Gender egoGender = definition.egoGender();
            String gender = "";
            if (!definition.egoGender().isUnknown()) {
                gender = String.valueOf(egoGender.toSymbol());
            }
            if (definition.primary() != null && StringUtils.isNotBlank((CharSequence)(ps = definition.getPrimaryAsString())) && !result.contains(ps)) {
                result.add(ps);
            }
            if (definition.inversion() != null && StringUtils.isNotBlank((CharSequence)(ps = definition.getInversePrimaryAsString(this.roleDefinitions))) && !result.contains(ps)) {
                result.add(ps);
            }
            if (definition.composition() == null) continue;
            for (String firstLink : this.links((Role)definition.composition().get(0), iterations + 1, maxIterations)) {
                char firstGender = firstLink.charAt(0);
                if (Gender.isGenderSymbol(firstGender)) {
                    firstLink = firstLink.substring(1);
                    if (!egoGender.isUnknown() && firstGender != egoGender.toSymbol()) continue;
                }
                if (firstLink.charAt(0) == 'H' && egoGender.isMale() || firstLink.charAt(0) == 'W' && egoGender.isFemale()) continue;
                char lastLetter = firstLink.charAt(firstLink.length() - 1);
                for (String secondLink : this.links((Role)definition.composition().get(1), maxIterations, maxIterations)) {
                    char secondGender = secondLink.charAt(0);
                    if (Gender.isGenderSymbol(secondGender)) {
                        if (lastLetter == 'a' || lastLetter == 'b' || lastLetter == 'h' || lastLetter == 'p' || Gender.matchesChar(lastLetter, secondGender)) {
                            secondLink = secondLink.substring(1);
                        } else {
                            System.err.println("Gender mismatch " + firstLink + " " + secondLink + " " + definition);
                        }
                    } else if (Gender.sameSexChar(lastLetter, secondGender)) continue;
                    String link = String.valueOf(firstLink) + secondLink;
                    if (firstLink.charAt(0) != 'H' && firstLink.charAt(0) != 'W') {
                        link = String.valueOf(gender) + link;
                    }
                    link = link.replaceAll("eBeB", "eB").replaceAll("yBeB", "eB").replaceAll("eZeB", "eB").replaceAll("yZeB", "eB").replaceAll("eSbeB", "eB").replaceAll("ySbeB", "eB").replaceAll("eBeZ", "eZ").replaceAll("yBeZ", "eZ").replaceAll("eZeZ", "eZ").replaceAll("yZeZ", "eZ").replaceAll("eSbeZ", "eZ").replaceAll("ySbeZ", "eZ").replaceAll("eByB", "yB").replaceAll("yByB", "yB").replaceAll("eZyB", "yB").replaceAll("yZyB", "yB").replaceAll("eSbyB", "yB").replaceAll("ySbyB", "yB").replaceAll("eByZ", "yZ").replaceAll("yByZ", "yZ").replaceAll("eZyZ", "yZ").replaceAll("yZyZ", "yZ").replaceAll("eSbyZ", "yZ").replaceAll("ySbyZ", "yZ").replaceAll("eBeSb", "eSb").replaceAll("yBeSb", "eSb").replaceAll("eZeSb", "eSb").replaceAll("yZeSb", "eSb").replaceAll("eSbeSb", "eSb").replaceAll("ySbeSb", "eSb").replaceAll("eBySb", "ySb").replaceAll("yBySb", "ySb").replaceAll("eZySb", "ySb").replaceAll("yZySb", "ySb").replaceAll("eSbySb", "ySb").replaceAll("ySbySb", "ySb");
                    link = link.replaceAll("BB", "B").replaceAll("SbB", "B").replaceAll("ZB", "B").replaceAll("BZ", "Z").replaceAll("SbZ", "Z").replaceAll("ZZ", "Z").replaceAll("BSb", "Sb").replaceAll("SbSb", "Sb").replaceAll("ZSb", "Sb");
                    link = link.replaceAll("eBF", "F").replaceAll("eSbF", "F").replaceAll("eZF", "F").replaceAll("eBM", "M").replaceAll("eSbM", "M").replaceAll("eZM", "M").replaceAll("yBF", "F").replaceAll("ySbF", "F").replaceAll("yZF", "F").replaceAll("yBM", "M").replaceAll("ySbM", "M").replaceAll("yZM", "M");
                    link = link.replaceAll("BF", "F").replaceAll("SbF", "F").replaceAll("ZF", "F").replaceAll("BM", "M").replaceAll("SbM", "M").replaceAll("ZM", "M");
                    link = link.replaceAll("SeB", "S").replaceAll("DeB", "S").replaceAll("CheB", "S").replaceAll("SeZ", "D").replaceAll("DeZ", "D").replaceAll("CheZ", "D").replaceAll("SeSb", "Ch").replaceAll("DeSb", "Ch").replaceAll("CheSb", "Ch");
                    link = link.replaceAll("SyB", "S").replaceAll("DyB", "S").replaceAll("ChyB", "S").replaceAll("SyZ", "D").replaceAll("DyZ", "D").replaceAll("ChyZ", "D").replaceAll("SySb", "Ch").replaceAll("DySb", "Ch").replaceAll("ChySb", "Ch");
                    link = link.replaceAll("SB", "S").replaceAll("DB", "S").replaceAll("ChB", "S").replaceAll("SZ", "D").replaceAll("DZ", "D").replaceAll("ChZ", "D").replaceAll("SSb", "Ch").replaceAll("DSb", "Ch").replaceAll("ChSb", "Ch");
                    link = link.replaceAll("ZM", "M").replaceAll("BM", "M").replaceAll("ZF", "F").replaceAll("BF", "F");
                    link = link.replaceAll("DF", "H").replaceAll("SF", "H").replaceAll("DM", "W").replaceAll("SM", "W");
                    String[] sameSexUnions = new String[]{"MW", "DW", "ZW", "WW", "FH", "SH", "BH", "HH"};
                    boolean containsSameSexUnions = false;
                    String[] stringArray = sameSexUnions;
                    int n = sameSexUnions.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String sameSexUnion = stringArray[n2];
                        if (link.contains(sameSexUnion)) {
                            containsSameSexUnions = true;
                            break;
                        }
                        ++n2;
                    }
                    if (result.contains(link) || containsSameSexUnions) continue;
                    result.add(link);
                }
            }
        }
        for (String link : new ArrayList<String>(result)) {
            String reducedLink = link.replaceAll("MS", "B").replaceAll("FS", "B").replaceAll("MD", "Z").replaceAll("FD", "Z").replaceAll("FCh", "Sb").replaceAll("MCh", "Sb");
            if (result.contains(reducedLink) && !link.equals(reducedLink)) {
                result.remove(link);
            } else {
                for (String otherLink : new ArrayList<String>(result)) {
                    String reducedOtherLink = otherLink.replaceAll("MS", "B").replaceAll("FS", "B").replaceAll("MD", "Z").replaceAll("FD", "Z").replaceAll("FCh", "Sb").replaceAll("MCh", "Sb");
                    if (link.equals(otherLink) || !reducedLink.equals(reducedOtherLink)) continue;
                    result.remove(otherLink);
                    if (result.contains(reducedLink)) continue;
                    result.add(reducedLink);
                }
            }
            if (reducedLink.equals("Sb") && PuckUtils.containsStrings(result, "B;Z;eB;yB;eZ;yZ") && !link.equals(reducedLink)) {
                result.remove(link);
            }
            if (reducedLink.equals("B") && PuckUtils.containsStrings(result, "eB;yB") && !link.equals(reducedLink)) {
                result.remove(link);
            }
            if (reducedLink.equals("Z") && PuckUtils.containsStrings(result, "eZ;yZ") && !link.equals(reducedLink)) {
                result.remove(link);
            }
            if (!result.contains(reducedLink = reducedLink.replaceAll("yB", "B").replaceAll("eB", "B").replaceAll("yZ", "Z").replaceAll("eZ", "Z").replaceAll("ySb", "Sb").replaceAll("eSb", "Sb")) || link.equals(reducedLink)) continue;
            result.remove(link);
        }
        for (String link : new ArrayList<String>(result)) {
            if (!Gender.isGenderSymbol(link.charAt(0))) continue;
            if (result.contains(link.substring(1))) {
                result.remove(link);
                continue;
            }
            if (!result.contains(String.valueOf(Gender.inverseGenderSymbol(link.charAt(0))) + link.substring(1))) continue;
            result.remove(link);
            result.add(link.substring(1));
        }
        Collections.sort(result);
        return result;
    }

    private boolean isParent(Role role) {
        boolean result = false;
        for (RoleDefinition definition : this.roleDefinitions) {
            if (!definition.role().equals(role) || definition.primary() != RoleDefinition.Primary.PARENT) continue;
            result = true;
            break;
        }
        return result;
    }

    private boolean isChild(Role role) {
        boolean result = false;
        for (RoleDefinition definition : this.roleDefinitions) {
            if (!definition.role().equals(role) || !this.isParent(definition.inversion())) continue;
            result = true;
            break;
        }
        return result;
    }

    private boolean isSibling(Role role) {
        boolean result = false;
        for (RoleDefinition definition : this.roleDefinitions) {
            if (!definition.role().equals(role) || definition.primary() != RoleDefinition.Primary.SIBLING) continue;
            result = true;
            break;
        }
        return result;
    }

    public boolean hasSameGender(Role alpha, Role beta) {
        boolean result = false;
        for (Gender gender : this.genders(alpha)) {
            if (!this.genders(beta).contains((Object)gender)) continue;
            result = true;
            break;
        }
        return result;
    }

    private boolean isAscendingParallel(Role role) {
        boolean result = false;
        for (RoleDefinition definition : this.roleDefinitions) {
            if (!definition.role().equals(role) || definition.composition() == null) continue;
            Role first = (Role)definition.composition().get(0);
            Role second = (Role)definition.composition().get(1);
            if (!this.isParent(first) || !this.isSibling(second) || !this.hasSameGender(first, second)) break;
            result = true;
            break;
        }
        return result;
    }

    private boolean isAscendingCross(Role role) {
        boolean result = false;
        for (RoleDefinition definition : this.roleDefinitions) {
            if (!definition.role().equals(role) || definition.composition() == null) continue;
            Role first = (Role)definition.composition().get(0);
            Role second = (Role)definition.composition().get(1);
            if (!this.isParent(first) || !this.isSibling(second) || this.hasSameGender(first, second)) continue;
            result = true;
            break;
        }
        return result;
    }

    private boolean isCollateralParallel(Role role) {
        boolean result = false;
        for (RoleDefinition definition : this.roleDefinitions) {
            if (!definition.role().equals(role) || definition.composition() == null) continue;
            Role first = (Role)definition.composition().get(0);
            Role second = (Role)definition.composition().get(1);
            if (!this.isAscendingParallel(first) || !this.isChild(second)) continue;
            result = true;
            break;
        }
        return result;
    }

    private boolean isCollateralCross(Role role) {
        boolean result = false;
        for (RoleDefinition definition : this.roleDefinitions) {
            if (!definition.role().equals(role) || definition.composition() == null) continue;
            Role first = (Role)definition.composition().get(0);
            Role second = (Role)definition.composition().get(1);
            if (!this.isAscendingCross(first) || !this.isChild(second)) break;
            result = true;
            break;
        }
        return result;
    }

    public String cousinClassification() {
        String result = null;
        boolean lineal = false;
        boolean merging = false;
        for (Role role : this.roles) {
            if (this.isCollateralParallel(role) && this.isSibling(role)) {
                merging = true;
            }
            if (!this.isCollateralParallel(role) || !this.isCollateralCross(role)) continue;
            lineal = true;
        }
        result = lineal ? (merging ? "GENERATIONAL" : "LINEAL") : (merging ? "BIFURCATE-MERGING" : "BIFURCATE-COLLATERAL");
        return result;
    }

    public Roles undefinedRoles() {
        Roles result = new Roles();
        for (Role role : this.roles) {
            if (this.roleDefinitions.getDefinitions(role).size() != 0 || result.contains(role)) continue;
            result.add(role);
        }
        Collections.sort(result);
        return result;
    }

    public Roles uncomposableRoles() {
        Roles result = this.roleDefinitions.getUncomposableRoles();
        Collections.sort(result);
        return result;
    }

    public RoleDefinitions recursiveDefinitions() {
        return this.roleDefinitions.recursiveDefinitions();
    }

    public List<String> nullFactors() {
        ArrayList<String> result = new ArrayList<String>();
        for (Role role : this.roles) {
            for (RoleDefinition definition : this.roleDefinitions.getDefinitions(role)) {
                if (!RoleDefinitions.isNullOrHasNullFactor(definition.composition()) || result.contains(definition.composition()) || definition.composition() == null) continue;
                result.add(role + ":\t" + definition.composition().get(0) + "\t" + definition.composition().get(1));
            }
        }
        Collections.sort(result);
        return result;
    }
}

