/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net.relations.workers;

import java.util.List;
import org.tip.puck.net.relations.RelationModel;
import org.tip.puck.net.relations.Role;
import org.tip.puck.net.relations.RoleDefinition;
import org.tip.puck.net.relations.RoleDefinitions;
import org.tip.puck.net.relations.Roles;
import org.tip.puck.net.relations.workers.RelationModelStatistics;
import org.tip.puck.report.Report;

public class RelationModelReporter {
    RelationModelStatistics statistics;
    RelationModel model;

    public RelationModelReporter(RelationModel model) {
        this.model = model;
        this.statistics = new RelationModelStatistics(model);
    }

    public Report reportModel(int maxIterations) {
        Report result = new Report("Model " + this.model.getName());
        result.outputs().append(this.reportDefinitions());
        result.outputs().append(this.reportStatistics(maxIterations));
        result.outputs().append(this.reportReciprocals(maxIterations));
        result.outputs().append(this.reportCompositions(maxIterations));
        result.outputs().append(this.reportProblems());
        return result;
    }

    public Report reportDefinitions() {
        Report result = new Report("Definitions");
        result.outputs().appendln("Relation Model " + this.model.getName());
        result.outputs().appendln();
        for (RoleDefinition definition : this.model.roleDefinitions().toSortedList()) {
            result.outputs().appendln(definition);
        }
        return result;
    }

    public Report reportProblems() {
        List<String> nullFactors;
        RoleDefinitions recursiveDefinitions;
        Roles uncomposableRoles;
        Report result = new Report("Problems");
        result.outputs().appendln("Relation Model " + this.model.getName());
        result.outputs().appendln();
        boolean noProblems = true;
        Roles undefinedRoles = this.statistics.undefinedRoles();
        if (undefinedRoles.size() > 0) {
            noProblems = false;
            result.outputs().appendln("Undefined roles: ");
            for (Role role : undefinedRoles) {
                result.outputs().appendln(role);
            }
            result.outputs().appendln();
        }
        if ((uncomposableRoles = this.statistics.uncomposableRoles()).size() > 0) {
            noProblems = false;
            result.outputs().appendln("Uncomposable roles: ");
            for (Role role : uncomposableRoles) {
                result.outputs().appendln(role);
            }
            result.outputs().appendln();
        }
        if ((recursiveDefinitions = this.statistics.recursiveDefinitions()).size() > 0) {
            noProblems = false;
            result.outputs().appendln("Recursively defined roles: ");
            for (RoleDefinition definition : recursiveDefinitions.toSortedList()) {
                result.outputs().appendln(definition);
            }
            result.outputs().appendln();
        }
        if ((nullFactors = this.statistics.nullFactors()).size() > 0) {
            noProblems = false;
            result.outputs().appendln("Null factors: ");
            for (String nullfactor : nullFactors) {
                result.outputs().appendln(nullfactor);
            }
            result.outputs().appendln();
        }
        if (noProblems) {
            result.outputs().appendln("No problems found");
        }
        return result;
    }

    public Report reportStatistics(int maxIterations) {
        Report result = new Report("Statistics");
        result.outputs().appendln("Relation Model " + this.model.getName());
        result.outputs().appendln();
        result.outputs().appendln("Nr of Terms: " + this.statistics.termCount());
        result.outputs().appendln("Cousin Classification: " + this.statistics.cousinClassification());
        result.outputs().appendln();
        result.outputs().appendln();
        for (Role role : this.statistics.sortedRoles()) {
            result.outputs().appendln(String.valueOf(role.getName()) + "\t" + this.statistics.generations(role) + "\t" + this.statistics.genders(role) + "\t" + this.statistics.links(role, maxIterations));
        }
        return result;
    }

    public Report reportCompositions(int maxIterations) {
        Report result = new Report("Compositions");
        result.outputs().appendln("Compositions: Relation Model " + this.model.getName());
        result.outputs().appendln();
        for (Role alpha : this.statistics.roles) {
            for (Role beta : this.statistics.roles) {
                Roles alphaBeta = this.statistics.roleDefinitions.getCompositeRoles(alpha, beta, 0, maxIterations);
                if (alphaBeta.size() <= 0) continue;
                String composition = alpha + " \u00b0 " + beta + " = ";
                for (Role gamma : alphaBeta) {
                    composition = String.valueOf(composition) + gamma + ", ";
                }
                result.outputs().appendln(composition);
            }
        }
        return result;
    }

    public Report reportReciprocals(int maxIterations) {
        Report result = new Report("Reciprocals");
        result.outputs().appendln("Reciprocals: Relation Model " + this.model.getName());
        result.outputs().appendln();
        for (Role alpha : this.statistics.roles) {
            Roles inverseAlpha = this.statistics.roleDefinitions.getReciprocalRoles(alpha, 0, maxIterations);
            if (inverseAlpha.size() > 0) {
                String reciprocal = alpha + " = ";
                for (Role beta : inverseAlpha) {
                    reciprocal = reciprocal.equals(alpha + " = ") ? String.valueOf(reciprocal) + "-" + beta : String.valueOf(reciprocal) + ", -" + beta;
                }
                result.outputs().appendln(reciprocal);
                continue;
            }
            result.outputs().appendln(alpha + " [no reciprocal term]");
        }
        return result;
    }
}

