/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net.relations.workers;

import fr.devinsy.util.StringList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.tip.puck.graphs.Graph;
import org.tip.puck.graphs.Link;
import org.tip.puck.net.Gender;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Net;
import org.tip.puck.net.relations.RelationModel;
import org.tip.puck.net.relations.Role;
import org.tip.puck.net.relations.RoleDefinition;
import org.tip.puck.net.relations.RoleDefinitions;
import org.tip.puck.net.relations.Roles;
import org.tip.puck.net.relations.workers.RelationModelStatistics;

public class RelationModelMaker {
    private static void compose(RelationModel model, Individual indi, Gender egoGender, Queue<Individual> queue, List<Individual> visited, List<String> egoNeutral) {
        Roles composition;
        Roles composition2;
        Gender childGender;
        RoleDefinitions roleDefinitions = model.roleDefinitions();
        if (!indi.getName().equalsIgnoreCase("ego") && roleDefinitions.getRoleByName(indi.getName()) == null) {
            System.out.println("role definition missing: " + indi + " for " + (Object)((Object)egoGender) + " ego");
        }
        if (indi.getFather() != null && indi.getFather().getName() != null && !visited.contains(indi.getFather())) {
            indi.getFather().setAttribute("EGOGENDER", egoGender.toString());
            indi.getFather().setAttribute("GENERATION", String.valueOf(Integer.parseInt(indi.getAttributeValue("GENERATION")) + 1));
            childGender = indi.getGender();
            if (indi.getName().equalsIgnoreCase("Ego")) {
                if (egoNeutral.contains("PARENT")) {
                    childGender = Gender.UNKNOWN;
                }
                roleDefinitions.addNew(new RoleDefinition(roleDefinitions.size(), model.role(indi.getFather()), RoleDefinition.Primary.PARENT, null, null, Gender.MALE, null, childGender));
            } else {
                for (Role fatherRole : roleDefinitions.getRoles(RoleDefinition.Primary.PARENT, Gender.MALE, null, childGender)) {
                    composition2 = new Roles();
                    composition2.add(roleDefinitions.getRoleByName(indi.getName()));
                    composition2.add(fatherRole);
                    roleDefinitions.addNew(new RoleDefinition(roleDefinitions.size(), model.role(indi.getFather()), null, null, composition2, Gender.MALE, null, egoGender));
                }
            }
            queue.add(indi.getFather());
            visited.add(indi.getFather());
        }
        if (indi.getMother() != null && indi.getMother().getName() != null && !visited.contains(indi.getMother())) {
            indi.getMother().setAttribute("EGOGENDER", egoGender.toString());
            indi.getMother().setAttribute("GENERATION", String.valueOf(Integer.parseInt(indi.getAttributeValue("GENERATION")) + 1));
            childGender = indi.getGender();
            if (indi.getName().equalsIgnoreCase("Ego")) {
                if (egoNeutral.contains("PARENT")) {
                    childGender = Gender.UNKNOWN;
                }
                roleDefinitions.addNew(new RoleDefinition(roleDefinitions.size(), model.role(indi.getMother()), RoleDefinition.Primary.PARENT, null, null, Gender.FEMALE, null, childGender));
            } else {
                for (Role motherRole : roleDefinitions.getRoles(RoleDefinition.Primary.PARENT, Gender.FEMALE, null, childGender)) {
                    composition2 = new Roles();
                    composition2.add(roleDefinitions.getRoleByName(indi.getName()));
                    composition2.add(motherRole);
                    roleDefinitions.addNew(new RoleDefinition(roleDefinitions.size(), model.role(indi.getMother()), null, null, composition2, Gender.FEMALE, null, egoGender));
                }
            }
            queue.add(indi.getMother());
            visited.add(indi.getMother());
        }
        for (Individual sibling : indi.siblings()) {
            Gender siblingGender = indi.getGender();
            if (egoNeutral.contains("SIBLING")) {
                siblingGender = Gender.UNKNOWN;
            }
            if (sibling.getName() == null || visited.contains(sibling)) continue;
            sibling.setAttribute("EGOGENDER", egoGender.toString());
            sibling.setAttribute("GENERATION", indi.getAttributeValue("GENERATION"));
            if (indi.getName().equalsIgnoreCase("Ego")) {
                roleDefinitions.addNew(new RoleDefinition(roleDefinitions.size(), model.role(sibling), RoleDefinition.Primary.SIBLING, null, null, sibling.getGender(), RelationModelMaker.getAlterAge(sibling, indi), siblingGender));
            } else {
                for (Role siblingRole : roleDefinitions.getRoles(RoleDefinition.Primary.SIBLING, sibling.getGender(), RelationModelMaker.getAlterAge(sibling, indi), siblingGender)) {
                    composition = new Roles();
                    composition.add(roleDefinitions.getRoleByName(indi.getName()));
                    composition.add(siblingRole);
                    roleDefinitions.addNew(new RoleDefinition(roleDefinitions.size(), model.role(sibling), null, null, composition, sibling.getGender(), null, egoGender));
                }
            }
            queue.add(sibling);
            visited.add(sibling);
        }
        for (Individual spouse : indi.getPartners()) {
            Gender spouseGender = indi.getGender();
            if (spouse.getName() == null || visited.contains(spouse)) continue;
            spouse.setAttribute("EGOGENDER", egoGender.toString());
            spouse.setAttribute("GENERATION", indi.getAttributeValue("GENERATION"));
            if (indi.getName().equalsIgnoreCase("Ego")) {
                if (egoNeutral.contains("SPOUSE")) {
                    spouseGender = Gender.UNKNOWN;
                }
                roleDefinitions.addNew(new RoleDefinition(roleDefinitions.size(), model.role(spouse), RoleDefinition.Primary.SPOUSE, null, null, spouse.getGender(), null, spouseGender));
            } else {
                for (Role spouseRole : roleDefinitions.getRoles(RoleDefinition.Primary.SPOUSE, spouse.getGender(), null, spouseGender)) {
                    composition = new Roles();
                    composition.add(roleDefinitions.getRoleByName(indi.getName()));
                    composition.add(spouseRole);
                    roleDefinitions.addNew(new RoleDefinition(roleDefinitions.size(), model.role(spouse), null, null, composition, spouse.getGender(), null, egoGender));
                }
            }
            queue.add(spouse);
            visited.add(spouse);
        }
        for (Individual child : indi.children()) {
            Roles parentRoles;
            Gender parentGender = indi.getGender();
            if (child.getName() == null || visited.contains(child)) continue;
            child.setAttribute("EGOGENDER", egoGender.toString());
            child.setAttribute("GENERATION", String.valueOf(Integer.parseInt(indi.getAttributeValue("GENERATION")) - 1));
            if (indi.getName().equalsIgnoreCase("Ego")) {
                if (egoNeutral.contains("CHILD")) {
                    parentGender = Gender.UNKNOWN;
                }
                parentRoles = roleDefinitions.getRoles(RoleDefinition.Primary.PARENT, parentGender, null, child.getGender());
                for (Role role : parentRoles) {
                    roleDefinitions.addNew(new RoleDefinition(roleDefinitions.size(), model.role(child), null, role, null, child.getGender(), null, parentGender));
                }
            } else {
                parentRoles = roleDefinitions.getRoles(RoleDefinition.Primary.PARENT, parentGender, null, child.getGender());
                for (Role parentRole : parentRoles) {
                    Role childRole = roleDefinitions.getInverseRole(parentRole, child.getGender(), parentGender);
                    if (childRole != null) {
                        Roles composition3 = new Roles();
                        composition3.add(roleDefinitions.getRoleByName(indi.getName()));
                        composition3.add(childRole);
                        roleDefinitions.addNew(new RoleDefinition(roleDefinitions.size(), model.role(child), null, null, composition3, child.getGender(), RelationModelMaker.getAlterAge(child), egoGender));
                        continue;
                    }
                    System.out.println("Missing " + (Object)((Object)indi.getGender()) + " (" + (Object)((Object)parentGender) + ") " + " parentRole for " + (Object)((Object)child.getGender()) + " child :" + indi + " for " + child);
                }
            }
            queue.add(child);
            visited.add(child);
        }
    }

    private static void composeParents(RelationModel model, Individual indi, Gender egoGender, Queue<Individual> queue, List<Individual> visited, List<String> egoNeutral) {
        Roles composition;
        Gender childGender;
        RoleDefinitions roleDefinitions = model.roleDefinitions();
        if (indi.getFather() != null && indi.getFather().getName() != null && !visited.contains(indi.getFather())) {
            indi.getFather().setAttribute("EGOGENDER", egoGender.toString());
            indi.getFather().setAttribute("GENERATION", String.valueOf(Integer.parseInt(indi.getAttributeValue("GENERATION")) + 1));
            childGender = indi.getGender();
            if (egoNeutral.contains("PARENT")) {
                childGender = Gender.UNKNOWN;
            }
            if (indi.getName().equalsIgnoreCase("Ego")) {
                roleDefinitions.addNew(new RoleDefinition(roleDefinitions.size(), model.role(indi.getFather()), RoleDefinition.Primary.PARENT, null, null, Gender.MALE, null, childGender));
            } else {
                for (Role fatherRole : roleDefinitions.getRoles(RoleDefinition.Primary.PARENT, Gender.MALE, null, childGender)) {
                    composition = new Roles();
                    composition.add(roleDefinitions.getRoleByName(indi.getName()));
                    composition.add(fatherRole);
                    roleDefinitions.addNew(new RoleDefinition(roleDefinitions.size(), model.role(indi.getFather()), null, null, composition, null, null, egoGender));
                }
            }
            queue.add(indi.getFather());
            visited.add(indi.getFather());
        }
        if (indi.getMother() != null && indi.getMother().getName() != null && !visited.contains(indi.getMother())) {
            indi.getMother().setAttribute("EGOGENDER", egoGender.toString());
            indi.getMother().setAttribute("GENERATION", String.valueOf(Integer.parseInt(indi.getAttributeValue("GENERATION")) + 1));
            childGender = indi.getGender();
            if (egoNeutral.contains("PARENT")) {
                childGender = Gender.UNKNOWN;
            }
            if (indi.getName().equalsIgnoreCase("Ego")) {
                roleDefinitions.addNew(new RoleDefinition(roleDefinitions.size(), model.role(indi.getMother()), RoleDefinition.Primary.PARENT, null, null, Gender.FEMALE, null, childGender));
            } else {
                for (Role motherRole : roleDefinitions.getRoles(RoleDefinition.Primary.PARENT, Gender.FEMALE, null, childGender)) {
                    composition = new Roles();
                    composition.add(roleDefinitions.getRoleByName(indi.getName()));
                    composition.add(motherRole);
                    roleDefinitions.addNew(new RoleDefinition(roleDefinitions.size(), model.role(indi.getMother()), null, null, composition, null, null, egoGender));
                }
            }
            queue.add(indi.getMother());
            visited.add(indi.getMother());
        }
    }

    public static RelationModel create(Net net) {
        RelationModel result = new RelationModel(net.getLabel());
        RelationModelMaker.createRoleDefinitions(result, net);
        return result;
    }

    public static RelationModel createFromPositionList(String name, StringList roleDefinitionsList) {
        RelationModel result = new RelationModel(name);
        RelationModelMaker.createRoleDefinitionsFromPositionList(result, roleDefinitionsList);
        return result;
    }

    public static RelationModel create(String name, StringList roleDefinitionsList) {
        RelationModel result = new RelationModel(name);
        RelationModelMaker.createRoleDefinitions(result, roleDefinitionsList);
        return result;
    }

    public static RoleDefinitions createRoleDefinitions(RelationModel model, Net net) {
        Gender egoGender;
        Individual indi;
        RoleDefinitions result = new RoleDefinitions();
        Individual maleEgo = null;
        Individual femaleEgo = null;
        for (Individual indi2 : net.individuals()) {
            if (!indi2.getName().equalsIgnoreCase("Ego")) continue;
            indi2.setAttribute("EGOGENDER", indi2.getGender().toString());
            indi2.setAttribute("GENERATION", "0");
            if (indi2.isMale()) {
                maleEgo = indi2;
            } else if (indi2.isFemale()) {
                femaleEgo = indi2;
            }
            if (maleEgo == null || femaleEgo == null) continue;
            result.setEgoGenderDistinction(true);
            break;
        }
        ArrayList<String> egoNeutral = new ArrayList<String>();
        if (maleEgo != null && maleEgo.isSterile() || femaleEgo != null && femaleEgo.isSterile() || !result.isEgoGenderDistinction()) {
            egoNeutral.add("CHILD");
        }
        if (maleEgo != null && maleEgo.isOrphan() || femaleEgo != null && femaleEgo.isOrphan() || !result.isEgoGenderDistinction()) {
            egoNeutral.add("PARENT");
        }
        if (maleEgo != null && maleEgo.isSingle() || femaleEgo != null && femaleEgo.isSingle() || !result.isEgoGenderDistinction()) {
            egoNeutral.add("SPOUSE");
        }
        if (maleEgo != null && maleEgo.isUnique() || femaleEgo != null && femaleEgo.isUnique() || !result.isEgoGenderDistinction()) {
            egoNeutral.add("SIBLING");
        }
        LinkedList<Individual> maleQueue = new LinkedList<Individual>();
        LinkedList<Individual> femaleQueue = new LinkedList<Individual>();
        ArrayList<Individual> visited = new ArrayList<Individual>();
        if (maleEgo != null) {
            maleQueue.add(maleEgo);
            visited.add(maleEgo);
            RelationModelMaker.composeParents(model, maleEgo, Gender.MALE, maleQueue, visited, egoNeutral);
        }
        if (femaleEgo != null) {
            femaleQueue.add(femaleEgo);
            visited.add(femaleEgo);
            RelationModelMaker.composeParents(model, femaleEgo, Gender.FEMALE, femaleQueue, visited, egoNeutral);
        }
        if (maleEgo != null) {
            RelationModelMaker.compose(model, maleEgo, Gender.MALE, maleQueue, visited, egoNeutral);
            System.out.println("Male Ego environments complete: " + maleQueue);
        }
        if (femaleEgo != null) {
            RelationModelMaker.compose(model, femaleEgo, Gender.FEMALE, femaleQueue, visited, egoNeutral);
            System.out.println("Female Ego environments complete: " + femaleQueue);
        }
        while (!maleQueue.isEmpty()) {
            indi = (Individual)maleQueue.remove();
            egoGender = Gender.valueOf(indi.getAttributeValue("EGOGENDER"));
            RelationModelMaker.compose(model, indi, egoGender, maleQueue, visited, egoNeutral);
        }
        while (!femaleQueue.isEmpty()) {
            indi = (Individual)femaleQueue.remove();
            egoGender = Gender.valueOf(indi.getAttributeValue("EGOGENDER"));
            RelationModelMaker.compose(model, indi, egoGender, femaleQueue, visited, egoNeutral);
        }
        result = result.clean();
        model.setRoleDefinitions(result);
        return result;
    }

    public static RoleDefinitions createRoleDefinitionsFromPositionList(RelationModel model, StringList rolePositionList) {
        RoleDefinitions result = new RoleDefinitions();
        TreeMap<String, Roles> pseudoRoles = new TreeMap<String, Roles>();
        int id = 0;
        for (String rolePositionLine : rolePositionList) {
            String[] items = rolePositionLine.split("\t");
            RoleDefinition definition = new RoleDefinition(++id);
            int idx = 0;
            while (idx < items.length) {
                String item = items[idx];
                if (!StringUtils.isEmpty((CharSequence)item)) {
                    switch (idx) {
                        case 0: {
                            definition.setRole(model.role(item));
                            break;
                        }
                        case 1: {
                            if (Character.isLowerCase(item.charAt(item.length() - 1))) {
                                definition.setOther(item);
                                item = null;
                            } else if (item.charAt(0) == 'e') {
                                definition.setAlterAge(RoleDefinition.AlterAge.ELDER);
                                item = item.substring(1);
                            } else if (item.charAt(0) == 'y') {
                                definition.setAlterAge(RoleDefinition.AlterAge.YOUNGER);
                                item = item.substring(1);
                            }
                            if (item == null || RoleDefinitions.setPrimaryFromString(definition, item)) break;
                            definition.setComposition();
                            definition.composition().add(new Role(item));
                            if (pseudoRoles.get(item) == null) {
                                pseudoRoles.put(item, new Roles());
                            }
                            ((Roles)pseudoRoles.get(item)).add(definition.role());
                            char firstLetter = item.charAt(0);
                            if (!definition.egoGender().isUnknown() || firstLetter != 'H' && firstLetter != 'W') break;
                            definition.setEgoGender(Gender.valueOf(firstLetter).invert());
                            break;
                        }
                        case 2: {
                            definition.setEgoGender(Gender.valueOf(item.charAt(0)));
                        }
                    }
                }
                ++idx;
            }
            result.addNew(definition);
        }
        result.setInversePrimaryTerms();
        result = result.clean();
        for (RoleDefinition definition : result.toSortedList()) {
            if (definition.composition() == null || definition.composition().size() != 1 || !pseudoRoles.containsKey(((Role)definition.composition().get(0)).getName())) continue;
            String name = ((Role)definition.composition().get(0)).getName();
            String firstItem = name.substring(0, name.length() - 1);
            String lastItem = name.substring(name.length() - 1);
            Roles firstRoles = null;
            if (firstItem.length() == 1) {
                firstRoles = result.getPrimaryTerms(firstItem, definition.egoGender(), null, Gender.UNKNOWN);
            }
            if (firstRoles == null) {
                firstRoles = (Roles)pseudoRoles.get(firstItem);
            }
            if (firstRoles == null) {
                firstRoles = new Roles();
                firstRoles.add(new Role("[" + firstItem + "]"));
            }
            Gender egoGender = Gender.UNKNOWN;
            char genderLetter = firstItem.charAt(firstItem.length() - 1);
            if (genderLetter == 'S' || genderLetter == 'F' || genderLetter == 'H' || genderLetter == 'B') {
                egoGender = Gender.MALE;
            } else if (genderLetter == 'D' || genderLetter == 'M' || genderLetter == 'W' || genderLetter == 'Z') {
                egoGender = Gender.FEMALE;
            }
            for (Role firstRole : firstRoles) {
                definition.composition().set(0, firstRole);
                Roles lastRoles = result.getPrimaryTerms(lastItem, egoGender, definition.alterAge(), definition.alterGender());
                if (lastRoles.size() <= 0) continue;
                result.removeById(definition.getId());
                for (Role lastRole : lastRoles) {
                    RoleDefinition def1 = definition.clone();
                    def1.setId(result.getLastId() + 1);
                    def1.composition().add(lastRole);
                    result.addNew(def1);
                }
            }
        }
        result = result.clean();
        model.setRoleDefinitions(result);
        return result;
    }

    public static RoleDefinitions createRoleDefinitions(RelationModel model, StringList roleDefinitionsList) {
        RoleDefinitions result = new RoleDefinitions();
        int id = 0;
        for (String roleDefinitionLine : roleDefinitionsList) {
            String[] items = roleDefinitionLine.split("\t");
            ++id;
            Role role = null;
            RoleDefinition.Primary primary = null;
            Role inversion = null;
            Roles composition = new Roles();
            RoleDefinition.AlterAge alterAge = null;
            Gender alterGender = Gender.UNKNOWN;
            Gender egoGender = Gender.UNKNOWN;
            int idx = 0;
            while (idx < items.length) {
                String item = items[idx];
                if (!StringUtils.isEmpty((CharSequence)item)) {
                    switch (idx) {
                        case 0: {
                            role = model.role(item);
                            break;
                        }
                        case 1: {
                            primary = RoleDefinition.Primary.valueOf(item);
                            break;
                        }
                        case 2: {
                            inversion = model.role(item);
                            break;
                        }
                        case 3: {
                            composition.add(model.role(item));
                            break;
                        }
                        case 4: {
                            composition.add(model.role(item));
                            break;
                        }
                        case 5: {
                            alterGender = Gender.valueOf(item);
                            break;
                        }
                        case 6: {
                            alterAge = RoleDefinition.AlterAge.valueOf(item);
                            break;
                        }
                        case 7: {
                            egoGender = Gender.valueOf(item);
                        }
                    }
                }
                ++idx;
            }
            result.add(new RoleDefinition(id, role, primary, inversion, composition, alterGender, alterAge, egoGender));
        }
        result = result.clean();
        model.setRoleDefinitions(result);
        return result;
    }

    private static RoleDefinition.AlterAge getAlterAge(Individual indi) {
        RoleDefinition.AlterAge result = null;
        if (indi.getAttributeValue("GENERATION").equals("0") && indi.getBirthOrder() != null) {
            if (indi.getBirthOrder() == 3) {
                result = RoleDefinition.AlterAge.YOUNGER;
            } else if (indi.getBirthOrder() == 1) {
                result = RoleDefinition.AlterAge.ELDER;
            }
        }
        return result;
    }

    private static RoleDefinition.AlterAge getAlterAge(Individual alter, Individual ego) {
        RoleDefinition.AlterAge result = null;
        if (alter == null || ego == null) {
            result = null;
        } else if (alter.isYoungerThan(ego)) {
            result = RoleDefinition.AlterAge.YOUNGER;
        } else if (alter.isElderThan(ego)) {
            result = RoleDefinition.AlterAge.ELDER;
        }
        return result;
    }

    private static boolean crossSex(Role ego, Role alter, Map<Role, List<Gender>> genders) {
        boolean result = false;
        for (Gender egoGender : genders.get(ego)) {
            for (Gender alterGender : genders.get(alter)) {
                if (egoGender == alterGender) continue;
                result = true;
                break;
            }
            if (result) break;
        }
        return result;
    }

    private static boolean sameSex(Role ego, Role alter, Map<Role, List<Gender>> genders) {
        boolean result = false;
        for (Gender egoGender : genders.get(ego)) {
            for (Gender alterGender : genders.get(alter)) {
                if (egoGender != alterGender) continue;
                result = true;
                break;
            }
            if (result) break;
        }
        return result;
    }

    public static Graph<Role> relationModelGraph(RelationModel model) {
        Role linkRole;
        Roles egos;
        Role alter;
        Graph<Role> result = new Graph<Role>();
        result.setLabel(model.getName());
        HashMap<Role, Link.LinkType> linkTypes = new HashMap<Role, Link.LinkType>();
        HashMap<Role, Integer> weights = new HashMap<Role, Integer>();
        HashMap<Role, Roles> inversions = new HashMap<Role, Roles>();
        HashMap<Role, String> tags = new HashMap<Role, String>();
        RelationModelStatistics statistics = new RelationModelStatistics(model);
        Map<Role, List<Gender>> genderMap = statistics.genderMap();
        Role maleEgo = new Role("Male Ego");
        Role femaleEgo = new Role("Female Ego");
        Gender[] maleGenders = new Gender[]{Gender.MALE};
        Gender[] femaleGenders = new Gender[]{Gender.FEMALE};
        genderMap.put(maleEgo, Arrays.asList(maleGenders));
        genderMap.put(femaleEgo, Arrays.asList(femaleGenders));
        result.addNode(maleEgo);
        result.addNode(femaleEgo);
        for (Role role : model.roles()) {
            result.addNode(role);
        }
        for (RoleDefinition definition : model.roleDefinitions().toSortedList()) {
            if (definition.primary() == null) continue;
            alter = definition.role();
            egos = new Roles();
            if (!definition.egoGender().isFemale()) {
                egos.add(maleEgo);
            }
            if (!definition.egoGender().isMale()) {
                egos.add(femaleEgo);
            }
            switch (definition.primary()) {
                case PARENT: {
                    linkTypes.put(alter, Link.LinkType.ARC);
                    if (definition.alterGender().isMale()) {
                        weights.put(alter, 1);
                        tags.put(alter, "F");
                        break;
                    }
                    if (definition.alterGender().isFemale()) {
                        weights.put(alter, -1);
                        tags.put(alter, "M");
                        break;
                    }
                    tags.put(alter, "Pa");
                    break;
                }
                case SIBLING: {
                    linkTypes.put(alter, Link.LinkType.EDGE);
                    weights.put(alter, -1);
                    if (definition.alterGender().isMale()) {
                        tags.put(alter, "B");
                        break;
                    }
                    if (definition.alterGender().isFemale()) {
                        tags.put(alter, "Z");
                        break;
                    }
                    tags.put(alter, "Sb");
                    break;
                }
                case SPOUSE: {
                    linkTypes.put(alter, Link.LinkType.EDGE);
                    weights.put(alter, 1);
                    if (definition.alterGender().isMale()) {
                        tags.put(alter, "H");
                        break;
                    }
                    if (definition.alterGender().isFemale()) {
                        tags.put(alter, "W");
                        break;
                    }
                    tags.put(alter, "Sp");
                }
            }
            for (Role ego : egos) {
                if (definition.primary() == RoleDefinition.Primary.SPOUSE && !RelationModelMaker.crossSex(ego, alter, genderMap)) continue;
                result.addLink(ego, alter, (Link.LinkType)((Object)linkTypes.get(alter)), (Integer)weights.get(alter));
            }
        }
        for (RoleDefinition definition : model.roleDefinitions().toSortedList()) {
            if (definition.inversion() == null) continue;
            alter = definition.role();
            egos = new Roles();
            if (!definition.egoGender().isFemale()) {
                egos.add(maleEgo);
            }
            if (!definition.egoGender().isMale()) {
                egos.add(femaleEgo);
            }
            linkRole = definition.inversion();
            Roles inverseRoles = (Roles)inversions.get(alter);
            if (inverseRoles == null) {
                inverseRoles = new Roles();
                inversions.put(alter, inverseRoles);
            }
            inverseRoles.add(linkRole);
            for (Role ego : egos) {
                if (genderMap.get(ego).size() != 0 && !RelationModelMaker.sameSex(ego, linkRole, genderMap)) continue;
                result.addLink(alter, ego, (Link.LinkType)((Object)linkTypes.get(linkRole)), (Integer)weights.get(linkRole));
            }
        }
        for (RoleDefinition definition : model.roleDefinitions().toSortedList()) {
            if (definition.composition() != null) {
                alter = definition.role();
                Role ego = (Role)definition.composition().get(0);
                linkRole = (Role)definition.composition().get(1);
                if (linkTypes.containsKey(linkRole)) {
                    if (linkTypes.get(linkRole) == Link.LinkType.EDGE && (Integer)weights.get(linkRole) == 1 && !RelationModelMaker.crossSex(ego, alter, genderMap)) continue;
                    result.addLink(ego, alter, (Link.LinkType)((Object)linkTypes.get(linkRole)), (Integer)weights.get(linkRole));
                    continue;
                }
                if (inversions.containsKey(linkRole)) {
                    Roles inverseLinkRoles = (Roles)inversions.get(linkRole);
                    for (Role inverseLinkRole : inverseLinkRoles) {
                        if (genderMap.get(ego).size() != 0 && !RelationModelMaker.sameSex(ego, inverseLinkRole, genderMap)) continue;
                        if (alter.getName().equals("viya'")) {
                            System.out.println("inverse " + ego + " " + inverseLinkRole + " " + linkTypes.get(inverseLinkRole));
                        }
                        result.addLink(alter, ego, (Link.LinkType)((Object)linkTypes.get(inverseLinkRole)), (Integer)weights.get(inverseLinkRole));
                    }
                    continue;
                }
                System.err.println("Undefined link role " + linkRole);
                continue;
            }
            if (definition.primary() != null || definition.inversion() != null) continue;
            System.err.println("No composition : " + definition);
        }
        return result;
    }
}

