/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.geo2.io;

import java.io.File;
import org.fest.assertions.Assertions;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.geo2.GeoLevel2;
import org.tip.puck.geo2.Geography2;
import org.tip.puck.geo2.Place2;
import org.tip.puck.geo2.Places2;
import org.tip.puck.geo2.io.GEOTXTFile;

public class GEOTXTFileTest {
    private static final Logger logger = LoggerFactory.getLogger(GEOTXTFileTest.class);

    @Test
    public void testLoad01() throws Exception {
        logger.debug("========================== testLoad01");
        Geography2 source = GEOTXTFile.load(new File("test/org/tip/puck/geo2/io/SimpleTest.geo.csv"));
        Assertions.assertThat((Object)source).isNotNull();
        Places2 places = source.getPlaces();
        Assertions.assertThat((boolean)places.isEmpty()).isFalse();
        Assertions.assertThat((Object)places.getByToponym("Massy")).isNotNull();
    }

    @Test
    public void testSave01() throws Exception {
        logger.debug("========================== testSave01");
        Geography2 source = new Geography2();
        Place2 place = new Place2("Paris");
        place.getHomonyms().add("Lut\u00c3\u00a8ce");
        place.getHomonyms().add("Lutecia");
        place.setGeoLevel(GeoLevel2.TOWN);
        source.addPlace(place);
        place = new Place2("Massy");
        place.setGeoLevel(GeoLevel2.TOWN);
        place.setLatitude(48.730946);
        place.setLongitude(2.271316);
        place.setElevation(100);
        place.setComment("91300");
        source.addPlace(place);
        File target = File.createTempFile("test", "csv");
        GEOTXTFile.save(target, source);
        Assertions.assertThat((Object)source).isNotNull();
    }
}

