/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.geo.io;

import com.vividsolutions.jts.geom.Coordinate;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckException;
import org.tip.puck.PuckExceptions;
import org.tip.puck.geo.GeoLevel;
import org.tip.puck.geo.Geography;
import org.tip.puck.geo.Place;

public class PlaceFile {
    private static final Logger logger = LoggerFactory.getLogger(PlaceFile.class);
    public static final String DEFAULT_CHARSET_NAME = "8859_1";
    public static final int MAX_LINE_SIZE = 2048;

    public static Geography loadGeoData(File file) throws PuckException {
        Geography result = null;
        BufferedReader in = null;
        try {
            try {
                in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), DEFAULT_CHARSET_NAME));
                result = PlaceFile.readGeoData(in);
            }
            catch (UnsupportedEncodingException exception) {
                throw PuckExceptions.UNSUPPORTED_ENCODING.create("Opening file [" + file + "]", new Object[0]);
            }
            catch (FileNotFoundException exception) {
                throw PuckExceptions.FILE_NOT_FOUND.create("Opening file [" + file + "]", new Object[0]);
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException exception) {
                logger.warn("Not managed error.");
                exception.printStackTrace();
            }
        }
        return result;
    }

    private static Geography readGeoData(BufferedReader in) throws PuckException {
        Geography result = new Geography();
        Place world = new Place(GeoLevel.INTERCONTINENTAL, "World");
        result.put(world);
        boolean ended = false;
        while (!ended) {
            try {
                in.mark(2048);
                String line = PlaceFile.readNotEmptyLine(in);
                if (line != null) {
                    String[] tokens = line.split("\\t");
                    Place place = null;
                    Place supPlace = world;
                    int i = 0;
                    while (i < 7) {
                        GeoLevel level = GeoLevel.values()[i + 1];
                        String name = tokens[i];
                        if (!StringUtils.isBlank((CharSequence)name)) {
                            String id = name;
                            if (supPlace != null) {
                                id = String.valueOf(id) + " / " + supPlace.getName();
                            }
                            if ((place = result.get(level, id)) == null) {
                                place = new Place(level, name);
                                if (supPlace != null) {
                                    place.setSup(supPlace);
                                }
                                result.put(place);
                            }
                            supPlace = place;
                            place = null;
                        }
                        ++i;
                    }
                    result.put(tokens[7], supPlace);
                    if (tokens.length == 10) {
                        supPlace.setCoordinate(new Coordinate(Double.parseDouble(tokens[9]), Double.parseDouble(tokens[8])));
                    }
                    supPlace = world;
                    continue;
                }
                ended = true;
            }
            catch (IOException exception) {
                throw PuckExceptions.IO_ERROR.create(exception, "Reading individual line.", new Object[0]);
            }
        }
        result.updateDistricts();
        return result;
    }

    public static String readNotEmptyLine(BufferedReader in) throws PuckException {
        String result;
        try {
            boolean ended = false;
            result = null;
            while (!ended) {
                String line = in.readLine();
                if (line == null) {
                    ended = true;
                    result = null;
                    continue;
                }
                if (!StringUtils.isNotBlank((CharSequence)line)) continue;
                ended = true;
                result = line;
            }
        }
        catch (IOException exception) {
            throw PuckExceptions.IO_ERROR.create(exception, "Reading line.", new Object[0]);
        }
        return result;
    }
}

