/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.census.chains;

import java.util.ArrayList;
import java.util.List;
import org.tip.puck.census.chains.Chain;
import org.tip.puck.census.chains.Couple;
import org.tip.puck.census.chains.Notation;
import org.tip.puck.census.chains.Vector;
import org.tip.puck.census.workers.CircuitFinder;
import org.tip.puck.census.workers.SiblingMode;
import org.tip.puck.net.FiliationType;
import org.tip.puck.net.Gender;
import org.tip.puck.net.Individual;

public class ChainMaker {
    public static void assimilateGender(Individual ego, Individual alter) {
        if (ego.getGender() != alter.getGender()) {
            if (ego.getGender().isUnknown()) {
                ego.setGender(alter.getGender());
            }
            if (alter.getGender().isUnknown()) {
                alter.setGender(ego.getGender());
            }
        }
    }

    public static Chain createMarriage(Individual ego, Individual alter) {
        Chain result = new Chain(ego);
        result.add(alter, 0);
        result.subchains = new ArrayList<Chain>();
        result.subchains.add(new Chain(ego));
        result.subchains.add(new Chain(ego));
        result.subchains.add(new Chain(alter));
        result.subchains.add(new Chain(alter));
        return result;
    }

    public static Chain compose(Chain chain1, Chain chain2) {
        Chain result;
        Chain leftChain = chain1.clone();
        Chain rightChain = chain2.clone();
        ChainMaker.assimilateGender(leftChain.getLast(), rightChain.getFirst());
        if (leftChain.getLast().getGender() != rightChain.getFirst().getGender()) {
            result = ChainMaker.concatenateWithMarriage(leftChain, rightChain);
        } else if (ChainMaker.continues(leftChain, rightChain)) {
            rightChain.remove(0);
            result = leftChain.dim() == 0 ? ChainMaker.concatenateWithMarriage(leftChain, rightChain) : ChainMaker.concatenate(leftChain, rightChain);
        } else {
            leftChain.removeLast();
            rightChain.truncate(true);
            result = ChainMaker.compose(leftChain, rightChain);
        }
        return result;
    }

    public static Chain concatenateWithMarriage(Chain chain1, Chain chain2) {
        Chain result = chain1.clone();
        if (result.subchains != null) {
            result.subchains.addAll(chain2.subchains);
        }
        result.addAllWithMarriage(chain2);
        result.setPivots(chain1);
        return result;
    }

    static Chain concatenate(Chain chain1, Chain chain2) {
        Chain result = chain1.clone();
        result.addAll(chain2);
        result.setPivots(chain1);
        return result;
    }

    public static Chain concatenate(List<Chain> chains, int dmax) {
        if (chains.size() == 1) {
            return chains.get(0);
        }
        Chain chain = new Chain();
        chain.subchains = new ArrayList<Chain>();
        int i = 0;
        while (i < chains.size()) {
            Chain next = chains.get(i);
            if (next.depth() > dmax || chain.hasElementsInCommon(next)) {
                return null;
            }
            chain.addAllWithMarriage(next);
            for (Chain subchain : next.subchains) {
                chain.subchains.add(subchain);
            }
            ++i;
        }
        return chain;
    }

    public static Chain concatenateInv(Chain left, Chain right) {
        Chain result = new Chain();
        result.subchains = new ArrayList<Chain>();
        result.subchains.add(left.clone());
        result.subchains.add(right.clone());
        result.addAll(left);
        result.addInv(right);
        if (left.size() > 1 && right.size() > 1) {
            result.addApex(left.length());
        }
        return result;
    }

    private static boolean continues(Chain chain1, Chain chain2) {
        boolean result;
        if (chain1.lastDir() == 0) {
            result = false;
        } else if (chain1.length() == 0 || chain2.length() == 0) {
            result = true;
        } else if (chain1.lastDir() == 1) {
            chain2.dir(1);
            result = true;
        } else {
            result = chain1.lastDir() == chain2.dir(1);
        }
        return result;
    }

    public static Chain fromNumber(int k) {
        Chain result = new Chain();
        int i = 0;
        int a = 2;
        int c = 1;
        if (k < 1) {
            c = -1;
            k = -k;
        }
        while (k > 0) {
            int b = a - k % a;
            result.add(new Individual(i + 1, "", Gender.valueOf(2 * b / a - 1)));
            a *= 2;
            k -= b;
            ++i;
        }
        if (c == -1) {
            result.getLast().setGender(Gender.UNKNOWN);
        }
        return result;
    }

    public static Chain fromString(String kinString) {
        Chain result = null;
        if (kinString != null && kinString.charAt(0) != '<') {
            if (Chain.notation(kinString) == Notation.VECTOR) {
                result = ChainMaker.fromVector(ChainMaker.getVector(kinString));
            } else {
                result = new Chain();
                kinString = ChainMaker.standardize(kinString);
                int k = 1;
                int n = 0;
                int d = 0;
                int i = 0;
                while (i < kinString.length()) {
                    try {
                        Gender gender = Gender.valueOf(Integer.parseInt(kinString.substring(i, i + 1)));
                        if (gender == Gender.UNKNOWN) {
                            result.add(new Couple(k), d);
                        } else {
                            result.add(new Individual(k, "", gender), d);
                        }
                        ++k;
                        if (d == 0) {
                            d = 1;
                        }
                    }
                    catch (NumberFormatException nfe) {
                        d = -(++n % 2);
                    }
                    ++i;
                }
                result.getSubchains();
            }
        }
        return result;
    }

    public static void develop(List<Chain> models, String str, SiblingMode sib, boolean crossSex, FiliationType line) {
        ChainMaker.develop(models, ChainMaker.transform(str), 0, sib, crossSex, line);
    }

    public static void develop(List<Chain> models, String str, int k, SiblingMode sib, boolean crossSex, FiliationType line) {
        if (ChainMaker.isWellFormed(str)) {
            int i = k;
            while (i < str.length()) {
                if (str.charAt(i) == 'X') {
                    ChainMaker.develop(models, ChainMaker.fill(str, "X", "H", line), i, sib, crossSex, line);
                    ChainMaker.develop(models, ChainMaker.fill(str, "X", "F", line), i, sib, crossSex, line);
                    return;
                }
                if (str.charAt(i) == 'Y') {
                    if (sib != SiblingMode.ALL) {
                        ChainMaker.develop(models, ChainMaker.fill(str, "Y", "X", line), k, sib, crossSex, line);
                    }
                    if (sib != SiblingMode.NONE) {
                        ChainMaker.develop(models, ChainMaker.fill(str, "Y", "", line), k, sib, crossSex, line);
                    }
                    return;
                }
                ++i;
            }
            if (!ChainMaker.containsHomosexualMarriages(crossSex, str)) {
                Chain model = ChainMaker.fromString(str);
                models.add(model.standard());
            }
        }
    }

    private static String fill(String str, String x, String y, FiliationType line) {
        if (line == FiliationType.COGNATIC || x.equals("Y") || line == FiliationType.AGNATIC && y.equals("H") || line == FiliationType.UTERINE && y.equals("F")) {
            return str.replaceFirst(x, y);
        }
        int i = str.indexOf(x);
        if (i == 0 || i == str.length() - 1 || str.charAt(i + 1) == '.' || str.charAt(i - 1) == '.') {
            return str.replaceFirst(x, y);
        }
        return null;
    }

    public static Chain fromVector(Vector vector) {
        Chain result = new Chain();
        result.vector = vector;
        int i = 0;
        while (i < vector.getNumbers().length) {
            if (i % 2 != 0) {
                result.addAllWithMarriage(ChainMaker.concatenateInv(ChainMaker.fromNumber(vector.getNumbers()[i - 1]), ChainMaker.fromNumber(vector.getNumbers()[i])));
            }
            ++i;
        }
        return result;
    }

    private static Vector getVector(String str) {
        String[] vec = str.split("\\ ");
        int[] numbers = new int[vec.length];
        int i = 0;
        while (i < vec.length) {
            numbers[i] = Integer.parseInt(vec[i]);
            ++i;
        }
        Vector result = new Vector(numbers);
        return result;
    }

    public static Chain insert(Chain outerChain, Chain innerChain) {
        Chain result;
        if (outerChain.length() == 0 || outerChain.dir(1) != 1) {
            result = outerChain;
        } else {
            if (((Individual)outerChain.get(1)).getGender() != innerChain.getLast().getGender()) {
                innerChain = innerChain.reflect();
            }
            innerChain.directions.set(0, 1);
            Chain chain = ChainMaker.concatenate(new Chain(outerChain.getFirst(), 1), innerChain);
            outerChain.truncate(true);
            result = ChainMaker.compose(chain, outerChain);
        }
        return result;
    }

    private static String standardize(char c, Notation key) {
        switch (key) {
            case POSITIONAL: {
                if (c == 'H') {
                    return "0";
                }
                if (c == 'F') {
                    return "1";
                }
                if (c == 'X') {
                    return "2";
                }
                if (c != ')' && c != '.') break;
                return ".";
            }
            case CLASSIC: {
                if (c == 'F' || c == 'S') {
                    return "0";
                }
                if (c == 'M' || c == 'D') {
                    return "1";
                }
                if (c == 'X') {
                    return "2";
                }
                if (c == 'H') {
                    return ".0";
                }
                if (c == 'W') {
                    return ".1";
                }
                if (c != '.') break;
                return ".";
            }
            case CLASSIC_GENDERED: {
                if (c == 'F' || c == 'S' || c == Gender.MALE.toSymbol()) {
                    return "0";
                }
                if (c == 'M' || c == 'D' || c == Gender.FEMALE.toSymbol()) {
                    return "1";
                }
                if (c == 'X' || c == Gender.UNKNOWN.toSymbol()) {
                    return "2";
                }
                if (c == 'H') {
                    return ".0";
                }
                if (c == 'W') {
                    return ".1";
                }
                if (c != '.') break;
                return ".";
            }
        }
        return "";
    }

    private static String standardize(String str) {
        String result = "";
        Notation notation = Chain.notation(str);
        if (notation == Notation.CLASSIC_GENDERED) {
            if (str.charAt(1) == ' ') {
                result = str.charAt(0) == 'H' ? String.valueOf(result) + 0 : (str.charAt(0) == 'F' ? String.valueOf(result) + 1 : String.valueOf(result) + 2);
                str = str.substring(2);
            } else {
                result = ChainMaker.standardize(str.charAt(0), Notation.CLASSIC_GENDERED);
                str = str.substring(1);
            }
            str = str.replaceAll("MH", "M.H").replaceAll("FW", "F.W").replace("MW", "M.W").replace("FH", "F.H");
            str = str.replaceAll("M ", "H ").replaceAll("F ", "W ");
            str = str.replaceAll("B", "X.S").replaceAll("Z", "X.D");
            char c = str.charAt(str.length() - 1);
            if (c != 'D' && c != 'S') {
                str = String.valueOf(str) + ".";
            }
        }
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (notation == Notation.POSITIONAL) {
                if (c == ')' && str.charAt(i - 1) == '(') {
                    result = String.valueOf(result) + "2";
                }
                if (c == '.' && (i == 1 || str.charAt(i - 2) == '.')) {
                    result = String.valueOf(result) + ".";
                }
            } else if (notation == Notation.CLASSIC_GENDERED) {
                int d = 32;
                if (i > 0) {
                    d = str.charAt(i - 1);
                }
                if (!(c != 'H' && c != 'W' || i != 0 && d != 72 && d != 87)) {
                    result = String.valueOf(result) + ".";
                }
                if ((c == 'S' || c == 'D') && (i == 0 || d != 83 && d != 68 && d != 46)) {
                    result = String.valueOf(result) + ".";
                }
            }
            result = String.valueOf(result) + ChainMaker.standardize(c, notation);
            ++i;
        }
        if (notation == Notation.POSITIONAL && str.charAt(str.length() - 2) == '.') {
            result = String.valueOf(result) + "..";
        }
        result = String.valueOf(result) + ".";
        return result;
    }

    public static boolean containsHomosexualMarriages(boolean crossSex, String str) {
        String s = str.replaceAll("\\(", "").replaceAll("\\)", "");
        if (s.indexOf("H.H") > -1 || s.indexOf("F.F") > -1) {
            return true;
        }
        return crossSex && str.charAt(0) == str.charAt(str.length() - 1);
    }

    public static boolean isWellFormed(String str) {
        int i;
        boolean result = str == null ? false : ((i = str.indexOf("()")) == 0 || i == str.length() - 2 ? false : str.indexOf(".()") <= -1 && str.indexOf("().") <= -1);
        return result;
    }

    public static List<Chain> getPermutations(Chain chain) {
        ArrayList<Chain> result = new ArrayList<Chain>();
        ArrayList<String> signatures = new ArrayList<String>();
        int i = 0;
        while (i < 2 * chain.dim()) {
            Chain newChain = chain.transform(i);
            String signature = newChain.signature(Notation.POSITIONAL);
            if (!signatures.contains(signature)) {
                result.add(newChain);
                signatures.add(signature);
            }
            ++i;
        }
        return result;
    }

    public static String transform(String s) {
        s = s.replaceAll("\\(\\)", "\\(X\\)");
        int n = s.length() - 3;
        int i = 1;
        while (i < n) {
            if (s.charAt(i) == '(' && s.charAt(i - 1) != '.') {
                s = CircuitFinder.replaceCharAt(s, i + 1, 'Y');
            }
            ++i;
        }
        return s;
    }
}

