package org.tip.puckgui.views;

import java.awt.BorderLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;

import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.clusternetworks.ClusterNetworkReporter;
import org.tip.puck.net.workers.IndividualValuator;
import org.tip.puck.report.Report;
import org.tip.puckgui.NetGUI;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;

/**
 * 
 * @author TIP
 */
public class FlowNetworkInputWindow extends JFrame {

	private static final Logger logger = LoggerFactory.getLogger(FlowNetworkInputWindow.class);

	private static final long serialVersionUID = -6113524443785800524L;

	private JFrame thisJFrame;
	private NetGUI netGUI;
	private JPanel contentPane;
	private static String lastParameter1;
	private static String lastParameter2;
	private static int lastMinimalValue = 2;
	private JComboBox comboBoxParameter1;
	private JComboBox comboBoxParameter2;
	private JSpinner spinnerMinimalNumberOfLinks;

	/**
	 * Create the frame.
	 */
	public FlowNetworkInputWindow(final NetGUI netGUI) {
		//
		List<String> availableParameters1 = IndividualValuator.getAttributeLabelSample(netGUI.getNet().individuals());
		List<String> availableParameters2 = new ArrayList<String>(availableParameters1);

		//
		if (lastParameter1 == null) {
			availableParameters1.add(0, "");
		} else {
			availableParameters1.add(0, lastParameter1);
		}

		//
		if (lastParameter2 == null) {
			availableParameters2.add(0, "");
		} else {
			availableParameters2.add(0, lastParameter2);
		}
		setIconImage(Toolkit.getDefaultToolkit().getImage(FooReporterInputWindow.class.getResource("/org/tip/puckgui/favicon-16x16.jpg")));

		this.thisJFrame = this;
		this.netGUI = netGUI;
		setTitle("Flow Network Inputs");
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		setBounds(100, 100, 317, 198);
		setLocationRelativeTo(null);

		this.contentPane = new JPanel();
		this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
		setContentPane(this.contentPane);
		this.contentPane.setLayout(new BorderLayout(0, 0));

		JPanel panel = new JPanel();
		this.contentPane.add(panel, BorderLayout.CENTER);
		panel.setLayout(new FormLayout(new ColumnSpec[] { FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC,
				ColumnSpec.decode("default:grow"), FormFactory.RELATED_GAP_COLSPEC, }, new RowSpec[] { FormFactory.RELATED_GAP_ROWSPEC,
				FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC,
				FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC,
				FormFactory.DEFAULT_ROWSPEC, }));

		JLabel lblSourceLabel = new JLabel("Source Label:");
		panel.add(lblSourceLabel, "2, 4, right, default");

		this.comboBoxParameter1 = new JComboBox(availableParameters1.toArray());
		this.comboBoxParameter1.setSelectedIndex(0);
		this.comboBoxParameter1.setMaximumRowCount(12);
		this.comboBoxParameter1.setEditable(true);
		panel.add(this.comboBoxParameter1, "4, 4, fill, default");

		JLabel lblTargetLabel = new JLabel("Target Label:");
		panel.add(lblTargetLabel, "2, 6, right, default");

		this.comboBoxParameter2 = new JComboBox(availableParameters2.toArray());
		this.comboBoxParameter2.setSelectedIndex(0);
		this.comboBoxParameter2.setMaximumRowCount(12);
		this.comboBoxParameter2.setEditable(true);
		panel.add(this.comboBoxParameter2, "4, 6, fill, default");

		JLabel label = new JLabel("<html><div style=\"text-align:right\">Minimal number:<br/>of links</div></html>");
		panel.add(label, "2, 8");

		this.spinnerMinimalNumberOfLinks = new JSpinner();
		this.spinnerMinimalNumberOfLinks.setModel(new SpinnerNumberModel(new Integer(2), new Integer(0), null, new Integer(1)));
		panel.add(this.spinnerMinimalNumberOfLinks, "4, 8");

		JPanel buttonPanel = new JPanel();
		this.contentPane.add(buttonPanel, BorderLayout.SOUTH);

		JButton btnCancel = new JButton("Cancel");
		btnCancel.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Close.
				dispose();
			}
		});
		buttonPanel.add(btnCancel);

		JButton btnLaunch = new JButton("Launch");
		getRootPane().setDefaultButton(btnLaunch);
		btnLaunch.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Launch.
				try {
					//
					String parameter1 = (String) FlowNetworkInputWindow.this.comboBoxParameter1.getSelectedItem();
					String parameter2 = (String) FlowNetworkInputWindow.this.comboBoxParameter2.getSelectedItem();
					int minimalNumberOfLinks = (Integer) FlowNetworkInputWindow.this.spinnerMinimalNumberOfLinks.getValue();

					//
					lastParameter1 = parameter1;
					lastParameter2 = parameter2;
					lastMinimalValue = minimalNumberOfLinks;

					//
					if ((parameter1 == null) || (parameter2 == null)) {
						//
						String title = "Bad input";
						String message = "Please, enter none empty input.";

						//
						JOptionPane.showMessageDialog(FlowNetworkInputWindow.this.thisJFrame, message, title, JOptionPane.ERROR_MESSAGE);
					} else {
						Report report = ClusterNetworkReporter.reportFlowNetwork(netGUI.getSegmentation(), netGUI.getFile(), null, parameter1, parameter2,
								null, minimalNumberOfLinks);
						netGUI.addReportTab(report);
						dispose();
					}
				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(FlowNetworkInputWindow.this.thisJFrame, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		buttonPanel.add(btnLaunch);

		// ////////////////////////

		//
		this.spinnerMinimalNumberOfLinks.setValue(lastMinimalValue);
	}
}
