package org.tip.puckgui.models;

import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;

import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.table.AbstractTableModel;

import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.net.Family;
import org.tip.puck.net.Gender;
import org.tip.puck.net.Individual;
import org.tip.puckgui.InputSettings.CheckLevel;
import org.tip.puckgui.NetGUI;
import org.tip.puckgui.util.ComboBoxIds;

/**
 * 
 * @author TIP
 */
public class FamilyChildrenModel extends AbstractTableModel {
	private static final long serialVersionUID = 7713941886363202385L;
	private static final Logger logger = LoggerFactory.getLogger(FamilyChildrenModel.class);
	private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("org.tip.puckgui.messages");

	private static ImageIcon smallFemaleIcon = new ImageIcon(IndividualChildrenModel.class.getResource("/org/tip/puckgui/images/female-16x16.png"));
	private static ImageIcon smallMaleIcon = new ImageIcon(IndividualChildrenModel.class.getResource("/org/tip/puckgui/images/male-16x16.png"));
	private static ImageIcon smallUnknowIcon = new ImageIcon(IndividualChildrenModel.class.getResource("/org/tip/puckgui/images/unknown-16x16.png"));

	private Family source;
	private List<Individual> children;
	private NetGUI netGUI;

	/**
	 * 
	 */
	public FamilyChildrenModel(final NetGUI netGUI, final Family source) {
		super();

		this.netGUI = netGUI;
		this.source = source;
		if (source == null) {
			//
			this.children = new ArrayList<Individual>();

		} else {
			//
			this.children = this.source.getChildren().toListSortedByOrder();
		}
	}

	/**
	 * 
	 * @return
	 */
	public List<Individual> children() {
		List<Individual> result;

		result = this.children;

		//
		return result;
	}

	/**
	 * 
	 */
	public void escapeNewEdition() {
		//
		if (isNewEditionOn()) {
			//
			logger.debug("ESCAPE d");
			int index = this.children.size() - 1;
			this.children.remove(index);
			fireTableRowsDeleted(index, index);
		}
	}

	/**
	 * 
	 */
	@Override
	public Class getColumnClass(final int columnIndex) {
		Class result;

		switch (columnIndex) {
			case 0:
				result = Number.class;
			break;

			case 1:
				result = ImageIcon.class;
			break;

			case 2:
				result = String.class;
			break;

			case 3:
				result = Number.class;
			break;

			case 4:
				result = String.class;
			break;

			case 5:
				result = String.class;
			break;

			default:
				result = String.class;
		}

		//
		return result;
	}

	/**
	 * 
	 */
	@Override
	public int getColumnCount() {
		int result;

		result = 6;

		//
		return result;
	}

	/**
	 * 
	 */
	@Override
	public String getColumnName(final int columnIndex) {
		String result;

		switch (columnIndex) {
			case 0:
				result = BUNDLE.getString("MainWindow.individual.id");
			break;

			case 1:
				result = BUNDLE.getString("MainWindow.individual.gender");
			break;

			case 2:
				result = BUNDLE.getString("MainWindow.individual.name");
			break;

			case 3:
				result = BUNDLE.getString("MainWindow.individual.position");
			break;

			case 4:
				result = BUNDLE.getString("MainWindow.individual.birth");
			break;

			case 5:
				result = BUNDLE.getString("MainWindow.individual.death");
			break;

			default:
				result = "";
		}

		//
		return result;
	}

	/**
	 * 
	 */
	@Override
	public int getRowCount() {
		int result;

		result = this.children.size();

		//
		return result;
	}

	/**
	 * 
	 * @return
	 */
	public Family getSource() {
		Family result;

		result = this.source;

		//
		return result;
	}

	/**
	 * 
	 */
	@Override
	public Object getValueAt(final int rowIndex, final int columnIndex) {
		Object result;

		if (this.source == null) {
			//
			result = null;

		} else if ((isNewEditionOn() && (rowIndex == this.children.size() - 1))) {
			//
			result = "";

		} else {
			//
			switch (columnIndex) {
				case 0:
					result = this.children.get(rowIndex).getId();
				break;

				case 1:
					switch (this.children.get(rowIndex).getGender()) {
						case FEMALE:
							result = smallFemaleIcon;
						break;
						case MALE:
							result = smallMaleIcon;
						break;
						case UNKNOWN:
							result = smallUnknowIcon;
						break;
						default:
							result = smallUnknowIcon;
					}
				break;

				case 2:
					result = this.children.get(rowIndex).getName();
				break;

				case 3:
					result = this.children.get(rowIndex).getBirthOrder();
				break;

				case 4:
					result = null;
				break;

				case 5:
					result = null;
				break;

				default:
					result = null;
			}
		}

		//
		return result;
	}

	/**
	 * 
	 */
	@Override
	public boolean isCellEditable(final int row, final int col) {
		boolean result;

		switch (col) {
			case 0:
			case 3:
				result = true;
			break;

			default:
				result = false;
		}

		//
		return result;
	}

	/**
	 * This method indicates if a new line is editing.
	 * 
	 * @return
	 */
	public boolean isNewEditionOn() {
		boolean result;

		if (this.source == null) {
			//
			result = false;

		} else if (this.children.size() == this.source.getChildren().size() + 1) {
			//
			result = true;

		} else {
			//
			result = false;
		}

		//
		return result;
	}

	/**
	 * 
	 */
	public void setNewItem() {
		//
		this.children.add(new Individual(0, "?", Gender.UNKNOWN));
		fireTableDataChanged();
	}

	/**
	 * 
	 * @param source
	 */
	public void setSource(final Family source) {
		//
		this.source = source;

		//
		if (source == null) {
			//
			this.children = new ArrayList<Individual>();

		} else {
			//
			this.children = this.source.getChildren().toListSortedByOrder();
		}

		//
		fireTableDataChanged();
	}

	/**
	 * 
	 */
	@Override
	public void setValueAt(final Object value, final int rowIndex, final int columnIndex) {
		logger.debug("setValueAt(" + rowIndex + ", " + columnIndex + " " + value + ")");

		//
		if (columnIndex == 0) {
			if (this.netGUI != null) {
				//
				if (isNewEditionOn()) {
					Individual newChild = ComboBoxIds.getOrCreateIndividualFromInput(this.netGUI.getNet(), value, Gender.UNKNOWN);
					if (newChild == null) {
						this.children.remove(rowIndex);
						fireTableDataChanged();
					} else {
						// Check errors.
						String errorMessage = controlChildKin(CheckLevel.ERROR, this.source, newChild);
						if (errorMessage != null) {
							JOptionPane.showMessageDialog(null, errorMessage, "Error", JOptionPane.ERROR_MESSAGE);
						} else {
							// Check warning.
							String warningMessage = controlChildKin(CheckLevel.WARNING, this.source, newChild);
							if (warningMessage != null) {
								JOptionPane.showMessageDialog(null, warningMessage, "Warning", JOptionPane.WARNING_MESSAGE);
							}

							//
							this.netGUI.getNet().removeChild(newChild);
							this.netGUI.getNet().addChild(this.source, newChild);

							//
							this.netGUI.setChanged(true);
							this.netGUI.updateAll();
						}
					}
				} else {
					//
					Individual oldChild = this.children.get(rowIndex);
					Individual newChild = ComboBoxIds.getOrCreateIndividualFromInput(this.netGUI.getNet(), value, Gender.UNKNOWN);

					//
					if (newChild == null) {
						//
						this.netGUI.getNet().removeChild(oldChild);

						//
						this.netGUI.setChanged(true);
						this.netGUI.updateAll();
					} else {
						// Check errors.
						String errorMessage = controlChildKin(CheckLevel.ERROR, this.source, newChild);
						if (errorMessage != null) {
							JOptionPane.showMessageDialog(null, errorMessage, "Error", JOptionPane.ERROR_MESSAGE);
						} else {
							// Check warning.
							String warningMessage = controlChildKin(CheckLevel.WARNING, this.source, newChild);
							if (warningMessage != null) {
								JOptionPane.showMessageDialog(null, warningMessage, "Warning", JOptionPane.WARNING_MESSAGE);
							}

							if (newChild != oldChild) {
								//
								Family currentFamily = oldChild.getOriginFamily();
								this.netGUI.getNet().removeChild(oldChild);
								this.netGUI.getNet().removeChild(newChild);
								this.netGUI.getNet().addChild(currentFamily, newChild);

								//
								this.netGUI.setChanged(true);
								this.netGUI.updateAll();
							}
						}
					}
				}
			}
		} else if (columnIndex == 3) {
			//
			Integer newBirthOrderValue;
			if (value instanceof String) {
				//
				if (NumberUtils.isDigits((String) value)) {
					//
					newBirthOrderValue = Integer.parseInt((String) value);

				} else {
					//
					newBirthOrderValue = null;
				}
			} else if (value instanceof Integer) {
				//
				newBirthOrderValue = (Integer) value;

			} else {
				//
				newBirthOrderValue = null;
			}

			//
			if ((newBirthOrderValue == null) || (newBirthOrderValue > 0)) {
				//
				Individual currentIndividual = this.netGUI.selectedIndividual();
				Individual child = this.children.get(rowIndex);

				//
				child.setBirthOrder(newBirthOrderValue);

				//
				this.netGUI.setChanged(true);
				this.netGUI.updateAll();
			}
		}
	}

	/**
	 * 
	 * @return
	 */
	public Family source() {
		Family result;

		result = this.source;

		//
		return result;
	}

	/**
	 * 
	 * @param level
	 * @param family
	 * @param children
	 * @return
	 */
	public static String controlChildKin(final CheckLevel level, final Family family, final Individual child) {
		String result;

		if ((level == null) || (family == null)) {
			//
			result = null;

		} else if (family.isOrphan()) {
			//
			result = null;

		} else {
			//
			result = IndividualChildrenModel.controlChildKin(level, family.getFather(), family, child);
		}

		//
		return result;
	}
}
