package org.tip.puck.sequences;

import org.tip.puck.census.chains.Chain;
import org.tip.puck.census.workers.CircuitFinder;
import org.tip.puck.census.workers.RestrictionType;
import org.tip.puck.census.workers.SymmetryType;
import org.tip.puck.partitions.MultiPartition;
import org.tip.puck.report.Report;
import org.tip.puck.report.ReportChart;
import org.tip.puck.report.ReportTable;
import org.tip.puck.util.Chronometer;

public class SequenceReporter {
	
	public static Report reportSequences (Sequences sequences){
		Report result;
		
		//
		Chronometer chrono = new Chronometer();

		//
		result = new Report();
		result.setTitle("Sequence report");
		result.setOrigin("Sequence reporter");

		Report report1 = new Report("Sequence list");
		
		for (Sequence sequence : sequences){
			report1.outputs().appendln(sequence.getId());
			for (String order : sequence.getEvents().keySet()){
				report1.outputs().appendln(order+"\t"+sequence.getEvents().get(order).getName());
			}
			report1.outputs().appendln();
		}
		
		result.outputs().append(report1);
		
		Report report2 = new Report("Actor-Event tables");
		
		for (Sequence sequence : sequences){
			report2.outputs().append(sequence.roleTable());
			report2.outputs().appendln();
		}
		
		result.outputs().append(report2);

		Report report3 = new Report("Actor-Event tables");
		
		for (Sequence sequence : sequences){
			report3.outputs().append(sequence.interactionTable());
			report3.outputs().appendln();
		}
		
		result.outputs().append(report3);

		//
		result.setTimeSpent(chrono.stop().interval());

		//
		return result;
	}

}
