package org.tip.puck.sequences;

import java.util.Map;
import java.util.TreeMap;

import org.tip.puck.net.Individual;
import org.tip.puck.net.Individuals;
import org.tip.puck.net.relations.Actor;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.net.relations.Roles;
import org.tip.puck.report.ReportTable;
import org.tip.puck.util.MathUtils;
import org.tip.puck.util.Numberable;
import org.tip.puck.util.Value;

public class Sequence implements Comparable<Sequence>, Numberable {
	
	int id;
	Map<String,Relation> events;
	
	public Sequence (int id){
		this.id = id;
		events = new TreeMap<String,Relation>(); 
	}
	
	public Roles getRoles(){
		Roles result;
		
		result = new Roles();
		
		for (Relation relation : events.values()){
			for (Actor actor : relation.actors()){
				if (!result.contains(actor.getRole())) {
					result.add(actor.getRole());
				}
			}
		}
		//
		return result;
	}
	
	public Individuals individuals(){
		Individuals result;
		
		result = new Individuals();
		for (Relation relation : events.values()){
			for (Actor actor : relation.actors()){
				if (!result.contains(actor.getIndividual())) {
					result.add(actor.getIndividual());
				}
			}
		}
		//
		return result;
		
	}
	

	
	/**
	 * 
	 * @param partitions
	 * @return
	 */
	public ReportTable roleTable() {
		ReportTable result;
		
		Individuals individuals = individuals();

		//
		result = new ReportTable(events.size() + 1, individuals.size() + 1);

		//
		{
			result.set(0, 0, id);
			int columnIndex = 1;
			for (Individual individual: individuals) {
				result.set(0, columnIndex, individual.getName());
				columnIndex += 1;
			}

			//
			int rowIndex = 1;
			for (String eventOrder : events.keySet()) {
				result.set(rowIndex, 0, eventOrder);
				columnIndex = 1;
				Relation event = events.get(eventOrder);
				for (Individual individual: individuals) {
					String rolesAsString = " - ";
					Roles roles = event.actors().getRoles(individual.getId());
					if (roles != null && roles.size()>0){
						rolesAsString = roles.nameList().toString();
					}
					result.set(rowIndex, columnIndex, rolesAsString);
					columnIndex += 1;
				}
				rowIndex += 1;
			}
		}
		//
		return result;
	}
	
	/**
	 * 
	 * @param partitions
	 * @return
	 */
	public ReportTable interactionTable() {
		ReportTable result;
		
		Individuals individuals = individuals();

		//
		result = new ReportTable(individuals.size() + 1, individuals.size() + 1);

		//
		{
			result.set(0, 0, id);
			int columnIndex = 1;
			for (Individual individual: individuals) {
				result.set(0, columnIndex, individual.getName());
				columnIndex += 1;
			}

			//
			int rowIndex = 1;
			for (Individual individual1: individuals) {
				result.set(rowIndex, 0, individual1.getName());
				columnIndex = 1;
				for (Individual individual2: individuals) {
					if (columnIndex>=rowIndex){
						break;
					}
					String roles1AsString = "";
					String roles2AsString = "";
					for (String eventOrder : events.keySet()){
						Relation event = events.get(eventOrder);
						Roles roles1 = event.actors().getRoles(individual1.getId());
						Roles roles2 = event.actors().getRoles(individual2.getId());
						if (roles1 != null && roles1.size()>0 && roles2 != null && roles2.size()>0){
							roles1AsString += roles1.nameList().toString();
							roles2AsString += roles2.nameList().toString();
						}
					}
					result.set(rowIndex, columnIndex, roles1AsString);
					result.set(columnIndex, rowIndex, roles2AsString);
					columnIndex += 1;
				}
				rowIndex += 1;
			}
		}
		//
		return result;
	}
	
	public void put(String order, Relation relation){
		events.put(order, relation);
	}
	

	public Map<String, Relation> getEvents() {
		return events;
	}

	@Override
	public int getId() {
		return id;
	}

	@Override
	public void setId(int id) {
		this.id = id;
	}

	@Override
	public String hashKey() {
		return id + "";
	}

	@Override
	public int compareTo(Sequence sequence) {
		return Integer.compare(this.id, sequence.id);
	}

}
