package org.tip.puck.net.workers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.tip.puck.net.Attribute;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.net.relations.Relations;
import org.tip.puck.util.NumberedValues;
import org.tip.puck.util.Value;

/**
 * 
 * @author TIP
 */
public class RelationValuator {

	public enum EndogenousLabel {
		ID
	}

	public static final Pattern YEAR_PATTERN = Pattern.compile("(\\d\\d\\d\\d)");

	/**
	 * 
	 * @param source
	 * @return
	 */
	public static String extractYear(final String source) {
		String result;

		Matcher matcher = YEAR_PATTERN.matcher(source);
		if ((matcher.find()) && (matcher.groupCount() > 0)) {
			//
			result = matcher.group(1);
		} else {
			result = null;
		}

		//
		return result;
	}

	/**
	 * 
	 * @param individual
	 * @param label
	 * @return
	 */
	public static Value get(final Relation source, final String label) {
		Value result;

		result = get(source, label, null);

		//
		return result;
	}

	/**
	 * 
	 * @param individual
	 * @param label
	 * 
	 * @return
	 */
	public static Value get(final Relation source, final String label, final Object parameter) {
		Value result;

		//
		EndogenousLabel enogenousLabel;
		try {
			enogenousLabel = EndogenousLabel.valueOf(label.replace(" ", "_"));
		} catch (IllegalArgumentException exception) {
			enogenousLabel = null;
		}

		if (enogenousLabel == null) {
			String attributeValue = source.getAttributeValue(label);

			if (attributeValue == null) {
				result = null;
			} else {
				if (label.toUpperCase().contains("DATE")) {
					String year = extractYear(attributeValue);
					if (year == null) {
						result = null;
					} else {
						result = new Value(Integer.parseInt(year));
					}
				} else {
					result = new Value(attributeValue);
				}
			}
		} else {
			switch (enogenousLabel) {
				case ID:
					result = new Value(source.getId());
				break;
				default:
					result = null;
			}
		}

		//
		return result;
	}

	/**
	 * This method is a helper one.
	 * 
	 * @param individual
	 * @param label
	 * @return
	 */
	public static NumberedValues get(final Relations source, final String label) {
		NumberedValues result;

		result = get(source, label, null);

		//
		return result;
	}

	/**
	 * 
	 * @param individual
	 * @param label
	 * @return
	 */
	public static NumberedValues get(final Relations source, final String label, final Object parameter) {
		NumberedValues result;

		//
		result = new NumberedValues();

		for (Relation relation : source) {
			result.put(relation.getId(), get(relation, label, parameter));
		}

		//
		return result;
	}

	/**
	 * 
	 * @param individuals
	 * @return
	 */
	public static List<String> getAttributeLabels(final Relations source) {
		List<String> result;

		result = getAttributeLabels(source, null);

		//
		return result;
	}

	/**
	 * @param individuals
	 * @return
	 */
	public static List<String> getAttributeLabels(final Relations source, final Integer limit) {
		List<String> result;

		//
		result = new ArrayList<String>(20);

		//
		for (EndogenousLabel label : EndogenousLabel.values()) {
			result.add(label.toString());
		}

		//
		result.addAll(getExogenousAttributeLabels(source, limit));

		//
		Collections.sort(result);

		//
		return result;
	}

	/**
	 * 
	 * @param individuals
	 * @return
	 */
	public static List<String> getAttributeLabelSample(final Relations source) {
		List<String> result;

		result = getAttributeLabels(source, 10000);

		//
		return result;
	}

	/**
	 * @param individuals
	 * @return
	 */
	public static List<String> getExogenousAttributeLabels(final Relations source) {
		List<String> result;

		//
		result = getExogenousAttributeLabels(source, null);

		//
		return result;
	}

	/**
	 * @param individuals
	 * @return
	 */
	public static List<String> getExogenousAttributeLabels(final Relations source, final Integer limit) {
		List<String> result;

		//
		result = new ArrayList<String>(20);

		//
		HashSet<String> buffer = new HashSet<String>();
		if (source != null) {
			int index = 0;
			Iterator<Relation> iterator = source.iterator();
			while ((iterator.hasNext()) && ((limit == null) || (index < limit))) {
				Relation relation = iterator.next();
				for (Attribute attribute : relation.attributes()) {
					buffer.add(attribute.getLabel());
				}
			}
		}

		for (String string : buffer) {
			result.add(string);
		}

		//
		Collections.sort(result);

		//
		return result;
	}

}
