package org.tip.puck.net.relations;

import org.tip.puck.net.Individual;

/**
 * 
 * @author TIP
 */
public class Actor {

	private Individual individual;
	private Integer relationOrder; // Relation order for the individual in this
									// role.
	private Role role;

	/**
	 * 
	 * @param individual
	 * @param role
	 */
	public Actor(final Individual individual, final Role role) {
		//
		this.individual = individual;
		this.role = role;
	}

	/**
	 * 
	 */
	@Override
	public boolean equals(final Object actor) {
		return this.role.equals(((Actor) actor).role) && this.individual.equals(((Actor) actor).individual);

	}

	/**
	 * 
	 * @return
	 */
	public int getId() {
		int result;

		result = this.individual.getId();

		//
		return result;
	}

	public Individual getIndividual() {
		return this.individual;
	}

	/**
	 * 
	 * @return
	 */
	public String getName() {
		String result;

		result = this.individual.getName();

		//
		return result;
	}

	public Integer getRelationOrder() {
		return this.relationOrder;
	}

	public Role getRole() {
		return this.role;
	}

	public void setIndividual(final Individual individual) {
		this.individual = individual;
	}

	public void setRelationOrder(final Integer order) {
		this.relationOrder = order;
	}

	public void setRole(final Role role) {
		this.role = role;
	}

}
