package oldcore.calc.partitions;

import java.util.ArrayList;

import org.tip.puck.net.Attribute;

public class ClusterChain extends ArrayList<Cluster> implements
		Clusterable, Comparable<ClusterChain> {
	
	private int numberOfLinks;
	private int numberOfCircuits;
	private String circuitType;
	
	
	public ClusterChain (Cluster first, int numberOfLinks, int numberOfCircuits){
		add(first);
		this.numberOfLinks = numberOfLinks;
		this.numberOfCircuits = numberOfCircuits;
	}

	public ClusterChain (Cluster first, Cluster second, int numberOfLinks, int numberOfCircuits){
		add(first);
		add(second);
		this.numberOfLinks = numberOfLinks;
		this.numberOfCircuits = numberOfCircuits;
	}

	public ClusterChain (Cluster first, Cluster second, Cluster third, int numberOfLinks, int numberOfCircuits){
		add(first);
		add(second);
		add(third);
		this.numberOfLinks = numberOfLinks;
		this.numberOfCircuits = numberOfCircuits;
	}
	
	public String signature(){
		String result = "";
		
		for (Cluster cluster : this){
			result = result + cluster.getVal()+ "\t";
		}
		//
		return result;
	}

	@Override
	public Object getAttributeValue(String circuitType) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public void setAttribute(Attribute attribute) {
		// TODO Auto-generated method stub

	}

	public int getNumberOfLinks() {
		return numberOfLinks;
	}

	public int getNumberOfCircuits() {
		return numberOfCircuits;
	}

	public String getCircuitType() {
		return circuitType;
	}

	public void setNumberOfLinks(int numberOfLinks) {
		this.numberOfLinks = numberOfLinks;
	}

	public void setNumberOfCircuits(int numberOfCircuits) {
		this.numberOfCircuits = numberOfCircuits;
	}

	public void setCircuitType(String circuitType) {
		this.circuitType = circuitType;
	}

	@Override
	public int compareTo(ClusterChain other) {
		int comp = new Integer(size()).compareTo(other.size());
		if (comp==0){
			for (int i=0;i<size();i++){
				comp = get(i).compareTo(other.get(i));
				if (comp!=0) break;
			}
		}
		return comp;
	}

}
