/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.visualization.layouts.sugiyama;

import java.awt.Color;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Random;
import java.util.Set;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.EdgeIterable;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.MixedGraph;
import org.gephi.graph.api.Node;
import org.gephi.layout.plugin.AbstractLayout;
import org.gephi.layout.spi.LayoutBuilder;
import org.gephi.layout.spi.LayoutProperty;
import org.tip.puck.visualization.layouts.GraphSource;
import org.tip.puck.visualization.layouts.sugiyama.NodeWrapper;

public class SugiyamaLayout
extends AbstractLayout {
    private static final Orientation DEFAULT_ORIENTATION = Orientation.TOP;
    private static final int DEFAULT_HORIZONTAL_SPACING = 100;
    private static final int DEFAULT_VERTICAL_SPACING = -500;
    private static final int DEFAULT_MARRIED_HORIZONTAL_SPACING = 50;
    private static final int DEFAULT_MARRIED_VERTICAL_SPACING = 100;
    private int gridAreaSize = Integer.MIN_VALUE;
    private int horzSpacing = 100;
    private int vertSpacing = -500;
    private Orientation orientation = DEFAULT_ORIENTATION;
    private boolean executing = false;
    private GraphSource graphSource;
    private Set<Node> traversalSet = new HashSet<Node>();
    private LinkedList<LinkedList<Node>> levels;
    private LinkedList<Node> roots;
    private Set<Node> marriedNodes = new HashSet<Node>();

    public SugiyamaLayout(LayoutBuilder layoutBuilder) {
        super(layoutBuilder);
    }

    public void setGraphModel(GraphModel graphModel) {
        super.setGraphModel(graphModel);
        this.graphSource = new GraphSource(graphModel.getMixedGraph());
    }

    public LayoutProperty[] getProperties() {
        return null;
    }

    public void resetPropertiesValues() {
    }

    private void setColor(Node node, float[] rgbColor) {
        node.getNodeData().setR(rgbColor[0]);
        node.getNodeData().setG(rgbColor[1]);
        node.getNodeData().setB(rgbColor[2]);
    }

    private float[] getColor(Node node) {
        float[] rgbColor = new float[]{node.getNodeData().r(), node.getNodeData().g(), node.getNodeData().b()};
        return rgbColor;
    }

    private float[] randomPastelColor() {
        Random random = new Random();
        float hue = random.nextFloat();
        float saturation = 0.9f;
        float luminance = 1.0f;
        Color hsbColor = Color.getHSBColor(hue, 0.9f, 1.0f);
        float[] rgb = new float[]{1.0f * (float)hsbColor.getRed() / 255.0f, 1.0f * (float)hsbColor.getGreen() / 255.0f, 1.0f * (float)hsbColor.getBlue() / 255.0f};
        return rgb;
    }

    public void initAlgo() {
        this.executing = true;
        this.searchRoots();
    }

    public void goAlgo() {
        if (!this.executing) {
            return;
        }
        this.fillLevels(this.roots);
        System.out.println("levels height: " + this.levels.size());
        for (LinkedList linkedList : this.levels) {
            System.out.println("level size " + linkedList.size());
        }
        this.solveEdgeCrosses(this.levels);
        this.moveToBarycenter(this.levels);
        System.out.println("Place");
        for (LinkedList linkedList : this.levels) {
            for (Node node : linkedList) {
                NodeWrapper wrapper = NodeWrapper.getData(node);
                if (this.orientation.equals((Object)Orientation.TOP)) {
                    float xCoordinate = 10.0f + 1.0f * (float)(wrapper.getGridPosition() * this.horzSpacing);
                    float yCoordinate = 10.0f + 1.0f * (float)(wrapper.getLevel() * this.vertSpacing);
                    node.getNodeData().setX(xCoordinate);
                    node.getNodeData().setY(yCoordinate);
                    continue;
                }
                float yCoordinate = 10.0f + 1.0f * (float)(wrapper.getGridPosition() * this.vertSpacing);
                float xCoordinate = 10.0f + 1.0f * (float)(wrapper.getLevel() * this.horzSpacing);
                node.getNodeData().setX(xCoordinate);
                node.getNodeData().setY(yCoordinate);
            }
        }
        this.moveMarriedNodes();
    }

    public void endAlgo() {
        Node[] nodes;
        this.traversalSet.clear();
        MixedGraph graph = this.graphModel.getMixedGraph();
        graph.readLock();
        Node[] nodeArray = nodes = graph.getNodes().toArray();
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeArray[n2];
            NodeWrapper.clean(node);
            ++n2;
        }
        graph.readUnlock();
        this.roots.clear();
        this.levels.clear();
        this.marriedNodes.clear();
        this.executing = false;
    }

    private void moveMarriedNodes() {
        MixedGraph graph = this.graphModel.getMixedGraph();
        for (Node node : this.marriedNodes) {
            float cX = 0.0f;
            float cY = 0.0f;
            int counter = 0;
            EdgeIterable edges = graph.getEdges(node);
            for (Edge edge : edges) {
                if (edge.isDirected()) continue;
                Node opposite = graph.getOpposite(node, edge);
                cX += opposite.getNodeData().x();
                cY += opposite.getNodeData().y();
                ++counter;
            }
            if (counter > 1) {
                node.getNodeData().setX(cX / ((float)counter * 1.0f));
                node.getNodeData().setY(cY / ((float)counter * 1.0f));
                continue;
            }
            if (counter != true) continue;
            node.getNodeData().setX(cX + 50.0f);
            node.getNodeData().setY(cY + 100.0f);
        }
    }

    private void searchRoots() {
        Node[] nodes;
        this.roots = new LinkedList();
        MixedGraph graph = this.graphModel.getMixedGraph();
        graph.readLock();
        Node[] nodeArray = nodes = graph.getNodes().toArray();
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeArray[n2];
            node.getNodeData().setX(0.0f);
            node.getNodeData().setY(5000.0f);
            Set<Node> parents = this.graphSource.getParents(node);
            if (parents.isEmpty()) {
                if (!this.graphSource.getChildren(node).isEmpty()) {
                    this.roots.add(node);
                } else {
                    this.marriedNodes.add(node);
                    node.getNodeData().setColor(0.0f, 0.0f, 0.0f);
                }
            }
            ++n2;
        }
        graph.readUnlock();
    }

    private void fillLevels(LinkedList<Node> roots) {
        this.levels = new LinkedList();
        this.traversalSet.clear();
        for (Node root : roots) {
            this.setColor(root, this.randomPastelColor());
            this.fillLevels(this.levels, 0, root);
        }
    }

    private void fillLevels(LinkedList<LinkedList<Node>> levels, int level, Node rootNode) {
        if (rootNode == null) {
            return;
        }
        if (levels.size() == level) {
            levels.add(level, new LinkedList());
        }
        if (this.traversalSet.contains(rootNode)) {
            return;
        }
        this.traversalSet.add(rootNode);
        LinkedList<Node> currentLevel = levels.get(level);
        int numberForTheEntry = currentLevel.size();
        NodeWrapper wrapper = new NodeWrapper(level, numberForTheEntry);
        NodeWrapper.initData(rootNode, wrapper);
        currentLevel.add(rootNode);
        Set<Node> children = this.graphSource.getChildren(rootNode);
        for (Node child : children) {
            this.setColor(child, this.getColor(rootNode));
            this.fillLevels(levels, level + 1, child);
        }
        if (currentLevel.size() > this.gridAreaSize) {
            this.gridAreaSize = currentLevel.size();
        }
    }

    private void solveEdgeCrosses(LinkedList<LinkedList<Node>> levels) {
        int movementsCurrentLoop = -1;
        while (movementsCurrentLoop != 0) {
            movementsCurrentLoop = 0;
            int i = 0;
            while (i < levels.size() - 1) {
                movementsCurrentLoop += this.solveEdgeCrosses(true, levels, i);
                ++i;
            }
            i = levels.size() - 1;
            while (i >= 0) {
                movementsCurrentLoop += this.solveEdgeCrosses(false, levels, i);
                --i;
            }
        }
    }

    private int solveEdgeCrosses(boolean down, LinkedList<LinkedList<Node>> levels, int levelIndex) {
        LinkedList<Node> currentLevel = levels.get(levelIndex);
        int movements = 0;
        Node[] levelSortBefore = currentLevel.toArray(new Node[currentLevel.size()]);
        Collections.sort(currentLevel, new Comparator<Node>(){

            @Override
            public int compare(Node o1, Node o2) {
                return NodeWrapper.getData(o1).compareTo(NodeWrapper.getData(o2));
            }
        });
        int j = 0;
        while (j < levelSortBefore.length) {
            if (NodeWrapper.getData(levelSortBefore[j]).getEdgeCrossesIndicator() != NodeWrapper.getData(currentLevel.get(j)).getEdgeCrossesIndicator()) {
                ++movements;
            }
            ++j;
        }
        j = currentLevel.size() - 1;
        while (j >= 0) {
            Node sourceNode = currentLevel.get(j);
            NodeWrapper sourceWrapper = NodeWrapper.getData(sourceNode);
            Collection<Edge> edgeList = this.graphSource.getNeighbourEdges(sourceNode);
            for (Edge edge : edgeList) {
                Node targetNode = null;
                if (down && sourceNode == edge.getSource()) {
                    targetNode = edge.getTarget();
                }
                if (!down && sourceNode == edge.getTarget()) {
                    targetNode = edge.getSource();
                }
                if (targetNode == null) continue;
                NodeWrapper targetWrapper = NodeWrapper.getData(targetNode);
                if (down && targetWrapper != null && targetWrapper.getLevel() > levelIndex) {
                    targetWrapper.addToEdgeCrossesIndicator(sourceWrapper.getEdgeCrossesIndicator());
                }
                if (down || targetWrapper == null || targetWrapper.getLevel() >= levelIndex) continue;
                targetWrapper.addToEdgeCrossesIndicator(sourceWrapper.getEdgeCrossesIndicator());
            }
            --j;
        }
        return movements;
    }

    private void moveToBarycenter(LinkedList<LinkedList<Node>> levels) {
        int n;
        Node[] nodes;
        System.out.println("moveToBarycenter");
        MixedGraph graph = this.graphModel.getMixedGraph();
        graph.readLock();
        Node[] nodeArray = nodes = graph.getNodes().toArray();
        int n2 = nodes.length;
        int n22 = 0;
        while (n22 < n2) {
            Node node = nodeArray[n22];
            NodeWrapper currentwrapper = NodeWrapper.getData(node);
            Collection<Edge> edgeList = this.graphSource.getNeighbourEdges(node);
            for (Edge edge : edgeList) {
                Node neighbourNode = null;
                if (node == edge.getSource()) {
                    neighbourNode = edge.getTarget();
                } else if (node == edge.getTarget()) {
                    neighbourNode = edge.getSource();
                }
                if (neighbourNode == null || neighbourNode == node) continue;
                NodeWrapper neighbourWrapper = NodeWrapper.getData(neighbourNode);
                if (currentwrapper == null || neighbourWrapper == null || currentwrapper.getLevel() == neighbourWrapper.getLevel()) continue;
                currentwrapper.incrementPriority();
            }
            ++n22;
        }
        graph.readUnlock();
        for (LinkedList linkedList : levels) {
            int pos = 0;
            for (Node node : linkedList) {
                NodeWrapper.getData(node).setGridPosition(pos++);
            }
        }
        int n3 = -1;
        while (n != 0) {
            n = 0;
            int i = 0;
            while (i < levels.size()) {
                n += this.moveToBarycenter(levels, i);
                ++i;
            }
            i = levels.size() - 1;
            while (i >= 0) {
                n += this.moveToBarycenter(levels, i);
                --i;
            }
        }
    }

    private int moveToBarycenter(LinkedList<LinkedList<Node>> levels, int levelIndex) {
        int movements = 0;
        LinkedList<Node> currentLevel = levels.get(levelIndex);
        int currentIndexInTheLevel = 0;
        while (currentIndexInTheLevel < currentLevel.size()) {
            Node node = currentLevel.get(currentIndexInTheLevel);
            NodeWrapper sourceWrapper = NodeWrapper.getData(node);
            float gridPositionsSum = 0.0f;
            float countNodes = 0.0f;
            Collection<Edge> edgeList = this.graphSource.getNeighbourEdges(node);
            for (Edge edge : edgeList) {
                NodeWrapper targetWrapper;
                Node neighbourNode = null;
                if (node == edge.getSource()) {
                    neighbourNode = edge.getTarget();
                } else if (node == edge.getSource()) {
                    neighbourNode = edge.getTarget();
                }
                if (neighbourNode == null || (targetWrapper = NodeWrapper.getData(neighbourNode)) == sourceWrapper && targetWrapper != null && targetWrapper.getLevel() != levelIndex) continue;
                gridPositionsSum += (float)targetWrapper.getGridPosition();
                countNodes += 1.0f;
            }
            if (countNodes > 0.0f) {
                float tmp = gridPositionsSum / countNodes;
                int newGridPosition = Math.round(tmp);
                boolean toRight = newGridPosition > sourceWrapper.getGridPosition();
                boolean moved = true;
                while (newGridPosition != sourceWrapper.getGridPosition() && moved) {
                    moved = this.move(toRight, currentLevel, currentIndexInTheLevel, sourceWrapper.getPriority());
                    if (!moved) continue;
                    ++movements;
                }
            }
            ++currentIndexInTheLevel;
        }
        return movements;
    }

    private boolean move(boolean toRight, LinkedList<Node> currentLevel, int currentIndexInTheLevel, int currentPriority) {
        NodeWrapper currentWrapper = NodeWrapper.getData(currentLevel.get(currentIndexInTheLevel));
        boolean moved = false;
        int neighbourIndexInTheLevel = currentIndexInTheLevel + (toRight ? 1 : -1);
        int newGridPosition = currentWrapper.getGridPosition() + (toRight ? 1 : -1);
        if (newGridPosition < 0 || newGridPosition >= this.gridAreaSize) {
            return false;
        }
        if (toRight && currentIndexInTheLevel == currentLevel.size() - 1 || !toRight && currentIndexInTheLevel == 0) {
            moved = true;
        } else {
            NodeWrapper neighbourWrapper = NodeWrapper.getData(currentLevel.get(neighbourIndexInTheLevel));
            int neighbourPriority = neighbourWrapper.getPriority();
            if (neighbourWrapper.getGridPosition() == newGridPosition) {
                if (neighbourPriority >= currentPriority) {
                    return false;
                }
                moved = this.move(toRight, currentLevel, neighbourIndexInTheLevel, currentPriority);
            } else {
                moved = true;
            }
        }
        if (moved) {
            currentWrapper.setGridPosition(newGridPosition);
        }
        return moved;
    }

    public static enum Orientation {
        TOP,
        LEFT;

    }
}

