/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.visualization.layouts.hierarchical.datastructs.partition;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.tip.puck.visualization.layouts.hierarchical.datastructs.partition.PartitionItem;

public class Partition<E> {
    final Map<E, PartitionItem<E>> partitionsMap = new HashMap<E, PartitionItem<E>>();

    public Partition() {
    }

    public Partition(Collection<? extends E> elements) {
        this();
        if (elements != null) {
            for (E element : elements) {
                super.unsafeAdd(element);
            }
        }
    }

    private void unsafeAdd(E element) {
        PartitionItem<E> singletonPartition = PartitionItem.singleton(element);
        this.partitionsMap.put(element, singletonPartition);
    }

    public boolean add(E element) {
        boolean result = false;
        if (!this.partitionsMap.containsKey(element)) {
            PartitionItem<E> singletonPartition = PartitionItem.singleton(element);
            this.partitionsMap.put(element, singletonPartition);
            result = true;
        }
        return result;
    }

    public boolean contains(E element) {
        return this.partitionsMap.containsKey(element);
    }

    public PartitionItem<E> getPartition(E element) {
        return this.partitionsMap.get(element);
    }

    public PartitionItem<E> getPartition(E element, boolean initialize) {
        if (initialize) {
            this.add(element);
        }
        return this.partitionsMap.get(element);
    }

    public Set<PartitionItem<E>> getRoots() {
        HashSet roots = new HashSet();
        Collection<PartitionItem<E>> values = this.partitionsMap.values();
        HashSet<PartitionItem<E>> temp = new HashSet<PartitionItem<E>>(values);
        while (!temp.isEmpty()) {
            PartitionItem partitionItem = (PartitionItem)temp.iterator().next();
            PartitionItem pRoot = partitionItem.find();
            roots.add(pRoot);
            boolean canGo = true;
            while (canGo && pRoot != null) {
                canGo = temp.remove(pRoot);
                pRoot = pRoot.getChild();
            }
            if (!temp.contains(partitionItem) && canGo) continue;
            System.out.println("Unexpected");
        }
        return roots;
    }

    public Set<PartitionItem<E>> getNonSingletonRoots() {
        HashSet roots = new HashSet();
        Collection<PartitionItem<E>> values = this.partitionsMap.values();
        HashSet<PartitionItem<E>> temp = new HashSet<PartitionItem<E>>(values);
        while (!temp.isEmpty()) {
            PartitionItem partitionItem = (PartitionItem)temp.iterator().next();
            PartitionItem pRoot = partitionItem.find();
            if (!pRoot.isSingleton()) {
                roots.add(pRoot);
                boolean canGo = true;
                while (canGo && pRoot != null) {
                    canGo = temp.remove(pRoot);
                    pRoot = pRoot.getChild();
                }
                if (!temp.contains(partitionItem) && canGo) continue;
                System.out.println("Unexpected");
                continue;
            }
            temp.remove(pRoot);
        }
        return roots;
    }

    public PartitionItem<E> merge(PartitionItem<E> a, PartitionItem<E> b) {
        if (Partition.areMerged(a, b)) {
            return a.find();
        }
        return b.merge(a);
    }

    public static <E> PartitionItem<E> copySubset(PartitionItem<E> element) {
        if (element == null) {
            return null;
        }
        PartitionItem<E> lastSubsetChild = Partition.getLastSubsetChild(element);
        if (lastSubsetChild == null) {
            return null;
        }
        PartitionItem<E> newRoot = PartitionItem.singleton(element.value());
        boolean canGo = !lastSubsetChild.equals(element);
        for (PartitionItem<E> temp = element.getChild(); canGo && temp != null; temp = temp.getChild()) {
            PartitionItem<E> subsetCopy = Partition.copySubset(temp);
            if (subsetCopy != null) {
                newRoot.append(subsetCopy);
                canGo = !lastSubsetChild.equals(temp);
                continue;
            }
            return null;
        }
        return newRoot;
    }

    public static <E> PartitionItem<E> getLastSubsetChild(PartitionItem<E> element) {
        if (element == null) {
            return null;
        }
        int rank = element.getRank();
        if (rank == 0) {
            return element;
        }
        if (rank == 1) {
            if (element.getChild() != null) {
                return element.getChild().getRank() == 0 ? element.getChild() : null;
            }
            return element.getChild();
        }
        PartitionItem<E> temp = element.getChild();
        while (temp != null && rank > 0) {
            PartitionItem<E> last = Partition.getLastSubsetChild(temp);
            if (last != null) {
                temp = --rank == 0 ? last : last.getChild();
                continue;
            }
            System.out.println("Unexpected");
            temp = null;
        }
        return rank == 0 ? temp : null;
    }

    private List<PartitionItem<E>> children(E element) {
        PartitionItem<E> partition = this.partitionsMap.get(element);
        if (partition == null) {
            return null;
        }
        ArrayList<PartitionItem<PartitionItem<E>>> result = new ArrayList<PartitionItem<PartitionItem<E>>>();
        Collection<PartitionItem<E>> allPartitions = this.partitionsMap.values();
        for (PartitionItem<E> partitionItem : allPartitions) {
            if (!partitionItem.getParent().equals(partition)) continue;
            result.add(partitionItem);
        }
        return result;
    }

    public Collection<E> toList() {
        ArrayList<E> list = new ArrayList<E>();
        Set<PartitionItem<E>> roots = this.getRoots();
        for (PartitionItem<E> rootPartition : roots) {
            List<E> values = rootPartition.values();
            if (values == null || values.isEmpty()) continue;
            System.out.println("values size: " + values.size());
            list.addAll(values);
        }
        System.out.println("list size: " + list.size());
        return list;
    }

    private static <E> List<E> values(PartitionItem<E> partition) {
        PartitionItem<E> rep = partition.find();
        PartitionItem<E> tmp = rep.getChild();
        LinkedList<E> retSet = new LinkedList<E>();
        while (tmp != null) {
            retSet.add(tmp.value());
            tmp = tmp.getChild();
        }
        return retSet;
    }

    public static boolean areMerged(PartitionItem<?> partition1, PartitionItem<?> partition2) {
        return partition1.find() == partition2.find();
    }

    public static void main(String ... args) {
        Partition<Integer> part = new Partition<Integer>();
        part.add(1);
        part.add(2);
        part.add(3);
        part.add(4);
        part.add(5);
        part.add(6);
        part.add(7);
        part.add(8);
        PartitionItem<Integer> first = part.getPartition(2).merge(part.getPartition(1));
        System.out.println("{1} U {2}");
        Partition.print(first);
        System.out.println("{3} U {4}");
        Partition.print(part.getPartition(4).merge(part.getPartition(3)));
        first = part.merge(first, part.getPartition(3));
        System.out.println("{1,2} U {3,4}");
        Partition.print(first);
        PartitionItem<Integer> second = part.getPartition(6).merge(part.getPartition(5));
        System.out.println("{1,2,3,4} U {7}");
        Partition.print(part.getPartition(7).merge(first));
        System.out.println("{1,2,3,4,7} U {8}");
        Partition.print(part.getPartition(8).merge(first));
        System.out.println("{1,2,3,4,7,8} U {5,6}");
        Partition.print(part.getPartition(5).merge(first));
    }

    public static void print(PartitionItem<Integer> item) {
        PartitionItem<Integer> root = item;
        while (root != null) {
            PartitionItem<Integer> last = Partition.getLastSubsetChild(root);
            System.out.println("root: " + root.value() + " (" + root.getParent().value() + ") last: " + last.value() + " rank: " + root.getRank());
            root = root.getChild();
        }
    }
}

