/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net.relations;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.tip.puck.net.Attribute;
import org.tip.puck.net.Attributes;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Individuals;
import org.tip.puck.net.relations.Actor;
import org.tip.puck.net.relations.Actors;
import org.tip.puck.net.relations.RelationModel;
import org.tip.puck.net.relations.Roles;
import org.tip.puck.util.Numberable;

public class Relation
implements Numberable {
    private int id;
    private int typedId;
    private RelationModel model;
    private String name;
    private Actors actors;
    private Attributes attributes;

    public Relation(int id, int typedId, RelationModel model, String name, Actor ... actors) {
        this.id = id;
        this.typedId = typedId;
        this.model = model;
        this.name = name;
        this.actors = new Actors();
        Actor[] actorArray = actors;
        int n = actors.length;
        int n2 = 0;
        while (n2 < n) {
            Actor actor = actorArray[n2];
            this.actors.add(actor);
            ++n2;
        }
        this.attributes = new Attributes();
    }

    public Actors actors() {
        return this.actors;
    }

    public Attributes attributes() {
        Attributes result = this.attributes;
        return result;
    }

    public String getAttributeValue(String label) {
        Attribute attribute = (Attribute)this.attributes().get(label);
        String result = attribute == null ? null : attribute.getValue();
        return result;
    }

    @Override
    public int getId() {
        return this.id;
    }

    public boolean equals(Object obj) {
        boolean result = obj != null && this.getId() == ((Relation)obj).getId();
        return result;
    }

    public RelationModel getModel() {
        return this.model;
    }

    public String getName() {
        return this.name;
    }

    public int getTypedId() {
        return this.typedId;
    }

    public boolean hasActor(Actor actor) {
        boolean result = actor == null ? false : this.actors.hasActor(actor.getId(), actor.getRole().getName());
        return result;
    }

    public List<String> getRoleNames(Individual individual) {
        ArrayList<String> result = new ArrayList<String>();
        for (Actor actor : this.actors) {
            if (!actor.getIndividual().equals(individual)) continue;
            result.add(actor.getRole().getName());
        }
        return result;
    }

    public String getRoleNamesAsString(Individual individual) {
        String result = "";
        for (Actor actor : this.actors) {
            if (!actor.getIndividual().equals(individual)) continue;
            result = String.valueOf(result) + actor.getRole().getName() + " ";
        }
        return result;
    }

    public Roles getRoles(Individual individual) {
        Roles result = new Roles();
        for (Actor actor : this.actors) {
            if (!actor.getIndividual().equals(individual)) continue;
            result.add(actor.getRole());
        }
        return result;
    }

    public Individuals getIndividuals(String roleName) {
        Individuals result = new Individuals();
        for (Actor actor : this.actors) {
            if (!actor.getRole().getName().equals(roleName)) continue;
            result.add(actor.getIndividual());
        }
        return result;
    }

    public Individuals getIndividuals(List<String> roleNames) {
        Individuals result = new Individuals();
        for (Actor actor : this.actors) {
            if (!roleNames.contains(actor.getRole().getName())) continue;
            result.add(actor.getIndividual());
        }
        return result;
    }

    public Individuals getIndividuals() {
        Individuals result = new Individuals();
        for (Actor actor : this.actors) {
            result.add(actor.getIndividual());
        }
        return result;
    }

    public boolean hasActor(Individual individual) {
        boolean result = individual == null ? false : this.actors.hasActor(individual.getId());
        return result;
    }

    public boolean hasActor(Individual individual, String role) {
        boolean result = individual == null ? false : this.actors.hasActor(individual.getId(), role);
        return result;
    }

    public boolean hasActor(int id) {
        boolean result = this.actors.hasActor(id);
        return result;
    }

    public boolean hasActor(int id, String role) {
        boolean result = this.actors.hasActor(id, role);
        return result;
    }

    @Override
    public String hashKey() {
        String result = "" + this.id;
        return result;
    }

    public boolean hasRole(Individual individual, String roleName) {
        boolean result = false;
        for (Actor actor : this.actors) {
            if (actor.getIndividual() != individual || !actor.getRole().getName().equals(roleName)) continue;
            result = true;
            break;
        }
        return result;
    }

    public boolean matches(String pattern) {
        boolean result;
        if (StringUtils.isBlank((CharSequence)pattern)) {
            result = false;
        } else {
            String targetPattern = pattern.toLowerCase();
            if (this.name.toLowerCase().contains(targetPattern)) {
                result = true;
            } else {
                boolean ended = false;
                result = false;
                Iterator iterator = this.actors.iterator();
                while (!ended) {
                    if (iterator.hasNext()) {
                        Actor actor = (Actor)iterator.next();
                        if (!actor.getIndividual().getName().toLowerCase().contains(targetPattern)) continue;
                        ended = true;
                        result = true;
                        continue;
                    }
                    ended = true;
                    result = false;
                }
            }
        }
        return result;
    }

    public void removeActor(Actor actor) {
        this.actors.remove(actor);
    }

    public void removeActor(int id) {
        for (Actor actor : this.actors.toList()) {
            if (actor.getId() != id) continue;
            this.actors.remove(actor);
        }
    }

    public void setAttribute(String label, String value) {
        this.attributes().put(label, value);
    }

    public String toString() {
        return String.valueOf(this.id) + " " + this.name + " (" + this.typedId + ")";
    }

    @Override
    public void setId(int id) {
        this.id = id;
    }

    public void setModel(RelationModel model) {
        this.model = model;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTypedId(int typedId) {
        this.typedId = typedId;
    }
}

