/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.io.kinsources;

import fr.devinsy.util.StringList;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckException;
import org.tip.puck.io.kinsources.Catalog;
import org.tip.puck.io.kinsources.CatalogItem;
import org.tip.puck.net.Net;

public class KinsourcesFile {
    private static final Logger logger = LoggerFactory.getLogger(KinsourcesFile.class);
    public static String DEFAULT_CHARSET_NAME = "UTF-8";
    private static final String KINSOURCES_URL = "https://www.kinsources.net/";
    private static final String KINSOURCES_CATALOG_URL = "https://www.kinsources.net/kidarep/catalog.xhtml";
    private static final String KINSOURCES_DATASET_FILE_URL = "https://www.kinsources.net/kidarep/dataset_public_file-/%d/for_puck.puc";

    private static String extractFilename(URLConnection source) {
        String result;
        if (source == null) {
            result = null;
        } else {
            Matcher matcher;
            String contentDisposition = source.getHeaderField("Content-Disposition");
            logger.debug("content-disposition=[{}]", (Object)contentDisposition);
            result = contentDisposition == null ? null : ((matcher = Pattern.compile("filename=\"(.*)\"").matcher(contentDisposition)).find() && matcher.groupCount() == 1 ? matcher.group(1) : null);
        }
        logger.debug("fileName=[{}]", result);
        return result;
    }

    /*
     * Exception decompiling
     */
    public static Net load(long id) throws PuckException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Catalog loadCatalog() {
        Catalog result;
        URLConnection connection = null;
        try {
            URL source = new URL(KINSOURCES_CATALOG_URL);
            connection = source.openConnection();
            connection.setConnectTimeout(15000);
            connection.setReadTimeout(15000);
            byte[] data = IOUtils.toByteArray((URLConnection)connection);
            logger.info("Kinsources catalog size=" + data.length);
            StringList lines = KinsourcesFile.toStringList(data, DEFAULT_CHARSET_NAME);
            Iterator iterator = lines.iterator();
            boolean ended = false;
            while (!ended) {
                if (iterator.hasNext()) {
                    String line = (String)iterator.next();
                    if (!StringUtils.isBlank((CharSequence)line)) continue;
                    ended = true;
                    continue;
                }
                ended = true;
            }
            if (!iterator.hasNext()) {
                result = null;
            } else {
                String labelsLine = (String)iterator.next();
                String[] labels = labelsLine.split("\t");
                result = new Catalog();
                result.setSource(KINSOURCES_CATALOG_URL);
                boolean ended2 = false;
                while (!ended2) {
                    if (iterator.hasNext()) {
                        String line = (String)iterator.next();
                        if (!StringUtils.isNotBlank((CharSequence)line)) continue;
                        CatalogItem item = new CatalogItem();
                        String[] values = line.split("\t");
                        int index = 0;
                        while (index < values.length) {
                            String label = labels[index];
                            String value = values[index];
                            if (label.equalsIgnoreCase("ID")) {
                                if (!NumberUtils.isDigits((String)value)) throw new IllegalArgumentException("ID is not a number.");
                                item.setId(Long.parseLong(value));
                            } else if (label.equalsIgnoreCase("Name")) {
                                item.setName(value);
                            } else if (label.equalsIgnoreCase("Contributor")) {
                                item.setContributor(value);
                            } else if (label.equalsIgnoreCase("Author")) {
                                item.setAuthor(value);
                            } else if (label.equalsIgnoreCase("Permanent link")) {
                                item.setPermanentLink(value);
                            } else if (label.equalsIgnoreCase("License")) {
                                item.setLicense(value);
                            } else if (label.equalsIgnoreCase("Publication date")) {
                                item.setPublicationDate(value);
                            } else if (label.equalsIgnoreCase("Individuals") && NumberUtils.isDigits((String)value)) {
                                item.setIndividualCount(Long.parseLong(value));
                            }
                            ++index;
                        }
                        result.add(item);
                        continue;
                    }
                    ended2 = true;
                }
            }
        }
        catch (MalformedURLException exception) {
            exception.printStackTrace();
            result = null;
            IOUtils.close((URLConnection)connection);
            return result;
        }
        catch (IOException exception) {
            try {
                exception.printStackTrace();
                result = null;
            }
            catch (Throwable throwable) {
                IOUtils.close(connection);
                throw throwable;
            }
            IOUtils.close((URLConnection)connection);
            return result;
        }
        IOUtils.close((URLConnection)connection);
        return result;
    }

    public static StringList toStringList(byte[] source, String charsetName) throws IOException {
        StringList result = KinsourcesFile.toStringList(new ByteArrayInputStream(source), charsetName);
        return result;
    }

    public static StringList toStringList(InputStream source, String charsetName) throws IOException {
        StringList result;
        BufferedReader in = null;
        try {
            in = new BufferedReader(new InputStreamReader(source, charsetName));
            boolean ended = false;
            result = new StringList();
            while (!ended) {
                String line = in.readLine();
                if (line == null) {
                    ended = true;
                    continue;
                }
                result.append(line);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)in);
        return result;
    }
}

