/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.io.bar;

import java.io.File;
import java.util.Calendar;
import org.fest.assertions.Assertions;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.io.bar.BARODSFile;
import org.tip.puck.io.txt.TXTFileTest;
import org.tip.puck.net.Gender;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Net;
import org.tip.puck.util.Chronometer;
import org.tip.puck.util.LogHelper;

public class BARODSFileTest {
    private static final Logger logger = LoggerFactory.getLogger(TXTFileTest.class);
    public static final String SIMPLE_FILE = "test/Resources/Chimane6.ods";
    public static final String COMPLEX_FILE = "test/Resources/Ebrei_08.ods";

    @Test
    public void testLoad01() throws Exception {
        logger.debug("========================== testLoad01");
        Chronometer chrono = new Chronometer();
        Net target = BARODSFile.load(new File(SIMPLE_FILE));
        logger.debug("TimeSpent=" + chrono.stop().interval());
        logger.debug("Net=" + LogHelper.toString(target));
        Assertions.assertThat((Object)target).isNotNull();
        Assertions.assertThat((int)target.individuals().size()).isEqualTo(2642);
        Assertions.assertThat((int)target.families().size()).isEqualTo(796);
        Assertions.assertThat((int)((Individual)target.individuals().getById(50)).getId()).isEqualTo(50);
        Assertions.assertThat((String)((Individual)target.individuals().getById(50)).getName()).isEqualTo((Object)"Delicia");
        Assertions.assertThat((Object)((Object)((Individual)target.individuals().getById(50)).getGender())).isEqualTo((Object)Gender.FEMALE);
        Assertions.assertThat((Object)((Individual)target.individuals().getById(50)).getMother()).isNotNull();
        Assertions.assertThat((int)((Individual)target.individuals().getById(50)).getMother().getId()).isEqualTo(44);
        Assertions.assertThat((Object)((Individual)target.individuals().getById(50)).getFather()).isNotNull();
        Assertions.assertThat((int)((Individual)target.individuals().getById(50)).getFather().getId()).isEqualTo(20);
        Assertions.assertThat((int)((Individual)target.individuals().getById(50)).getSpouses().size()).isEqualTo(3);
        Assertions.assertThat((int)((Individual)target.individuals().getById(50)).getChildren().size()).isEqualTo(4);
        Assertions.assertThat((int)((Individual)target.individuals().getById(50)).attributes().size()).isEqualTo(2);
    }

    @Test
    public void testLoad02() throws Exception {
        logger.debug("========================== testLoad02");
        Chronometer chrono = new Chronometer();
        Net target = BARODSFile.load(new File(COMPLEX_FILE));
        logger.debug("TimeSpent=" + chrono.stop().interval());
        logger.debug("Net=" + LogHelper.toString(target));
        Assertions.assertThat((Object)target).isNotNull();
        Assertions.assertThat((int)target.individuals().size()).isEqualTo(5368);
        Assertions.assertThat((int)target.families().size()).isEqualTo(3305);
        Assertions.assertThat((int)((Individual)target.individuals().getById(116)).getId()).isEqualTo(116);
        Assertions.assertThat((String)((Individual)target.individuals().getById(116)).getName()).isEqualTo((Object)"Salomone /Mondolfo");
        Assertions.assertThat((Object)((Object)((Individual)target.individuals().getById(116)).getGender())).isEqualTo((Object)Gender.MALE);
        Assertions.assertThat((Object)((Individual)target.individuals().getById(116)).getMother()).isNotNull();
        Assertions.assertThat((int)((Individual)target.individuals().getById(116)).getMother().getId()).isEqualTo(444);
        Assertions.assertThat((Object)((Individual)target.individuals().getById(116)).getFather()).isNotNull();
        Assertions.assertThat((int)((Individual)target.individuals().getById(116)).getFather().getId()).isEqualTo(114);
        Assertions.assertThat((int)((Individual)target.individuals().getById(116)).getSpouses().size()).isEqualTo(2);
        Assertions.assertThat((int)((Individual)target.individuals().getById(116)).getChildren().size()).isEqualTo(4);
        Assertions.assertThat((int)((Individual)target.individuals().getById(116)).attributes().size()).isEqualTo(9);
    }

    @Test
    public void testSave01() throws Exception {
        logger.debug("========================== testSave01");
        File sourceFile = new File(SIMPLE_FILE);
        Chronometer chrono = new Chronometer();
        Net source = BARODSFile.load(sourceFile);
        logger.debug("TimeSpent=" + chrono.stop().interval());
        logger.debug("Net=" + LogHelper.toString(source));
        File targetFile = new File("tmp/target-" + Calendar.getInstance().getTimeInMillis() + ".ods");
        targetFile.delete();
        chrono.reset().start();
        BARODSFile.save(targetFile, source);
        logger.debug("TimeSpent=" + chrono.stop().interval());
        Assertions.assertThat((boolean)targetFile.exists()).isTrue();
        Assertions.assertThat((long)targetFile.length()).isNotEqualTo(0L);
        chrono.reset().start();
        Net target = BARODSFile.load(targetFile);
        logger.debug("TimeSpent=" + chrono.stop().interval());
        logger.debug("Net=" + LogHelper.toString(source));
        Assertions.assertThat((Object)target).isNotNull();
        Assertions.assertThat((int)target.individuals().size()).isEqualTo(source.individuals().size());
        Assertions.assertThat((int)target.families().size()).isEqualTo(source.families().size());
        Assertions.assertThat((int)((Individual)target.individuals().getById(50)).getId()).isEqualTo(50);
        Assertions.assertThat((String)((Individual)target.individuals().getById(50)).getName()).isEqualTo((Object)"Delicia");
        Assertions.assertThat((Object)((Object)((Individual)target.individuals().getById(50)).getGender())).isEqualTo((Object)Gender.FEMALE);
        Assertions.assertThat((Object)((Individual)target.individuals().getById(50)).getMother()).isNotNull();
        Assertions.assertThat((int)((Individual)target.individuals().getById(50)).getMother().getId()).isEqualTo(44);
        Assertions.assertThat((Object)((Individual)target.individuals().getById(50)).getFather()).isNotNull();
        Assertions.assertThat((int)((Individual)target.individuals().getById(50)).getFather().getId()).isEqualTo(20);
        Assertions.assertThat((int)((Individual)target.individuals().getById(50)).getSpouses().size()).isEqualTo(3);
        Assertions.assertThat((int)((Individual)target.individuals().getById(50)).getChildren().size()).isEqualTo(4);
        Assertions.assertThat((int)((Individual)target.individuals().getById(50)).attributes().size()).isEqualTo(2);
        targetFile.delete();
    }

    @Test
    public void testSave02() throws Exception {
        logger.debug("========================== testSave02");
        File sourceFile = new File(COMPLEX_FILE);
        Chronometer chrono = new Chronometer();
        Net source = BARODSFile.load(sourceFile);
        logger.debug("TimeSpent=" + chrono.stop().interval());
        logger.debug("Net=" + LogHelper.toString(source));
        File targetFile = new File("tmp/target-" + Calendar.getInstance().getTimeInMillis() + ".ods");
        targetFile.delete();
        chrono.reset().start();
        BARODSFile.save(targetFile, source);
        logger.debug("TimeSpent=" + chrono.stop().interval());
        Assertions.assertThat((boolean)targetFile.exists()).isTrue();
        Assertions.assertThat((long)targetFile.length()).isNotEqualTo(0L);
        chrono.reset().start();
        Net target = BARODSFile.load(targetFile);
        logger.debug("TimeSpent=" + chrono.stop().interval());
        logger.debug("Net=" + LogHelper.toString(source));
        Assertions.assertThat((Object)target).isNotNull();
        Assertions.assertThat((int)target.individuals().size()).isEqualTo(source.individuals().size());
        Assertions.assertThat((int)target.families().size()).isEqualTo(source.families().size());
        Assertions.assertThat((int)((Individual)target.individuals().getById(116)).getId()).isEqualTo(116);
        Assertions.assertThat((String)((Individual)target.individuals().getById(116)).getName()).isEqualTo((Object)"Salomone /Mondolfo");
        Assertions.assertThat((Object)((Object)((Individual)target.individuals().getById(116)).getGender())).isEqualTo((Object)Gender.MALE);
        Assertions.assertThat((Object)((Individual)target.individuals().getById(116)).getMother()).isNotNull();
        Assertions.assertThat((int)((Individual)target.individuals().getById(116)).getMother().getId()).isEqualTo(444);
        Assertions.assertThat((Object)((Individual)target.individuals().getById(116)).getFather()).isNotNull();
        Assertions.assertThat((int)((Individual)target.individuals().getById(116)).getFather().getId()).isEqualTo(114);
        Assertions.assertThat((int)((Individual)target.individuals().getById(116)).getSpouses().size()).isEqualTo(2);
        Assertions.assertThat((int)((Individual)target.individuals().getById(116)).getChildren().size()).isEqualTo(4);
        Assertions.assertThat((int)((Individual)target.individuals().getById(116)).attributes().size()).isEqualTo(9);
        targetFile.delete();
    }
}

