/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.io;

import java.io.File;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckManager;
import org.tip.puck.io.BARIURDetector;
import org.tip.puck.io.bar.BARFile;
import org.tip.puck.io.iur.IURFile;
import org.tip.puck.io.txt.TXTFileTest;
import org.tip.puck.net.Net;

public class BARIURDetectorTest {
    private static final Logger logger = LoggerFactory.getLogger(TXTFileTest.class);
    public static final String SIMPLE_FILE = "test/Resources/Chimane6.ods";
    public static final String COMPLEX_FILE = "test/Resources/Ebrei_08.ods";

    @Test
    public void testBARIURDetector() throws Exception {
        logger.debug("========================== testLoad01");
        Object[] source = new File("/home/cpm/C/Puck/Corpus/BARIUR/Test/").listFiles();
        Arrays.sort(source);
        System.out.println("ID\tName                                       \tisBAR\tisIUR\tdetect      \tBARFile\tIURFile\tPuckM\tInd.\tUnions\tRela.");
        int index = 0;
        Object[] objectArray = source;
        int n = source.length;
        int n2 = 0;
        while (n2 < n) {
            Object file = objectArray[n2];
            if (StringUtils.endsWithAny((CharSequence)((File)file).getName(), (CharSequence[])new CharSequence[]{".txt", ".xls", ".ods"})) {
                String relationCount;
                String unionCount;
                String individualCount;
                String result;
                if (++index > 95) break;
                System.out.print(String.valueOf(index) + "/" + source.length / 2 + "\t");
                System.out.print(((File)file).getName());
                System.out.print(StringUtils.repeat((char)' ', (int)(40 - ((File)file).getName().length())));
                System.out.print("\t");
                System.out.print(BARFile.isBAR((File)file, PuckManager.DEFAULT_CHARSET_NAME));
                System.out.print("\t");
                System.out.print(IURFile.isIUR((File)file, PuckManager.DEFAULT_CHARSET_NAME));
                System.out.print("\t");
                BARIURDetector.Format format = BARIURDetector.detectFormat((File)file);
                System.out.print(String.valueOf(format.toString()) + StringUtils.repeat((char)' ', (int)(15 - format.toString().length())));
                System.out.print("\t");
                try {
                    BARFile.load((File)file, PuckManager.DEFAULT_CHARSET_NAME);
                    result = "OK";
                }
                catch (Exception exception) {
                    result = "EXC";
                }
                System.out.print(result);
                System.out.print("\t");
                try {
                    IURFile.load((File)file, PuckManager.DEFAULT_CHARSET_NAME);
                    result = "OK";
                }
                catch (Exception exception) {
                    result = "EXC";
                }
                System.out.print(result);
                System.out.print("\t");
                try {
                    Net net = PuckManager.loadNet((File)file);
                    individualCount = String.valueOf(net.individuals().size());
                    unionCount = String.valueOf(net.families().size());
                    relationCount = String.valueOf(net.relations().size());
                    result = "OK";
                }
                catch (Exception exception) {
                    result = "EXC";
                    individualCount = "n/a";
                    unionCount = "n/a";
                    relationCount = "n/a";
                }
                System.out.print(String.valueOf(result) + "\t" + individualCount + "\t" + unionCount + "\t" + relationCount);
                System.out.println("");
            }
            ++n2;
        }
        System.out.println("OVER");
    }
}

