/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.graphs.workers;

import fr.devinsy.util.StringList;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.tip.puck.PuckException;
import org.tip.puck.PuckManager;
import org.tip.puck.clusternetworks.ClusterNetworkUtils;
import org.tip.puck.graphs.ClusterPair;
import org.tip.puck.graphs.Graph;
import org.tip.puck.graphs.Node;
import org.tip.puck.graphs.workers.GraphUtils;
import org.tip.puck.io.dat.DATFile;
import org.tip.puck.matrix.MatrixStatistics;
import org.tip.puck.matrix.SparseMatrix;
import org.tip.puck.net.Family;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Individuals;
import org.tip.puck.net.Net;
import org.tip.puck.net.relations.Actor;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.net.relations.Relations;
import org.tip.puck.net.workers.NetUtils;
import org.tip.puck.partitions.Cluster;
import org.tip.puck.partitions.Partition;
import org.tip.puck.report.Report;
import org.tip.puck.segmentation.Segmentation;
import org.tip.puck.util.Chronometer;
import org.tip.puck.util.MathUtils;
import org.tip.puck.util.PuckUtils;

public class GraphReporter {
    public static StringList getCoupleList(Graph<Cluster<Individual>> source, ClusterNetworkUtils.AllianceType allianceType) {
        StringList result = new StringList(100);
        result.appendln("Couple list");
        for (Node<Cluster<Individual>> sourceNode : source.getNodes().toListSortedByLabel()) {
            if (sourceNode.getLabel() == null) continue;
            for (Node<Cluster<Individual>> targetNode : sourceNode.getOutLinks().getTargetNodesSortedByLabel()) {
                if (targetNode.getLabel() == null) continue;
                StringList nodeCoupleList = new StringList();
                for (Individual individual : sourceNode.getReferent().getItems()) {
                    Family family2;
                    if (allianceType == ClusterNetworkUtils.AllianceType.WIFE_HUSBAND) {
                        for (Family family2 : individual.getPersonalFamilies()) {
                            Individual spouse;
                            if (family2.getWife() != individual || (spouse = family2.getOtherParent(individual)) == null || !targetNode.getReferent().getItems().contains(spouse)) continue;
                            nodeCoupleList.appendln(String.format("\t%d %s\t%d %s", individual.getId(), individual.getName(), spouse.getId(), spouse.getName()));
                        }
                        continue;
                    }
                    if (allianceType != ClusterNetworkUtils.AllianceType.SISTER_BROTHER || (family2 = individual.getOriginFamily()) == null || !individual.isFemale() || !individual.isNotSingle()) continue;
                    for (Individual sibling : family2.getChildren()) {
                        if (sibling == null || !sibling.isMale() || !sibling.isNotSingle() || !targetNode.getReferent().getItems().contains(sibling)) continue;
                        nodeCoupleList.appendln(String.format("\t%d %s\t%d %s", individual.getId(), individual.getName(), sibling.getId(), sibling.getName()));
                    }
                }
                if (nodeCoupleList.size() <= 0) continue;
                result.appendln(String.valueOf(sourceNode.getLabel()) + "-" + targetNode.getLabel() + "\t" + new Double(sourceNode.getArcWeight(targetNode)).intValue());
                result.addAll((Collection)nodeCoupleList);
                result.appendln();
            }
        }
        return result;
    }

    public static StringList getSides(Graph<Cluster<Individual>> source) {
        StringList result = new StringList(100);
        result.appendln("Sides");
        Partition<Node<Node>> sides = GraphUtils.sides(source);
        double sidedness = GraphUtils.sidedness(source, sides);
        result.appendln("Sidedness: " + sidedness);
        for (Cluster cluster : sides.getClusters()) {
            result.appendln("Side " + cluster.getValue() + "\t" + cluster.count() + " nodes");
        }
        result.appendln();
        for (Node node : source.getNodes()) {
            result.appendln(String.valueOf(node.getId()) + "\t" + ((Cluster)node.getReferent()).getLabel() + "\t" + sides.getValue(node));
        }
        return result;
    }

    public static StringList getSortableList(Graph<Cluster<Individual>> source) {
        StringList result = new StringList(100);
        result.appendln("Sortable list");
        for (Node<Cluster<Individual>> sourceNode : source.getNodes().toListSortedByLabel()) {
            if (sourceNode.getLabel() == null) continue;
            for (Node<Cluster<Individual>> targetNode : sourceNode.getOutLinks().getTargetNodesSortedByLabel()) {
                if (targetNode.getLabel() == null) continue;
                StringList nodeCoupleList = new StringList();
                for (Individual individual : sourceNode.getReferent().getItems()) {
                    for (Family family : individual.getPersonalFamilies()) {
                        Individual spouse;
                        if (family.getWife() != individual || (spouse = family.getOtherParent(individual)) == null || !targetNode.getReferent().getItems().contains(spouse)) continue;
                        nodeCoupleList.append(String.format("%d %s\t%d %s", individual.getId(), individual.getName(), spouse.getId(), spouse.getName()));
                    }
                }
                for (String line : nodeCoupleList) {
                    result.appendln(String.valueOf(line) + "\t" + sourceNode.getLabel() + "\t" + targetNode.getLabel() + "\t" + new Double(sourceNode.getArcWeight(targetNode)).intValue());
                }
            }
        }
        return result;
    }

    public static StringList getIndividualFlowList(Graph<ClusterPair<Individual>> source) {
        StringList result = new StringList(100);
        result.appendln("Individual Flow list");
        result.appendln();
        for (Node<ClusterPair<Individual>> sourceNode : source.getNodes().toListSortedByLabel()) {
            if (sourceNode.getLabel() == null) continue;
            for (Node<ClusterPair<Individual>> targetNode : sourceNode.getOutLinks().getTargetNodesSortedByLabel()) {
                if (targetNode.getLabel() == null) continue;
                Individuals flows = new Individuals();
                for (Individual individual : sourceNode.getReferent().getLeft().getItems()) {
                    if (individual == null || !targetNode.getReferent().getRight().getItems().contains(individual)) continue;
                    flows.add(individual);
                }
                if (flows.size() <= 0) continue;
                result.appendln(String.valueOf(sourceNode.getLabel()) + " > " + targetNode.getLabel());
                for (Individual individual : flows.toSortedList()) {
                    result.appendln(String.format("\t%d %s", individual.getId(), individual.getName()));
                }
                result.appendln();
            }
        }
        return result;
    }

    public static StringList getRelationFlowList(Graph<ClusterPair<Relation>> source) {
        StringList result = new StringList(100);
        result.appendln("Relation Flow list");
        result.appendln();
        for (Node<ClusterPair<Relation>> sourceNode : source.getNodes().toListSortedByLabel()) {
            if (sourceNode.getLabel() == null) continue;
            for (Node<ClusterPair<Relation>> targetNode : sourceNode.getOutLinks().getTargetNodesSortedByLabel()) {
                if (targetNode.getLabel() == null) continue;
                Relations flows = new Relations();
                for (Relation relation : sourceNode.getReferent().getLeft().getItems()) {
                    if (relation == null || !targetNode.getReferent().getRight().getItems().contains(relation)) continue;
                    flows.add(relation);
                }
                if (flows.size() <= 0) continue;
                result.appendln(String.valueOf(sourceNode.getLabel()) + " > " + targetNode.getLabel() + "\t(" + flows.size() + ")");
                for (Relation relation : flows.toSortedList()) {
                    result.append(String.format("\t%d %s\t", relation.getId(), relation.getName()));
                    for (Actor actor : relation.actors()) {
                        if (!actor.getRole().getName().equals("MIG")) continue;
                        result.append(String.valueOf(actor.getName()) + "; ");
                    }
                    result.appendln();
                }
                result.appendln();
            }
        }
        return result;
    }

    public static <E> MatrixStatistics getMatrixStatistics(Graph<E> source) {
        MatrixStatistics result = new MatrixStatistics(source);
        return result;
    }

    public static <E> MatrixStatistics getMatrixStatistics(List<Graph<E>> sources) {
        MatrixStatistics result = new MatrixStatistics();
        ArrayList<MatrixStatistics> statistics = new ArrayList<MatrixStatistics>();
        for (Graph<E> source : sources) {
            MatrixStatistics stats = new MatrixStatistics(source);
            statistics.add(stats);
            result.incrementValues(stats);
        }
        result.normalizeValues(sources.size());
        double target = result.getNumber(MatrixStatistics.Indicator.CONCENTRATION);
        double shortestDistance = 1.0;
        for (MatrixStatistics stats : statistics) {
            double distance = Math.abs(target - stats.getNumber(MatrixStatistics.Indicator.CONCENTRATION));
            if (!(distance < shortestDistance)) continue;
            shortestDistance = distance;
            result.setGraph(stats.getGraph());
        }
        return result;
    }

    public static <E> StringList getGraphStats(Graph<E> source) {
        StringList result = new StringList(100);
        MatrixStatistics stats = new MatrixStatistics(source);
        MatrixStatistics rstats = null;
        result.appendln("alliance network:\t" + source.getLabel());
        result.appendln();
        result.append(MatrixStatistics.statistics(stats, rstats));
        return result;
    }

    public static <E> StringList getMatrixStrings(Graph<E> source) {
        SparseMatrix sparse = source.getSquareMatrix();
        StringList result = new StringList(100);
        result.appendln("sources=" + sparse.getSourceCount());
        result.appendln("targets=" + sparse.getTargetCount());
        result.appendln();
        result.append("m=" + sparse.getTargetCount() + "\t");
        int columnIndex = 0;
        while (columnIndex < sparse.getMatrix().getColDim()) {
            result.append(source.getNode(sparse.getTargetId(columnIndex)).getLabel()).append("\t");
            ++columnIndex;
        }
        result.appendln("Pop");
        int rowIndex = 0;
        while (rowIndex < sparse.getMatrix().getRowDim()) {
            result.append(String.valueOf(source.getNodes().get(sparse.getSourceId(rowIndex)).getLabel()) + "\t");
            int columnIndex2 = 0;
            while (columnIndex2 < sparse.getMatrix().getColDim()) {
                result.append(String.valueOf(MathUtils.toString(sparse.getMatrix().get(rowIndex, columnIndex2))) + "\t");
                ++columnIndex2;
            }
            result.appendln(sparse.getMatrix().getRowSum(rowIndex));
            ++rowIndex;
        }
        result.append("Pop\t");
        columnIndex = 0;
        while (columnIndex < sparse.getMatrix().getColDim()) {
            result.append(String.valueOf(sparse.getMatrix().getColSum(columnIndex)) + "\t");
            ++columnIndex;
        }
        result.appendln("n=" + sparse.getSum());
        result.appendln();
        return result;
    }

    public static <E> StringList getRawMatrixStrings(Graph<E> source) {
        SparseMatrix sparse = source.getSquareMatrix();
        StringList result = new StringList(100);
        int rowIndex = 0;
        while (rowIndex < sparse.getMatrix().getRowDim()) {
            int columnIndex = 0;
            while (columnIndex < sparse.getMatrix().getColDim()) {
                result.append(MathUtils.toString(sparse.getMatrix().get(rowIndex, columnIndex)));
                if (columnIndex < sparse.getMatrix().getColDim() - 1) {
                    result.append("\t");
                }
                ++columnIndex;
            }
            if (rowIndex < sparse.getMatrix().getRowDim() - 1) {
                result.appendln();
            }
            ++rowIndex;
        }
        return result;
    }

    public static void test() throws PuckException {
        Net net = PuckManager.loadNet(new File("/Users/klaushamberger/Desktop/Ebrei 2009.ged"));
        Segmentation source = new Segmentation(net);
        Graph<Family> graph = NetUtils.createPGraph(source);
        StringList partitionLabels = new StringList();
        System.out.println("==================================");
        System.out.println(PuckUtils.writePajekNetwork(graph, (List<String>)partitionLabels).toString());
        System.out.println("==================================");
    }

    public static Report reportSynopsis(String directory) {
        Chronometer chrono = new Chronometer();
        Report result = new Report();
        result.setTitle("Basic statistics about a corpus.");
        result.setOrigin("Statistics reporter");
        StringList listStatistics = new StringList();
        String headline = "General statistics";
        MatrixStatistics.Indicator[] indicatorArray = MatrixStatistics.Indicator.values();
        int n = indicatorArray.length;
        int n2 = 0;
        while (n2 < n) {
            MatrixStatistics.Indicator indicator = indicatorArray[n2];
            headline = String.valueOf(headline) + "\t" + indicator.toString();
            ++n2;
        }
        result.outputs().appendln(headline);
        File folder = new File(directory);
        File[] fileArray = folder.listFiles();
        int n3 = fileArray.length;
        n = 0;
        while (n < n3) {
            File file = fileArray[n];
            try {
                Graph<Cluster<Individual>> graph = DATFile.load(file);
                listStatistics.appendln(MatrixStatistics.getValueString(graph));
            }
            catch (PuckException e) {
                System.err.println("Not a corpus file: " + file.getName());
            }
            ++n;
        }
        result.outputs().append(listStatistics);
        result.outputs().appendln();
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }
}

